/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.hive.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import oracle.ideimpl.db.components.ExtendedTableComponentWrapper;
import oracle.ideimpl.db.controls.ExtendedTable;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.hive.HivePartition;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.property.Property;
import oracle.javatools.ui.table.GenericTable;

public class HivePartitionsComponentWrapper
extends ExtendedTableComponentWrapper<HivePartitionsTable> {
    public HivePartitionsComponentWrapper(String prop) {
        super(new HivePartitionsTable(prop));
    }

    @Override
    public Object getPropertyValue() {
        return ((HivePartitionsTable)this.getExtendedTable()).getPartitions();
    }

    @Override
    public void setPropertyValue(Object val) {
        String colProp;
        String prop = Property.getLastProperty((String)this.getPropertyName());
        String parProp = Property.getParentProperty((String)this.getComponentContext().getFullPropertyPath());
        DBObject par = (DBObject)this.getUpdatedObject().getProperty(parProp);
        if ("skewedValues".equals(prop)) {
            colProp = "skewedColumns";
        } else if ("partitions".equals(prop)) {
            colProp = "partitionColumns";
        } else {
            throw new IllegalArgumentException(prop);
        }
        ((HivePartitionsTable)this.getExtendedTable()).setPartitions(par, colProp, val instanceof HivePartition[] ? (HivePartition[])val : null);
    }

    public static class HivePartitionsTable
    extends ExtendedTable {
        private final List<HivePartition> m_partitions = new ArrayList<HivePartition>();
        private DBObject m_parent;
        private boolean m_loading;

        HivePartitionsTable(String prop) {
            super(DisplayNames.getPropertyDisplayName((String)prop), "HivePartitionsTable");
            this.addTableModelListener(new ExtendedTable.ExtendedTableModelListener(){

                @Override
                public void cellValueEdited(TableModelEvent e) {
                    this.sync(e);
                }

                @Override
                public void tableChanged(TableModelEvent e) {
                }
            });
            this.setSelectionModel(new DefaultListSelectionModel(){

                @Override
                public void setValueIsAdjusting(boolean isAdjusting) {
                    if (!m_loading) {
                        super.setValueIsAdjusting(isAdjusting);
                    }
                }
            });
        }

        private void sync(TableModelEvent e) {
            TableCellEditor ed;
            int col = e.getColumn();
            if (!this.m_loading && 0 == e.getType() && col != -1 && (ed = this.getTable().getCellEditor()) != null) {
                int size = this.getModel().getColumnCount();
                int row = e.getFirstRow();
                String newVal = (String)ed.getCellEditorValue();
                HivePartition tp = this.m_partitions.get(row);
                String[] oldVals = tp.getValues();
                String[] vals = new String[size];
                System.arraycopy(oldVals, 0, vals, 0, Math.min(oldVals.length, size));
                vals[col] = newVal;
                tp.setValues(vals);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setPartitions(DBObject parent, String colProp, HivePartition[] parts) {
            GenericTable tab = this.getTable();
            ListSelectionModel selectionModel = tab.getSelectionModel();
            selectionModel.setValueIsAdjusting(true);
            this.m_loading = true;
            try {
                DBObjectID[] cols;
                this.m_partitions.clear();
                if (parts != null) {
                    this.m_partitions.addAll(Arrays.asList(parts));
                }
                this.m_parent = parent;
                Vector<String> colNames = new Vector<String>();
                int numCols = 0;
                if (this.m_parent != null && (cols = (DBObjectID[])this.m_parent.getProperty(colProp)) != null) {
                    for (HivePartition hivePartition : cols) {
                        colNames.add(DBUtil.getDBObjectName((DBObjectID)hivePartition));
                        ++numCols;
                    }
                }
                Vector<Vector> values = new Vector<Vector>();
                if (parts != null) {
                    for (HivePartition hivePartition : parts) {
                        Vector<String> tpv = new Vector<String>(numCols);
                        String[] vals = hivePartition.getValues();
                        for (int i = 0; i < numCols; ++i) {
                            tpv.add(vals != null && i < vals.length ? vals[i] : null);
                        }
                        values.add(tpv);
                    }
                }
                int numRows = values.size();
                int row = tab.getSelectedRowInModel();
                if (row >= numRows) {
                    row = 0;
                }
                this.setModel(new PartitionTableModel(values, colNames));
                if (row >= 0 && numRows > 0) {
                    tab.setSelectedRowInModel(row);
                }
            }
            finally {
                this.m_loading = false;
                selectionModel.setValueIsAdjusting(false);
            }
        }

        HivePartition[] getPartitions() {
            this.stopCellEditing();
            return this.m_partitions.toArray(new HivePartition[this.m_partitions.size()]);
        }

        @Override
        protected void addNewRow() {
            ExtendedTable.StringTableModel model = this.getModel();
            int size = model.getColumnCount();
            HivePartition tp = new HivePartition();
            tp.setParent(this.m_parent);
            tp.setValues(new String[size]);
            this.m_partitions.add(tp);
            Vector<Object> rowData = new Vector<Object>(size);
            for (int i = 0; i < size; ++i) {
                rowData.add(null);
            }
            model.addRow(rowData);
        }

        public int indexOf(HivePartition tp) {
            int retval = -1;
            for (int i = 0; i < this.m_partitions.size(); ++i) {
                if (this.m_partitions.get(i) != tp) continue;
                retval = i;
                break;
            }
            return retval;
        }

        public HivePartition getPartition(int i) {
            return i < this.m_partitions.size() && i >= 0 ? this.m_partitions.get(i) : null;
        }

        private class PartitionTableModel
        extends ExtendedTable.StringTableModel {
            PartitionTableModel(Vector<Vector> data, Vector<String> colNames) {
                super(data, colNames);
            }

            public void removeRow(int row) {
                HivePartitionsTable.this.m_partitions.remove(row);
                super.removeRow(row);
            }
        }
    }
}

