/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import oracle.ideimpl.db.controls.ExtendedTable;

public class KeyValueTable
extends ExtendedTable {
    private NameCellEditor m_nameEditor;

    protected KeyValueTable(String tableHeaderText, String name) {
        super(tableHeaderText, name);
    }

    public final void setKeys(Collection<String> keys) {
        if (this.m_nameEditor == null) {
            this.m_nameEditor = new NameCellEditor();
        }
        JComboBox combo = this.m_nameEditor.getCombo();
        combo.removeAllItems();
        if (keys != null) {
            for (String key : keys) {
                combo.addItem(key);
            }
        }
        this.ensureNameCellEditor();
    }

    @Override
    protected void modelReplaced() {
        this.ensureNameCellEditor();
    }

    private void ensureNameCellEditor() {
        ExtendedTable.StringTableModel tableModel = this.getModel();
        if (tableModel != null && this.m_nameEditor != null) {
            this.getTable().getColumnModel().getColumn(0).setCellEditor(this.m_nameEditor);
        }
    }

    protected String getDefaultValue(String key) {
        return null;
    }

    protected void keyChanged(String newKey, int row) {
    }

    public static KeyValueTable getKeyValueTable(JComponent component) {
        return (KeyValueTable)ExtendedTable.getExtendedTable(component);
    }

    private class NameCellEditor
    extends DefaultCellEditor {
        private boolean m_active;

        NameCellEditor() {
            super(new JComboBox());
            final JComboBox combo = this.getCombo();
            combo.setEditable(true);
            combo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int row;
                    if (NameCellEditor.this.m_active && (row = KeyValueTable.this.getTable().getSelectedRow()) >= 0) {
                        KeyValueTable.this.keyChanged((String)combo.getSelectedItem(), row);
                    }
                }
            });
            KeyValueTable.this.getResourceHelper().setName(combo, "NameCombo");
        }

        JComboBox getCombo() {
            return (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component retval = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            this.m_active = true;
            return retval;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            this.m_active = false;
        }

        @Override
        public boolean stopCellEditing() {
            boolean retval = super.stopCellEditing();
            if (retval) {
                String defaultValue;
                Object key;
                ExtendedTable.StringTableModel tableModel;
                Object value;
                this.m_active = false;
                int row = KeyValueTable.this.getTable().getSelectedRowInModel();
                if (row >= 0 && (value = (tableModel = KeyValueTable.this.getModel()).getValueAt(row, 1)) == null && (key = tableModel.getValueAt(row, 0)) instanceof String && (defaultValue = KeyValueTable.this.getDefaultValue((String)key)) != null) {
                    tableModel.setValueAt(defaultValue, row, 1);
                }
            }
            return retval;
        }
    }
}

