/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.property.Property;
import oracle.javatools.ui.TitledSeparator;

public class IdPanel
extends JPanel {
    private TitledSeparator m_header;
    private JLabel m_schemaLabel;
    private DBObjectChooser m_cmbSchema;
    private JLabel m_parentLabel;
    private DBObjectChooser m_cmbParent;
    private JLabel m_lblObject;
    private DBObjectChooser m_cmbObject;

    public void initialisePanel(DBObjectChooser cmbObject, DBObjectChooser cmbParent, DBObjectChooser cmbSchema, ComponentContext context, String displayName, boolean useHeader) {
        String headerText;
        String labelText;
        this.m_cmbObject = cmbObject;
        this.m_cmbParent = cmbParent;
        this.m_cmbSchema = cmbSchema;
        String propname = Property.getLastProperty((String)context.getPropertyName());
        DBUIResourceHelper resHelp = new DBUIResourceHelper("");
        if (useHeader) {
            labelText = DBTypeDisplayRegistry.getSingularDisplayName(this.m_cmbObject.getTypes()[0]);
            headerText = displayName;
        } else {
            labelText = displayName;
            headerText = null;
        }
        this.m_lblObject = new JLabel();
        resHelp.resLabel(this.m_lblObject, this.m_cmbObject, labelText + ":", propname + "_object");
        DBUILayoutHelper layout = new DBUILayoutHelper(this, context.isInFlatEditor());
        layout.setMarginTop(0);
        if (useHeader) {
            this.m_header = new TitledSeparator(headerText);
            layout.add((Component)this.m_header, 2, 1, true, false);
            layout.nextRow();
        }
        if (this.m_cmbSchema != null) {
            String schemalabelText = useHeader ? DBTypeDisplayRegistry.getSingularDisplayName("SCHEMA") + ":" : UIBundle.format("LABEL_IDPROP_SCHEMA", labelText);
            this.m_schemaLabel = new JLabel();
            resHelp.resLabel(this.m_schemaLabel, this.m_cmbSchema, schemalabelText, propname + "_schema");
            layout.add(this.m_schemaLabel);
            layout.add(this.m_cmbSchema);
            layout.nextRow();
        }
        if (this.m_cmbParent != null) {
            this.m_parentLabel = new JLabel();
            resHelp.resLabel(this.m_parentLabel, this.m_cmbParent, DBTypeDisplayRegistry.getSingularDisplayName(this.m_cmbParent.getTypes()[0]) + ":", propname + "_parent");
            layout.add(this.m_parentLabel);
            layout.add(this.m_cmbParent);
            layout.nextRow();
        }
        if (!context.isInTable() || this.m_cmbSchema != null || this.m_cmbParent != null) {
            layout.add(this.m_lblObject);
        }
        layout.add(this.m_cmbObject, 1, 1, true, false);
        if (useHeader) {
            layout.pushUp();
        }
        layout.layout();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.m_cmbSchema != null) {
            this.m_cmbSchema.setEnabled(enabled);
            this.m_schemaLabel.setEnabled(enabled);
        }
        if (this.m_cmbParent != null) {
            this.m_cmbParent.setEnabled(enabled);
            this.m_parentLabel.setEnabled(enabled);
        }
        this.m_cmbObject.setEnabled(enabled);
        this.m_lblObject.setEnabled(enabled);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.m_header != null) {
            this.m_header.setVisible(visible);
        }
        if (this.m_cmbSchema != null) {
            this.m_cmbSchema.setVisible(visible);
            this.m_schemaLabel.setVisible(visible);
        }
        if (this.m_cmbParent != null) {
            this.m_cmbParent.setVisible(visible);
            this.m_parentLabel.setVisible(visible);
        }
        this.m_cmbObject.setVisible(visible);
        this.m_lblObject.setVisible(visible);
    }

    public String getSchemaComponentName() {
        return this.m_cmbSchema == null ? null : this.m_cmbSchema.getDelegateName();
    }

    public String getDBObjectComponentName() {
        return this.m_cmbObject == null ? null : this.m_cmbObject.getDelegateName();
    }
}

