/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.controls.ExtendedTable;
import oracle.ideimpl.db.controls.KeyValueTable;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameter;
import oracle.javatools.db.ora.bigdata.BigDataJsonArray;
import oracle.javatools.db.ora.bigdata.BigDataJsonEntry;
import oracle.javatools.db.ora.bigdata.BigDataJsonObject;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.ui.ExtendedTextField;
import oracle.javatools.ui.combo.JCheckCombo;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public class BigDataJsonEntriesTable
extends KeyValueTable {
    private static final String QUOTE = "\"";
    private final String m_keyName;
    private final String m_valueName;
    private final TableCellRenderer m_cellRenderer = new Renderer();
    private Relation m_relation;
    private BigDataAccessParameter m_param;

    public BigDataJsonEntriesTable(String keyName, String valueName) {
        super(PropertyDisplayRegistry.getDisplayName("bigDataEntries"), "BigDataJsonEntriesTable");
        this.m_keyName = keyName;
        this.m_valueName = valueName;
    }

    @Override
    protected boolean shouldTerminateEditOnFocusLost() {
        return true;
    }

    private Vector<String> getColumnNames() {
        Vector<String> retval = new Vector<String>();
        retval.add(QUOTE + this.m_keyName + QUOTE);
        retval.add(QUOTE + this.m_valueName + QUOTE);
        return retval;
    }

    public void setBigDataJsonArray(BigDataJsonArray arr, BigDataAccessParameter param, Relation relation) {
        this.m_relation = relation;
        this.m_param = param;
        String paramName = param.getName();
        Vector<Vector> rows = new Vector<Vector>();
        for (SQLFragment frag : arr.getArguments()) {
            if (frag instanceof BigDataJsonObject) {
                BigDataJsonEntry[] entries = ((BigDataJsonObject)frag).getBigDataEntries();
                Tuple allowedEntries = BigDataJsonEntry.getJsonEntryNames((String)paramName);
                boolean col1Extended = BigDataJsonEntry.hasExtendedEntry((String)((String)allowedEntries.object1()), (String)paramName);
                if (entries.length <= 0) continue;
                Vector<Object> row = new Vector<Object>();
                if (entries.length == 1) {
                    row.add(entries[0]);
                } else if (entries.length == 2) {
                    BigDataJsonEntry first = entries[0];
                    if (col1Extended && entries.length > 1 && ModelUtil.areEqual((Object)allowedEntries.object1(), (Object)first.getName()) && !ModelUtil.areEqual((Object)allowedEntries.object2(), (Object)entries[1].getName())) {
                        row.add(new BigDataJsonEntry[]{entries[0], entries[1]});
                    } else {
                        row.add(entries[0]);
                        row.add(entries[1]);
                    }
                } else if (entries.length == 3) {
                    row.add(new BigDataJsonEntry[]{entries[0], entries[1]});
                    row.add(entries[2]);
                } else {
                    throw new IllegalStateException("Expect 2 BigDataJsonEntry");
                }
                rows.add(row);
                continue;
            }
            throw new IllegalStateException("Not a BigDataJsonObject");
        }
        BigDataValueArrayTableModel model = new BigDataValueArrayTableModel(rows);
        this.setModel(model);
        TableColumnModel columnModel = this.getTable().getColumnModel();
        Collection allowedKeys = BigDataJsonEntry.getAllowedValueStrings((String)this.m_keyName, (String)paramName, (Relation)this.m_relation);
        AbstractCellEditor keyEd = BigDataJsonEntry.hasExtendedEntry((String)this.m_keyName, (String)paramName) ? new ExtendedCellEditor(this.m_keyName, allowedKeys) : (allowedKeys == null ? new SimpleCellEditor(this.m_keyName, new JTextField()) : new ComboEditor(this.m_keyName, allowedKeys, false));
        TableColumn keyCol = columnModel.getColumn(0);
        keyCol.setCellEditor((TableCellEditor)((Object)keyEd));
        keyCol.setCellRenderer(this.m_cellRenderer);
        Collection allowedVals = BigDataJsonEntry.getAllowedValueStrings((String)this.m_valueName, (String)paramName, (Relation)this.m_relation);
        AbstractCellEditor valEd = allowedVals == null ? new SimpleCellEditor(this.m_valueName, (JTextComponent)new ExtendedTextField()) : new ComboEditor(this.m_valueName, allowedVals, "col".equals(this.m_valueName));
        TableColumn valCol = columnModel.getColumn(1);
        valCol.setCellEditor((TableCellEditor)((Object)valEd));
        valCol.setCellRenderer(this.m_cellRenderer);
    }

    public BigDataJsonArray getBigDataJsonArray() {
        this.stopCellEditing();
        BigDataJsonArray retval = new BigDataJsonArray();
        BigDataValueArrayTableModel model = (BigDataValueArrayTableModel)this.getModel();
        Vector victor = model.getDataVector();
        for (Vector row : victor) {
            BigDataJsonObject obj = new BigDataJsonObject();
            retval.addArgument((SQLFragment)obj);
            this.addBigDataJsonEntry(row.elementAt(0), obj, this.m_keyName);
            this.addBigDataJsonEntry(row.elementAt(1), obj, this.m_valueName);
        }
        return retval;
    }

    private void addBigDataJsonEntry(Object cellData, BigDataJsonObject obj, String entryName) {
        if (cellData instanceof BigDataJsonEntry[]) {
            for (BigDataJsonEntry frag : (BigDataJsonEntry[])cellData) {
                obj.addBigDataEntry(frag);
            }
        } else if (cellData instanceof BigDataJsonEntry) {
            obj.addBigDataEntry((BigDataJsonEntry)cellData);
        } else if (!BigDataJsonEntry.isJsonEntryOptional((String)this.m_param.getName(), (String)entryName)) {
            obj.addBigDataEntry(new BigDataJsonEntry(entryName, null));
        }
    }

    private static Object getSelectedItem(JComboBox combo) {
        ComboBoxEditor ed = combo.isEditable() ? combo.getEditor() : null;
        Object retval = ed == null ? combo.getSelectedItem() : ed.getItem();
        return retval;
    }

    private class ExtendedCellEditor
    extends AbstractCellEditor
    implements ExtendedTable.ExtendedTableCellEditor {
        private final JComboBox m_entryCombo;
        private final ExtendedTextField m_extendedEntryField;
        private final JPanel m_panel;
        private final String m_entryName;

        ExtendedCellEditor(String entryName, Collection<String> allowedValues) {
            this.m_entryName = entryName;
            DBUIResourceHelper reshelp = new DBUIResourceHelper("BigDataJsonEntriesTable.ExtendedCellEditor");
            this.m_entryCombo = new JComboBox();
            for (String val : allowedValues) {
                this.m_entryCombo.addItem(val);
            }
            reshelp.setName(this.m_entryCombo, "EntryCombo");
            this.m_entryCombo.setEditable(true);
            this.m_entryCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ExtendedCellEditor.this.checkValueEntry();
                }
            });
            this.m_extendedEntryField = new ExtendedTextField();
            reshelp.setName((Component)this.m_extendedEntryField, "ExtendedEntryField");
            this.m_panel = new JPanel();
            this.m_panel.setLayout(new BoxLayout(this.m_panel, 0));
            this.m_panel.add(this.m_entryCombo);
            this.m_panel.add((Component)this.m_extendedEntryField);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            SQLFragment entryValueFrag = null;
            String extendedText = null;
            if (value instanceof BigDataJsonEntry[]) {
                BigDataJsonEntry[] entries = (BigDataJsonEntry[])value;
                entryValueFrag = entries[0].getValueFragment();
                if (entries.length > 1) {
                    SQLFragment extendedFrag = entries[1].getValueFragment();
                    extendedText = extendedFrag == null ? null : extendedFrag.getSQLText();
                }
            } else if (value instanceof BigDataJsonEntry) {
                entryValueFrag = ((BigDataJsonEntry)value).getValueFragment();
            }
            this.m_entryCombo.setSelectedItem(entryValueFrag == null ? null : entryValueFrag.getSQLText());
            this.m_extendedEntryField.setText(extendedText);
            this.checkValueEntry();
            return this.m_panel;
        }

        private String getExtendedEntryForSelection() {
            return BigDataJsonEntry.getExtendedEntryName((String)this.m_entryName, (String)((String)BigDataJsonEntriesTable.getSelectedItem(this.m_entryCombo)), (String)BigDataJsonEntriesTable.this.m_param.getName());
        }

        @Override
        public Object getCellEditorValue() {
            BigDataJsonEntry[] retval;
            String selectedEntry = (String)BigDataJsonEntriesTable.getSelectedItem(this.m_entryCombo);
            BigDataJsonEntry entryFrag = new BigDataJsonEntry(this.m_entryName, (SQLFragment)new SimpleSQLFragment(selectedEntry));
            String ext = this.getExtendedEntryForSelection();
            if (ext != null) {
                BigDataJsonEntry extendedFrag = new BigDataJsonEntry(ext, (SQLFragment)new SimpleSQLFragment(this.m_extendedEntryField.getText()));
                retval = new BigDataJsonEntry[]{entryFrag, extendedFrag};
            } else {
                retval = new BigDataJsonEntry[]{entryFrag};
            }
            return retval;
        }

        private void checkValueEntry() {
            if (this.getExtendedEntryForSelection() == null) {
                this.m_extendedEntryField.setVisible(false);
                this.m_entryCombo.setEditable(true);
            } else {
                this.m_extendedEntryField.setVisible(true);
                this.m_entryCombo.setEditable(false);
            }
        }

        @Override
        public void prepareComponent(Component component) {
            if (component == this.m_panel) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ExtendedCellEditor.this.m_extendedEntryField.isVisible()) {
                            ExtendedCellEditor.this.m_extendedEntryField.requestFocusInWindow();
                        } else if (ExtendedCellEditor.this.m_entryCombo.isVisible()) {
                            ExtendedCellEditor.this.m_entryCombo.requestFocusInWindow();
                        }
                    }
                });
            }
        }
    }

    private class ComboEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final Collection<String> m_allowed;
        private final JComboBox m_combo;
        private final String m_entryName;

        ComboEditor(String entryName, Collection<String> allowed, boolean array) {
            this.m_entryName = entryName;
            this.m_allowed = allowed;
            if (array) {
                this.m_combo = new JCheckCombo();
                this.m_combo.setName("BigDataJsonEntriesTable.ColArrayEditor.JCheckCombo");
            } else {
                this.m_combo = new JComboBox();
                this.m_combo.setName("BigDataJsonEntriesTable.ColArrayEditor.JComboBox");
                this.m_combo.setEditable(true);
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            DefaultComboBoxModel<String> listModel = new DefaultComboBoxModel<String>();
            for (String string : this.m_allowed) {
                listModel.addElement(string);
            }
            if (value instanceof BigDataJsonEntry) {
                value = ((BigDataJsonEntry)value).getValueFragment();
            }
            if (this.m_combo instanceof JCheckCombo) {
                TreeSet<String> selectedNames = new TreeSet<String>();
                if (value instanceof BigDataJsonArray) {
                    for (SQLFragment frag : ((BigDataJsonArray)value).getArguments()) {
                        this.addColumnName(frag, selectedNames);
                    }
                } else if (value instanceof SQLFragment) {
                    this.addColumnName((SQLFragment)value, selectedNames);
                }
                DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
                for (String name : selectedNames) {
                    if (!this.m_allowed.contains(name)) {
                        listModel.insertElementAt(name, 0);
                    }
                    int i = listModel.getIndexOf(name);
                    defaultListSelectionModel.addSelectionInterval(i, i);
                }
                ((JCheckCombo)this.m_combo).setModel(listModel, (ListSelectionModel)defaultListSelectionModel);
            } else {
                String sel = null;
                if (value instanceof SQLFragment) {
                    sel = ((SQLFragment)value).getSQLText();
                }
                this.m_combo.setModel(listModel);
                this.m_combo.setSelectedItem(sel);
            }
            return this.m_combo;
        }

        private void addColumnName(SQLFragment frag, Set<String> names) {
            String txt;
            if (frag != null && ModelUtil.hasLength((String)(txt = frag.getSQLText()))) {
                names.add(txt);
            }
        }

        @Override
        public Object getCellEditorValue() {
            Object valueFragment;
            boolean forceArray = this.m_combo instanceof JCheckCombo;
            boolean optional = BigDataJsonEntry.isJsonEntryOptional((String)BigDataJsonEntriesTable.this.m_param.getName(), (String)this.m_entryName);
            Object[] selected = this.m_combo.getSelectedObjects();
            if (forceArray || selected.length > 1) {
                if (selected.length == 0 && optional) {
                    valueFragment = null;
                } else {
                    valueFragment = new BigDataJsonArray();
                    for (Object name : selected) {
                        valueFragment.addArgument(this.createFragment((String)name));
                    }
                }
            } else {
                String val = (String)BigDataJsonEntriesTable.getSelectedItem(this.m_combo);
                valueFragment = val == null || !optional ? this.createFragment(val == null ? "" : val) : null;
            }
            return valueFragment == null ? null : new BigDataJsonEntry(this.m_entryName, (SQLFragment)valueFragment);
        }

        private SQLFragment createFragment(String text) {
            SimpleSQLFragment retval;
            Column col;
            Column column = col = BigDataJsonEntriesTable.this.m_relation == null ? null : BigDataJsonEntriesTable.this.m_relation.getColumn(text);
            if (col != null) {
                TemporaryObjectID.setID((DBObject)col, (boolean)false);
                DBObjectID id = col.getID();
                retval = new ColumnUsage(id);
            } else {
                retval = new SimpleSQLFragment(text);
            }
            return retval;
        }
    }

    private class SimpleCellEditor
    extends AbstractCellEditor
    implements ExtendedTable.ExtendedTableCellEditor {
        private final JTextComponent m_editor;
        private final String m_entryName;

        SimpleCellEditor(String entryName, JTextComponent editor) {
            this.m_entryName = entryName;
            this.m_editor = editor;
            this.m_editor.setName("BigDataJsonEntriesTable.SimpleCellEditor");
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof BigDataJsonEntry[]) {
                value = ((BigDataJsonEntry[])value)[0];
            }
            if (value instanceof BigDataJsonEntry) {
                value = ((BigDataJsonEntry)value).getValueFragment();
            }
            String text = null;
            if (value instanceof SQLFragment) {
                text = ((SQLFragment)value).getSQLText();
            }
            this.m_editor.setText(text);
            return this.m_editor;
        }

        @Override
        public Object getCellEditorValue() {
            return new BigDataJsonEntry(this.m_entryName, (SQLFragment)new SimpleSQLFragment(this.m_editor.getText()));
        }

        @Override
        public void prepareComponent(Component component) {
            if (component == this.m_editor) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (SimpleCellEditor.this.m_editor.isVisible() && !SimpleCellEditor.this.m_editor.hasFocus()) {
                            SimpleCellEditor.this.m_editor.requestFocusInWindow();
                        }
                    }
                });
            }
        }
    }

    private class Renderer
    extends DefaultTableCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof BigDataJsonEntry[]) {
                StringBuilder text = new StringBuilder();
                for (int i = 0; i < ((BigDataJsonEntry[])value).length; ++i) {
                    BigDataJsonEntry entry = ((BigDataJsonEntry[])value)[i];
                    if (i == 0) {
                        text.append(entry.getValueSQLText());
                        continue;
                    }
                    text.append(", ");
                    text.append(entry.getSQLText());
                }
                value = text.toString().trim();
            } else if (value instanceof BigDataJsonEntry) {
                value = ((BigDataJsonEntry)value).getValueSQLText();
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private class BigDataValueArrayTableModel
    extends ExtendedTable.StringTableModel {
        BigDataValueArrayTableModel(Vector<Vector> model) {
            super(BigDataJsonEntriesTable.this, model, BigDataJsonEntriesTable.this.getColumnNames());
        }
    }
}

