/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.components.DelegateComponentWrapper;
import oracle.ideimpl.db.components.FKColumnIDsComponentWrapper;
import oracle.ideimpl.db.components.InternalChildIdArrayWrapper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.UniqueConstraint;

public class ConstraintColumnIDsComponentWrapper
extends DelegateComponentWrapper {
    @Override
    protected void registerDelegateWrappers() {
        this.registerDelegateWrapper("UniqueConstraint", new UKWrapper());
        this.registerDelegateWrapper("FKConstraint", new FKColumnIDsComponentWrapper());
    }

    public FKColumnIDsComponentWrapper getFKWrapper() {
        return (FKColumnIDsComponentWrapper)this.getDelegate("FKConstraint");
    }

    @Override
    protected String getDelegateKey() {
        String retval = "UniqueConstraint";
        DBObject obj = this.getUpdatedObject();
        if (obj instanceof FKConstraint) {
            retval = "FKConstraint";
        }
        return retval;
    }

    private static class UKWrapper
    extends InternalChildIdArrayWrapper {
        public UKWrapper() {
            super(Column.class, null, true);
        }

        @Override
        public void setPropertyValue(Object val) {
            DBObject obj = this.getUpdatedObject();
            if (obj instanceof UniqueConstraint) {
                super.setPropertyValue(val);
            }
        }

        @Override
        protected boolean checkPropertyIsSupported() {
            boolean retval = false;
            if (!(this.getUpdatedObject() instanceof FKConstraint)) {
                retval = super.checkPropertyIsSupported();
            }
            return retval;
        }

        @Override
        protected Component createComponentForLayout() {
            Component base;
            Component retval = base = super.createComponentForLayout();
            if (this.getComponentContext().getEditorConfig().isChildEditOnly() && DBEditorFactoryRegistry.getCreateFactory(this.getProvider(), "COLUMN") != null) {
                retval = new JPanel();
                DBUILayoutHelper layout = new DBUILayoutHelper((JPanel)retval, this.getComponentContext().isInFlatEditor());
                layout.add(base, 1, 1, true, true);
                layout.nextRow();
                JButton button = this.createAddColumnButton();
                layout.add(button);
                layout.getConstraints((Component)button).anchor = 13;
                layout.layout();
            }
            return retval;
        }

        private JButton createAddColumnButton() {
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.addColumn();
                }
            };
            action.putValue("Name", UIBundle.get("PK_ADD_COLUMN"));
            return new JButton(action);
        }

        private void addColumn() {
            DBEditorFactory factory = DBEditorFactoryRegistry.getCreateFactory(this.getProvider(), "COLUMN");
            if (factory != null) {
                DBEditorConfig config = DBEditorConfig.newEditConfig(this.getProvider(), this.getUpdatedObject().getParent());
                config.setObjectType("COLUMN");
                config.setChildEditOnly(true);
                config.setCommitToProvider(false);
                factory.launchDialog(config);
                if (config.getResult() == DBEditorConfig.Result.SUCCESS) {
                    this.initialiseComponent();
                    this.refreshObject(this.getComponentContext().getUpdatedObject());
                }
            }
        }
    }
}

