/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import javax.swing.JLabel;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.components.DBObjectIDComponentWrapper;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.components.BooleanPropertyComponentWrapper;
import oracle.ideimpl.db.components.DataTypeUsageWrapper;
import oracle.ideimpl.db.components.DatePropertyComponentWrapper;
import oracle.ideimpl.db.components.EnumPropertyComponentWrapper;
import oracle.ideimpl.db.components.ExternalChildIdArrayWrapper;
import oracle.ideimpl.db.components.IndexPartitionTypePropertyWrapper;
import oracle.ideimpl.db.components.InternalChildIdArrayWrapper;
import oracle.ideimpl.db.components.NumberPropertyComponentWrapper;
import oracle.ideimpl.db.components.PartitionTypePropertyWrapper;
import oracle.ideimpl.db.components.SchemaComponentWrapper;
import oracle.ideimpl.db.components.SizableNumberPropertyComponentWrapper;
import oracle.ideimpl.db.components.SystemObjectIdArrayWrapper;
import oracle.ideimpl.db.components.TextPropertyComponentWrapper;
import oracle.ideimpl.db.components.UnlimitedNumberComponentWrapper;
import oracle.ideimpl.db.components.UnlimitedSizableNumberComponentWrapper;
import oracle.ideimpl.db.extension.DatabaseUIExtensionHook;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public class ComponentFactoryImpl
extends ComponentFactory {
    public ComponentFactoryImpl(String panelName) {
        super(panelName);
    }

    public ComponentFactoryImpl(String panelName, ComponentFactory parent) {
        super(panelName, parent);
    }

    @Override
    public ComponentWrapper createWrapper(ComponentContext ctxt) {
        String propName = Property.getLastProperty((String)ctxt.getPropertyName());
        PropertyInfo propInfo = ctxt.getPropertyInfo();
        ComponentWrapper wrapper = DatabaseUIExtensionHook.getHook().createComponentWrapper(ctxt);
        if (wrapper == null && propInfo != null) {
            DBObject updatedObject = ctxt.getUpdatedObject();
            Class propClz = propInfo.getPropertyClass();
            if (propClz.isArray()) {
                if (propClz.getComponentType() == DBObjectID.class) {
                    if (updatedObject instanceof MaterializedViewLog && "columnIDs".equals(propName)) {
                        DBObjectFilter filter = new DBObjectFilter(){

                            public boolean accept(DBObject obj) {
                                return !ColumnConstraint.isConstrained((Column)((Column)obj), (String[])new String[]{"PKConstraint"}) && ((Column)obj).getVirtualExpressionSource() == null;
                            }
                        };
                        wrapper = new ExternalChildIdArrayWrapper(propInfo.getReferencedClass(), filter, null, false, "masterTableID", "columns");
                    } else if (updatedObject instanceof Trigger && "columnIDs".equals(propName)) {
                        wrapper = new ExternalChildIdArrayWrapper(propInfo.getReferencedClass(), null, 5, false, "baseObjectID", "columns");
                    } else if (updatedObject instanceof LOBDescriptor && "columns".equals(propName)) {
                        DBObjectFilter filter = new DBObjectFilter(){

                            public boolean accept(DBObject obj) {
                                return LOBDescriptor.isLOBColumn((Column)((Column)obj)) || LOBDescriptor.isVARRAYColumn((Column)((Column)obj));
                            }
                        };
                        wrapper = new InternalChildIdArrayWrapper(Column.class, filter, false);
                    } else if (propInfo.isInternalReference()) {
                        wrapper = new InternalChildIdArrayWrapper(propInfo.getReferencedClass(), null, false);
                    } else if (SystemObject.class.isAssignableFrom(propInfo.getReferencedClass())) {
                        DBObjectCriteria crit = new DBObjectCriteria(propInfo.getReferencedClass(), new String[0]);
                        wrapper = new SystemObjectIdArrayWrapper((Class<? extends DBObject>)propInfo.getReferencedClass(), null, false, crit);
                    }
                }
            } else if (String.class.isAssignableFrom(propClz) || propName.equals("default")) {
                Collection allowedValues = ctxt.getProvider().getPropertyManager().getAllowedPropertyValues(ctxt.getOriginalObject(), updatedObject, propName);
                wrapper = allowedValues != null ? new EnumPropertyComponentWrapper() : TextPropertyComponentWrapper.createTextWrapper(ctxt);
            } else if (Boolean.class.isAssignableFrom(propClz) || propClz.equals(Boolean.TYPE)) {
                wrapper = propInfo.getNullBehaviour() == Nullable.NullBehaviour.NOT_NULLABLE || propInfo.getNullBehaviour() == Nullable.NullBehaviour.NULL_MEANS_FALSE ? new BooleanPropertyComponentWrapper() : new EnumPropertyComponentWrapper();
            } else if (Integer.class.isAssignableFrom(propClz) || propClz.equals(Integer.TYPE)) {
                wrapper = propInfo.isNumberPhysicalSize() ? new SizableNumberPropertyComponentWrapper() : (propInfo.isNumberUnlimited() ? new UnlimitedNumberComponentWrapper(propInfo.getNumberUnlimitedValue()) : new NumberPropertyComponentWrapper());
            } else if (BigInteger.class.isAssignableFrom(propClz)) {
                if (propInfo.isNumberUnlimited()) {
                    if (propInfo.isNumberPhysicalSize()) {
                        wrapper = new UnlimitedSizableNumberComponentWrapper();
                    } else {
                        wrapper = new UnlimitedNumberComponentWrapper(propInfo.getNumberUnlimitedValue());
                        ((UnlimitedNumberComponentWrapper)wrapper).setUseBigIntegers(true);
                    }
                } else if (propInfo.isNumberPhysicalSize()) {
                    wrapper = new SizableNumberPropertyComponentWrapper();
                } else {
                    wrapper = new NumberPropertyComponentWrapper();
                    ((NumberPropertyComponentWrapper)wrapper).setUseBigIntegers(true);
                }
            } else if (DBObjectID.class.isAssignableFrom(propClz)) {
                wrapper = new DBObjectIDComponentWrapper();
            } else if (Enum.class.isAssignableFrom(propClz)) {
                wrapper = OracleTablePartitions.PartitionType.class.isAssignableFrom(propClz) ? new PartitionTypePropertyWrapper() : (OracleIndexPartitions.PartitionType.class.isAssignableFrom(propClz) ? new IndexPartitionTypePropertyWrapper() : new EnumPropertyComponentWrapper());
            } else if (Date.class.isAssignableFrom(propClz)) {
                wrapper = new DatePropertyComponentWrapper();
            } else if (Schema.class.isAssignableFrom(propClz)) {
                wrapper = new SchemaComponentWrapper();
            } else if (DataTypeUsage.class.isAssignableFrom(propClz)) {
                wrapper = new DataTypeUsageWrapper();
            } else if (SQLFragment.class.isAssignableFrom(propClz)) {
                wrapper = TextPropertyComponentWrapper.createMultiLineSQLTextWrapper(propInfo);
            }
        }
        if (wrapper == null) {
            throw new IllegalArgumentException("Property \"" + propName + "\" not supported by ComponentFactory");
        }
        wrapper.initialise(ctxt);
        return wrapper;
    }

    @Override
    public void registerComponent(JLabel label, Component component, String labelText, String componentName, String propPath) {
        if (ModelUtil.hasLength((String)propPath)) {
            DummyComponentWrapper wrapper = new DummyComponentWrapper(component, label);
            if (this.getEditorConfig() == null) {
                Namespace ns = new Namespace();
                ns.put(DBEditorConfig.class.getName(), (Object)DBEditorConfig.newEmptyConfig(null));
                this.setDataContext(ns);
            }
            ComponentContext ctxt = this.createComponentContext(propPath, null, null);
            wrapper.initialise(ctxt);
            this.registerComponentWrapper(wrapper);
        }
        if (label == null) {
            this.getResourceHelper().setName(component, componentName);
        } else {
            this.getResourceHelper().resLabel(label, component, labelText, componentName);
        }
    }

    public void setUpdatedObject(DBObject update) {
        for (ComponentWrapper wrapper : this.getComponentWrappers()) {
            if (!(wrapper instanceof DummyComponentWrapper)) continue;
            wrapper.getComponentContext().setUpdatedObject(update);
        }
    }

    private class DummyComponentWrapper
    extends ComponentWrapper {
        private final JLabel m_label;

        public DummyComponentWrapper(Component component, JLabel label) {
            super(component);
            this.m_label = label;
        }

        @Override
        public Object getPropertyValue() {
            return null;
        }

        @Override
        public void setPropertyValue(Object val) {
        }

        @Override
        protected void initialiseComponentListener() {
        }

        @Override
        protected Component getDefaultValidationComponent() {
            return this.m_label;
        }

        @Override
        public JLabel getLabel() {
            return this.m_label;
        }
    }
}

