/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import oracle.ide.db.components.DBObjectIDComponentWrapper;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnSequenceProcessor;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.plsql.Trigger;

public class ColSeqTriggerComponentWrapper
extends DBObjectIDComponentWrapper {
    @Override
    protected boolean isFixedSchema() {
        return true;
    }

    @Override
    protected void setupObjectChooser(DBObjectChooser chooser) {
        super.setupObjectChooser(chooser);
        DBObjectFilter filter = new DBObjectFilter(){

            public boolean accept(DBObject obj) {
                SystemObject tab = ColSeqTriggerComponentWrapper.this.getComponentContext().getUpdatedSystemObject();
                if (obj instanceof Trigger) {
                    Trigger trig = (Trigger)obj;
                    if (!tab.getID().equals(trig.getBaseObjectID())) {
                        return false;
                    }
                    if (trig.isStatementLevel()) {
                        return false;
                    }
                    for (String event : trig.getEvents()) {
                        if (!"INSERT".equals(event)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
        chooser.setFilter(filter);
    }

    @Override
    protected void initialiseNewObject(SystemObject obj) {
        Column col = (Column)this.getUpdatedObject();
        Trigger trigger = (Trigger)obj;
        String name = this.getProvider().getUniqueName("TRIGGER", (DBObject)trigger.getSchema(), col.getRelation().getName() + "_TRG");
        ColumnSequenceProcessor.initialiseTrigger((Trigger)trigger, (DBObjectProvider)this.getProvider(), (Table)((Table)col.getRelation()), (String)name);
    }

    @Override
    protected boolean isShowAddButton() {
        return true;
    }

    @Override
    protected DBObjectChooser createObjectChooser(DBObjectChooser parent, String ... types) {
        DBObjectProvider pro = this.getProvider();
        Table table = (Table)this.getUpdatedObject().getParent();
        DBObjectLister lister = pro.getDescriptor().getTriggerLister(pro);
        DBObjectCriteria criteria = new DBObjectCriteria((SystemObject)table);
        return new DBObjectChooser(parent, lister, (DBObjectCriteria<SystemObject>)criteria, types);
    }
}

