/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.Context;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.model.Node;
import oracle.ide.util.Namespace;

public abstract class AsynchronousComponentWrapper<T extends Component>
extends ComponentWrapper<T> {
    private static final String CANCEL_CLIENT_PROP = "AsynchronousComponentWrapper.cancellingComponent";
    private boolean m_dirty;
    private boolean m_suppressWrite;

    public AsynchronousComponentWrapper(T component) {
        super(component);
    }

    public final boolean writeUpdates() {
        return this.writeUpdatesImpl(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeUpdatesImpl(boolean silent) {
        boolean retval = true;
        this.prepareForWrite();
        if (this.m_dirty) {
            boolean tryCommit;
            boolean revert;
            retval = false;
            boolean showErrorDialog = !silent;
            boolean bl = revert = silent || this.getComponentContext().isInFlatEditor();
            if (this.m_suppressWrite) {
                if (revert) {
                    showErrorDialog = false;
                    tryCommit = true;
                } else {
                    tryCommit = false;
                }
            } else {
                tryCommit = true;
            }
            if (tryCommit) {
                try {
                    this.fireVetoableChangeEvent();
                    retval = true;
                    this.m_suppressWrite = false;
                }
                catch (PropertyVetoException pve) {
                    String message;
                    this.m_suppressWrite = true;
                    if (showErrorDialog && (message = pve.getMessage()) != null) {
                        this.showError(message);
                    }
                    if (revert) {
                        PropertyChangeEvent pce = pve.getPropertyChangeEvent();
                        if (pce != null) {
                            this.setPropertyValue(pce.getOldValue());
                        }
                        this.cancelUpdates();
                    }
                }
                finally {
                    if (this.m_suppressWrite) {
                        SwingUtilities.invokeLater(() -> {
                            this.m_suppressWrite = false;
                        });
                    }
                }
            }
            if (retval) {
                this.m_dirty = false;
            }
            this.writeFinished(retval);
        }
        return retval;
    }

    protected void prepareForWrite() {
    }

    protected void writeFinished(boolean successful) {
    }

    protected void cancelUpdates() {
        if (this.m_dirty) {
            this.m_dirty = false;
            this.m_suppressWrite = false;
        }
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.getFocusComponents()[0];
    }

    public Component[] getFocusComponents() {
        return new Component[]{this.getActiveComponent()};
    }

    @Override
    protected void initialiseComponentListener() {
        Component[] comps = this.getFocusComponents();
        if (comps != null) {
            for (Component comp : comps) {
                comp.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        AsynchronousComponentWrapper.this.gainingFocus();
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        AsynchronousComponentWrapper.this.losingFocus();
                        if (!AsynchronousComponentWrapper.this.m_suppressWrite) {
                            boolean cc = AsynchronousComponentWrapper.isCancellingComponent(e.getOppositeComponent(), e.getComponent());
                            AsynchronousComponentWrapper.this.writeUpdatesImpl(cc);
                        }
                    }
                });
            }
        }
    }

    protected final void markDirty() {
        Namespace parent;
        this.m_dirty = true;
        this.m_suppressWrite = false;
        Namespace dataContext = this.getComponentContext().getDataContext();
        while ((parent = dataContext.getParent()) != null && parent != dataContext) {
            dataContext = parent;
        }
        AsynchronousComponentWrapper current = (AsynchronousComponentWrapper)dataContext.find(AsynchronousComponentWrapper.class);
        if (current != this) {
            if (current != null) {
                current.writeUpdatesImpl(true);
            }
            dataContext.put(AsynchronousComponentWrapper.class.getName(), (Object)this);
        }
        if (this.getComponentContext().isInFlatEditor()) {
            Node node;
            Context context = (Context)dataContext.find(Context.class);
            Node node2 = node = context == null ? null : context.getNode();
            if (node != null) {
                node.markDirty(true);
            }
        }
    }

    protected void gainingFocus() {
    }

    protected void losingFocus() {
    }

    protected boolean isDirty() {
        return this.m_dirty;
    }

    protected void processUpdate(DocumentEvent evt) {
        if (evt.getLength() != 0) {
            this.markDirty();
        }
    }

    public static boolean commitCurrentWrapper(Namespace dataContext, boolean cancelOnFail, boolean onExit) {
        boolean retval = true;
        AsynchronousComponentWrapper current = (AsynchronousComponentWrapper)dataContext.find(AsynchronousComponentWrapper.class);
        if (current != null && (retval = current.writeUpdatesImpl(cancelOnFail)) && onExit) {
            dataContext.remove(AsynchronousComponentWrapper.class.getName());
        }
        return retval;
    }

    public static void cancelCurrentWrapper(Namespace dataContext) {
        AsynchronousComponentWrapper current = (AsynchronousComponentWrapper)dataContext.find(AsynchronousComponentWrapper.class);
        if (current != null) {
            current.cancelUpdates();
        }
    }

    public static void registerCancellingComponent(JComponent c, Component parent) {
        c.putClientProperty(CANCEL_CLIENT_PROP, parent);
    }

    private static boolean isCancellingComponent(Component c, Component focusLostFrom) {
        Object parent;
        boolean retval = false;
        if (c instanceof JComponent && (parent = ((JComponent)c).getClientProperty(CANCEL_CLIENT_PROP)) instanceof Component) {
            for (Component test = focusLostFrom; test != null; test = test.getParent()) {
                if (parent != test) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    protected class AsynchronousDocumentListener
    implements DocumentListener {
        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            AsynchronousComponentWrapper.this.processUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AsynchronousComponentWrapper.this.processUpdate(e);
        }
    }
}

