/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.awt.Component;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.DBObjectPlSqlNode;
import oracle.ide.db.panels.sql.tester.SQLQueryTester;
import oracle.ide.dialogs.ProgressBar;
import oracle.ideimpl.db.ceditor.DBEditorConnectionProvider;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlDatum;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlStatement;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.token.Token;

public class PlSqlQueryTester {
    private PlSqlQueryTester() {
    }

    public static boolean enableTestQuery(Context ctx) {
        try {
            return PlSqlQueryTester.getSelectTokens(ctx, false) != null;
        }
        catch (CancelledException e) {
            return false;
        }
    }

    public static void invokeTestQuery(final Context ctx) {
        Component parent = ctx.getView().getGUI();
        final ProgressBar pbar = new ProgressBar(parent, UIBundle.get("TEST_QUERY_ACTION"), null, true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    PlSqlQueryTester.invokeTestQueryImpl(ctx);
                }
                catch (CancelledException ce) {
                    DBLog.getLogger((Object)this).fine(ce.getMessage());
                }
                finally {
                    pbar.setDoneStatus();
                }
            }
        };
        pbar.setRunnable(runnable);
        pbar.setCancelable(true);
        pbar.start(null, null, 1500);
    }

    private static void invokeTestQueryImpl(final Context ctx) throws CancelledException {
        PlSqlToken[] toks;
        SourceObject obj = ((BaseDBObjectTextNode)ctx.getNode()).getDBObjectFromBuffer();
        final Database db = DBEditorConnectionProvider.getCurrentDatabase(ctx);
        if (obj != null && (toks = PlSqlQueryTester.getSelectTokens(ctx, true)) != null && toks.length == 4) {
            PlSqlToken startTk = toks[0];
            PlSqlToken endTk = toks[1];
            PlSqlToken intoStartTk = toks[2];
            PlSqlToken intoEndTk = toks[3];
            StringBuilder sb = new StringBuilder(startTk.getSource(false, (Token)endTk));
            boolean inInto = false;
            for (PlSqlToken tk = endTk; tk != startTk && !Thread.currentThread().isInterrupted(); tk = (PlSqlToken)tk.getPrevCodeToken()) {
                DBObjectPlSqlFragment ref;
                CancelledException.checkInterrupt();
                if (tk == intoEndTk) {
                    inInto = true;
                    continue;
                }
                if (tk == intoStartTk) {
                    inInto = false;
                    sb.replace(intoStartTk.getStart() - startTk.getStart(), intoEndTk.getEnd() - startTk.getStart() + 1, "");
                    continue;
                }
                if (inInto || !((ref = ((DBObjectPlSqlFragment)obj).getReferenceAtOffset(tk.getStart())) instanceof PlSqlReference)) continue;
                DBObjectID refID = ((PlSqlReference)ref).getReferenceID();
                if (!Metadata.getInstance().isTypeOf(PlSqlDatum.class, refID.getType())) continue;
                DBObject refObj = null;
                try {
                    refObj = ((PlSqlReference)ref).getReferenceID().resolveID();
                }
                catch (CancelledException ce) {
                    throw ce;
                }
                catch (DBException e) {
                    DBLog.getLogger(PlSqlQueryTester.class).warning(e.getMessage());
                }
                PlSqlSourceObject otherSource = (PlSqlSourceObject)DBUtil.getSchemaObject((DBObject)refObj);
                PlSqlParser parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)otherSource, (DBObjectProvider)db);
                if (parser == null) continue;
                PlSqlSearch s = new PlSqlSearch("? constant ?% := <def {^{;}}...>;");
                PlSqlToken tk2 = parser.getTokenAtOffset(((PlSqlDatum)refObj).getStartOffset().intValue());
                if (s.matches(tk2)) {
                    sb.replace(tk.getStart() - startTk.getStart(), tk.getEnd() - startTk.getStart() + 1, s.getNamedMatch("def"));
                    continue;
                }
                if (((PlSqlToken)tk.getPrevCodeToken()).matches(".")) {
                    sb.replace(tk.getStart() - startTk.getStart() - 1, tk.getStart() - startTk.getStart(), "_");
                    continue;
                }
                sb.insert(tk.getStart() - startTk.getStart(), ":");
            }
            if (!Thread.currentThread().isInterrupted()) {
                String[] lines = sb.toString().split("\n");
                final StringBuilder sb2 = new StringBuilder();
                for (int i = 0; i < lines.length; ++i) {
                    String line;
                    if (lines[i] == null || (line = lines[i].trim()) == null || line.length() <= 0) continue;
                    sb2.append(line);
                    sb2.append("\n");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SQLQueryTester sqlTester = new SQLQueryTester(db);
                        sqlTester.showDialog(((CodeEditor)ctx.getView()).getDefaultFocusComponent(), sb2.toString());
                    }
                });
            }
        }
    }

    private static PlSqlToken[] getSelectTokens(Context ctx, boolean strict) throws CancelledException {
        PlSqlToken[] ret = null;
        PlSqlSearch selSearch = new PlSqlSearch("{SELECT|WITH} {^;}...");
        PlSqlSearch selWithIntoSearch = new PlSqlSearch("{SELECT|WITH} {^INTO|BULK COLLECT INTO|;}... <into [[BULK COLLECT]INTO {^FROM}...]> {^;}...");
        if (ctx.getView() instanceof CodeEditor && ctx.getNode() instanceof DBObjectPlSqlNode) {
            CodeEditor ceditor = (CodeEditor)ctx.getView();
            BaseDBObjectTextNode node = (BaseDBObjectTextNode)ctx.getNode();
            PlSqlSourceObject obj = node != null ? (PlSqlSourceObject)node.getDBObject() : null;
            if (obj != null) {
                PlSqlToken startTk = null;
                PlSqlToken endTk = null;
                PlSqlToken intoStartTk = null;
                PlSqlToken intoEndTk = null;
                PlSqlParser parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)obj, (DBObjectProvider)node.getProvider());
                if (parser != null) {
                    int pos = ceditor.getSelectionStart();
                    if (ceditor.getSelectedText() != null) {
                        startTk = parser.getTokenAtOffset(ceditor.getSelectionStart());
                        if (startTk != null) {
                            if (!startTk.isCode()) {
                                startTk = (PlSqlToken)startTk.getNextCodeToken();
                            }
                            if ((endTk = parser.getTokenAtOffset(ceditor.getSelectionEnd() - 1)) != null) {
                                if (!endTk.isCode()) {
                                    endTk = (PlSqlToken)endTk.getPrevCodeToken();
                                }
                                if (endTk.matches(";")) {
                                    endTk = (PlSqlToken)endTk.getPrevCodeToken();
                                }
                                if (selWithIntoSearch.matches(startTk)) {
                                    intoStartTk = selWithIntoSearch.getNamedMatchStartToken("into");
                                    intoEndTk = selWithIntoSearch.getNamedMatchEndToken("into");
                                } else if (!selSearch.matches(startTk)) {
                                    startTk = null;
                                    endTk = null;
                                }
                            }
                        }
                    } else if (!strict) {
                        PlSqlToken tk = parser.getTokenAtOffset(ceditor.getSelectionStart());
                        if (tk != null) {
                            endTk = tk;
                            while (tk.isCode()) {
                                if (tk.matches("select")) {
                                    startTk = tk;
                                    break;
                                }
                                if (tk.matches(";")) {
                                    endTk = null;
                                    break;
                                }
                                tk = (PlSqlToken)tk.getPrevCodeToken();
                            }
                        }
                    } else {
                        DBObjectPlSqlFragment frag;
                        for (frag = obj.getDeclarationAtOffset(pos); frag != null && !(frag instanceof PlSqlStatement); frag = (DBObjectPlSqlFragment)frag.getParent()) {
                        }
                        if (frag instanceof PlSqlStatement) {
                            PlSqlToken firstTk = parser.getTokenAtOffset(frag.getStartOffset().intValue());
                            DBObjectPlSqlFragment parFrag = (DBObjectPlSqlFragment)frag.getParent();
                            if (parFrag != null) {
                                PlSqlSearch selInLoopSearch;
                                PlSqlToken parFirstTk = parser.getTokenAtOffset(parFrag.getStartOffset().intValue());
                                if (((PlSqlStatement)frag).getStatementType() == PlSqlStatement.Type.STATEMENT && selWithIntoSearch.matches(firstTk)) {
                                    startTk = selWithIntoSearch.getStartToken();
                                    endTk = selWithIntoSearch.getEndToken();
                                    intoStartTk = selWithIntoSearch.getNamedMatchStartToken("into");
                                    intoEndTk = selWithIntoSearch.getNamedMatchEndToken("into");
                                } else if (((PlSqlStatement)frag).getStatementType() == PlSqlStatement.Type.CURSOR) {
                                    PlSqlSearch selInCursorSearch = new PlSqlSearch("CURSOR {^IS}... IS <select {SELECT|WITH} {^;}...>");
                                    if (selInCursorSearch.matches(parFirstTk)) {
                                        startTk = selInCursorSearch.getNamedMatchStartToken("select");
                                        endTk = selInCursorSearch.getNamedMatchEndToken("select");
                                    }
                                } else if (((PlSqlStatement)frag).getStatementType() == PlSqlStatement.Type.FOR_LOOP && (selInLoopSearch = new PlSqlSearch("FOR ? IN <select (...)> LOOP")).matches(firstTk)) {
                                    startTk = (PlSqlToken)selInLoopSearch.getNamedMatchStartToken("select").getNextCodeToken();
                                    endTk = (PlSqlToken)selInLoopSearch.getNamedMatchEndToken("select").getPrevCodeToken();
                                }
                            }
                        }
                    }
                }
                if (startTk != null && endTk != null) {
                    ret = new PlSqlToken[]{startTk, endTk, intoStartTk, intoEndTk};
                }
            }
        }
        return ret;
    }
}

