/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.spinBox.SpinBox;
import oracle.ide.controls.FlatEditorTransparentPanel;
import oracle.ide.controls.JComboCardPanel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.AbstractSizeChooser;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.panels.TabbedPanel;
import oracle.ideimpl.db.controls.IntegerWithComboPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.mviewlog.MViewLogHeader;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ResizeComponent;
import oracle.javatools.ui.RichHintLabel;
import oracle.javatools.ui.TitledSeparator;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;

public final class DBUILayoutHelper {
    public static final String SHUTTLE = "oracle.ideimpl.db.DBUILayoutHelper.SHUTTLE";
    private static final String MERGED_CONTAINERS_KEY = "oracle.ideimpl.db.DBUILayoutHelper.MERGED_CONTAINERS";
    private static final String MERGED_PARENT_KEY = "oracle.ideimpl.db.DBUILayoutHelper.MERGED_PARENT";
    private DBUILayoutHelper m_parent;
    private final List<DBUILayoutHelper> m_children = new ArrayList<DBUILayoutHelper>();
    private final JPanel m_panel;
    private boolean m_layoutDone;
    private boolean m_reuseLayout;
    private final Map<Component, GridBagConstraints> m_componentMap = new LinkedHashMap<Component, GridBagConstraints>();
    private final List<List<Component>> m_grid = new ArrayList<List<Component>>();
    private List<Component> m_lastRow;
    private final List<Component> m_extras = new ArrayList<Component>();
    private TitledSeparator m_titledSeparator = null;
    private final boolean m_isInFlatEditor;
    private final int CELL_SPACING = 2;
    private int m_x = 0;
    private int m_y = -2;
    private int m_maxx = 0;
    private int m_verticalGap = 0;
    private int m_marginTop = 6;
    private int m_marginLeft = 0;
    private int m_marginBottom = 6;
    private int m_marginRight = 0;
    private static final List<Class<? extends Component>> s_fillHorizontalClz = new ArrayList<Class<? extends Component>>();
    private static final List<Class<? extends Component>> s_fillVerticalClz;
    private static final List<Class<? extends Component>> s_allKnownClz;

    private DBUILayoutHelper(JPanel panel, DBUILayoutHelper parent, boolean flatEditing) {
        this.m_panel = panel;
        if ("oracle.ideimpl.db.components.panels".equals(panel.getClass().getPackage().getName())) {
            this.m_marginTop = 0;
        }
        this.m_parent = parent;
        this.m_isInFlatEditor = flatEditing;
        this.setOpaque(this.m_panel);
        if (parent != null) {
            parent.m_children.add(this);
        }
    }

    public DBUILayoutHelper(JPanel panel) {
        this(panel, null, false);
    }

    public DBUILayoutHelper(JPanel panel, boolean flatEditing) {
        this(panel, null, flatEditing);
    }

    public DBUILayoutHelper newChildHelper(int cellWidth, int cellHeight, boolean fillHorizontal, boolean fillVertical) {
        JPanel panel = new JPanel();
        DBUILayoutHelper child = this.newChildHelperImpl(panel, panel, cellWidth, cellHeight, fillHorizontal, fillVertical);
        child.setMargins(0);
        return child;
    }

    public DBUILayoutHelper newChildHelper(String panelName, int cellWidth, int cellHeight, boolean fillHorizontal, boolean fillVertical) {
        JPanel panel = new JPanel();
        panel.setName(panelName);
        DBUILayoutHelper child = this.newChildHelperImpl(panel, panel, cellWidth, cellHeight, fillHorizontal, fillVertical);
        child.setMargins(0);
        return child;
    }

    @Deprecated
    public DBUILayoutHelper newTitledBorderHelper(String title, int cellWidth, int cellHeight, boolean fillHorizontal, boolean fillVertical) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(title));
        return this.newChildHelperImpl(panel, panel, cellWidth, cellHeight, fillHorizontal, fillVertical);
    }

    @Deprecated
    public DBUILayoutHelper newCheckboxBorderHelper(JCheckBox cbx, int cellWidth, int cellHeight, boolean fillHorizontal, boolean fillVertical) {
        JComboCardPanel cardPanel = new JComboCardPanel(new JLabel(), (JComponent)cbx);
        JPanel panel = new JPanel();
        cardPanel.showSubPanel((JComponent)panel);
        return this.newChildHelperImpl((JPanel)cardPanel, panel, cellWidth, cellHeight, fillHorizontal, fillVertical);
    }

    public DBUILayoutHelper newTitledHelper(String title, int cellWidth, int cellHeight, boolean fillHorizontal, boolean fillVertical) {
        JLabel label = new JLabel(title);
        return this.newTitledHelper(label, cellWidth, cellHeight, fillHorizontal, fillVertical);
    }

    public DBUILayoutHelper newTitledHelper(ComponentWrapper wrapper, int cellWidth, int cellHeight, boolean fillHorizontal, boolean fillVertical) {
        ((Component)wrapper.getActiveComponent()).setForeground(UIManager.getColor("TitledBorder.titleColor"));
        return this.newTitledHelper((JComponent)wrapper.getComponent(), cellWidth, cellHeight, fillHorizontal, fillVertical);
    }

    public DBUILayoutHelper newTitledHelper(JComponent comp, int cellWidth, int cellHeight, boolean fillHorizontal, boolean fillVertical) {
        TitledSeparator sep = new TitledSeparator(comp, TitledSeparator.STYLE.LINE);
        this.add((Component)sep, cellWidth, 1, fillHorizontal, false);
        this.nextRow();
        JPanel panel = new JPanel();
        DBUILayoutHelper childHelper = this.newChildHelperImpl(panel, panel, cellWidth, cellHeight, fillHorizontal, fillVertical);
        childHelper.setTitleSeparator(sep);
        return childHelper;
    }

    private DBUILayoutHelper newChildHelperImpl(JPanel panelToAdd, JPanel panelForChild, int cellWidth, int cellHeight, boolean fillHorizontal, boolean fillVertical) {
        this.add(panelToAdd, cellWidth, cellHeight, fillHorizontal, fillVertical);
        DBUILayoutHelper child = new DBUILayoutHelper(panelForChild, this, this.isInFlatEditor());
        child.setMarginTop(6);
        child.setMarginLeft(10);
        child.setMarginRight(6);
        child.setMarginBottom(10);
        return child;
    }

    public JPanel getPanel() {
        return this.m_panel;
    }

    public void add(Component comp) {
        this.add(comp, 1, 1);
    }

    public void add(Component comp, int cellWidth, int cellHeight) {
        boolean fillHorizontal = false;
        boolean fillVertical = false;
        if (comp != null) {
            boolean known = false;
            for (Class<? extends Component> clz : s_allKnownClz) {
                if (!clz.isAssignableFrom(comp.getClass())) continue;
                known = true;
                break;
            }
            if (!known) {
                throw new IllegalArgumentException("Don't know how to fill component of class " + comp.getClass().getCanonicalName());
            }
            for (Class<? extends Component> clz : s_fillHorizontalClz) {
                if (!clz.isAssignableFrom(comp.getClass())) continue;
                fillHorizontal = true;
                break;
            }
            for (Class<? extends Component> clz : s_fillVerticalClz) {
                if (!clz.isAssignableFrom(comp.getClass())) continue;
                fillVertical = true;
                break;
            }
        }
        this.add(comp, cellWidth, cellHeight, fillHorizontal, fillVertical);
    }

    public void add(Component comp, int cellWidth, int cellHeight, boolean fillHorizontal, boolean fillVertical) {
        Object val;
        if (comp == null) {
            throw new IllegalArgumentException("Component is null");
        }
        if (this.m_y < 0) {
            this.nextRowImpl(this.m_marginTop);
        }
        int fill = 0;
        if (fillHorizontal && fillVertical) {
            fill = 1;
        } else if (fillHorizontal) {
            fill = 2;
        } else if (fillVertical) {
            fill = 3;
        }
        int top = this.m_verticalGap;
        int left = 16;
        if (this.m_y == 0) {
            top = this.m_marginTop;
        }
        if (this.m_x == 0) {
            left = this.m_marginLeft;
        } else if (this.m_lastRow != null && this.m_lastRow.size() > 0) {
            Component prevComp = this.m_lastRow.get(this.m_lastRow.size() - 1);
            if (prevComp instanceof JLabel) {
                if (this.isLabelFor((JLabel)prevComp, comp)) {
                    left = 8;
                    if (fillVertical) {
                        this.getConstraints((Component)prevComp).anchor = 18;
                    }
                }
            } else if (prevComp instanceof JRadioButton && comp instanceof JRadioButton) {
                left = 16;
            } else if (prevComp instanceof JCheckBox && comp instanceof JCheckBox) {
                left = 16;
            } else if (prevComp instanceof AbstractButton && comp instanceof AbstractButton) {
                left = 8;
            }
        }
        if (comp instanceof JComponent && (val = ((JComponent)comp).getClientProperty(SHUTTLE)) instanceof Boolean && ((Boolean)val).booleanValue()) {
            top -= 6;
        }
        GridBagConstraints constr = new GridBagConstraints(this.m_x, this.m_y, 1 + (cellWidth - 1) * 2, 1 + (cellHeight - 1) * 2, fillHorizontal ? 1.0 : 0.0, fillVertical ? 1.0 : 0.0, 17, fill, new Insets(top, left, 0, 0), 0, 0);
        this.m_componentMap.put(comp, constr);
        this.m_lastRow.add(comp);
        this.m_x += cellWidth * 2;
        if (this.m_x > this.m_maxx) {
            this.m_maxx = this.m_x;
        }
    }

    private boolean isLabelFor(JLabel label, Component comp) {
        boolean retval = false;
        if (label.getLabelFor() == comp) {
            retval = true;
        } else if (comp instanceof Container) {
            for (Component child : ((Container)comp).getComponents()) {
                if (!this.isLabelFor(label, child)) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    public void add(ComponentWrapper wrapper) {
        JLabel label = wrapper.getLabel();
        if (label != null) {
            this.add(wrapper.getLabel());
            this.add(wrapper.getComponent());
        } else {
            this.add(wrapper.getComponent(), 2, 1);
        }
    }

    public void addChildren(Component c, Integer ... gridWidths) {
        this.addChildrenImpl(c, gridWidths);
    }

    public void addChildren(ComponentWrapper wrapper, Integer ... gridWidths) {
        this.addChildrenImpl(wrapper.getComponent(), gridWidths);
    }

    private void addChildrenImpl(Component c, Integer ... gridWidths) {
        Container con;
        LayoutManager layout;
        Integer[] widths = gridWidths == null ? new Integer[]{} : gridWidths;
        if (c instanceof Container && (layout = (con = (Container)c).getLayout()) instanceof GridBagLayout) {
            this.addMergedContainer(con);
            GridBagLayout gbl = (GridBagLayout)layout;
            int currRow = -999;
            int currCol = 0;
            for (Component comp : con.getComponents()) {
                if (comp instanceof Box.Filler) continue;
                GridBagConstraints gbc = gbl.getConstraints(comp);
                if (currRow != gbc.gridy) {
                    if (this.m_lastRow != null && this.m_lastRow.size() > 0) {
                        this.nextRow();
                        currCol = 0;
                    }
                    currRow = gbc.gridy;
                }
                int gridwidth = currCol < widths.length ? 1 + (widths[currCol] - 1) * 2 : gbc.gridwidth;
                boolean fillHoriz = gbc.fill == 1 || gbc.fill == 2;
                boolean fillVert = gbc.fill == 1 || gbc.fill == 3;
                this.add(comp, gridwidth, gbc.gridheight, fillHoriz, fillVert);
                if (gbc.gridx != 0) {
                    this.getConstraints((Component)comp).insets.left = gbc.insets.left;
                }
                ++currCol;
            }
        }
    }

    private void addMergedContainer(Container c) {
        ArrayList<Container> containers = (ArrayList<Container>)this.m_panel.getClientProperty(MERGED_CONTAINERS_KEY);
        if (containers == null) {
            containers = new ArrayList<Container>();
            this.m_panel.putClientProperty(MERGED_CONTAINERS_KEY, containers);
        }
        containers.add(c);
        if (c instanceof JComponent) {
            ((JComponent)c).putClientProperty(MERGED_PARENT_KEY, this.m_panel);
        }
    }

    public void nextRow() {
        this.nextRowImpl(6);
    }

    public void nextRowWithGap() {
        this.nextRowImpl(16);
    }

    private void nextRowImpl(int gap) {
        this.m_x = 0;
        this.m_y += 2;
        this.m_lastRow = new ArrayList<Component>();
        this.m_grid.add(this.m_lastRow);
        this.m_verticalGap = gap;
    }

    public void nextColumn() {
        this.m_x += 2;
        if (this.m_x > this.m_maxx) {
            this.m_maxx = this.m_x;
        }
    }

    public void pushUp() {
        this.nextRowImpl(0);
        this.add(Box.createVerticalGlue(), 1, 1, false, true);
    }

    public void pushLeft() {
        this.m_x = this.m_maxx;
        this.add(Box.createHorizontalGlue(), 1, 1, true, false);
    }

    public void indent(Component comp) {
        GridBagConstraints constr = this.getConstraints(comp);
        constr.insets.left += 16;
    }

    public GridBagConstraints getConstraints(Component comp) {
        if (comp == null) {
            throw new IllegalArgumentException("Component is null");
        }
        GridBagConstraints constr = this.m_componentMap.get(comp);
        if (constr == null) {
            throw new IllegalStateException("Component has not been added");
        }
        return constr;
    }

    public void setMinWidth(Component comp, int width) {
        GridBagConstraints compConstr = this.getConstraints(comp);
        if (compConstr != null) {
            Component filler = Box.createHorizontalStrut(width);
            GridBagConstraints fillerConstr = (GridBagConstraints)compConstr.clone();
            ++fillerConstr.gridy;
            fillerConstr.insets.top = 0;
            fillerConstr.insets.bottom = 0;
            this.m_componentMap.put(filler, fillerConstr);
            this.m_extras.add(filler);
        }
    }

    public void setMinHeight(Component comp, int height) {
        GridBagConstraints compConstr = this.getConstraints(comp);
        if (compConstr != null) {
            Component filler = Box.createVerticalStrut(height);
            GridBagConstraints fillerConstr = (GridBagConstraints)compConstr.clone();
            ++fillerConstr.gridx;
            fillerConstr.insets.left = 0;
            fillerConstr.insets.right = 0;
            this.m_componentMap.put(filler, fillerConstr);
            this.m_extras.add(filler);
        }
    }

    public void layout() {
        if (this.m_parent != null) {
            return;
        }
        for (DBUILayoutHelper child : this.m_children) {
            child.m_parent = null;
            child.layout();
        }
        this.m_children.clear();
        if (!this.m_layoutDone && this.m_panel != null && this.m_grid != null) {
            if (!this.m_reuseLayout) {
                this.m_panel.setLayout(new GridBagLayout());
            }
            if (this.m_marginRight > 0) {
                Component filler = Box.createHorizontalStrut(this.m_marginRight);
                GridBagConstraints fillerConstr = new GridBagConstraints();
                fillerConstr.gridx = this.m_maxx + 1;
                fillerConstr.gridy = 1;
                this.m_componentMap.put(filler, fillerConstr);
                this.m_extras.add(filler);
            }
            if (this.m_lastRow != null && this.m_lastRow.size() > 0) {
                for (int i = 0; i < this.m_lastRow.size(); ++i) {
                    GridBagConstraints constr = this.getConstraints(this.m_lastRow.get(i));
                    if (constr == null) continue;
                    constr.insets.bottom = this.m_marginBottom;
                }
            }
            for (List<Component> row : this.m_grid) {
                for (Component comp : row) {
                    this.m_panel.add(this.getComponent(comp), this.getConstraints(comp));
                    this.showDebug(comp);
                }
            }
            for (Component comp : this.m_extras) {
                this.m_panel.add(this.getComponent(comp), this.getConstraints(comp));
                this.showDebug(comp);
            }
            this.showDebug(this.m_panel);
        }
        this.m_componentMap.clear();
        this.m_extras.clear();
        this.m_grid.clear();
        this.m_lastRow.clear();
        this.m_layoutDone = true;
    }

    private void showDebug(Component c) {
        if (c instanceof JComponent && DBUILayoutHelper.isDebug()) {
            final JComponent comp = (JComponent)c;
            if (c != this.m_panel) {
                GridBagConstraints constr = this.getConstraints(comp);
                StringBuffer sb = new StringBuffer("Debug");
                sb.append(": class=").append(comp.getClass());
                sb.append(": name=").append(comp.getName());
                sb.append(": gridx=").append(constr.gridx);
                sb.append(": gridy=").append(constr.gridy);
                sb.append(": gridwidth=").append(constr.gridwidth);
                sb.append(": gridheight=").append(constr.gridheight);
                sb.append(": fill=").append(constr.fill);
                sb.append(": anchor=").append(constr.anchor);
                sb.append(": insets.top=").append(constr.insets.top);
                sb.append(": insets.left=").append(constr.insets.left);
                sb.append(": insets.bottom=").append(constr.insets.bottom);
                sb.append(": insets.right=").append(constr.insets.right);
                comp.setToolTipText(sb.toString());
                comp.addMouseListener(new MouseListener(){
                    private Border m_border = null;
                    private Color m_color;
                    private boolean m_opaque;

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        this.m_border = comp.getBorder();
                        this.m_color = comp.getBackground();
                        this.m_opaque = comp.isOpaque();
                        comp.setBorder(new LineBorder(Color.RED));
                        comp.setBackground(Color.cyan);
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        comp.setBorder(this.m_border);
                        comp.setBackground(this.m_color);
                        comp.setOpaque(this.m_opaque);
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }
                });
            }
        }
    }

    private static boolean isDebug() {
        return Boolean.getBoolean("ide.db.debugLayout");
    }

    public void setMarginTop(int marginTop) {
        this.m_marginTop = marginTop;
    }

    public int getMarginTop() {
        return this.m_marginTop;
    }

    public void setMarginLeft(int marginLeft) {
        this.m_marginLeft = marginLeft;
    }

    public int getMarginLeft() {
        return this.m_marginLeft;
    }

    public void setMarginBottom(int marginBottom) {
        this.m_marginBottom = marginBottom;
    }

    public int getMarginBottom() {
        return this.m_marginBottom;
    }

    public void setMarginRight(int marginRight) {
        this.m_marginRight = marginRight;
    }

    public int getMarginRight() {
        return this.m_marginRight;
    }

    public void setMargins(int margin) {
        this.m_marginTop = margin;
        this.m_marginLeft = margin;
        this.m_marginBottom = margin;
        this.m_marginRight = margin;
    }

    public void setReuseExistingLayout(int row) {
        LayoutManager layout = this.m_panel.getLayout();
        if (layout instanceof GridBagLayout) {
            for (Component c : this.m_panel.getComponents()) {
                GridBagConstraints cons = ((GridBagLayout)layout).getConstraints(c);
                if (cons == null || cons.gridy < row) continue;
                this.m_panel.remove(c);
            }
        } else {
            throw new IllegalStateException("panel must have an existing grid bag");
        }
        this.m_reuseLayout = true;
        this.m_y = row;
        this.nextRow();
    }

    private Component getComponent(Component comp) {
        this.setOpaque(comp);
        return comp;
    }

    private void setOpaque(Component component) {
        if (component instanceof JComponent && this.isInFlatEditor()) {
            if (component instanceof JButton && ((JButton)component).getUI() instanceof IconicButtonUI) {
                ((JButton)component).setOpaque(false);
            } else {
                DBUILayoutHelper.makeTransparentForFlatEditor((JComponent)component);
            }
        }
    }

    private boolean isInFlatEditor() {
        return this.m_isInFlatEditor;
    }

    public TitledSeparator getTitleSeparator() {
        return this.m_titledSeparator;
    }

    private void setTitleSeparator(TitledSeparator titledSeparator) {
        this.m_titledSeparator = titledSeparator;
    }

    public Component wrapForInvisibility(Component comp) {
        JPanel retval = new JPanel();
        DBUILayoutHelper layout = new DBUILayoutHelper(retval, this.isInFlatEditor());
        layout.add(comp, 1, 1, true, true);
        layout.layout();
        return retval;
    }

    public static JScrollPane createFlatScrollPane(Component comp) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        }
        JScrollPane retval = new JScrollPane(comp);
        retval.setBorder(null);
        retval.setBackground(UIManager.getColor("window"));
        retval.getViewport().setBackground(UIManager.getColor("window"));
        retval.getVerticalScrollBar().setUnitIncrement(20);
        retval.getHorizontalScrollBar().setUnitIncrement(20);
        return retval;
    }

    public static Collection<Container> getMergedContainers(JPanel panel) {
        return (Collection)panel.getClientProperty(MERGED_CONTAINERS_KEY);
    }

    public static JPanel getMergedParent(JComponent comp) {
        JPanel par2;
        JPanel retval = (JPanel)comp.getClientProperty(MERGED_PARENT_KEY);
        if (retval != null && (par2 = DBUILayoutHelper.getMergedParent(retval)) != null) {
            retval = par2;
        }
        return retval;
    }

    public static void makeTransparentForFlatEditor(JComponent comp) {
        FlatEditorTransparentPanel.makeTransparent((JComponent)comp);
    }

    static {
        s_fillHorizontalClz.add(JList.class);
        s_fillHorizontalClz.add(JTextField.class);
        s_fillHorizontalClz.add(JTextArea.class);
        s_fillHorizontalClz.add(JMultiLineLabel.class);
        s_fillHorizontalClz.add(JComboBox.class);
        s_fillHorizontalClz.add(JSplitPane.class);
        s_fillHorizontalClz.add(DateEditor.class);
        s_fillHorizontalClz.add(DBObjectChooser.class);
        s_fillHorizontalClz.add(AbstractSizeChooser.class);
        s_fillHorizontalClz.add(JScrollPane.class);
        s_fillHorizontalClz.add(ResizeComponent.class);
        s_fillHorizontalClz.add(Shuttle.class);
        s_fillHorizontalClz.add(ComponentWithTitlebar.class);
        s_fillHorizontalClz.add(ReorderableTableWithTitleBar.class);
        s_fillHorizontalClz.add(JWrappedLabel.class);
        s_fillHorizontalClz.add(RichHintLabel.class);
        s_fillHorizontalClz.add(TitledSeparator.class);
        s_fillHorizontalClz.add(JTabbedPane.class);
        s_fillHorizontalClz.add(TabbedPanel.class);
        s_fillHorizontalClz.add(ChildObjectEditorPanel.class);
        s_fillHorizontalClz.add(MViewLogHeader.class);
        s_fillHorizontalClz.add(IntegerWithComboPanel.class);
        s_fillVerticalClz = new ArrayList<Class<? extends Component>>();
        s_fillVerticalClz.add(JList.class);
        s_fillVerticalClz.add(JTextArea.class);
        s_fillVerticalClz.add(JSplitPane.class);
        s_fillVerticalClz.add(ResizeComponent.class);
        s_fillVerticalClz.add(JScrollPane.class);
        s_fillVerticalClz.add(ComponentWithTitlebar.class);
        s_fillVerticalClz.add(ReorderableTableWithTitleBar.class);
        s_fillVerticalClz.add(JWrappedLabel.class);
        s_fillVerticalClz.add(JTabbedPane.class);
        s_fillVerticalClz.add(TabbedPanel.class);
        s_fillVerticalClz.add(ChildObjectEditorPanel.class);
        s_fillVerticalClz.add(MViewLogHeader.class);
        s_allKnownClz = new ArrayList<Class<? extends Component>>();
        s_allKnownClz.add(JLabel.class);
        s_allKnownClz.add(JPanel.class);
        s_allKnownClz.add(AbstractButton.class);
        s_allKnownClz.add(JWrappedLabel.class);
        s_allKnownClz.add(SpinBox.class);
        s_allKnownClz.addAll(s_fillHorizontalClz);
    }
}

