/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.util;

import java.awt.Color;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import oracle.javatools.util.ModelUtil;

public class LiveValidationController {
    private JComponent m_comp;
    private Popup m_pup;
    private int m_xOffset = 10;
    private int m_yOffset = 2;

    public LiveValidationController(JComponent comp) {
        this.m_comp = comp;
    }

    public void setXOffset(int x) {
        this.m_xOffset = x;
    }

    public void setyOffset(int y) {
        this.m_yOffset = y;
    }

    public void hidePopup() {
        this.m_comp.setBackground(new Color(255, 255, 255));
        this.m_comp.getAccessibleContext().setAccessibleDescription(null);
        if (this.m_pup != null) {
            this.m_pup.hide();
            this.m_pup = null;
        }
    }

    public void showError(String error) {
        if (ModelUtil.hasLength((String)error)) {
            Color errorColor = new Color(255, 175, 175);
            this.m_comp.setBackground(errorColor);
            try {
                JToolTip tip = new JToolTip();
                tip.setComponent(this.m_comp);
                tip.setTipText(error);
                tip.setVisible(true);
                tip.setBackground(errorColor);
                tip.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
                Point p = this.m_comp.getLocationOnScreen();
                int x = (int)(p.getX() + this.m_comp.getBounds().getWidth()) + this.m_xOffset;
                int y = (int)p.getY() + this.m_yOffset;
                if (this.m_pup != null) {
                    this.m_pup.hide();
                }
                this.m_pup = PopupFactory.getSharedInstance().getPopup(this.m_comp, tip, x, y);
                this.m_comp.getAccessibleContext().setAccessibleDescription(error);
                this.m_pup.show();
            }
            catch (Exception exception) {}
        } else {
            this.hidePopup();
        }
    }
}

