/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;

public class SelectSchemaPanel
extends DefaultTraversablePanel {
    public static final String USE_DEFAULT_KEY = "USE_DEFAULT";
    private final JLabel m_lblSchemaName = new JLabel();
    private final DBObjectChooser m_pickerSchema = new DBObjectChooser("SCHEMA");
    private final JCheckBox m_useDefault = new JCheckBox();
    private final ItemListener m_listener = new CheckBoxListener();
    private DBObjectProvider m_prov = null;
    private DBObjectID m_previous = null;

    public SelectSchemaPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        DBUIResourceHelper reshelp = new DBUIResourceHelper("SelectSchemaPanel");
        reshelp.resLabel(this.m_lblSchemaName, this.m_pickerSchema, UIBundle.get("SCHEMA_INFO_LABEL_SCHEMA_NAME"), "Schema");
        ResourceUtils.resButton((AbstractButton)this.m_useDefault, (String)UIBundle.get("SCHEMA_USE_DEFAULT"));
        this.add(this.m_lblSchemaName, new GridBagConstraints(10, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this.m_pickerSchema, new GridBagConstraints(20, 10, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_useDefault, new GridBagConstraints(20, 20, 17, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, 100, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public String getHeaderTitle() {
        return UIBundle.get("SCHEMA_HEADER");
    }

    public String getHeaderDescription() {
        return UIBundle.get("SCHEMA_HEADER_DESC");
    }

    public void onEntry(TraversableContext dataContext) {
        DBObjectProvider provider;
        this.m_prov = provider = (DBObjectProvider)dataContext.find("oracle.javatools.db.DBObjectProvider");
        Schema schema = (Schema)dataContext.find("NewObject");
        if (schema != null) {
            this.m_previous = schema.getID();
        }
        boolean useDefault = Boolean.TRUE == dataContext.find(USE_DEFAULT_KEY);
        this.m_pickerSchema.setProvider(provider);
        this.m_pickerSchema.setDBObject((DBObject)schema);
        this.m_pickerSchema.setNullText("");
        this.m_pickerSchema.setEditable(true);
        this.m_useDefault.removeItemListener(this.m_listener);
        this.m_useDefault.setSelected(useDefault);
        this.m_useDefault.addItemListener(this.m_listener);
        this.enablePicker(useDefault);
        WizardCallbacks callbacks = dataContext.getWizardCallbacks();
        if (callbacks != null) {
            callbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
            callbacks.wizardSetInitialFocus((Component)(this.m_pickerSchema.isEnabled() ? this.m_pickerSchema : this.m_useDefault));
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        dataContext.remove("NewObject");
        if (!this.m_useDefault.isSelected()) {
            dataContext.put("NewObject", (Object)this.m_pickerSchema.getOrCreateDBObject());
        } else {
            dataContext.put("NewObject", null);
        }
        dataContext.put(USE_DEFAULT_KEY, (Object)this.m_useDefault.isSelected());
    }

    private void enablePicker(boolean usingDefault) {
        this.m_lblSchemaName.setEnabled(!usingDefault);
        this.m_pickerSchema.setEnabled(!usingDefault);
    }

    private final class CheckBoxListener
    implements ItemListener {
        private CheckBoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean usingDefault = SelectSchemaPanel.this.m_useDefault.isSelected();
            SelectSchemaPanel.this.enablePicker(usingDefault);
            if (usingDefault) {
                SelectSchemaPanel.this.m_previous = SelectSchemaPanel.this.m_pickerSchema.getDBObjectID();
                boolean set = false;
                if (SelectSchemaPanel.this.m_prov != null) {
                    try {
                        SelectSchemaPanel.this.m_pickerSchema.setDBObject((DBObject)SelectSchemaPanel.this.m_prov.getDefaultSchema());
                        set = true;
                    }
                    catch (DBException dbe) {
                        dbe.printStackTrace();
                    }
                }
                if (!set) {
                    SelectSchemaPanel.this.m_pickerSchema.setDBObject(null);
                }
            } else if (SelectSchemaPanel.this.m_previous != null) {
                SelectSchemaPanel.this.m_pickerSchema.setDBObjectID(SelectSchemaPanel.this.m_previous);
            }
        }
    }
}

