/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.model;

import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.model.BaseDBObjectNode;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectFactory;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public abstract class BaseDBObjectTextNode
extends TextNode
implements DBObjectNode {
    private SourceObject m_bufferObject;
    private SourceObject m_tempObject;
    private boolean m_tempSaved;
    private int m_lastChangeId;

    @Override
    public String getProviderType() {
        return "db";
    }

    @Override
    public DBObject getDBObject() {
        return this.findProviderDBObject();
    }

    @Override
    public DBObjectProvider getProvider() {
        return BaseDBObjectNode.findProvider(this);
    }

    public Icon getIcon() {
        Icon icon = DBTypeDisplayRegistry.getNodeIcon(DBObjectNodeUtil.normalizeType(this));
        if (icon != null) {
            return icon;
        }
        return super.getIcon();
    }

    public String getShortLabel() {
        String name = this.getObjectName();
        if (ModelUtil.hasLength((String)name)) {
            return name;
        }
        return super.getShortLabel();
    }

    public int getLine(int offset) {
        LineMap lm;
        int ret = 0;
        TextBuffer buff = this.acquireTextBuffer();
        LineMap lineMap = lm = buff == null ? null : buff.getLineMap();
        if (lm != null) {
            ret = lm.getLineFromOffset(offset) + 1;
        }
        return ret;
    }

    protected void openImpl() throws IOException {
        TextBuffer tb;
        super.openImpl();
        if (!"db".equals(this.getProviderType()) && (tb = this.tryAcquireTextBuffer()) != null) {
            try {
                this.m_lastChangeId = tb.getChangeId();
            }
            finally {
                this.releaseTextBuffer();
            }
        }
    }

    @Deprecated
    public final SourceObject getDBObject(boolean fullyBuilt) {
        return this.getDBObjectFromBuffer();
    }

    public final SourceObject getDBObjectFromBuffer() {
        final Holder ret = new Holder();
        Runnable runUnderLock = new Runnable(){

            @Override
            public void run() {
                ret.set((Object)BaseDBObjectTextNode.this.getDBObjectFromBufferImpl());
            }
        };
        this.runUnderReadLock(runUnderLock);
        return (SourceObject)ret.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourceObject getDBObjectFromBufferImpl() {
        TextBuffer tb;
        DBObjectProvider pro = this.getProvider();
        String type = this.getObjectType();
        if (type != null && pro != null) {
            Object provObj = this.m_tempObject == null || this.m_tempSaved ? this.getDBObject() : null;
            if (provObj == null) {
                this.m_bufferObject = this.getTempObject();
            } else if (provObj instanceof SourceObject) {
                this.m_bufferObject = (SourceObject)provObj;
                this.m_tempObject = null;
            } else {
                this.m_bufferObject = null;
            }
        } else {
            this.m_bufferObject = null;
        }
        if (this.m_bufferObject != null && (tb = this.tryAcquireTextBuffer()) != null) {
            try {
                int changeId;
                if (this.isOpen() && (changeId = tb.getChangeId()) != this.m_lastChangeId) {
                    String source = tb.getString(0, tb.getLength());
                    this.updateSource(this.m_bufferObject, source);
                    this.m_lastChangeId = changeId;
                }
            }
            finally {
                this.releaseTextBuffer();
            }
        }
        return this.m_bufferObject;
    }

    @Deprecated
    public final void cancelCurrentBuild() {
    }

    protected SourceObject findProviderDBObject() {
        return (SourceObject)BaseDBObjectNode.findDBObject(this);
    }

    protected void updateSource(SourceObject so, String source) {
        so.setSource(source);
    }

    private SourceObject getTempObject() {
        if (this.m_tempObject == null) {
            String type = this.getObjectType();
            Class cls = Metadata.getInstance().getObjectClass(type);
            if (cls != null && SourceObject.class.isAssignableFrom(cls)) {
                DBObjectProvider pro = this.getProvider();
                DBObjectFactory fac = pro.getObjectFactory();
                this.m_tempObject = (SourceObject)fac.newObject(cls);
                this.m_tempObject.setName(this.getObjectName());
                this.m_tempObject.setSchema(new Schema(this.getSchemaName()));
                this.m_tempObject.setID(TemporaryObjectID.createID((DBObject)this.m_tempObject));
                this.addNodeListener(new NodeListener(){

                    public void nodeClosed(NodeEvent e) {
                        NodeFactory.uncache((URL)BaseDBObjectTextNode.this.getURL());
                        BaseDBObjectTextNode.this.removeNodeListener(this);
                    }

                    public void nodeSaved(NodeEvent e) {
                        BaseDBObjectTextNode.this.removeNodeListener(this);
                        BaseDBObjectTextNode.this.m_tempSaved = true;
                    }
                });
            }
        }
        return this.m_tempObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetBuffer(SourceObject obj) {
        if (this.isOpen()) {
            TextBuffer buffer = this.acquireTextBuffer();
            try {
                buffer.writeLock();
                try {
                    buffer.beginEdit();
                    try {
                        buffer.removeToEnd(0);
                        String source = obj.getSource();
                        if (source != null) {
                            buffer.append(source.toCharArray());
                        }
                        this.m_lastChangeId = buffer.getChangeId();
                    }
                    finally {
                        buffer.endEdit();
                    }
                }
                finally {
                    buffer.writeUnlock();
                }
            }
            finally {
                this.releaseTextBuffer();
            }
        }
    }
}

