/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.insight.model;

import java.util.Collection;
import javax.swing.Icon;
import oracle.ide.db.insight.model.InsightDataProvider;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.plsql.Package;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.icons.OracleIcons;

public class FunctionProvider
extends InsightDataProvider {
    private static final String[] SCHEMA_OBJECT_TYPES = new String[]{"PACKAGE", "FUNCTION"};
    private Collection<BuiltInFunction> m_funcDefs;
    private final Icon m_funcIcon = OracleIcons.getIcon((String)"function.png");
    private String m_desc;

    @Override
    public void addItems(DBObject parent) throws CancelledException {
        if (this.isTargetClass(DBObject.class, false)) {
            if (parent instanceof Package) {
                for (PlSqlSubProgram sub : ((Package)parent).getSubPrograms()) {
                    CancelledException.checkInterrupt();
                    if (sub.getReturnTypeReference() == null) continue;
                    this.addDBObject((DBObject)sub);
                }
            } else if (parent instanceof Schema) {
                Schema schema = (Schema)parent;
                for (SchemaObject so : this.getMatchingSchemaItems(schema, SCHEMA_OBJECT_TYPES)) {
                    CancelledException.checkInterrupt();
                    this.addDBObject((DBObject)so);
                }
            }
            if (this.isTopLevel(parent)) {
                if (this.m_funcDefs == null) {
                    this.m_funcDefs = this.getProvider().getDescriptor().listBuiltInFunctions();
                    StringBuilder sb = new StringBuilder(this.m_DBInsightProvider.getLanguage());
                    sb.append(" ");
                    sb.append(UIBundle.get("FUNCTION_TYPE"));
                    this.m_desc = sb.toString();
                }
                for (BuiltInFunction fd : this.m_funcDefs) {
                    CancelledException.checkInterrupt();
                    this.addExpression(this.m_desc, this.m_funcIcon, fd.getSignature(false));
                }
            }
        }
    }
}

