/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.insight.completion;

import java.util.List;
import javax.swing.text.JTextComponent;
import oracle.ide.db.insight.model.DBInsightContext;
import oracle.ide.db.insight.model.DBInsightData;
import oracle.ide.db.insight.model.DBInsightProvider;
import oracle.ide.insight.InsightModel;
import oracle.ide.insight.completion.CompletionModel;
import oracle.javatools.db.CancelledException;

class DBCompletionModel
implements CompletionModel<DBInsightData> {
    private final DBInsightProvider m_dbInsightProvider;
    private final JTextComponent m_component;

    DBCompletionModel(DBInsightContext insightContext, JTextComponent component) throws CancelledException {
        this.m_dbInsightProvider = new DBInsightProvider(insightContext);
        this.m_component = component;
    }

    public String getMatchingText() {
        return this.m_dbInsightProvider.getMatchingText();
    }

    public List<DBInsightData> getItems() {
        return this.getMatchingItems();
    }

    public List<DBInsightData> getMatchingItems() {
        return this.m_dbInsightProvider.getInsightData();
    }

    public DBInsightData getDefaultItem() {
        List<DBInsightData> items = this.getMatchingItems();
        if (items.size() > 0) {
            return items.get(0);
        }
        return null;
    }

    public void partialComplete() {
    }

    public InsightModel.Result complete(DBInsightData selectedItem) {
        int start = selectedItem.getReplacementStart();
        int end = selectedItem.getReplacementEnd();
        String text = selectedItem.getName();
        int parenPos = text.indexOf("(");
        int newCursPos = parenPos < 0 ? start + text.length() : start + parenPos + 1;
        this.m_component.setSelectionStart(start);
        this.m_component.setSelectionEnd(end);
        this.m_component.replaceSelection(text);
        this.m_component.setCaretPosition(newCursPos);
        return InsightModel.Result.DONE;
    }
}

