/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.controls.DBObjectPicker;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.dialogs.ProgressBar;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class DBObjectSourcePicker
extends DBObjectPicker {
    private String[] m_types;
    private DBObjectProvider m_pro;
    private Schema m_schema;
    private String m_filter;
    private final JPanel m_component = new JPanel();
    private JWrappedLabel m_emptyLabel;

    public DBObjectSourcePicker(DBObjectProvider pro, boolean showChildren, boolean removeOnShuttle) {
        super(showChildren, removeOnShuttle);
        this.m_pro = pro;
        this.showEmptyUI();
    }

    private void showEmptyUI() {
        if (this.m_emptyLabel == null) {
            this.m_emptyLabel = new JWrappedLabel(UIBundle.get("PICKER_EMPTY"));
            this.m_component.removeAll();
            this.m_component.setLayout(new GridBagLayout());
            this.m_component.setBorder(BorderFactory.createEtchedBorder());
            this.m_component.add((Component)this.m_emptyLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.m_component.validate();
        }
    }

    public void setProvider(DBObjectProvider pro) {
        if (this.m_pro != pro) {
            this.m_pro = pro;
            this.m_top.removeAllChildren();
            this.m_treeModel.reload();
            this.showEmptyUI();
        }
    }

    protected DBObjectProvider getProvider() {
        return this.m_pro;
    }

    public void setTypes(String[] types) {
        this.m_types = types;
    }

    public void setSchema(Schema schema) {
        this.m_schema = schema;
    }

    public boolean setFilter(String filter) {
        if (!ModelUtil.areEqual((Object)this.m_filter, (Object)filter)) {
            this.m_filter = filter;
            return true;
        }
        return false;
    }

    public void query() {
        boolean queried;
        if (this.m_pro instanceof Database) {
            final ProgressBar bar = new ProgressBar(DBMessageDialog.getDialogParent(), UIBundle.get("PICKER_PROGRESS_TITLE"), null, true);
            final Holder pbarThread = new Holder();
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    pbarThread.set((Object)Thread.currentThread());
                    try {
                        DBObjectSourcePicker.this.doQuery(bar);
                    }
                    finally {
                        pbarThread.set(null);
                        bar.setDoneStatus();
                    }
                }
            };
            bar.setRunnable(run);
            bar.start(UIBundle.get("PICKER_PROGRESS_TEXT"), null);
            if (bar.hasUserCancelled()) {
                queried = false;
                Thread t = (Thread)pbarThread.get();
                if (t != null) {
                    StatementWrapper.cancelExecution((Thread)t);
                }
            } else {
                queried = true;
            }
        } else {
            this.doQuery(null);
            queried = true;
        }
        if (queried) {
            this.m_treeModel.setRoot(this.m_top);
            this.m_treeModel.reload();
            if (this.m_emptyLabel != null) {
                this.m_component.removeAll();
                DBUIResourceHelper reshelp = new DBUIResourceHelper(this.getComponentNamePrefix());
                ComponentWithTitlebar tree = (ComponentWithTitlebar)super.getComponent();
                reshelp.setName(tree.getComponent(), "Tree");
                this.m_component.add((Component)tree, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.m_component.setBorder(null);
                this.m_component.validate();
                this.m_emptyLabel = null;
            }
        }
    }

    protected String getComponentNamePrefix() {
        return "DBObjectSourcePicker";
    }

    private void doQuery(ProgressBar bar) {
        DBException error = null;
        try {
            if (this.m_types != null && this.m_types.length > 0) {
                if (bar != null && bar.hasUserCancelled()) {
                    return;
                }
                ArrayList<String> sysObjTypes = new ArrayList<String>();
                ArrayList<String> schemaObjTypes = new ArrayList<String>();
                for (String type : this.m_types) {
                    if (Metadata.getInstance().isTypeOf(SchemaObject.class, type)) {
                        schemaObjTypes.add(type);
                        continue;
                    }
                    if (type.equals("SCHEMA")) continue;
                    sysObjTypes.add(type);
                }
                ArrayList listed = new ArrayList();
                if (!schemaObjTypes.isEmpty()) {
                    DBObjectCriteria crit = DBObjectCriteria.createTypeCriteria(schemaObjTypes);
                    crit.setSchema(this.m_schema);
                    crit.setNameLike(this.m_filter);
                    if (this.m_schema != null && this.m_schema.getID() instanceof BaseObjectID) {
                        crit.setDatabaseName(((BaseObjectID)this.m_schema.getID()).getDatabaseName());
                    }
                    listed.addAll(this.m_pro.listObjects(crit));
                }
                if (bar != null && bar.hasUserCancelled()) {
                    return;
                }
                if (!sysObjTypes.isEmpty()) {
                    DBObjectCriteria crit = DBObjectCriteria.createTypeCriteria(sysObjTypes);
                    crit.setNameLike(this.m_filter);
                    listed.addAll(this.m_pro.listObjects(crit));
                }
                if (bar != null && bar.hasUserCancelled()) {
                    return;
                }
                SystemObject[] objs = this.filterAndSort(listed.toArray(new SystemObject[listed.size()]));
                this.m_top = new DefaultMutableTreeNode("DB_OBJECTS");
                for (int i = 0; i < objs.length; ++i) {
                    if (bar != null && bar.hasUserCancelled()) {
                        return;
                    }
                    DefaultMutableTreeNode node = this.m_nodeMaker.createTreeNode((DBObject)objs[i]);
                    this.m_top.add(node);
                }
            }
        }
        catch (DBException dbe) {
            error = dbe;
        }
        if (bar != null) {
            bar.setDoneStatus();
        }
        if (!(error == null || bar != null && bar.hasUserCancelled() || error instanceof CancelledException)) {
            DBExceptionDialog.showErrorDialog(DBMessageDialog.getDialogParent(), UIBundle.get("QUERY_FAILED"), error);
        }
    }

    protected SystemObject[] filterAndSort(SystemObject[] objs) {
        Arrays.sort(objs, DBUtil.getNameComparator());
        return objs;
    }

    @Override
    public Component getComponent() {
        return this.m_component;
    }
}

