/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.ide.db.DBObjectTransferable;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.util.DBObjectMap;
import oracle.javatools.util.ModelUtil;

public class DBObjectListPicker
extends ListPicker {
    private Collection m_acceptTypes;
    private Map<DBObject, DBObject[]> m_paths;
    private DBObjectRenderer m_renderer;
    private DefaultListModel m_model;
    private boolean m_removeOnShuttle = true;

    public DBObjectListPicker() {
        this(new JList(new DefaultListModel()));
    }

    public DBObjectListPicker(JList list) {
        super(list);
        this.m_model = (DefaultListModel)list.getModel();
        list.setCellRenderer(this.getRenderer());
    }

    public void setRemoveOnShuttle(boolean remove) {
        this.m_removeOnShuttle = remove;
    }

    public void setAcceptTypes(String[] types) {
        this.m_acceptTypes = types == null ? null : Arrays.asList(types);
    }

    public void addDBObject(DBObject obj) {
        this.m_model.addElement(obj);
    }

    protected final ListCellRenderer getRenderer() {
        if (this.m_renderer == null) {
            this.m_renderer = new DBObjectRenderer();
            this.m_renderer.setIncludeIcon(true);
        }
        return this.m_renderer;
    }

    protected Transferable[] filterForAdd(Transferable[] add) {
        if (this.m_acceptTypes != null) {
            ArrayList<Transferable> retval = new ArrayList<Transferable>();
            for (int i = 0; i < add.length; ++i) {
                DBObject obj;
                if (!(add[i] instanceof DBObjectTransferable) || !this.m_acceptTypes.contains((obj = ((DBObjectTransferable)add[i]).getDBObject()).getType())) continue;
                retval.add(add[i]);
            }
            return retval.toArray(new Transferable[retval.size()]);
        }
        return add;
    }

    public DefaultListModel getListModel() {
        return this.m_model;
    }

    public boolean canAcceptFlavors(DataFlavor[] df) {
        if (!this.m_removeOnShuttle) {
            return true;
        }
        for (int i = 0; i < df.length; ++i) {
            Class<?> clz;
            if (df[i] == null || !ModelUtil.areEqual(clz = df[i].getRepresentationClass(), DBObjectTransferable.class)) continue;
            if (this.m_acceptTypes != null) {
                String type = df[i].getHumanPresentableName();
                if (!this.m_acceptTypes.contains(type)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public DataFlavor[] getSelectionDataFlavors() {
        Object[] selected = this.getList().getSelectedValues();
        DataFlavor[] retval = new DataFlavor[selected.length];
        for (int i = 0; i < retval.length; ++i) {
            String type = null;
            if (selected[i] instanceof DBObject) {
                type = ((DBObject)selected[i]).getType();
            } else if (selected[i] instanceof SchemaObjectDescriptor) {
                type = ((SchemaObjectDescriptor)selected[i]).getType();
            }
            retval[i] = DBObjectTransferable.getDataFlavor(type);
        }
        return retval;
    }

    protected Transferable createTransferable(Object obj) {
        if (obj instanceof SchemaObjectDescriptor) {
            obj = ((SchemaObjectDescriptor)obj).getObject();
        }
        if (this.m_paths == null) {
            return new DBObjectTransferable((DBObject)obj);
        }
        return new DBObjectTransferable((DBObject)obj, this.m_paths.get(obj));
    }

    public boolean addSelectedItems(Transferable[] add) {
        if (!this.m_removeOnShuttle) {
            return true;
        }
        Transferable[] toAdd = this.filterForAdd(add);
        for (int i = 0; i < toAdd.length; ++i) {
            if (!(add[i] instanceof DBObjectTransferable)) continue;
            this.cachePath((DBObjectTransferable)add[i]);
        }
        return super.addSelectedItems(toAdd);
    }

    protected void cachePath(DBObjectTransferable trans) {
        DBObject obj = trans.getDBObject();
        DBObject[] path = trans.getPath();
        if (this.m_paths == null) {
            this.m_paths = new DBObjectMap();
        }
        this.m_paths.put(obj, path);
    }

    public void removeSelectedItems() {
        if (this.m_removeOnShuttle) {
            Object[] selection = this.getList().getSelectedValues();
            for (int i = 0; i < selection.length; ++i) {
                Object obj = selection[i];
                if (obj instanceof SchemaObjectDescriptor) {
                    obj = ((SchemaObjectDescriptor)obj).getObject();
                }
                if (!(obj instanceof DBObject) || this.m_paths == null) continue;
                this.m_paths.remove((DBObject)obj);
            }
            super.removeSelectedItems();
        }
    }

    public void removeAllSelectableItems() {
        if (this.m_removeOnShuttle) {
            if (this.m_paths != null) {
                this.m_paths.clear();
            }
            super.removeAllSelectableItems();
        }
    }
}

