/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.components;

import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.components.AsynchronousComponentWrapper;
import oracle.ideimpl.db.controls.IdPanel;
import oracle.ideimpl.db.validate.DBValidationHandler;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

public class DBObjectIDComponentWrapper
extends AsynchronousComponentWrapper<IdPanel> {
    private final DocumentListener m_docList = new AsynchronousComponentWrapper.AsynchronousDocumentListener(this);
    private final DBObjectChooser.ChangeListener m_chooserChangeListener = new DBObjectChooser.ChangeListener(){

        @Override
        public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
            DBObjectIDComponentWrapper.this.fireChangeEvent();
        }
    };
    private DBObjectChooser m_cmbSchema;
    private DBObjectChooser m_cmbParent;
    private DBObjectChooser m_cmbObject;

    public DBObjectIDComponentWrapper() {
        super(new IdPanel());
    }

    @Override
    public Object getPropertyValue() {
        return this.m_cmbObject.getDBObjectID();
    }

    @Override
    public void setValidationStatus(Collection<ValidationException> ves, DBValidationHandler handler) {
        this.setValidationStatus(this.m_cmbSchema, ves, handler);
        this.setValidationStatus(this.m_cmbParent, ves, handler);
        this.setValidationStatus(this.m_cmbObject, ves, handler);
    }

    private void setValidationStatus(DBObjectChooser chooser, Collection<ValidationException> ves, DBValidationHandler handler) {
        if (chooser != null) {
            if (chooser != this.m_cmbObject && chooser.getDBObjectID() != null) {
                ves = null;
            }
            handler.processValidation(chooser.isEditable() ? chooser.getEditorComponent() : chooser, this, ves);
        }
    }

    @Override
    public void setPropertyValue(Object value) {
        this.enableDocListener(false);
        DBObjectID id = null;
        if (value instanceof DBObjectID) {
            id = (DBObjectID)value;
        }
        DBObjectID curr = this.m_cmbObject.getDBObjectID();
        if (id == null || !id.equals(curr, true)) {
            DBObjectID parId = DBUtil.getUppermostParent((DBObjectID)id);
            this.setSelectedSchema(parId);
            if (this.m_cmbParent != null) {
                this.m_cmbParent.setDBObjectID(parId);
            }
            this.m_cmbObject.removeChangeListener(this.m_chooserChangeListener);
            this.m_cmbObject.setDBObjectID(id);
            this.m_cmbObject.addChangeListener(this.m_chooserChangeListener);
        }
        this.enableDocListener(true);
    }

    private void setSelectedSchema(DBObjectID schemaObjectID) {
        if (this.m_cmbSchema != null) {
            String dbName;
            String schemaName;
            DBObjectProvider pro = this.getProvider();
            if (schemaObjectID instanceof BaseObjectID) {
                schemaName = ((BaseObjectID)schemaObjectID).getSchemaName();
                dbName = ((BaseObjectID)schemaObjectID).getDatabaseName();
            } else {
                schemaName = DBUtil.getSchemaName((DBObjectID)schemaObjectID);
                dbName = null;
            }
            Schema defaultSchema = this.getDefaultSchema();
            if (ModelUtil.hasLength((String)dbName) || ModelUtil.hasLength((String)schemaName)) {
                NameBasedID schemaID = null;
                try {
                    DBObjectCriteria crit = new DBObjectCriteria(Schema.class, new String[0]);
                    crit.setDatabaseName(dbName);
                    crit.setName(schemaName);
                    Schema schema = (Schema)pro.getObject(crit);
                    if (schema != null) {
                        schemaID = schema.getID();
                    }
                }
                catch (DBException dbe) {
                    DBLog.getLogger((Object)this).warning(dbe.getMessage());
                }
                if (schemaID == null) {
                    schemaID = new NameBasedID("SCHEMA", null, schemaName);
                    schemaID.setDatabaseName(dbName);
                }
                this.m_cmbSchema.setDBObjectID((DBObjectID)schemaID);
            } else if (defaultSchema != null && ModelUtil.areDifferent((Object)defaultSchema.getName(), (Object)pro.getDescriptor().getPublicSchemaName())) {
                this.m_cmbSchema.setDBObject((DBObject)defaultSchema);
            } else {
                try {
                    this.m_cmbSchema.setDBObject((DBObject)pro.getDefaultSchema());
                }
                catch (DBException dbe) {
                    DBLog.getLogger((Object)this).warning(dbe.getMessage());
                }
            }
        }
    }

    @Override
    protected void gainingFocus() {
        this.enableDocListener(true);
    }

    @Override
    protected void losingFocus() {
        this.enableDocListener(false);
    }

    private void enableDocListener(boolean enable) {
        Component editorComp = this.m_cmbObject.getEditorComponent();
        if (editorComp instanceof JTextField) {
            JTextField tf = (JTextField)editorComp;
            tf.getDocument().removeDocumentListener(this.m_docList);
            if (enable) {
                tf.getDocument().addDocumentListener(this.m_docList);
            }
        }
    }

    @Override
    protected void initialiseComponent() {
        boolean isFixedSchema = this.isFixedSchema();
        boolean editable = this.isEditable();
        Schema defaultSchema = this.getDefaultSchema();
        ComponentContext context = this.getComponentContext();
        PropertyInfo propInfo = context.getPropertyInfo();
        DBObjectProvider pro = this.getProvider();
        String propname = context.getPropertyName();
        String[] types = this.getTypesFilterForProperty();
        String[] parentTypes = null;
        boolean isInTable = context.isInTable();
        DBUIResourceHelper resHelp = new DBUIResourceHelper("");
        boolean useHeader = false;
        if (!propInfo.isInternalReference()) {
            Metadata m = Metadata.getInstance();
            boolean hasSchemaObject = false;
            boolean hasNonSchemaObject = false;
            boolean hasChildObject = false;
            for (String type : types) {
                Class typeClz = m.getObjectClass(type);
                if (SchemaObject.class.isAssignableFrom(typeClz)) {
                    hasSchemaObject = true;
                    continue;
                }
                if (ChildDBObject.class.isAssignableFrom(typeClz)) {
                    hasChildObject = true;
                    continue;
                }
                hasNonSchemaObject = true;
            }
            Collection parentTypesToCheck = pro.getPropertyManager().getAllowedReferenceParentTypes(context.getUpdatedObject(), propname);
            if (parentTypesToCheck != null && parentTypesToCheck.size() > 0) {
                parentTypes = new String[parentTypesToCheck.size()];
                int i = 0;
                for (String parType : parentTypesToCheck) {
                    if (m.isSchemaObject(parType)) {
                        hasSchemaObject = true;
                    }
                    parentTypes[i++] = parType;
                }
            }
            if (hasSchemaObject && hasNonSchemaObject) {
                types = DBUtil.filterSchemaObjectTypes((String[])types);
            }
            if (hasChildObject && parentTypes == null) {
                throw new IllegalStateException("Cannot pick child objects with a parent picker.");
            }
            boolean bl = useHeader = !isInTable && parentTypes != null;
            if (hasSchemaObject && !isFixedSchema) {
                this.m_cmbSchema = new DBObjectChooser("SCHEMA");
                this.m_cmbSchema.setEditable(editable);
                if (this.isShowDBLinkButton()) {
                    this.m_cmbSchema.setShowDBLinkButton(true);
                }
            }
            if (parentTypes != null) {
                this.m_cmbParent = new DBObjectChooser(this.m_cmbSchema, parentTypes);
                this.m_cmbParent.setEditable(editable);
            }
        }
        this.m_cmbObject = this.createObjectChooser(this.m_cmbParent == null ? this.m_cmbSchema : this.m_cmbParent, types);
        this.m_cmbObject.setEditable(editable);
        boolean showAdd = this.isShowAddButton();
        boolean showEdit = this.isShowEditButton();
        if (this.getComponentContext().isInFlatEditor() && (showAdd || showEdit)) {
            this.m_cmbObject.setShowAddButton(showAdd);
            this.m_cmbObject.setAddButtonProcessor(new DBObjectChooser.NewObjectProcessor(){

                @Override
                public void initialise(SystemObject so) {
                    DBObjectIDComponentWrapper.this.initialiseNewObject(so);
                }
            });
            this.m_cmbObject.setShowEditButton(showEdit);
        } else if (showAdd) {
            this.m_cmbObject.setEditable(true);
        }
        if (PropertyDisplayRegistry.hasNlsStringForPropValue(propname, null)) {
            this.m_cmbObject.setNullText(PropertyDisplayRegistry.getPropValueDisplay(propname, null));
        }
        this.setupObjectChooser(this.m_cmbObject);
        if (this.m_cmbParent != null) {
            this.setupParentChooser(this.m_cmbParent);
        }
        DBObjectChooser top = this.getTopChooser();
        top.setProvider(pro);
        top.setDBObject(null);
        if (propInfo.isInternalReference()) {
            this.m_cmbObject.setContextDBObjectID(context.getEditorConfig().getUpdatedObject().getID());
        } else if (isFixedSchema) {
            DBObjectChooser sobjsChooser = this.m_cmbParent == null ? this.m_cmbObject : this.m_cmbParent;
            sobjsChooser.setContextDBObjectID(defaultSchema.getID());
        } else if (this.isIncludeContextObject()) {
            DBObjectID objIDWeAreEditing = context.getEditorConfig().getUpdatedObject().getID();
            String typeWeAreEditing = objIDWeAreEditing.getType();
            if (Arrays.asList(types).contains(typeWeAreEditing)) {
                this.m_cmbObject.addIDToList(objIDWeAreEditing);
            } else if (this.m_cmbParent != null && Arrays.asList(parentTypes).contains(typeWeAreEditing)) {
                this.m_cmbParent.addIDToList(objIDWeAreEditing);
            }
        }
        IdPanel panel = (IdPanel)this.getActiveComponent();
        panel.setName(propname);
        panel.initialisePanel(this.m_cmbObject, this.m_cmbParent, this.m_cmbSchema, context, this.getPropertyDisplayName(), useHeader);
    }

    private DBObjectChooser getTopChooser() {
        DBObjectChooser retval = this.m_cmbSchema != null ? this.m_cmbSchema : (this.m_cmbParent != null ? this.m_cmbParent : this.m_cmbObject);
        return retval;
    }

    private String[] getTypesFilterForProperty() {
        DBObjectProvider pro = this.getProvider();
        PropertyInfo info = this.getComponentContext().getPropertyInfo();
        Collection types = pro.getPropertyManager().getAllowedReferenceTypes(info);
        if (types == null || types.size() == 0) {
            throw new IllegalStateException("Property has insufficient @References metadata: " + info.getPropertyName());
        }
        return types.toArray(new String[types.size()]);
    }

    @Override
    protected void initialiseComponentListener() {
        super.initialiseComponentListener();
        this.m_cmbObject.addChangeListener(this.m_chooserChangeListener);
    }

    @Override
    protected void setActiveImpl(boolean active) {
        boolean inFlatEditor = this.getComponentContext().isInFlatEditor();
        this.activateChooser(this.m_cmbSchema, active, inFlatEditor, inFlatEditor);
        this.activateChooser(this.m_cmbParent, active, inFlatEditor, inFlatEditor);
        this.activateChooser(this.m_cmbObject, active, inFlatEditor, inFlatEditor || this.getComponentContext().getPropertyInfo().isInternalReference());
    }

    private void activateChooser(DBObjectChooser chooser, boolean active, boolean useProviderListener, boolean resetCaches) {
        if (chooser != null) {
            chooser.setActive(active, useProviderListener, resetCaches);
        }
    }

    @Override
    public Component[] getFocusComponents() {
        return new Component[]{this.m_cmbObject.getEditorComponent()};
    }

    protected void setupObjectChooser(DBObjectChooser chooser) {
    }

    protected void setupParentChooser(DBObjectChooser chooser) {
    }

    protected boolean isEditable() {
        return false;
    }

    protected boolean isIncludeContextObject() {
        return true;
    }

    protected boolean isFixedSchema() {
        return false;
    }

    protected Schema getDefaultSchema() {
        DBObject obj = this.getUpdatedObject();
        return DBUtil.getSchema((DBObject)obj);
    }

    protected boolean isShowAddButton() {
        return false;
    }

    protected boolean isShowEditButton() {
        return !"schema".equals(this.getPropertyName());
    }

    protected boolean isShowDBLinkButton() {
        return false;
    }

    protected void initialiseNewObject(SystemObject obj) {
    }

    protected DBObjectChooser createObjectChooser(DBObjectChooser parent, String ... types) {
        return new DBObjectChooser(parent, types);
    }

    protected final DBObjectChooser getSchemaChooser() {
        return this.m_cmbSchema;
    }

    protected final DBObjectChooser getParentChooser() {
        return this.m_cmbParent;
    }

    protected final DBObjectChooser getObjectChooser() {
        return this.m_cmbObject;
    }
}

