/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HexDisplay {
    public static InputStream wrap(InputStream is) {
        return new HexDisplayInputStream(is);
    }

    public static OutputStream wrap(OutputStream os) {
        return new HexDisplayOutputStream(os);
    }

    public static String format(byte[] bytes) {
        HexBuffer display = new HexBuffer();
        for (byte aByte : bytes) {
            display.addByte(aByte);
        }
        return display.toString();
    }

    public static class HexBuffer {
        private StringBuffer m_buffer = new StringBuffer("\n");
        private byte[] m_bytes = new byte[32];
        private int m_count;
        private static final int BYTES_PER_GROUP = 8;
        private static final int GROUPS_PER_LINE = 4;
        private static final int BYTES_PER_LINE = 32;
        private static final int LAST_IN_GROUP = 7;

        public String toString() {
            if (this.m_count != 0) {
                this.formatBytes();
            }
            return this.m_buffer.toString();
        }

        void addByte(byte b) {
            if (this.m_count == this.m_bytes.length) {
                this.formatBytes();
            }
            this.m_bytes[this.m_count++] = b;
        }

        private void formatBytes() {
            int i;
            for (i = 0; i < this.m_count; ++i) {
                byte aByte = this.m_bytes[i];
                this.formatOneByte(aByte);
                if (i % 8 != 7) continue;
                this.m_buffer.append(' ');
            }
            for (i = this.m_count; i < 32; ++i) {
                this.m_buffer.append("  ");
            }
            for (i = this.m_count / 8; i < 4; ++i) {
                this.m_buffer.append(' ');
            }
            this.m_buffer.append("  ");
            for (i = 0; i < this.m_count; ++i) {
                if (this.m_bytes[i] >= 32) continue;
                this.m_bytes[i] = 0;
            }
            this.m_buffer.append(new String(this.m_bytes, 0, this.m_count));
            this.m_buffer.append('\n');
            this.m_count = 0;
        }

        private void formatOneByte(byte aByte) {
            int value = aByte & 0xFF;
            if (value < 16) {
                this.m_buffer.append('0');
            }
            this.m_buffer.append(Integer.toHexString(value));
        }
    }

    private static class HexDisplayOutputStream
    extends OutputStream {
        private HexBuffer m_display = new HexBuffer();
        private OutputStream m_stream;

        public HexDisplayOutputStream(OutputStream stream) {
            this.m_stream = stream;
        }

        @Override
        public void flush() throws IOException {
            this.m_stream.flush();
            System.out.println("flushing output stream:" + this.m_display);
            this.m_display = new HexBuffer();
        }

        @Override
        public void close() throws IOException {
            this.m_stream.close();
            System.out.println("closing output stream:" + this.m_display);
        }

        @Override
        public void write(int b) throws IOException {
            this.m_display.addByte((byte)b);
            this.m_stream.write(b);
        }
    }

    private static class HexDisplayInputStream
    extends BufferedInputStream {
        public HexDisplayInputStream(InputStream stream) {
            super(stream);
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            int numRead = super.read(b, off, len);
            if (numRead <= 0) {
                return numRead;
            }
            HexBuffer display = new HexBuffer();
            for (int i = 0; i < numRead; ++i) {
                display.addByte(b[i + off]);
            }
            System.out.println("Read in (" + numRead + " bytes):" + display);
            return numRead;
        }
    }
}

