/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.annotation.logging.MessageInfo;

public class LoggingUtils {
    private Logger m_logger;
    public Map<String, Level> m_levels;

    public static String logAndReturnMessage(Logger logger, Level level, String key, Object ... params) {
        logger.log(level, key, params);
        return LoggingUtils.getMessage(logger, key, params);
    }

    public static String getMessage(Logger logger, String key, Object ... params) {
        return MessageFormat.format(logger.getResourceBundle().getString(key), params);
    }

    public static String formatMessage(LogRecord lr) {
        return MessageFormat.format(lr.getResourceBundle().getString(lr.getMessage()), lr.getParameters());
    }

    public static void logWarningStackTrace(Logger logger, Throwable throwable) {
        if (logger.isLoggable(Level.FINE)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            logger.fine(sw.toString());
        }
    }

    public static void logSevereStackTrace(Logger logger, Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        logger.severe(sw.toString());
    }

    public LoggingUtils(Logger logger) {
        this.m_logger = logger;
    }

    private Level getLevel(String messageId) {
        if (this.m_levels == null) {
            this.m_levels = this.getAnnotatedLevels();
        }
        return this.m_levels.containsKey(messageId) ? this.m_levels.get(messageId) : Level.INFO;
    }

    private Map<String, Level> getAnnotatedLevels() {
        HashMap<String, Level> annotatedLevels = new HashMap<String, Level>();
        for (Field field : this.m_logger.getResourceBundle().getClass().getFields()) {
            try {
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !String.class.equals(field.getType())) continue;
                String id = (String)field.get(null);
                MessageInfo messageInfo = field.getAnnotation(MessageInfo.class);
                if (messageInfo == null) continue;
                annotatedLevels.put(id, messageInfo.severity().getLevel());
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return annotatedLevels;
    }

    public boolean isLoggable(String messageId) {
        return this.m_logger.isLoggable(this.getLevel(messageId));
    }

    public void log(String messageId, Object ... parameters) {
        this.m_logger.log(this.getLevel(messageId), messageId, parameters);
    }

    public void logWithThrowable(String messageId, Throwable throwable, Object ... parameters) {
        Level level = this.getLevel(messageId);
        LogRecord logRecord = new LogRecord(level, messageId);
        if (this.shouldLogStackTrace(level)) {
            logRecord.setThrown(throwable);
        }
        logRecord.setParameters(parameters);
        logRecord.setLoggerName(this.m_logger.getName());
        this.m_logger.log(logRecord);
    }

    public void logAndEchoToConsole(String messageId, Throwable throwable, Object ... parameters) {
        this.logWithThrowable(messageId, throwable, parameters);
        System.err.println(this.getFormattedMessage(messageId, parameters));
    }

    public String getFormattedMessage(String messageId, Object ... parameters) {
        return LoggingUtils.getMessage(this.m_logger, messageId, parameters);
    }

    private boolean shouldLogStackTrace(Level level) {
        return level == Level.SEVERE || level == Level.WARNING && this.m_logger.isLoggable(Level.FINE);
    }
}

