/*
 * Decompiled with CFR 0.152.
 */
package oracle.annotation.logging.processor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Merge {
    private static final FilenameFilter HTML_FILES = new FilenameFilter(){

        @Override
        public boolean accept(File f, String name) {
            return name.endsWith(".html");
        }
    };
    private HashMap<String, String> locations = new HashMap();
    private HashMap<String, HashMap<String, String>> components = new HashMap();
    private HashMap<String, Counter> componentCounters = new HashMap();
    private int fileCount = 0;
    private int messageCount = 0;
    private int componentCount = 0;
    private HashMap<String, File> baseFileNames = new HashMap();
    private HashMap<String, Boolean> validationLogs = new HashMap();

    public void run(String outFile, String[] fileOrDir) {
        for (int i = 0; i < fileOrDir.length; ++i) {
            this.readFileOrDir(fileOrDir[i]);
        }
        this.writeFile(outFile);
        System.out.println("INFO: merged " + this.fileCount + " files with " + this.messageCount + " messages from " + this.componentCount + " components into the file " + outFile + ".");
        this.writeHtmlFile(outFile);
    }

    private void readFileOrDir(String fileOrDir) {
        File f = new File(fileOrDir);
        if (f.isDirectory()) {
            File[] files = f.listFiles(HTML_FILES);
            if (files == null || files.length == 0) {
                System.out.println("WARNING: no *.xml files found in directory " + f);
            } else {
                for (File file : files) {
                    this.readFile(file);
                }
            }
        } else {
            this.readFile(f);
        }
    }

    private void readFile(File f) {
        String base = f.toString();
        if (base.endsWith(".xml")) {
            base = base.substring(0, base.length() - ".xml".length());
        } else if (base.endsWith(".html")) {
            base = base.substring(0, base.length() - ".html".length());
        } else if (base.endsWith(".txt")) {
            base = base.substring(0, base.length() - ".txt".length());
        }
        File htmlFile = new File(base + ".html");
        File xmlFile = new File(base + ".xml");
        File vlogFile = new File(base + ".txt");
        if (xmlFile.exists() || htmlFile.exists()) {
            if (xmlFile.exists()) {
                if (this.baseFileNames.get(base) == null) {
                    this.baseFileNames.put(base, xmlFile);
                    boolean valid = true;
                    if (vlogFile.exists()) {
                        try {
                            List<String> issues = this.readValidationLog(vlogFile);
                            boolean bl = valid = issues.size() == 0;
                            if (!valid) {
                                System.out.println("SEVERE: Validation failed for " + xmlFile + " - your messages may not be uploaded until you have fixed" + (issues.size() == 1 ? " the following issue:" : " these " + issues.size() + " issues:"));
                                if (issues.size() == 1) {
                                    System.out.println("  - " + issues.get(0));
                                } else {
                                    for (int i = 0; i < issues.size(); ++i) {
                                        System.out.println(" " + i + " - " + issues.get(i));
                                    }
                                }
                            }
                            this.validationLogs.put(base, new Boolean(valid));
                        }
                        catch (Exception e) {
                            System.out.println("SEVERE: Error reading from " + f + ": " + e);
                        }
                    }
                    if (valid) {
                        this.readXMLFile(xmlFile);
                        ++this.fileCount;
                    } else {
                        System.out.println("SEVERE: Did not include messages from " + xmlFile);
                    }
                }
            } else if (htmlFile.exists()) {
                this.baseFileNames.put(base, htmlFile);
            }
        } else {
            System.out.println("SEVERE: Neither " + xmlFile + " nor " + htmlFile + " exists!");
        }
    }

    private void readXMLFile(File f) {
        block16: {
            if (!f.exists()) {
                System.out.println("WARNING: " + f + " does not exist. Skipped.");
                return;
            }
            if (f.isDirectory()) {
                System.out.println("WARNING: " + f + " is a directory, not a file. Skipped.");
                return;
            }
            if (!f.canRead()) {
                System.out.println("WARNING: Unable to read file " + f + ". Skipped.");
                return;
            }
            LineNumberReader lnr = null;
            String fileName = f.toString();
            String component = "-1";
            String key = "";
            String prefix = "";
            String number = "";
            StringBuffer message = new StringBuffer();
            int startLine = 0;
            int endLine = 0;
            boolean isError = false;
            boolean isOther = false;
            String line = null;
            String lt = null;
            try {
                lnr = new LineNumberReader(new BufferedReader(new FileReader(f)));
                while ((line = lnr.readLine()) != null) {
                    lt = line.trim();
                    if (lnr.getLineNumber() == 1 && lt.startsWith("<?xml version=") || lt.equals("<messages>") && lt.equals("</messages>")) continue;
                    if (lt.startsWith("<component number='")) {
                        component = this.unFix(lt, "<component number='", "'>");
                        continue;
                    }
                    if (lt.equals("</component>")) continue;
                    if (lt.equals("<message>")) {
                        key = "";
                        prefix = "";
                        number = "";
                        startLine = lnr.getLineNumber();
                        message = new StringBuffer();
                        isOther = false;
                        isError = false;
                        continue;
                    }
                    if (lt.equals("</message>")) {
                        key = prefix + "-" + number;
                        endLine = lnr.getLineNumber();
                        this.addMessage(fileName, startLine, endLine, component, key, message.toString(), isError, isOther);
                        continue;
                    }
                    if (lt.startsWith("<prefix>")) {
                        prefix = this.unFix(lt, "<prefix>", "</prefix>");
                    } else if (lt.startsWith("<number>")) {
                        number = this.unFix(lt, "<number>", "</number>");
                    }
                    if (line.indexOf("<category>Other</category>") >= 0) {
                        isOther = true;
                    }
                    if (line.indexOf("<type>ERROR</type>") >= 0) {
                        isError = true;
                    }
                    message.append(line);
                    message.append("\n");
                }
            }
            catch (Exception e) {
                System.out.println("SEVERE: Error reading from " + f + ": " + e);
                if (lnr == null) break block16;
                try {
                    lnr.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readValidationLog(File f) throws IOException {
        ArrayList<String> issues = new ArrayList<String>();
        BufferedReader lnr = null;
        String fileName = f.toString();
        String line = null;
        String lt = null;
        try {
            lnr = new LineNumberReader(new BufferedReader(new FileReader(f)));
            while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                lt = line.trim();
                if (!lt.startsWith("[validate] Error:")) continue;
                issues.add(lt.substring("[validate] Error:".length()).trim());
            }
            ArrayList<String> arrayList = issues;
            return arrayList;
        }
        finally {
            if (lnr != null) {
                try {
                    lnr.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private String unFix(String s, String prefix, String postfix) {
        if (prefix != null && s.startsWith(prefix)) {
            s = s.substring(prefix.length());
        }
        if (postfix != null && s.endsWith(postfix)) {
            s = s.substring(0, s.length() - postfix.length());
        }
        return s.trim();
    }

    private void addMessage(String fileName, int startLine, int endLine, String component, String key, String message, boolean isError, boolean isOther) {
        if (this.locations.get(key) != null) {
            System.out.println("SEVERE: " + fileName + ":" + startLine + "-" + endLine + ": duplicate message " + "with key " + key + ". Original message at " + this.locations.get(key) + ". " + "Duplicate message will be skipped.");
        } else {
            this.locations.put(key, fileName + ":" + startLine + "-" + endLine);
            HashMap<String, String> messages = this.components.get(component);
            if (messages == null) {
                messages = new HashMap();
                this.components.put(component, messages);
                ++this.componentCount;
            }
            messages.put(key, message);
            ++this.messageCount;
            Counter counter = this.componentCounters.get(component);
            if (counter == null) {
                counter = new Counter();
                this.componentCounters.put(component, counter);
            }
            counter.addMessage(isError, isOther);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String fileName) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            String[] compNames = this.getSortedKeys(this.components);
            if (compNames.length == 0) {
                System.out.println("SEVERE: No components will be listed in the merged file " + fileName + ".");
            } else {
                pw.println("<messages>");
                for (String comp : compNames) {
                    HashMap<String, String> messages = this.components.get(comp);
                    String[] msgKeys = this.getSortedKeys(messages);
                    if (msgKeys.length == 0) {
                        System.out.println("WARNING: No messages for component " + comp + " in the merged file " + fileName + ".");
                        continue;
                    }
                    if (!this.componentCounters.get(comp).hasGoodRatio()) {
                        Counter ctr = this.componentCounters.get(comp);
                        System.out.println("WARNING: component " + comp + " has " + ctr.getPercentOther() + "% 'Other' error messages (" + ctr.getOtherCount() + " of " + ctr.getErrorCount() + ")");
                    }
                    pw.println("     <component number='" + comp + "'>");
                    for (String key : msgKeys) {
                        pw.println("          <message>");
                        pw.print(messages.get(key));
                        pw.println("          </message>");
                    }
                    pw.println("     </component>");
                }
                pw.println("</messages>");
            }
        }
        catch (Exception e) {
            System.out.println("SEVERE: Error while writing " + fileName + ": " + e);
        }
        finally {
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Exception e2) {
                    System.out.println("SEVERE: Unable to close " + fileName + ": " + e2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHtmlFile(String outFileName) {
        File f = new File(outFileName);
        String baseFileName = this.unFix(f.getName(), null, ".xml");
        String fileName = f.getParent() + "/" + baseFileName + ".html";
        PrintWriter pw = null;
        try {
            String[] bfNames;
            pw = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            pw.println("<html><head><title>Error Registry Index</title></head>");
            pw.println("<body>");
            pw.println("<h1>Error Registry Index</h1>");
            pw.println("<a href=\"" + baseFileName + ".xml" + "\">Combined Error Registry XML Bulk Upload file</a>");
            pw.println(" was merged from " + this.fileCount + " files and contains " + this.messageCount + " messages from " + this.componentCount + " components.");
            pw.println("<ol>");
            for (String name : bfNames = this.getSortedKeys(this.baseFileNames)) {
                File htmlFile = new File(name + ".html");
                String shortName = htmlFile.getName().substring(0, htmlFile.getName().length() - ".html".length());
                pw.print("<li>" + shortName + ": ");
                if (htmlFile.exists()) {
                    pw.print("<a href=\"" + shortName + ".html\">report</a>");
                } else {
                    pw.print("<em>no report available</em>");
                }
                File xf = this.baseFileNames.get(name);
                if (xf != null && xf.getName().endsWith(".xml")) {
                    pw.print(", <a href=\"" + shortName + ".xml\">xml file</a>");
                    Boolean b = this.validationLogs.get(name);
                    if (b == null) {
                        pw.print(". <em>No validation log file available!</em>");
                    } else if (b.booleanValue()) {
                        pw.print(", <a href=\"" + shortName + ".txt\">validation log</a>.");
                    } else {
                        pw.print(", <b>validation failure - <a href=\"" + shortName + ".txt\">see validation log</a>.</b>");
                    }
                } else {
                    pw.print(". No registerable messages in bundle.");
                }
                pw.println("</li>");
            }
            pw.println("</ol>");
            pw.println("</body></html>");
        }
        catch (Exception e) {
            System.out.println("SEVERE: Error while writing " + fileName + ": " + e);
        }
        finally {
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Exception e2) {}
            }
        }
    }

    private <T> String[] getSortedKeys(HashMap<String, T> map) {
        String[] keys = new String[map.size()];
        Iterator<String> it = map.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            keys[i] = it.next();
            ++i;
        }
        boolean sorted = false;
        while (!sorted) {
            sorted = true;
            for (int i2 = 0; i2 < keys.length - 1; ++i2) {
                if (keys[i2].compareTo(keys[i2 + 1]) <= 0) continue;
                String tmp = keys[i2];
                keys[i2] = keys[i2 + 1];
                keys[i2 + 1] = tmp;
                sorted = false;
            }
        }
        return keys;
    }

    public static class Counter {
        private int messageCount = 0;
        private int otherCount = 0;

        public void addMessage(boolean isError, boolean isOther) {
            if (isError) {
                ++this.messageCount;
                if (isOther) {
                    ++this.otherCount;
                }
            }
        }

        public double getPercentOther() {
            if (this.messageCount == 0) {
                return 0.0;
            }
            return 100.0 * (double)this.otherCount / (double)this.messageCount;
        }

        public boolean hasGoodRatio() {
            return this.getPercentOther() < 95.0;
        }

        public int getErrorCount() {
            return this.messageCount;
        }

        public int getOtherCount() {
            return this.otherCount;
        }
    }
}

