/*
 * Decompiled with CFR 0.152.
 */
package oracle.annotation.logging.processor;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.StringTokenizer;
import oracle.annotation.logging.Category;
import oracle.annotation.logging.Severity;
import oracle.annotation.logging.processor.AnnotationsProcessor;
import oracle.annotation.logging.processor.GoFishing;
import oracle.annotation.logging.processor.ListResourceExtractor;
import oracle.annotation.logging.processor.MessageDescriptor;
import oracle.annotation.logging.processor.Util;

public class BundleDescriptor {
    public static final double OTHER_PERCENTAGE_THRESHOLD = 95.0;
    private String pakkage;
    private String name;
    private String fileName;
    private String shortFileName;
    private ListResourceBundle bundle;
    private ListResourceExtractor listResourceExtractor;
    private Class bundleConstants;
    private String bundleConstantsFileName;
    private HashMap<String, String> keyConstants = null;
    private boolean marked = false;
    private int size = 0;
    private int product = 0;
    private Category defaultCategory = Category.OTHER;
    private String[] invoke = new String[0];
    private int registeredSize = 0;
    private List<String> unregisteredKeys = new ArrayList<String>();
    private List<String> errors = new ArrayList<String>();
    private List<String> warnings = new ArrayList<String>();
    private Integer theProduct = null;
    private static HashMap<Integer, String> componentPrefix = new HashMap();
    private List<MessageDescriptor> messages = new ArrayList<MessageDescriptor>();
    private boolean isSorted;
    HashMap<String, List<GoFishing.Hit>> usages = new HashMap();
    private static final int NEEDS_THREE_DIGITS = 100;
    private static final int NEEDS_TWO_DIGITS = 10;
    private Stats stats = null;
    private static final int MAX_BOX_WIDTH = 40;
    private static final String ODL_MARKER_CONTENTS = "oracle.core.ojdl.logging.MessageIdKeyResourceBundle";
    private static final double HUNDRED_PERCENT = 100.0;

    public BundleDescriptor(String fName) {
        this.setFileName(Util.getCanonicalFileName(fName));
        int pos = this.getFileName().lastIndexOf("/");
        String className = pos >= 0 ? this.getFileName().substring(pos + 1) : this.getFileName();
        if (className.endsWith(".java")) {
            className = className.substring(0, className.length() - ".java".length());
        }
        this.name = className;
        try {
            String line;
            File f = new File(this.getFileName());
            LineNumberReader lr = new LineNumberReader(new FileReader(f));
            this.pakkage = null;
            while ((line = lr.readLine()) != null && this.pakkage == null) {
                pos = line.indexOf("package ");
                if (pos < 0 || !line.trim().startsWith("package")) continue;
                if ((pos = (line = line.substring(pos + "package ".length())).indexOf(";")) < 0) {
                    String pkg = line.trim();
                    if (pkg.equals("")) continue;
                    this.pakkage = pkg;
                    continue;
                }
                this.pakkage = line.substring(0, pos).trim();
            }
            lr.close();
            if (this.pakkage == null) {
                this.addError("Unable to determine package name from bundle source file at " + this.getFileName() + ".");
                return;
            }
        }
        catch (IOException ioe) {
            this.addError("Unable to determine package name from bundle source file at " + this.getFileName() + ": " + ioe);
            return;
        }
        try {
            this.bundle = (ListResourceBundle)Class.forName(this.pakkage + "." + this.name).newInstance();
        }
        catch (Exception e) {
            this.addError("Unable to load class for bundle " + this.pakkage + "." + this.name + " located at " + this.getFileName() + ": " + e + "\n" + "Please ensure that this class is found in the classpath.");
            System.out.println("SEVERE: unable to load resource bundle class " + this.pakkage + "." + this.name + ": " + e);
            System.out.println("        Either ensure that this class is found in the classpath, or check that ");
            System.out.println("        " + this.getFileName() + " is not referencing an obsolete package and/or class name.");
            System.out.println("        (I can get confused sometimes.)");
            return;
        }
        try {
            Class<?>[] interfaces;
            for (Class<?> itf : interfaces = this.getBundle().getClass().getInterfaces()) {
                if (!itf.getName().equals(ODL_MARKER_CONTENTS)) continue;
                this.marked = true;
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String val;
            if (!this.isMarked() && (val = this.bundle.getString(ODL_MARKER_CONTENTS)) != null) {
                this.marked = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Enumeration<String> e = this.bundle.getKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                if (key.equals(ODL_MARKER_CONTENTS) || !this.verifyListResourceBundleKey(key)) continue;
                ++this.size;
                this.unregisteredKeys.add(key);
            }
        }
        catch (Exception e) {
            this.addError("Unable to retrieve resources from bundle " + this.pakkage + "." + this.name + ": " + e);
        }
        boolean foundConstants = false;
        String[] suffixes = new String[]{"ID", "IDs", "Constants", "Constant", "Interface", "Interf", "Itf"};
        for (int i = 0; i < suffixes.length && !foundConstants; ++i) {
            foundConstants = this.checkBundleConstants(suffixes[i]);
            if (!foundConstants || !Util.getVerbose()) continue;
            System.out.println("INFO: Symbolic bundle constants in " + this.getBundleConstants().getName() + ".");
        }
        if (!foundConstants) {
            try {
                Class<?>[] interfaces = this.getBundle().getClass().getInterfaces();
                for (int i = 0; i < suffixes.length && !foundConstants; ++i) {
                    for (int ii = 0; ii < interfaces.length; ++ii) {
                        if (!interfaces[ii].getName().endsWith(suffixes[i])) continue;
                        foundConstants = true;
                        String itfFname = Util.getFileForClass(interfaces[ii]);
                        if (itfFname == null) {
                            System.out.println("WARNING: Symbolic bundle constants for " + this.getBundle().getClass().getName() + " expected to be in " + interfaces[ii].getName() + "." + " Unable to find source file for this interface." + " You may want to check your -srcdir setting and add the source root for this file.");
                        }
                        this.bundleConstants = interfaces[ii];
                        this.bundleConstantsFileName = itfFname;
                    }
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
    }

    private boolean checkBundleConstants(String suffix) {
        try {
            String itf = this.name.endsWith("Bundle") ? this.name.substring(0, this.name.length() - "Bundle".length()) + suffix : this.name + suffix;
            this.bundleConstants = Class.forName(this.pakkage + "." + itf);
            this.bundleConstantsFileName = this.name.endsWith("Bundle") ? this.getFileName().substring(0, this.getFileName().length() - "Bundle.java".length()) + suffix + ".java" : this.getFileName().substring(0, this.getFileName().length() - ".java".length()) + suffix + ".java";
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getPackage() {
        return this.pakkage;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return "" + this.getPackage() + "." + this.getName();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getShortFileName() {
        if (this.shortFileName == null) {
            this.shortFileName = Util.getShortFileName(this.getFileName());
        }
        return this.shortFileName;
    }

    public ListResourceBundle getBundle() {
        return this.bundle;
    }

    public boolean verifyListResourceBundleKey(String key) {
        if (this.listResourceExtractor == null) {
            this.listResourceExtractor = new ListResourceExtractor(this.bundle);
        }
        return this.listResourceExtractor.verifyListResourceBundleKey(key);
    }

    public Class getBundleConstants() {
        return this.bundleConstants;
    }

    public String getBundleConstantsFileName() {
        return this.bundleConstantsFileName;
    }

    public String getKeyConstant(String key) {
        if (this.getBundleConstants() == null) {
            return null;
        }
        if (this.keyConstants == null) {
            this.keyConstants = new HashMap();
            Field[] fields = this.getBundleConstants().getFields();
            for (int i = 0; i < fields.length; ++i) {
                int modif = fields[i].getModifiers();
                try {
                    if (!Modifier.isPublic(modif) || !Modifier.isStatic(modif) || !Modifier.isFinal(modif) || !fields[i].getType().equals(String.class)) continue;
                    String val = (String)fields[i].get(null);
                    if (this.getBundle().getString(val) == null) continue;
                    this.keyConstants.put(val, fields[i].getName());
                    continue;
                }
                catch (Exception iae) {
                    // empty catch block
                }
            }
        }
        return this.keyConstants.get(key);
    }

    public boolean isMarked() {
        return this.marked;
    }

    public int getSize() {
        return this.size;
    }

    public void processAnnotations(AnnotationsProcessor.Entry[] entries) {
        if (this.getBundle() == null) {
            return;
        }
        if (entries == null || entries.length == 0) {
            System.out.println("WARNING: No @RegistryInfo() annotation found in bundle " + this.getQualifiedName());
            return;
        }
        if (entries.length != 1) {
            throw new IllegalArgumentException("Found more than one @RegistryInfo annotation for " + this.getQualifiedName() + ".");
        }
        HashMap<String, Object> p = entries[0].getAnnotationProperties();
        try {
            this.product = -1;
            Object o = Util.getAnnotationValue(p.get("product"));
            if (o != null) {
                if (o instanceof Integer) {
                    this.product = (Integer)p.get("product");
                } else {
                    this.addError("SEVERE: Tag product=... - expected int but received " + o + ": " + o.getClass().getName());
                }
            }
            this.defaultCategory = Category.OTHER;
            o = Util.getAnnotationValue(p.get("category"));
            if (o != null) {
                if (o instanceof Category) {
                    this.defaultCategory = (Category)((Object)o);
                } else {
                    this.addError("SEVERE: Tag category=... - expected oracle.annotation.logging.Category but received " + o + ": " + o.getClass().getName());
                }
            }
            if (Util.getDebug()) {
                System.out.println("INFO: Default category for " + this.getName() + " is Category." + (Object)((Object)this.getDefaultCategory()));
            }
            ArrayList<String> useList = new ArrayList<String>();
            o = Util.getAnnotationValue(p.get("invoke"));
            if (o != null && o instanceof String) {
                o = new Object[]{o};
            }
            if (o != null) {
                if (o instanceof Object[]) {
                    Object[] list = o;
                    for (int i = 0; i < list.length; ++i) {
                        if (list[i] != null && list[i] instanceof String) {
                            StringTokenizer st = new StringTokenizer((String)list[i], ", ");
                            while (st.hasMoreTokens()) {
                                String classOrFile = st.nextToken();
                                String normalizedFile = this.invokeToFile(classOrFile);
                                if (normalizedFile == null) continue;
                                if (new File(normalizedFile).canRead()) {
                                    useList.add(normalizedFile);
                                    continue;
                                }
                                this.addError("WARNING: <code>@RegistryInfo(invoke=\"...\")</code> in " + this.getQualifiedName() + " says that <code>" + classOrFile + "</code> is using this bundle. " + "I am unable to read the corresponding file <code>" + Util.getShortFileName(normalizedFile) + "</code>. If this is not due to an error in the class or file name, you may want to " + "specify the invoker as a file relative to $ADE_VIEW_ROOT, such as " + "<code>$ADE_VIEW_ROOT/&lt;product>/&lt;component>/src/&lt;package>/&lt;file>.java</code>");
                            }
                            continue;
                        }
                        this.addError("SEVERE: Unable to determine 'invoke' tag for bundle " + this.getQualifiedName() + ", got: " + list[i] + ". Should not occur.");
                    }
                } else {
                    this.addError("SEVERE: Unable to determine 'invoke' tag for bundle " + this.getQualifiedName() + ", got: " + o + ". Should not occur.");
                }
            }
            this.invoke = useList.toArray(this.invoke);
        }
        catch (Exception e) {
            this.addError("WARNING: Unexpected exception when processing annotation for bundle " + this.getQualifiedName() + ": " + e.toString());
        }
    }

    private String invokeToFile(String classOrFile) {
        String fName;
        if (classOrFile.startsWith("/")) {
            fName = classOrFile;
        } else if (classOrFile.indexOf("/") > 0) {
            if (classOrFile.startsWith("$ADE_VIEW_ROOT/")) {
                classOrFile = classOrFile.substring("$ADE_VIEW_ROOT/".length());
            } else if (classOrFile.startsWith("$SRCHOME/")) {
                classOrFile = classOrFile.substring("$SRCHOME/".length());
            } else if (classOrFile.startsWith("${ADE_VIEW_ROOT}/") || classOrFile.startsWith("$(ADE_VIEW_ROOT)/")) {
                classOrFile = classOrFile.substring("${ADE_VIEW_ROOT}/".length());
            } else if (classOrFile.startsWith("${SRCHOME}/") || classOrFile.startsWith("$(SRCHOME)/")) {
                classOrFile = classOrFile.substring("${SRCHOME}/".length());
            } else if (classOrFile.startsWith("$")) {
                this.addError("SEVERE: Use of " + classOrFile + " in @RegistryInfo( ..., invoke=\"" + classOrFile + "\") " + "is not permitted. You may only use a $ADE_VIEW_ROOT/ prefix.");
            }
            if (!classOrFile.endsWith(".java")) {
                classOrFile = classOrFile + ".java";
            }
            fName = Util.getSrchome() + "/" + classOrFile;
        } else {
            ArrayList<String> candidates = new ArrayList<String>();
            for (int i = 0; i <= 1 && candidates.size() == 0; ++i) {
                String[] dirs;
                for (String dir : dirs = i == 0 ? Util.getSrcdirs() : Util.getResdirs()) {
                    String file = Util.getSrchome() + "/" + dir + "/" + classOrFile.replace('.', '/') + ".java";
                    if (!new File(file).exists()) continue;
                    candidates.add(file);
                }
            }
            if (candidates.size() == 0) {
                this.addError("SEVERE: " + this.getFileName() + " @RegistryInfo(invoke=..) attribute " + " specifies \"" + classOrFile + "\". Unable to find the corresponding source file. " + "Please check the name and the srcdir setting. You can also use an absolute " + "location of the form $ADE_VIEW_ROOT/xx/yy/Zx.java");
                return null;
            }
            if (candidates.size() > 1) {
                StringBuffer found = new StringBuffer();
                for (int i = 0; i < candidates.size(); ++i) {
                    found.append(Util.getCanonicalFileName((String)candidates.get(i)));
                    if (i >= candidates.size() - 1) continue;
                    found.append(", ");
                }
                this.addError("SEVERE: " + this.getFileName() + " @RegistryInfo(invoke=..) attribute " + " specifies \"" + classOrFile + "\". " + "Found multiple source files that match this designation: " + found.toString() + ". " + "Please check this name and the srcdir setting. You can also use an absolute " + "location of the form $ADE_VIEW_ROOT/xx/yy/Zx.java");
                return null;
            }
            fName = (String)candidates.get(0);
        }
        return Util.getCanonicalFileName(fName);
    }

    public int getProduct() {
        return this.product;
    }

    public Category getDefaultCategory() {
        return this.defaultCategory;
    }

    public String[] getInvoke() {
        return this.invoke;
    }

    public int getRegisteredSize() {
        return this.registeredSize;
    }

    public String[] getUnregisteredKeys() {
        if (!this.isSorted) {
            this.sortMessages();
        }
        return this.unregisteredKeys.toArray(new String[0]);
    }

    public String[] getErrors() {
        return this.errors.toArray(new String[0]);
    }

    protected void addError(String e) {
        this.errors.add(e);
    }

    public String[] getWarnings() {
        return this.warnings.toArray(new String[0]);
    }

    protected void addWarning(String e) {
        this.warnings.add(e);
    }

    void registerMessage(MessageDescriptor md) {
        if (this.getBundle() == null) {
            return;
        }
        if (this.unregisteredKeys.contains(md.getKey())) {
            this.unregisteredKeys.remove(md.getKey());
            if (this.unregisteredKeys.contains(md.getKey() + "_CAUSE")) {
                this.unregisteredKeys.remove(md.getKey() + "_CAUSE");
            } else if (this.unregisteredKeys.contains(md.getKey() + "-CAUSE")) {
                this.unregisteredKeys.remove(md.getKey() + "-CAUSE");
            }
            if (this.unregisteredKeys.contains(md.getKey() + "_ACTION")) {
                this.unregisteredKeys.remove(md.getKey() + "_ACTION");
            } else if (this.unregisteredKeys.contains(md.getKey() + "-ACTION")) {
                this.unregisteredKeys.remove(md.getKey() + "-ACTION");
            }
            if (this.unregisteredKeys.contains(md.getKey() + "_SEVERITY")) {
                this.unregisteredKeys.remove(md.getKey() + "_SEVERITY");
            } else if (this.unregisteredKeys.contains(md.getKey() + "-SEVERITY")) {
                this.unregisteredKeys.remove(md.getKey() + "-SEVERITY");
            }
            ++this.registeredSize;
        } else {
            boolean foundDup = false;
            for (int i = 0; i < this.messages.size(); ++i) {
                if (!md.getKey().equals(this.messages.get(i).getKey())) continue;
                foundDup = true;
                this.addError(md.getShortSourcePosition() + ": duplicate <code>@MessageInfo()</code> annotation. Message " + md.getKey() + " was previously defined at " + this.messages.get(i).getShortSourcePosition() + ".");
                break;
            }
            if (!foundDup) {
                this.addError(md.getShortSourcePosition() + ": <code>@MessageInfo()</code> annotation defines message " + md.getKey() + ", but this message cannot be found in <code>" + this.getQualifiedName() + "</code>");
            }
        }
        if (md.getSeverity() != Severity.SKIP) {
            this.messages.add(md);
            if (this.theProduct == null) {
                this.theProduct = new Integer(this.getProduct());
            }
            String pref = componentPrefix.get(this.theProduct);
            String msgPref = md.getPrefix().trim();
            if (pref == null) {
                pref = msgPref;
                componentPrefix.put(this.theProduct, pref);
            }
            if (!pref.equals(msgPref)) {
                md.addError("Message used prefix \"" + msgPref + "\" but other messages for the component " + this.theProduct + " already use the prefix \"" + pref + "\". " + "The component " + this.theProduct + " must only use a single prefix.");
            }
        }
        this.isSorted = false;
    }

    public List<MessageDescriptor> getMessages() {
        if (!this.isSorted) {
            this.sortMessages();
        }
        return this.messages;
    }

    private void sortMessages() {
        Object tmp;
        String key1;
        String key0;
        int i;
        boolean done = false;
        while (!done) {
            done = true;
            for (i = 1; i < this.messages.size(); ++i) {
                key0 = this.messages.get(i - 1).getKey();
                if (key0.compareTo(key1 = this.messages.get(i).getKey()) <= 0) continue;
                tmp = this.messages.get(i - 1);
                this.messages.set(i - 1, this.messages.get(i));
                this.messages.set(i, (MessageDescriptor)tmp);
                done = false;
            }
        }
        done = false;
        while (!done) {
            done = true;
            for (i = 1; i < this.unregisteredKeys.size(); ++i) {
                key0 = this.unregisteredKeys.get(i - 1);
                if (key0.compareTo(key1 = this.unregisteredKeys.get(i)) <= 0) continue;
                tmp = this.unregisteredKeys.get(i - 1);
                this.unregisteredKeys.set(i - 1, this.unregisteredKeys.get(i));
                this.unregisteredKeys.set(i, (String)tmp);
                done = false;
            }
        }
        this.isSorted = true;
    }

    void addUsageCandidate(GoFishing.Hit hit) {
        String file = Util.getCanonicalFileName(hit.getFileName());
        String key = hit.getToken();
        if (!file.equals(this.getFileName()) && !file.equals(this.getBundleConstantsFileName())) {
            List<GoFishing.Hit> used = this.usages.get(key);
            if (used == null) {
                used = new ArrayList<GoFishing.Hit>();
                this.usages.put(key, used);
            }
            used.add(hit);
        }
    }

    public GoFishing.Hit[] getUsageCandidates(String key) {
        int j;
        int i;
        ArrayList res = new ArrayList();
        List[] cands = (List[])Array.newInstance(res.getClass(), 2);
        String cons = this.getKeyConstant(key);
        if (cons != null) {
            cands[0] = this.usages.get(cons);
        }
        cands[1] = this.usages.get(key);
        for (i = 0; i <= 1; ++i) {
            if (cands[i] == null) continue;
            for (j = 0; j < cands[i].size(); ++j) {
                if (((GoFishing.Hit)cands[i].get(j)).getSeverity() == null) continue;
                res.add(cands[i].get(j));
            }
        }
        if (res.size() == 0) {
            for (i = 0; i <= 1; ++i) {
                if (cands[i] == null) continue;
                for (j = 0; j < cands[i].size(); ++j) {
                    if (((GoFishing.Hit)cands[i].get(j)).getSeverity() != null) continue;
                    res.add(cands[i].get(j));
                }
            }
        }
        return res.toArray(new GoFishing.Hit[0]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Bundle " + this.getQualifiedName() + " from " + this.getFileName() + "\n");
        sb.append("   product=" + this.getProduct());
        if (this.getInvoke().length > 0) {
            sb.append(" invoke = {");
            for (int i = 0; i < this.getInvoke().length; ++i) {
                sb.append("\"" + this.getInvoke()[i] + "\"");
                if (i >= this.getInvoke().length - 1) continue;
                sb.append(", ");
            }
            sb.append("}");
        }
        sb.append("\n");
        sb.append("   marked=" + this.isMarked() + " size=" + this.getSize() + " interface=" + this.getBundleConstants() + "\n");
        return sb.toString();
    }

    private void printContents(StringBuffer sb) {
        ListResourceBundle lrb;
        String[] warn = this.getWarnings();
        if (warn.length > 0) {
            sb.append("<ul>\n");
            for (String w : warn) {
                sb.append("<li>");
                sb.append(w);
                sb.append("</li>\n");
            }
            sb.append("</ul>\n");
        }
        sb.append("<H3>BUNDLE CONTENTS with " + this.getRegisteredSize() + " message" + (this.getRegisteredSize() == 1 ? "" : "s") + "</H3>" + "\n");
        if (this.getRegisteredSize() > 0) {
            sb.append("You may want to review the content of the message bundle. \n");
        }
        if ((lrb = this.getBundle()) == null) {
            sb.append("<b>BUNDLE PROCESSING ERROR: Unable to load resource bundle " + this.getQualifiedName() + ".</b>");
            sb.append("\n");
        } else if (!this.isMarked()) {
            sb.append("<b>NO OJDL MARKER PRESENT IN BUNDLE " + this.getQualifiedName() + "!</b><br>");
            sb.append("\n");
            sb.append("<b>ABSOLUTELY NO Entries will be registered in the error message registry for this bundle!!!!</b><br>");
            sb.append("\n");
        } else if (this.getRegisteredSize() > 0) {
            sb.append("This table is purely informational - you may find it useful for an editorial review of your messages.\n");
            sb.append("<table BORDER=\"1\" CELLPADDING=\"1\" CELLSPACING=\"0\">\n");
            sb.append("<thead>\n");
            sb.append("<th>Message ID</th><th>Level</th><th>Category</th><th>Doc status</th><th>Text</th><th>Cause/Action</th>\n");
            sb.append("</thead>\n");
            sb.append("<tbody>\n");
            List<MessageDescriptor> enu = this.getMessages();
            for (int i = 0; i < enu.size(); ++i) {
                MessageDescriptor md = enu.get(i);
                sb.append(md.toHTML());
                sb.append("\n");
            }
            sb.append("</tbody>\n");
            sb.append("</table>\n");
        } else {
            sb.append("<b>NOTE:</b> No registered message in bundle.<br>\n");
        }
    }

    private void printUnregisteredKeys(StringBuffer sb, String[] keys) {
        sb.append("<h3>Table of " + keys.length + " unreferenced entries</h3>" + "\n");
        sb.append("If any of these entries are used in runtime error messages, please add appropriate <code>@MessageInfo()</code> annotations. ");
        sb.append("If <i>not</i>, then you want to add <code>@MessageInfo(severity=Severe.SKIP ...)</code> annotations instead. ");
        if (!Util.getFishing()) {
            sb.append("In order to obtain a list of source locations that appear to use these constants, please specify the <code>-fishing</code> option.<br>");
        }
        sb.append("\n");
        if (!this.listResourceExtractor.hasPublicGetContents()) {
            sb.append("If you are adding a parent to this ListResourceBundle, please make its 'getContents()' method public. Otherwise I cannot determine which messages were added explicitly by this bundle.<br>");
            sb.append("\n");
        }
        sb.append("<table BORDER=\"1\" CELLPADDING=\"1\" CELLSPACING=\"0\">\n");
        sb.append("<thead>\n");
        sb.append("<th>Key <i>(Symbolic Constant)</i></th>");
        if (Util.getFishing()) {
            sb.append("<th>Apparently Used From</th>\n");
        }
        sb.append("<th>Message Text</th>\n");
        sb.append("</thead>\n");
        sb.append("<tbody>\n");
        for (String key : keys) {
            sb.append("<tr>");
            sb.append("<td>");
            String text = key;
            if (this.getKeyConstant(key) != null) {
                text = text + " <i>(" + this.getKeyConstant(key) + ")</i>";
            }
            if (text.length() > 40) {
                text = "<font size=-3>" + text + "</font>";
            }
            sb.append(text);
            sb.append("</td>");
            sb.append("\n");
            if (Util.getFishing()) {
                int maxWidthSeen = 0;
                StringBuffer textBuf = new StringBuffer();
                sb.append("<td>");
                GoFishing.Hit[] hits = this.getUsageCandidates(key);
                if (hits.length == 0) {
                    textBuf.append("<i>not found</i>");
                }
                for (int i = 0; i < hits.length; ++i) {
                    GoFishing.Hit h = hits[i];
                    String fname = Util.getShortFileName(h.getFileName());
                    if (fname.length() > maxWidthSeen) {
                        maxWidthSeen = fname.length() + ":ll.cc ERROR<br>".length();
                    }
                    textBuf.append(fname);
                    textBuf.append(":");
                    textBuf.append(h.getLine());
                    textBuf.append(".");
                    textBuf.append(h.getColumn());
                    if (h.getSeverity() != null) {
                        textBuf.append(" <b>" + h.getSeverity().toString() + "</b>");
                    }
                    if (i < hits.length - 1) {
                        textBuf.append("<br>");
                    }
                    textBuf.append("\n");
                }
                if (maxWidthSeen > 40) {
                    sb.append("<font size=-3>");
                }
                sb.append(textBuf);
                if (maxWidthSeen > 40) {
                    sb.append("</font>");
                }
                sb.append("</td>");
                sb.append("\n");
            }
            sb.append("<td>");
            sb.append(Util.escapeHtml(this.getBundle().getString(key)));
            sb.append("</td>");
            sb.append("\n");
            sb.append("</tr>");
            sb.append("\n");
        }
        sb.append("</tbody>\n");
        sb.append("</table>\n");
        sb.append("<p>\n");
    }

    private void printUnregisteredKeysByFile(StringBuffer sb, String[] keys) {
        int i;
        if (!Util.getFishing()) {
            return;
        }
        HashMap locations = new HashMap();
        for (String key : keys) {
            GoFishing.Hit[] hits = this.getUsageCandidates(key);
            String lastFile = null;
            int keyFileCount = 0;
            for (i = 0; i < hits.length; ++i) {
                String f = Util.getShortFileName(hits[i].getFileName());
                if (f.equals(lastFile)) continue;
                ++keyFileCount;
                lastFile = f;
            }
            for (i = 0; i < hits.length; ++i) {
                GoFishing.Hit h = hits[i];
                String fname = Util.getShortFileName(h.getFileName());
                ArrayList<String> occs = (ArrayList<String>)locations.get(fname);
                if (occs == null) {
                    occs = new ArrayList<String>();
                    locations.put(fname, occs);
                }
                String entry = "" + (h.getLine() < 10 ? "00" : (h.getLine() < 100 ? "0" : "")) + h.getLine() + ":" + h.getColumn() + " " + key + (this.getKeyConstant(key) != null ? " (" + this.getKeyConstant(key) + ")" : "") + (h.getSeverity() != null ? " " + (Object)((Object)h.getSeverity()) : "") + (keyFileCount > 1 ? "<sup>" + keyFileCount + " files</sup>" : "");
                occs.add(entry);
            }
        }
        String[] files = locations.keySet().toArray(new String[0]);
        boolean done = false;
        while (!done) {
            done = true;
            for (int i2 = 0; i2 < files.length - 1; ++i2) {
                if (files[i2].compareTo(files[i2 + 1]) <= 0) continue;
                String tmp = files[i2];
                files[i2] = files[i2 + 1];
                files[i2 + 1] = tmp;
                done = false;
            }
        }
        for (String file : files) {
            List occs = (List)locations.get(file);
            done = false;
            for (i = 0; i < occs.size() - 1; ++i) {
                if (((String)occs.get(i)).compareTo((String)occs.get(i + 1)) <= 0) continue;
                String tmp = (String)occs.get(i);
                occs.set(i, occs.get(i + 1));
                occs.set(i + 1, tmp);
                done = false;
            }
        }
        if (files.length > 0) {
            sb.append("<h3>Files with unreferenced entries</h3>\n");
            sb.append("A different view of the unreferenced keys. If any of these entries are used in error messages, please add appropriate <code>@MessageInfo()</code> annotations. ");
            sb.append("If <i>not</i>, then you want to add <code>@MessageInfo(severity=Severe.SKIP ...)</code> annotations instead. ");
            sb.append("\n");
            sb.append("The marker <sup>n files</sup> indicates that a key is found in <i>n</i> different files.\n");
            sb.append("<table BORDER=\"1\" CELLPADDING=\"1\" CELLSPACING=\"0\">\n");
            sb.append("<thead>\n");
            sb.append("<th>File</th>");
            sb.append("<th>Key (Symbolic name) - Text</th>\n");
            sb.append("</thead>\n");
            sb.append("<tbody>\n");
            for (String file : files) {
                sb.append("<tr>");
                sb.append("<td>");
                sb.append(file);
                sb.append("</td>");
                sb.append("\n");
                sb.append("<td>");
                List occs = (List)locations.get(file);
                for (i = 0; i < occs.size(); ++i) {
                    sb.append((String)occs.get(i));
                    if (i >= occs.size() - 1) continue;
                    sb.append("<br>");
                    sb.append("\n");
                }
                sb.append("</td>");
                sb.append("</tr>");
                sb.append("\n");
            }
            sb.append("</tbody>\n");
            sb.append("</table>\n");
            sb.append("<p>\n");
        }
    }

    private void printNeedCauseAction(StringBuffer sb, MessageDescriptor[] mds) {
        sb.append("<h3>Table of " + mds.length + " message" + (mds.length == 1 ? "" : "s") + " that require" + (mds.length == 1 ? "s" : "") + " Cause/Action information</h3>" + "\n");
        sb.append("Note that for <b>all</b> messages of severity SEVERE or higher, you <b>must</b> provide full cause and action information. It is not sufficient to use placeholder text, such as <code>\"edit_cause\"</code> or <code>\"edit_action\"</code>.\n");
        sb.append("<table BORDER=\"1\" CELLPADDING=\"1\" CELLSPACING=\"0\">\n");
        sb.append("<thead>\n");
        sb.append("<th>Key</th><th>Invoked From</th><th>Message Text</th>\n");
        sb.append("</thead>\n");
        sb.append("<tbody>\n");
        for (MessageDescriptor md : mds) {
            sb.append("<tr>");
            sb.append("<td>" + md.getKey() + "</td>");
            sb.append("<td>" + md.getShortSourcePosition() + "</td>");
            sb.append("<td>" + Util.escapeHtml(md.getText()) + "</td>");
            sb.append("</tr>\n");
        }
        sb.append("</tbody>\n");
        sb.append("</table>\n");
        sb.append("<p>\n");
    }

    private void printErrors(StringBuffer sb, String[] es) {
        sb.append("<h3>" + es.length + " issue" + (es.length == 1 ? "" : "s") + " encountered during processing</h3>" + "\n");
        sb.append("<ul>\n");
        for (String error : es) {
            sb.append("<li>" + error + "<br>" + "\n");
        }
        sb.append("</ul>\n");
        sb.append("<p>\n");
    }

    public String toHTML() {
        String[] unregistered;
        double perc;
        this.stats = new Stats(this);
        StringBuffer sb = new StringBuffer();
        sb.append("<H3>ACTION / TODO ITEMS</H3>\n");
        ArrayList<String> messageErrors = new ArrayList<String>();
        String[] es = this.getErrors();
        if (es.length > 0) {
            for (String e : es) {
                messageErrors.add(e);
                System.out.println("ERROR: Bundle: " + e);
            }
            this.stats.bundleIssues = es.length;
        }
        MessageDescriptor[] mds = this.getMessages().toArray(new MessageDescriptor[0]);
        ArrayList<MessageDescriptor> needCauseAction = new ArrayList<MessageDescriptor>();
        int countOther = 0;
        for (MessageDescriptor md : mds) {
            if (md.needsCauseAction()) {
                needCauseAction.add(md);
                this.stats.messageIssues++;
                System.out.print("ERROR: Cause/Action: " + md);
            }
            if (md.hasErrors()) {
                for (String e : md.printErrors()) {
                    messageErrors.add(e);
                    this.stats.messageIssues++;
                    System.out.println("ERROR: Message: " + e);
                }
            }
            if (md.getCategory() != Category.OTHER) continue;
            ++countOther;
        }
        if (mds.length > 0 && (perc = 100.0 * (double)countOther / (double)mds.length) >= 95.0) {
            this.stats.messageIssues++;
            String mesgErro = "Messages need to use categories different from 'OTHER'. There are " + mds.length + " messages, " + countOther + " of which (" + perc + "%)" + " use the category 'OTHER'. Less than " + 95.0 + "% of messages " + " should use this category.";
            messageErrors.add(mesgErro);
            System.out.println("ERROR: Message: " + mesgErro);
        }
        if (messageErrors.size() > 0) {
            String[] sa = new String[messageErrors.size()];
            for (int i = 0; i < sa.length; ++i) {
                sa[i] = (String)messageErrors.get(i);
            }
            this.printErrors(sb, sa);
        }
        if (needCauseAction.size() > 0) {
            this.printNeedCauseAction(sb, needCauseAction.toArray(new MessageDescriptor[0]));
            this.stats.causeAction = needCauseAction.size();
        }
        if ((unregistered = this.getUnregisteredKeys()).length > 0) {
            this.printUnregisteredKeys(sb, unregistered);
            this.printUnregisteredKeysByFile(sb, unregistered);
            this.stats.unregisteredMessages = unregistered.length;
        }
        if (!this.stats.hadErrors()) {
            sb = new StringBuffer();
        }
        this.printContents(sb);
        return sb.toString();
    }

    public String toXML(int indent) {
        StringBuffer sb = new StringBuffer();
        ListResourceBundle lrb = this.getBundle();
        if (lrb != null && this.isMarked()) {
            List<MessageDescriptor> enu = this.getMessages();
            for (int i = 0; i < enu.size(); ++i) {
                MessageDescriptor md = enu.get(i);
                sb.append(md.toXML(indent + 4));
            }
        }
        return sb.toString();
    }

    public Stats getStats() {
        if (this.stats == null) {
            this.toHTML();
        }
        return this.stats;
    }

    public static class Stats {
        private BundleDescriptor bundleDescriptor;
        private int bundleCount;
        private int bundleIssues;
        private int messageIssues;
        private int causeAction;
        private int unregisteredMessages;
        private boolean hasRegistryInfo;

        public Stats() {
            this.hasRegistryInfo = true;
        }

        private Stats(BundleDescriptor bd) {
            this.bundleDescriptor = bd;
            this.bundleCount = 1;
            this.hasRegistryInfo = bd.getProduct() != 0 && bd.getProduct() != -1;
        }

        public boolean hadErrors() {
            return this.hasRegistryInfo && (this.bundleIssues > 0 || this.messageIssues > 0 || this.causeAction > 0 || this.unregisteredMessages > 0);
        }

        public void addBundle(BundleDescriptor bd) {
            this.bundleDescriptor = this.bundleCount == 0 ? bd : null;
            ++this.bundleCount;
            Stats s = bd.getStats();
            if (s.hasRegistryInfo) {
                this.bundleIssues += s.bundleIssues;
                this.messageIssues += s.messageIssues;
                this.causeAction += s.causeAction;
                this.unregisteredMessages += s.unregisteredMessages;
            }
        }

        public String toString() {
            return (this.bundleDescriptor == null ? Util.plural(this.bundleCount, "bundle") + ": " : this.bundleDescriptor.getQualifiedName() + ": ") + (this.hadErrors() ? Util.pluralIfNotZero(this.bundleIssues, "bundle error", "; ") + Util.pluralIfNotZero(this.messageIssues, "message issue", "; ") + Util.pluralIfNotZero(this.causeAction, "cause/action description", "; ") + Util.pluralIfNotZero(this.unregisteredMessages, "unregistered/other message", ".") : " no issues.");
        }
    }
}

