/*
 * Decompiled with CFR 0.152.
 */
package oracle.annotation.logging.processor;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.annotation.logging.processor.Util;

public class AnnotationsProcessor {
    private static HashMap<String, Entry[]> results;
    private static String[] filter;
    public static final int CLASS_ANNOTATION = 1;
    public static final int METHOD_ANNOTATION = 2;
    public static final int FIELD_ANNOTATION = 4;
    private static int annotationLevel;

    public static boolean start(RootDoc root) {
        ClassDoc[] classes;
        results = new HashMap();
        for (ClassDoc classDoc : classes = root.classes()) {
            AnnotationsProcessor.processClassDoc(classDoc);
        }
        return true;
    }

    private static void processClassDoc(ClassDoc classDoc) {
        String className = classDoc.qualifiedName();
        String fileName = Util.getCanonicalFileName(classDoc.position().file().toString());
        ArrayList<Entry> entries = new ArrayList<Entry>();
        AnnotationDesc[] annotationDescs = new AnnotationDesc[]{};
        if ((AnnotationsProcessor.getAnnotationLevel() & 1) != 0) {
            AnnotationsProcessor.addAnnotations(entries, (Doc)classDoc, classDoc.annotations(), null);
        }
        if ((AnnotationsProcessor.getAnnotationLevel() & 2) != 0) {
            MethodDoc[] methods;
            for (MethodDoc methodDoc : methods = classDoc.methods()) {
                AnnotationsProcessor.addAnnotations(entries, (Doc)methodDoc, methodDoc.annotations(), null);
            }
        }
        if ((AnnotationsProcessor.getAnnotationLevel() & 4) != 0) {
            FieldDoc[] fields = classDoc.fields();
            for (MethodDoc methodDoc : fields) {
                AnnotationsProcessor.addAnnotations(entries, (Doc)methodDoc, methodDoc.annotations(), (FieldDoc)methodDoc);
            }
        }
        if (entries.size() > 0) {
            results.put(fileName, entries.toArray(new Entry[0]));
        }
    }

    private static void addAnnotations(List<Entry> entries, Doc doc, AnnotationDesc[] annotationDescs, FieldDoc fieldDoc) {
        for (AnnotationDesc annotationDesc : annotationDescs) {
            AnnotationDesc.ElementValuePair[] elements;
            boolean found = false;
            if (AnnotationsProcessor.getFilter() != null) {
                for (String tag : AnnotationsProcessor.getFilter()) {
                    if (!tag.equals(annotationDesc.annotationType().qualifiedName())) continue;
                    found = true;
                    break;
                }
            }
            if (!found) continue;
            HashMap<String, Object> annotation = new HashMap<String, Object>();
            for (AnnotationDesc.ElementValuePair evp : elements = annotationDesc.elementValues()) {
                annotation.put(evp.element().name(), evp.value().value());
            }
            String fieldStringValue = AnnotationsProcessor.getFieldStringValue(fieldDoc);
            if (fieldStringValue != null) {
                annotation.put("*String-constant*", fieldStringValue);
            }
            entries.add(new Entry(doc.position(), annotationDesc.annotationType().qualifiedName(), annotation));
        }
    }

    private static String getFieldStringValue(FieldDoc doc) {
        if (doc == null) {
            return null;
        }
        Object res = Util.constantValue(doc);
        if (res == null) {
            return null;
        }
        if (res instanceof String) {
            return (String)res;
        }
        return null;
    }

    public static HashMap<String, Entry[]> getResults() {
        return results;
    }

    public static void setFilter(String[] qualifiedName) {
        filter = qualifiedName;
    }

    public static String[] getFilter() {
        return filter;
    }

    public static int getAnnotationLevel() {
        return annotationLevel;
    }

    public static void setAnnotationLevel(int level) {
        annotationLevel = level;
    }

    static {
        filter = null;
        annotationLevel = 1;
    }

    public static class Entry {
        public static final String FIELD_STRING_VALUE = "*String-constant*";
        private SourcePosition sourcePosition;
        private String annotationName;
        private HashMap<String, Object> annotationProperties;

        public Entry() {
        }

        public Entry(SourcePosition sourcePosition, String annotationName, HashMap<String, Object> annotationProperties) {
            this.setSourcePosition(sourcePosition);
            this.setAnnotationName(annotationName);
            this.setAnnotationProperties(annotationProperties);
        }

        public void setSourcePosition(SourcePosition sourcePosition) {
            this.sourcePosition = sourcePosition;
        }

        public SourcePosition getSourcePosition() {
            return this.sourcePosition;
        }

        public void setAnnotationName(String annotationName) {
            this.annotationName = annotationName;
        }

        public String getAnnotationName() {
            return this.annotationName;
        }

        public void setAnnotationProperties(HashMap<String, Object> annotationProperties) {
            this.annotationProperties = annotationProperties;
        }

        public HashMap<String, Object> getAnnotationProperties() {
            return this.annotationProperties;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.sourcePosition.toString() + "@" + this.getAnnotationName() + "(");
            Iterator<String> it = this.getAnnotationProperties().keySet().iterator();
            while (it.hasNext()) {
                String key = it.next();
                sb.append(key + "=" + this.getAnnotationProperties().get(key));
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(")");
            return sb.toString();
        }
    }
}

