/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.extcache;

import com.oracle.jdeveloper.extcache.ExtensionsFS;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ideimpl.extension.LayerCache;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class LayerCacheImpl
implements LayerCache {
    private static Map<String, byte[]> layersTmp;
    private static FileObject root;

    public boolean isCacheLoaded() {
        boolean loaded = ExtensionsFS.getInstance().isCacheLoaded();
        if (loaded) {
            root = ExtensionsFS.getInstance().getDelegate().getRoot();
        }
        return loaded;
    }

    public void init(List<LayerCache.ExtXmlBuffer> buffs) {
        layersTmp = new HashMap<String, byte[]>(buffs.size());
        ArrayList<URL> urls = new ArrayList<URL>(buffs.size());
        int i = 0;
        for (LayerCache.ExtXmlBuffer b : buffs) {
            try {
                URL url = new URL("jdevext", "memory/", b.getId());
                layersTmp.put(url.toString(), b.getContent());
                urls.add(url);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            ++i;
        }
        ExtensionsFS.getInstance().init(urls);
        layersTmp = null;
        root = ExtensionsFS.getInstance().getDelegate().getRoot();
    }

    public FileObject getRoot() {
        return root;
    }

    private static byte[] getContent(URL url) {
        return layersTmp.get(url.toString());
    }

    public static class InMemoryURLHandler
    extends URLStreamHandler {
        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new URLConnection(u){

                @Override
                public void connect() throws IOException {
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(LayerCacheImpl.getContent(this.url));
                }
            };
        }
    }
}

