/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.xml;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerCacheSettings;
import oracle.dbtools.listener.model.ListenerConnectionSettings;
import oracle.dbtools.listener.model.ListenerEnvironmentSettings;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.model.ListenerProcedureSettings;
import oracle.dbtools.listener.model.ListenerReportData;
import oracle.dbtools.listener.model.ListenerReportMessage;
import oracle.dbtools.listener.model.ListenerReportSettings;
import oracle.dbtools.listener.model.ListenerSecuritySettings;
import oracle.dbtools.listener.model.ListenerURLMappings;
import oracle.dbtools.listener.model.NoSQLStoreConfig;
import oracle.dbtools.listener.nosql.NoSQLConstants;
import oracle.dbtools.listener.nosql.NoSQLUtils;
import oracle.dbtools.listener.utils.ListenerUtils;
import oracle.dbtools.listener.utils.ListenerZipFileReader;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.javatools.dialogs.MessageDialog;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ListenerImportAdmin {
    private static ListenerImportAdmin _instance;
    private ListenerZipFileReader _zipRdr;
    private ListenerModel _model;
    private HashMap<String, String> _attributes;
    private Properties _globalProps;
    private HashMap<String, Properties> _dbSettingsProps;
    private HashMap<String, Properties> _restProps;
    private HashMap<String, ListenerURLMappings> _urlMaps;
    private HashMap<String, HashMap<String, Properties>> _noSQLProps;
    private boolean _passwordClearText = false;
    private String _ordsConfigPath;
    private ShutdownHook myShutdownHook = new ShutdownHook(){

        public boolean canShutdown() {
            return true;
        }

        public void shutdown() {
            File file;
            File file2;
            if (ListenerImportAdmin.this._ordsConfigPath != null && (file2 = new File(ListenerImportAdmin.this._ordsConfigPath)).exists() && file2.isDirectory() && (file = file2.getParentFile()).exists() && file.isAbsolute() && file.getName().equals("config")) {
                try {
                    ListenerUtils.delete(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    };

    public ListenerImportAdmin() {
        this.initImport();
    }

    public static synchronized ListenerImportAdmin getInstance() {
        if (_instance == null) {
            _instance = new ListenerImportAdmin();
        }
        return _instance;
    }

    public boolean importAdministration(File file, boolean bl) throws IOException {
        return this.importAdministration(file.getAbsolutePath(), bl);
    }

    public boolean importAdministration(String string, boolean bl) throws IOException {
        boolean bl2 = false;
        this.unZipORDSConfigFiles(string);
        if (this.initReader(string)) {
            bl2 = this.importAdministration();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importAdministration() {
        boolean bl = false;
        this.initialize();
        this._model = new ListenerModel();
        this._model.setConfigPath(this._ordsConfigPath);
        try {
            this.buildURLMappings();
            this.loadGlobalSettings();
            this.loadDBSettings();
            this.loadNoSQLStores();
            bl = true;
        }
        catch (Exception exception) {
            try {
                String string = ListenerArb.format("ADMIN_LOAD_ERROR", this._zipRdr.getName());
                MessageDialog.error(null, (Object)string, (String)ListenerArb.getString("ADMIN_LOAD_ERROR_TITLE"), null);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            this.closeImport();
        }
        return bl;
    }

    public ListenerModel getModel() {
        return this._model;
    }

    public Properties getGlobalSettingsProperties() {
        return this._globalProps;
    }

    public Properties getDBSettingsProperties(String string) {
        return this._dbSettingsProps == null ? null : this._dbSettingsProps.get(string);
    }

    public Properties getRESTSettingsProperties(String string) {
        return this._restProps == null ? null : this._restProps.get(string);
    }

    public HashMap<String, Properties> getNoSQLStoresProperties(String string) {
        return this._noSQLProps == null ? null : this._noSQLProps.get(string);
    }

    public void renameNoSQLStoresProperties(String string, String string2) {
        if (this._noSQLProps.containsKey(string)) {
            HashMap<String, Properties> hashMap = this._noSQLProps.remove(string);
            this._noSQLProps.put(string2, hashMap);
        }
    }

    public void deleteNoSQLStoresProperties(String string) {
        if (this._noSQLProps.containsKey(string)) {
            this._noSQLProps.remove(string);
        }
    }

    public void updateNoSQLStoresProperties(HashMap<String, HashMap<String, Properties>> hashMap) {
        this._noSQLProps = new HashMap<String, HashMap<String, Properties>>(hashMap);
    }

    private void loadGlobalSettings() throws InvalidPropertiesFormatException, IOException {
        this._globalProps = new Properties();
        this._globalProps.loadFromXML(this._zipRdr.getInputStream(this._zipRdr.getGlobalSettingsZipEntry()));
        if (!this._globalProps.containsKey("sqldev.name")) {
            this._globalProps.setProperty("sqldev.name", ListenerArb.getString("ADMINISTRATION_DEFAULT_NAME"));
        }
        this.loadSettings(this._globalProps, this._model, true);
    }

    private void loadDBSettings() throws Exception {
        HashMap<String, ZipEntry> hashMap = this._zipRdr.getDBSettingsZipEntryList();
        LinkedHashSet<String> linkedHashSet = this._zipRdr.getDBSettingNames();
        ArrayList<ListenerModel> arrayList = new ArrayList<ListenerModel>();
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            Cloneable cloneable;
            if (this._dbSettingsProps == null) {
                this._dbSettingsProps = new HashMap();
            }
            String string = (String)iterator.next();
            String string2 = "conf/" + string + ".xml";
            Properties properties = new Properties();
            if (hashMap.containsKey(string2)) {
                cloneable = hashMap.get(string2);
                properties.loadFromXML(this._zipRdr.getInputStream((ZipEntry)cloneable));
            }
            properties.setProperty("sqldev.name", string);
            this._dbSettingsProps.put(string2, properties);
            cloneable = new ListenerModel();
            cloneable = this._model.clone();
            this.loadSettings(properties, (ListenerModel)cloneable, false);
            this.loadRESTUsers((ListenerModel)cloneable, "conf/" + ((ListenerModel)cloneable).getName());
            this.loadURLMappings((ListenerModel)cloneable);
            arrayList.add((ListenerModel)cloneable);
        }
        if (!arrayList.isEmpty()) {
            this._model.setChildren(arrayList);
        }
    }

    private void loadSettings(Properties properties, ListenerModel listenerModel, boolean bl) {
        if (properties.containsKey("sqldev.name")) {
            listenerModel.setName(properties.getProperty("sqldev.name"));
        }
        if (properties.containsKey("sqldev.description")) {
            listenerModel.setDescription(properties.getProperty("sqldev.description"));
        }
        this.loadConnectionSettings(properties, listenerModel);
        if (bl) {
            this.loadSecuritySettings(properties, listenerModel);
            this.loadCacheSettings(properties, listenerModel);
            this.loadProcedureSettings(properties, listenerModel);
            this.loadEnvironmentSettings(properties, listenerModel);
            this.loadReportSettings(properties, listenerModel);
        }
    }

    private void loadConnectionSettings(Properties properties, ListenerModel listenerModel) {
        Enum enum_;
        String string;
        ListenerConnectionSettings listenerConnectionSettings = listenerModel.getConnectionSettings();
        if (properties.containsKey("db.username")) {
            listenerConnectionSettings.setUserName(properties.getProperty("db.username"));
        } else {
            listenerConnectionSettings.setUserName(null);
        }
        if (listenerConnectionSettings.getUserName() != null && listenerConnectionSettings.getUserName().trim().length() > 0) {
            if (properties.containsKey("db.password")) {
                string = properties.getProperty("db.password");
                listenerConnectionSettings.setPassword(this.getPassword(string));
            }
        } else {
            listenerConnectionSettings.setPassword(null);
        }
        if (properties.containsKey("db.connectionType")) {
            string = properties.getProperty("db.connectionType");
            enum_ = ListenerConnectionSettings.CONNECTION_TYPES.BASIC;
            if (string.equals("tns")) {
                enum_ = ListenerConnectionSettings.CONNECTION_TYPES.TNS;
            } else if (string.equals("customurl")) {
                enum_ = ListenerConnectionSettings.CONNECTION_TYPES.ADVANCED;
            }
            listenerConnectionSettings.setConnectionType((ListenerConnectionSettings.CONNECTION_TYPES)enum_);
        }
        if (properties.containsKey("db.hostname")) {
            listenerConnectionSettings.setHost(properties.getProperty("db.hostname"));
        }
        if (properties.containsKey("db.port")) {
            listenerConnectionSettings.setPort(properties.getProperty("db.port"));
        }
        if (properties.containsKey("db.sid")) {
            listenerConnectionSettings.setSid(properties.getProperty("db.sid"));
        }
        if (properties.containsKey("db.servicename")) {
            listenerConnectionSettings.setServiceName(properties.getProperty("db.servicename"));
        }
        if (properties.containsKey("db.tnsAliasName")) {
            listenerConnectionSettings.setTNSAliasName(properties.getProperty("db.tnsAliasName"));
        }
        if (properties.containsKey("db.tnsDirectory")) {
            listenerConnectionSettings.setTNSDirectory(properties.getProperty("db.tnsDirectory"));
        }
        if (properties.containsKey("db.customURL")) {
            listenerConnectionSettings.setCustomJDBCURL(properties.getProperty("db.customURL"));
        }
        if (properties.containsKey("jdbc.DriverType")) {
            string = properties.getProperty("jdbc.DriverType");
            enum_ = ListenerConnectionSettings.JDBC_DRIVER_TYPES.THIN;
            if (string.equals("oci8")) {
                enum_ = ListenerConnectionSettings.JDBC_DRIVER_TYPES.OCI;
            }
            listenerConnectionSettings.setJDBCDriver((ListenerConnectionSettings.JDBC_DRIVER_TYPES)enum_);
        }
        if (properties.containsKey("jdbc.InitialLimit")) {
            listenerConnectionSettings.setInitialPoolSize(Integer.parseInt(properties.getProperty("jdbc.InitialLimit")));
        }
        if (properties.containsKey("jdbc.MinLimit")) {
            listenerConnectionSettings.setMinimumConnections(Integer.parseInt(properties.getProperty("jdbc.MinLimit")));
        }
        if (properties.containsKey("jdbc.MaxLimit")) {
            listenerConnectionSettings.setMaximumConnections(Integer.parseInt(properties.getProperty("jdbc.MaxLimit")));
        }
        if (properties.containsKey("jdbc.MaxStatementsLimit")) {
            listenerConnectionSettings.setMaximumStatements(Integer.parseInt(properties.getProperty("jdbc.MaxStatementsLimit")));
        }
        if (properties.containsKey("jdbc.InactivityTimeout")) {
            listenerConnectionSettings.setInactivityTimeout(Integer.parseInt(properties.getProperty("jdbc.InactivityTimeout")));
        }
        if (properties.containsKey("jdbc.statementTimeout")) {
            listenerConnectionSettings.setAbandonedConnectionTimeout(Integer.parseInt(properties.getProperty("jdbc.statementTimeout")));
        } else if (properties.containsKey("jdbc.AbandonedConnectionTimeout")) {
            listenerConnectionSettings.setAbandonedConnectionTimeout(Integer.parseInt(properties.getProperty("jdbc.AbandonedConnectionTimeout")));
        }
    }

    private void loadSecuritySettings(Properties properties, ListenerModel listenerModel) {
        ArrayList<String> arrayList;
        Object object;
        String string;
        ListenerSecuritySettings listenerSecuritySettings = listenerModel.getSecuritySettings();
        if (properties.containsKey("security.inclusionList") && (string = properties.getProperty("security.inclusionList")) != null) {
            object = string.split(",");
            arrayList = this.createList((String[])object);
            listenerSecuritySettings.setAllowedProcedures(arrayList);
        }
        if (properties.containsKey("security.exclusionList") && (string = properties.getProperty("security.exclusionList")) != null) {
            object = string.split(",");
            arrayList = this.createList((String[])object);
            listenerSecuritySettings.setBlockedProcedures(arrayList);
        }
        if (properties.containsKey("security.disableDefaultExclusionList")) {
            listenerSecuritySettings.setDisableExclusionList(Boolean.parseBoolean(properties.getProperty("security.disableDefaultExclusionList")));
        }
        if (properties.containsKey("security.validationFunctionType")) {
            string = properties.getProperty("security.validationFunctionType");
            object = ListenerSecuritySettings.VALIDATION_FUNCTION_TYPE.PL_SQL;
            if (string.equals("javascript")) {
                object = ListenerSecuritySettings.VALIDATION_FUNCTION_TYPE.JAVASCRIPT;
            }
            listenerSecuritySettings.setValidationFunctionType((ListenerSecuritySettings.VALIDATION_FUNCTION_TYPE)((Object)object));
        }
        if (properties.containsKey("security.requestValidationFunction")) {
            listenerSecuritySettings.setValidationFunction(properties.getProperty("security.requestValidationFunction"));
        }
        if (properties.containsKey("security.verifySSL")) {
            listenerSecuritySettings.setVerifySSLRequests(Boolean.parseBoolean(properties.getProperty("security.verifySSL")));
        }
        if (properties.containsKey("icap.server")) {
            listenerSecuritySettings.setICAPServer(properties.getProperty("icap.server"));
        }
        if (properties.containsKey("icap.port")) {
            listenerSecuritySettings.setICAPPort(properties.getProperty("icap.port"));
        }
        if (properties.containsKey("security.maxEntries")) {
            listenerSecuritySettings.setMaximumCacheEntries(Integer.parseInt(properties.getProperty("security.maxEntries")));
        }
    }

    private void loadCacheSettings(Properties properties, ListenerModel listenerModel) {
        Object object;
        String string;
        ListenerCacheSettings listenerCacheSettings = listenerModel.getCacheSettings();
        if (properties.containsKey("cache.procedureNameList") && (string = properties.getProperty("cache.procedureNameList")) != null) {
            object = string.split(",");
            ArrayList<String> arrayList = this.createList((String[])object);
            listenerCacheSettings.setCacheProcedures(arrayList);
        }
        if (properties.containsKey("cache.type")) {
            string = properties.getProperty("cache.type");
            object = ListenerCacheSettings.CACHE_TYPE.LRU;
            if (string.equals("expire")) {
                object = ListenerCacheSettings.CACHE_TYPE.EXPIRATION;
            }
            listenerCacheSettings.setCacheType((ListenerCacheSettings.CACHE_TYPE)((Object)object));
        }
        if (properties.containsKey("cache.expiration")) {
            listenerCacheSettings.setExpiration(Integer.parseInt(properties.getProperty("cache.expiration")));
        }
        if (properties.containsKey("cache.duration")) {
            string = properties.getProperty("cache.duration");
            object = ListenerCacheSettings.DURATION.DAYS;
            if (string.equals("hours")) {
                object = ListenerCacheSettings.DURATION.HOURS;
            } else if (string.equals("minutes")) {
                object = ListenerCacheSettings.DURATION.MINUTES;
            }
            listenerCacheSettings.setDuration((ListenerCacheSettings.DURATION)((Object)object));
        }
        if (properties.containsKey("cache.maxEntries")) {
            listenerCacheSettings.setMaxCacheEntries(Integer.parseInt(properties.getProperty("cache.maxEntries")));
        }
        if (properties.containsKey("cache.directory")) {
            listenerCacheSettings.setDirectory(properties.getProperty("cache.directory"));
        }
        if (properties.containsKey("cache.caching")) {
            listenerCacheSettings.setCaching(Boolean.parseBoolean(properties.getProperty("cache.caching")));
        }
    }

    private void loadProcedureSettings(Properties properties, ListenerModel listenerModel) {
        ArrayList<String> arrayList;
        String[] stringArray;
        String string;
        ListenerProcedureSettings listenerProcedureSettings = listenerModel.getProcedureSettings();
        if (properties.containsKey("procedure.preProcess") && (string = properties.getProperty("procedure.preProcess")) != null) {
            stringArray = string.split(",");
            arrayList = this.createList(stringArray);
            listenerProcedureSettings.setPreProcessProcedures(arrayList);
        }
        if (properties.containsKey("procedure.postProcess") && (string = properties.getProperty("procedure.postProcess")) != null) {
            stringArray = string.split(",");
            arrayList = this.createList(stringArray);
            listenerProcedureSettings.setPostProcessProcedures(arrayList);
        }
    }

    private void loadEnvironmentSettings(Properties properties, ListenerModel listenerModel) {
        ListenerEnvironmentSettings listenerEnvironmentSettings = listenerModel.getEnvironmentSettings();
        if (properties.containsKey("misc.defaultPage")) {
            listenerEnvironmentSettings.setDefaultWebPage(properties.getProperty("misc.defaultPage"));
        }
        if (properties.containsKey("apex.docTable")) {
            listenerEnvironmentSettings.setDocTable(properties.getProperty("apex.docTable"));
        }
        if (properties.containsKey("apex.extensions")) {
            listenerEnvironmentSettings.setExtensionClasses(properties.getProperty("apex.extensions"));
        }
    }

    private void loadReportSettings(Properties properties, ListenerModel listenerModel) {
        ListenerReportSettings listenerReportSettings = listenerModel.getReportSettings();
        if (properties.containsKey("apex.excel2collection")) {
            listenerReportSettings.setCreateCollectionFromExcelFile(Boolean.parseBoolean(properties.getProperty("apex.excel2collection")));
        }
        if (properties.containsKey("apex.excel2collection.onecollection")) {
            listenerReportSettings.setPutWorkSheetsInOneCollection(Boolean.parseBoolean(properties.getProperty("apex.excel2collection.onecollection")));
        }
        if (properties.containsKey("apex.excel2collection.useSheetName")) {
            listenerReportSettings.setUseWorkSheetNameAsCollectionName(Boolean.parseBoolean(properties.getProperty("apex.excel2collection.useSheetName")));
        }
        if (properties.containsKey("apex.excel2collection.name")) {
            listenerReportSettings.setCollectionName(properties.getProperty("apex.excel2collection.name"));
        }
        if (properties.containsKey("debug.output")) {
            String string = properties.getProperty("debug.output");
            if (string != null && !string.isEmpty()) {
                if (string.equalsIgnoreCase("off")) {
                    listenerReportSettings.setDebugOutput(ListenerReportSettings.DEBUG_OUTPUT.OFF);
                } else if (string.equalsIgnoreCase("console")) {
                    listenerReportSettings.setDebugOutput(ListenerReportSettings.DEBUG_OUTPUT.CONSOLE);
                } else if (string.equalsIgnoreCase("logger")) {
                    listenerReportSettings.setDebugOutput(ListenerReportSettings.DEBUG_OUTPUT.LOGGER);
                } else {
                    listenerReportSettings.setDebugOutput(ListenerReportSettings.DEBUG_OUTPUT.LOGGER);
                }
            } else {
                listenerReportSettings.setDebugOutput(ListenerReportSettings.DEBUG_OUTPUT.LOGGER);
            }
        } else if (properties.containsKey("debug.debugger")) {
            boolean bl = Boolean.parseBoolean(properties.getProperty("debug.debugger"));
            if (bl) {
                listenerReportSettings.setDebugOutput(ListenerReportSettings.DEBUG_OUTPUT.CONSOLE);
            } else {
                listenerReportSettings.setDebugOutput(ListenerReportSettings.DEBUG_OUTPUT.OFF);
            }
        } else {
            listenerReportSettings.setDebugOutput(ListenerReportSettings.DEBUG_OUTPUT.LOGGER);
        }
        if (properties.containsKey("debug.printDebugToScreen")) {
            listenerReportSettings.setDisplayErrorMessages(Boolean.parseBoolean(properties.getProperty("debug.printDebugToScreen")));
        }
        if (properties.containsKey("error.keepErrorMessages")) {
            listenerReportSettings.setKeepErrorMessages(Boolean.parseBoolean(properties.getProperty("error.keepErrorMessages")));
        }
        if (properties.containsKey("error.maxEntries")) {
            listenerReportSettings.setMaxErrorEntries(Integer.parseInt(properties.getProperty("error.maxEntries")));
        }
        if (properties.containsKey("log.logging")) {
            listenerReportSettings.setLogging(Boolean.parseBoolean(properties.getProperty("log.logging")));
        }
        if (properties.containsKey("log.maxEntries")) {
            listenerReportSettings.setMaxLogEntries(Integer.parseInt(properties.getProperty("log.maxEntries")));
        }
        if (properties.containsKey("status.statistics")) {
            listenerReportSettings.setReporting(Boolean.parseBoolean(properties.getProperty("status.statistics")));
        }
    }

    private void loadRESTUsers(ListenerModel listenerModel, String string) throws IOException {
        this.setRESTUserSettings(listenerModel.getConnectionSettings(), string + "_rt.xml");
        this.setRESTUserSettings(listenerModel.getConnectionSettings(), string + "_al.xml");
        this.setRESTUserSettings(listenerModel.getConnectionSettings(), string + "_pu.xml");
    }

    private void setRESTUserSettings(ListenerConnectionSettings listenerConnectionSettings, String string) throws IOException {
        Properties properties = this.getRESTProperties(string);
        if (properties != null) {
            String string2;
            if (this._restProps == null) {
                this._restProps = new HashMap();
            }
            this._restProps.put(string, properties);
            String string3 = null;
            if (properties.containsKey("db.password")) {
                string3 = properties.getProperty("db.password");
            } else if (this._globalProps.containsKey("db.password")) {
                string3 = this._globalProps.getProperty("db.password");
            }
            if (string3 != null && (string2 = properties.getProperty("db.username")) != null) {
                if (string2.equals("APEX_LISTENER")) {
                    listenerConnectionSettings.setListenerPassword(this.getPassword(string3));
                } else if (string2.equals("APEX_REST_PUBLIC_USER")) {
                    listenerConnectionSettings.setRestPassword(this.getPassword(string3));
                } else if (string2.equals("ORDS_PUBLIC_USER")) {
                    listenerConnectionSettings.setPublicPassword(this.getPassword(string3));
                }
            }
        }
    }

    private Properties getRESTProperties(String string) throws IOException {
        ZipEntry zipEntry = this._zipRdr.getRESTUserZipEntry(string);
        if (zipEntry != null) {
            Properties properties = new Properties();
            properties.loadFromXML(this._zipRdr.getInputStream(zipEntry));
            return properties;
        }
        return null;
    }

    private void loadNoSQLStores() throws Exception {
        LinkedHashMap<String, HashMap<String, ZipEntry>> linkedHashMap = this._zipRdr.getNoSQLZipEntryList();
        if (linkedHashMap == null || linkedHashMap.size() == 0) {
            return;
        }
        this._noSQLProps = new HashMap();
        ArrayList<NoSQLStoreConfig> arrayList = new ArrayList<NoSQLStoreConfig>();
        for (String string : linkedHashMap.keySet()) {
            Object object;
            Object object2;
            NoSQLStoreConfig noSQLStoreConfig = new NoSQLStoreConfig();
            HashMap<String, ZipEntry> hashMap = linkedHashMap.get(string);
            if (!hashMap.containsKey("nosql.properties")) continue;
            Properties properties = new Properties();
            properties.load(this._zipRdr.getInputStream(hashMap.get("nosql.properties")));
            HashMap<String, Properties> hashMap2 = new HashMap<String, Properties>();
            hashMap2.put("nosql.properties", properties);
            noSQLStoreConfig.setStoreMode(NoSQLConstants.StoreMode.UPDATE);
            File file = NoSQLUtils.getStoreDirFile(this._ordsConfigPath, string);
            if (file != null) {
                noSQLStoreConfig.setStorePath(file.getPath());
            }
            noSQLStoreConfig.setStoreAlias(string);
            noSQLStoreConfig.setStoreName(properties.getProperty("oracle.dbtools.kv.store.name"));
            String string2 = properties.getProperty("oracle.dbtools.kv.store.hosts");
            if (string2 != null) {
                object2 = this.createList(string2.split(","));
                noSQLStoreConfig.setHostPortList((List<String>)object2);
            }
            if ((object2 = properties.getProperty("oracle.dbtools.kv.store.requiredRoles")) != null) {
                object = this.createList(((String)object2).split(","));
                noSQLStoreConfig.setRolesList((List<String>)object);
            }
            if ((object = properties.getProperty("oracle.dbtools.kv.store.pagelimit")) != null) {
                noSQLStoreConfig.setMaxItems(Integer.valueOf((String)object));
            }
            if (hashMap.containsKey("client.security")) {
                properties = new Properties();
                properties.load(this._zipRdr.getInputStream(hashMap.get("client.security")));
                hashMap2.put("client.security", properties);
                noSQLStoreConfig.setSecureStore(true);
                noSQLStoreConfig.setOrigSecureStore(true);
                noSQLStoreConfig.setClientTrustFile(properties.getProperty("oracle.kv.ssl.trustStore"));
                noSQLStoreConfig.setWalletDir(properties.getProperty("oracle.kv.auth.wallet.dir"));
                noSQLStoreConfig.setUsername(properties.getProperty("oracle.kv.auth.username"));
                noSQLStoreConfig.setPassword(properties.getProperty("oracle.dbtools.kv.store.auth.pwd"));
            }
            arrayList.add(noSQLStoreConfig);
            this._noSQLProps.put(string, hashMap2);
        }
        if (arrayList.size() > 0) {
            this._model.setNoSQLStores(arrayList);
        }
    }

    private void loadURLMappings(ListenerModel listenerModel) {
        ListenerURLMappings listenerURLMappings;
        if (this._urlMaps != null && !this._urlMaps.isEmpty() && (listenerURLMappings = this._urlMaps.get(listenerModel.getName())) != null) {
            listenerModel.setUrlMappings(listenerURLMappings);
        }
    }

    private void buildURLMappings() throws Exception {
        ZipEntry zipEntry = this._zipRdr.getURLMappingsZipEntry();
        if (zipEntry == null) {
            return;
        }
        this._attributes = new HashMap();
        this._urlMaps = new HashMap();
        SAXParser sAXParser = new SAXParser();
        ListenerURLMapReaderHandler listenerURLMapReaderHandler = new ListenerURLMapReaderHandler();
        sAXParser.setContentHandler((ContentHandler)listenerURLMapReaderHandler);
        sAXParser.setErrorHandler((ErrorHandler)listenerURLMapReaderHandler);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this._zipRdr.getInputStream(zipEntry)));
        sAXParser.parse(new InputSource(bufferedReader));
        if (bufferedReader != null) {
            bufferedReader.close();
        }
    }

    private String getPassword(String string) {
        String string2 = string;
        String string3 = "";
        if (string2 != null && !string2.isEmpty()) {
            if (string2.indexOf("!") == 0 && string2.length() > 1) {
                string3 = string2.substring(1);
                this._passwordClearText = true;
            } else if (string2.indexOf("@") == 0 && string2.length() > 1) {
                string2 = string2.substring(1);
                string3 = Passwords.comingIn((String)string2);
            } else {
                string3 = string2;
                this._passwordClearText = true;
            }
        }
        return string3;
    }

    private ArrayList<String> createList(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            arrayList.add(string);
        }
        return arrayList;
    }

    private boolean initReader(String string) {
        this._zipRdr = new ListenerZipFileReader();
        try {
            this._zipRdr.setEntriesFromZip(string);
            return true;
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            iOException.printStackTrace();
            if (this._zipRdr != null) {
                try {
                    this._zipRdr.closeFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public void initialize() {
        this._globalProps = null;
        this._dbSettingsProps = null;
        this._restProps = null;
        this._noSQLProps = null;
        this._urlMaps = null;
        this._passwordClearText = false;
    }

    private void closeImport() {
        try {
            this._zipRdr.closeFile();
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public void setReportData(ListenerReportData listenerReportData) {
        if (this._model != null) {
            this._model.setReportData(listenerReportData);
        }
    }

    public ListenerReportData getReportData() {
        if (this._model != null) {
            return this._model.getReportData();
        }
        return null;
    }

    public void setErrorReport(List<ListenerReportMessage> list) {
        if (this._model != null && this._model.getReportData() != null) {
            this._model.getReportData().setErrors(list);
        }
    }

    public void setLogReport(List<ListenerReportMessage> list) {
        if (this._model != null && this._model.getReportData() != null) {
            this._model.getReportData().setLogs(list);
        }
    }

    public boolean isPasswordClearText() {
        return this._passwordClearText;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean unZipORDSConfigFiles(String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) throw new IOException("Zip file: " + string + " is not found.");
        if (!file.isFile()) throw new IOException("Zip file: " + string + " is not a file.");
        File file2 = ListenerUtils.createConfigTempDir();
        if (file2 == null || !ListenerUtils.unzip(file, file2)) return false;
        this._ordsConfigPath = file2.getPath();
        return true;
    }

    private void initImport() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExitCommand.addShutdownHook((ShutdownHook)ListenerImportAdmin.this.myShutdownHook);
            }
        });
    }

    class ListenerURLMapReaderHandler
    extends DefaultHandler {
        ListenerURLMapReaderHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!ListenerImportAdmin.this._attributes.isEmpty()) {
                ListenerImportAdmin.this._attributes.clear();
            }
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                ListenerImportAdmin.this._attributes.put(attributes.getLocalName(i), attributes.getValue(i));
            }
            if (string2.equals("pool")) {
                String string4 = (String)ListenerImportAdmin.this._attributes.get("name");
                String string5 = (String)ListenerImportAdmin.this._attributes.get("base-path");
                String string6 = (String)ListenerImportAdmin.this._attributes.get("base-url");
                String string7 = (String)ListenerImportAdmin.this._attributes.get("uri-pattern");
                String string8 = (String)ListenerImportAdmin.this._attributes.get("schema-name");
                String string9 = (String)ListenerImportAdmin.this._attributes.get("workspace-id");
                String string10 = (String)ListenerImportAdmin.this._attributes.get("updated");
                ListenerURLMappings.ROUTING_RULE_TYPE rOUTING_RULE_TYPE = null;
                String string11 = null;
                if (string5 != null) {
                    rOUTING_RULE_TYPE = ListenerURLMappings.ROUTING_RULE_TYPE.BASE_PATH;
                    string11 = string5;
                } else if (string6 != null) {
                    rOUTING_RULE_TYPE = ListenerURLMappings.ROUTING_RULE_TYPE.BASE_URL;
                    string11 = string6;
                } else if (string7 != null) {
                    rOUTING_RULE_TYPE = ListenerURLMappings.ROUTING_RULE_TYPE.REG_EXPR;
                    string11 = string7;
                }
                if (string11 != null) {
                    String string12 = string8 == null ? "" : string8;
                    String string13 = string9 == null ? "" : string9;
                    ListenerURLMappings listenerURLMappings = (ListenerURLMappings)ListenerImportAdmin.this._urlMaps.get(string4);
                    if (listenerURLMappings == null) {
                        listenerURLMappings = new ListenerURLMappings();
                    }
                    listenerURLMappings.addURLPattern(rOUTING_RULE_TYPE, string11, string12, string13, string10);
                    ListenerImportAdmin.this._urlMaps.put(string4, listenerURLMappings);
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
        }
    }
}

