/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.model.ListenerSecuritySettings;
import oracle.dbtools.listener.ui.ListenerSettings;
import oracle.ide.util.ResourceUtils;

public class ListenerVirusScanPanel
extends ListenerSettings {
    private JTextField _server;
    private JTextField _port;

    public ListenerVirusScanPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this._server = new JTextField();
        this._port = new JTextField();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._server, (String)ListenerArb.getString("ICAP_SERVER"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._port, (String)ListenerArb.getString("ICAP_PORT"));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setPreferredSize(new Dimension(200, 35));
        jTextPane.setText(ListenerArb.getString("VIRUS_SCAN_INFO"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jTextPane, new GridBagConstraints(0, ++n, 2, 1, 0.5, 0.5, 23, 1, new Insets(3, 8, 0, 8), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 1, 0.2, 0.2, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(2, 8, 0, 8), 0, 0));
        jPanel.add((Component)this._server, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 0, 6), 0, 0));
        jPanel.add((Component)this._port, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        jPanel.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addSettingsPanel(jPanel);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel, ListenerModel listenerModel2) {
        this.initSettings(listenerModel, listenerModel2, "VirusScanning");
        this.assignSettings(this._model);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel) {
        if (listenerModel != null && listenerModel.getSecuritySettings() != null) {
            this._server.setText(listenerModel.getSecuritySettings().getICAPServer());
            this._port.setText(listenerModel.getSecuritySettings().getICAPPort());
            if (this._parentModel != null) {
                this.highlightGlobalValues(this._parentModel);
            }
        }
    }

    @Override
    public ListenerModel getSettings() {
        if (this._model != null && this._model.getSecuritySettings() != null) {
            this._model.getSecuritySettings().setICAPServer(this._server.getText());
            this._model.getSecuritySettings().setICAPPort(this._port.getText());
        }
        return this._model;
    }

    @Override
    public void highlightGlobalValues(ListenerModel listenerModel) {
        ListenerSecuritySettings listenerSecuritySettings = listenerModel.getSecuritySettings();
        this.updateTextHandler(this._server, listenerSecuritySettings.getICAPServer());
        this.updateTextHandler(this._port, listenerSecuritySettings.getICAPPort());
    }

    @Override
    public boolean isGlobalSettingsChange() {
        if (this._parentModel == null) {
            ListenerSecuritySettings listenerSecuritySettings = this._model.getSecuritySettings();
            if (this._server.getText() != listenerSecuritySettings.getICAPServer() || this._port.getText() != listenerSecuritySettings.getICAPPort()) {
                return true;
            }
        }
        return false;
    }
}

