/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerConnectionSettings;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.ui.ListenerSettings;
import oracle.dbtools.listener.ui.ListenerUIUtils;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.util.ResourceUtils;

public class ListenerJDBCPanel
extends ListenerSettings {
    private static final int MIN_SIZE = 1;
    private static final int MAX_SIZE = 100000;
    private ListenerConnectionSettings.JDBC_DRIVER_TYPES[] _dtList = ListenerConnectionSettings.JDBC_DRIVER_TYPES.values();
    private JComboBox _jdbcDriverType;
    private NumericSpinBox _initPoolSize;
    private NumericSpinBox _minConnections;
    private NumericSpinBox _maxConnections;
    private NumericSpinBox _maxStatements;
    private NumericSpinBox _inactivityTimeout;
    private NumericSpinBox _abandonedConnTimeout;

    public ListenerJDBCPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this._jdbcDriverType = new JComboBox<String>(ListenerUIUtils.getJDBCDriverTypes());
        this._initPoolSize = new NumericSpinBox(1, 100000);
        this._minConnections = new NumericSpinBox(1, 100000);
        this._maxConnections = new NumericSpinBox(1, 100000);
        this._maxStatements = new NumericSpinBox(1, 100000);
        this._inactivityTimeout = new NumericSpinBox(1, 100000);
        this._abandonedConnTimeout = new NumericSpinBox(1, 100000);
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        JLabel jLabel8 = new JLabel(ListenerArb.getString("SECONDS"));
        JLabel jLabel9 = new JLabel(ListenerArb.getString("SECONDS"));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._jdbcDriverType, (String)ListenerArb.getString("JDBC_DRIVER_TYPE"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._initPoolSize, (String)ListenerArb.getString("JDBC_INIT_POOL_SIZE"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._minConnections, (String)ListenerArb.getString("JDBC_MIN_CONN"));
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this._maxConnections, (String)ListenerArb.getString("JDBC_MAX_CONN"));
        ResourceUtils.resLabel((JLabel)jLabel5, (Component)this._maxStatements, (String)ListenerArb.getString("JDBC_MAX_STATEMENTS"));
        ResourceUtils.resLabel((JLabel)jLabel6, (Component)this._inactivityTimeout, (String)ListenerArb.getString("JDBC_INACTIVITY_TIMEOUT"));
        ResourceUtils.resLabel((JLabel)jLabel7, (Component)this._abandonedConnTimeout, (String)ListenerArb.getString("JDBC_ABANDONED_CONN_TIMEOUT"));
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 22, 0, new Insets(3, 0, 0, 6), 0, 0));
        jPanel.add((Component)this._jdbcDriverType, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(3, 0, 0, 8), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 22, 0, new Insets(10, 0, 0, 6), 0, 0));
        jPanel.add((Component)this._initPoolSize, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 0, 0, 8), 0, 0));
        jPanel.add((Component)jLabel5, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 22, 0, new Insets(8, 0, 0, 6), 0, 0));
        jPanel.add((Component)this._maxStatements, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 0, 0, 8), 0, 0));
        n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jLabel3, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 22, 2, new Insets(3, 8, 0, 6), 0, 0));
        jPanel2.add((Component)this._minConnections, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 23, 2, new Insets(3, 0, 0, 8), 0, 0));
        jPanel2.add((Component)jLabel4, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 22, 2, new Insets(8, 8, 6, 6), 0, 0));
        jPanel2.add((Component)this._maxConnections, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 23, 2, new Insets(8, 0, 6, 8), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel2, (String)ListenerArb.getString("CONNECTION_SIZE_TITLE"));
        n = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)jLabel6, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 22, 0, new Insets(3, 8, 0, 6), 0, 0));
        jPanel3.add((Component)this._inactivityTimeout, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(3, 0, 0, 1), 0, 0));
        jPanel3.add((Component)jLabel8, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 25, 0, new Insets(6, 0, 0, 8), 0, 0));
        jPanel3.add((Component)jLabel7, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 22, 0, new Insets(8, 8, 6, 6), 0, 0));
        jPanel3.add((Component)this._abandonedConnTimeout, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 0, 6, 1), 0, 0));
        jPanel3.add((Component)jLabel9, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 25, 0, new Insets(8, 0, 6, 8), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel3, (String)ListenerArb.getString("TIMEOUT_TITLE"));
        n = 0;
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)jPanel, new GridBagConstraints(0, n, 2, 1, 0.0, 0.0, 23, 0, new Insets(3, 8, 0, 8), 0, 0));
        jPanel4.add((Component)jPanel2, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 23, 0, new Insets(8, 8, 0, 8), 0, 0));
        jPanel4.add((Component)jPanel3, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 23, 0, new Insets(8, 8, 0, 8), 0, 0));
        jPanel4.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addSettingsPanel(jPanel4);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel, ListenerModel listenerModel2) {
        this.initSettings(listenerModel, listenerModel2, "JDBC");
        this.assignSettings(this._model);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel) {
        if (listenerModel != null && listenerModel.getConnectionSettings() != null) {
            ListenerConnectionSettings listenerConnectionSettings = listenerModel.getConnectionSettings();
            this._jdbcDriverType.setSelectedIndex(listenerConnectionSettings.getJDBCDriver().ordinal());
            this._initPoolSize.setIntValue(listenerConnectionSettings.getInitialPoolSize());
            this._minConnections.setIntValue(listenerConnectionSettings.getMinimumConnections());
            this._maxConnections.setIntValue(listenerConnectionSettings.getMaximumConnections());
            this._maxStatements.setIntValue(listenerConnectionSettings.getMaximumStatements());
            this._inactivityTimeout.setIntValue(listenerConnectionSettings.getInactivityTimeout());
            this._abandonedConnTimeout.setIntValue(listenerConnectionSettings.getAbandonedConnectionTimeout());
            if (this._parentModel != null) {
                this.highlightGlobalValues(this._parentModel);
            }
        }
    }

    @Override
    public ListenerModel getSettings() {
        if (this._model != null && this._model.getConnectionSettings() != null) {
            ListenerConnectionSettings listenerConnectionSettings = this._model.getConnectionSettings();
            listenerConnectionSettings.setJDBCDriver(this._dtList[this._jdbcDriverType.getSelectedIndex()]);
            listenerConnectionSettings.setInitialPoolSize(this._initPoolSize.getIntValue());
            listenerConnectionSettings.setMinimumConnections(this._minConnections.getIntValue());
            listenerConnectionSettings.setMaximumConnections(this._maxConnections.getIntValue());
            listenerConnectionSettings.setMaximumStatements(this._maxStatements.getIntValue());
            listenerConnectionSettings.setInactivityTimeout(this._inactivityTimeout.getIntValue());
            listenerConnectionSettings.setAbandonedConnectionTimeout(this._abandonedConnTimeout.getIntValue());
        }
        return this._model;
    }

    @Override
    public void highlightGlobalValues(ListenerModel listenerModel) {
        ListenerConnectionSettings listenerConnectionSettings = listenerModel.getConnectionSettings();
        this.updateNumericSpinBoxHandler(this._initPoolSize, listenerConnectionSettings.getInitialPoolSize());
        this.updateNumericSpinBoxHandler(this._minConnections, listenerConnectionSettings.getMinimumConnections());
        this.updateNumericSpinBoxHandler(this._maxConnections, listenerConnectionSettings.getMaximumConnections());
        this.updateNumericSpinBoxHandler(this._maxStatements, listenerConnectionSettings.getMaximumStatements());
        this.updateNumericSpinBoxHandler(this._inactivityTimeout, listenerConnectionSettings.getInactivityTimeout());
        this.updateNumericSpinBoxHandler(this._abandonedConnTimeout, listenerConnectionSettings.getAbandonedConnectionTimeout());
        this.updateComboBoxHandler(this._jdbcDriverType, listenerConnectionSettings.getJDBCDriver().ordinal());
    }

    @Override
    public boolean isGlobalSettingsChange() {
        if (this._parentModel == null) {
            ListenerConnectionSettings listenerConnectionSettings = this._model.getConnectionSettings();
            if (this._initPoolSize.getIntValue() != listenerConnectionSettings.getInitialPoolSize() || this._minConnections.getIntValue() != listenerConnectionSettings.getMinimumConnections() || this._maxConnections.getIntValue() != listenerConnectionSettings.getMaximumConnections() || this._maxStatements.getIntValue() != listenerConnectionSettings.getMaximumStatements() || this._inactivityTimeout.getIntValue() != listenerConnectionSettings.getInactivityTimeout() || this._abandonedConnTimeout.getIntValue() != listenerConnectionSettings.getAbandonedConnectionTimeout() || this._jdbcDriverType.getSelectedIndex() != listenerConnectionSettings.getJDBCDriver().ordinal()) {
                return true;
            }
        }
        return false;
    }
}

