/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerCacheSettings;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.ui.ListenerNameTablePanel;
import oracle.dbtools.listener.ui.ListenerSettings;
import oracle.dbtools.listener.ui.ListenerUIUtils;
import oracle.ide.util.ResourceUtils;

public class ListenerCacheFilesPanel
extends ListenerSettings
implements ItemListener {
    private ListenerNameTablePanel _tablePanel;
    private JRadioButton _mostRecentRadioBtn;
    private JRadioButton _expirationRadioBtn;
    private NumericSpinBox _maxEntries;
    private NumericSpinBox _expiration;
    private JComboBox _duration;
    private Color _origExpirationBGColor;
    private Color _origDurationBGColor;
    private Color _origRadioBGColor;
    private int _globalExpiration;
    private int _globalDuration;
    private boolean _globalMostRecent;
    private Color _globalBGColor;
    private boolean _isGlobalShowing = false;

    public ListenerCacheFilesPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(300, 275));
        String[] stringArray = new String[]{ListenerCacheSettings.DURATION.DAYS.getNLS(), ListenerCacheSettings.DURATION.HOURS.getNLS(), ListenerCacheSettings.DURATION.MINUTES.getNLS()};
        this._duration = new JComboBox<String>(stringArray);
        this._duration.setSelectedIndex(0);
        this._maxEntries = new NumericSpinBox(1, 1000000);
        this._expiration = new NumericSpinBox(1, 1000000);
        this._mostRecentRadioBtn = new JRadioButton();
        this._expirationRadioBtn = new JRadioButton();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._maxEntries, (String)ListenerArb.getString("MAX_ENTRIES"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._expiration, (String)ListenerArb.getString("EXPIRES_AFTER"));
        ResourceUtils.resButton((AbstractButton)this._mostRecentRadioBtn, (String)ListenerArb.getString("CACHE_KEEP_RECENTLY_USED_FILES"));
        ResourceUtils.resButton((AbstractButton)this._expirationRadioBtn, (String)ListenerArb.getString("CACHE_KEEP_SPECIFIED_DURATION"));
        this._tablePanel = new ListenerNameTablePanel(ListenerArb.getString("CACHE_PROCECURE_DESCRIP"), null);
        JPanel jPanel = new JPanel(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._mostRecentRadioBtn);
        buttonGroup.add(this._expirationRadioBtn);
        int n = 0;
        jPanel.add((Component)this._mostRecentRadioBtn, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 2, new Insets(8, 8, 0, 6), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 21, 2, new Insets(8, 0, 0, 6), 0, 0));
        jPanel.add((Component)this._maxEntries, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        jPanel.add((Component)this._expirationRadioBtn, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 2, new Insets(8, 8, 0, 6), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 21, 2, new Insets(8, 0, 0, 6), 0, 0));
        jPanel.add((Component)this._expiration, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        jPanel.add((Component)this._duration, new GridBagConstraints(3, n, 1, 1, 0.0, 0.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        n = 0;
        this.add((Component)this._tablePanel, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 23, 1, new Insets(3, 8, 0, 8), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 8, 8, 8), 0, 0));
        this.setLastRow(n);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableDisableOptions();
    }

    private void enableDisableOptions() {
        this._maxEntries.setEnabled(this._mostRecentRadioBtn.isSelected());
        this._expiration.setEnabled(this._expirationRadioBtn.isSelected());
        this._duration.setEnabled(this._expirationRadioBtn.isSelected());
    }

    private void updateRadioButtonBGColor() {
        if (this._globalMostRecent) {
            this._mostRecentRadioBtn.setBackground(this._globalBGColor);
            this._expirationRadioBtn.setBackground(this._origRadioBGColor);
        } else {
            this._mostRecentRadioBtn.setBackground(this._origRadioBGColor);
            this._expirationRadioBtn.setBackground(this._globalBGColor);
        }
    }

    private void updateExpirationDurationBGColor() {
        if (this._expiration.getIntValue() == this._globalExpiration && this._duration.getSelectedIndex() == this._globalDuration) {
            this._expiration.setBackground(this._globalBGColor);
            this._duration.setBackground(this._globalBGColor);
            this._isGlobalShowing = true;
        } else if (this._isGlobalShowing) {
            this._expiration.setBackground(this._origExpirationBGColor);
            this._duration.setBackground(this._origDurationBGColor);
            this._isGlobalShowing = false;
        }
    }

    @Override
    public void assignSettings(ListenerModel listenerModel, ListenerModel listenerModel2) {
        this.initSettings(listenerModel, listenerModel2, "CacheFiles");
        this.assignSettings(this._model);
        if (listenerModel2 != null) {
            this._origExpirationBGColor = new Color(this._expiration.getBackground().getRGB());
            this._origDurationBGColor = new Color(this._duration.getBackground().getRGB());
            this._origRadioBGColor = new Color(this._mostRecentRadioBtn.getBackground().getRGB());
            this._globalBGColor = ListenerUIUtils.getHighlightBackgroundColor();
            this._mostRecentRadioBtn.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    try {
                        ListenerCacheFilesPanel.this.updateRadioButtonBGColor();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this._expiration.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    ListenerCacheFilesPanel.this.updateExpirationDurationBGColor();
                }
            });
            this._duration.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    try {
                        ListenerCacheFilesPanel.this.updateExpirationDurationBGColor();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        this._mostRecentRadioBtn.addItemListener(this);
        this._expirationRadioBtn.addItemListener(this);
        this.enableDisableOptions();
    }

    @Override
    public void assignSettings(ListenerModel listenerModel) {
        if (listenerModel != null && listenerModel.getCacheSettings() != null) {
            ListenerCacheSettings listenerCacheSettings = listenerModel.getCacheSettings();
            this._tablePanel.setNames(listenerCacheSettings.getCacheProcedures());
            this._maxEntries.setIntValue(listenerCacheSettings.getMaxCacheEntries());
            this._expiration.setIntValue(listenerCacheSettings.getExpiration());
            this._duration.setSelectedIndex(listenerCacheSettings.getDuration().ordinal());
            if (listenerCacheSettings.getCacheType() == ListenerCacheSettings.CACHE_TYPE.LRU) {
                this._mostRecentRadioBtn.setSelected(true);
            } else {
                this._expirationRadioBtn.setSelected(true);
            }
            if (this._parentModel != null) {
                this.highlightGlobalValues(this._parentModel);
            }
        }
    }

    @Override
    public ListenerModel getSettings() {
        if (this._model != null && this._model.getCacheSettings() != null) {
            if (this._tablePanel.getTable() != null && this._tablePanel.getTable().getCellEditor() != null) {
                this._tablePanel.getTable().getCellEditor().stopCellEditing();
            }
            ListenerCacheSettings listenerCacheSettings = this._model.getCacheSettings();
            listenerCacheSettings.setCacheProcedures((ArrayList)this._tablePanel.getNames());
            listenerCacheSettings.setMaxCacheEntries(this._maxEntries.getIntValue());
            listenerCacheSettings.setExpiration(this._expiration.getIntValue());
            listenerCacheSettings.setDuration(ListenerCacheSettings.DURATION.values()[this._duration.getSelectedIndex()]);
            listenerCacheSettings.setCacheType(this._mostRecentRadioBtn.isSelected() ? ListenerCacheSettings.CACHE_TYPE.LRU : ListenerCacheSettings.CACHE_TYPE.EXPIRATION);
            if (listenerCacheSettings.getCacheProcedures() != null && !listenerCacheSettings.getCacheProcedures().isEmpty()) {
                listenerCacheSettings.setCaching(true);
            } else {
                listenerCacheSettings.setCaching(false);
            }
        }
        return this._model;
    }

    @Override
    public void highlightGlobalValues(ListenerModel listenerModel) {
        ListenerCacheSettings listenerCacheSettings = listenerModel.getCacheSettings();
        if (this._tablePanel.getTable() != null && this._tablePanel.getTable().getCellEditor() != null && this._tablePanel.getTable().isEditing()) {
            this._tablePanel.getTable().getCellEditor().stopCellEditing();
        }
        this._tablePanel.setParentNames(listenerCacheSettings.getCacheProcedures());
        this.updateNumericSpinBoxHandler(this._maxEntries, listenerCacheSettings.getMaxCacheEntries());
        this._globalExpiration = listenerCacheSettings.getExpiration();
        this._globalDuration = listenerCacheSettings.getDuration().ordinal();
        this._globalMostRecent = listenerCacheSettings.getCacheType() == ListenerCacheSettings.CACHE_TYPE.LRU;
        this.updateRadioButtonBGColor();
        this.updateExpirationDurationBGColor();
    }

    @Override
    public boolean resetSettings() {
        if (this._parentModel != null) {
            this._tablePanel.removeAllRows();
            this.assignSettings(this._parentModel);
            return true;
        }
        return false;
    }

    @Override
    public boolean isGlobalSettingsChange() {
        if (this._parentModel == null) {
            ListenerCacheSettings.CACHE_TYPE cACHE_TYPE;
            ListenerCacheSettings listenerCacheSettings = this._model.getCacheSettings();
            ArrayList<String> arrayList = listenerCacheSettings.getCacheProcedures();
            String string = ListenerUIUtils.getCommaDelimited(arrayList);
            String string2 = ListenerUIUtils.getCommaDelimited(this._tablePanel.getNames());
            if (string2.equals(string)) {
                return true;
            }
            ListenerCacheSettings.CACHE_TYPE cACHE_TYPE2 = cACHE_TYPE = this._mostRecentRadioBtn.isSelected() ? ListenerCacheSettings.CACHE_TYPE.LRU : ListenerCacheSettings.CACHE_TYPE.EXPIRATION;
            if (this._maxEntries.getIntValue() != listenerCacheSettings.getMaxCacheEntries() || this._expiration.getIntValue() != listenerCacheSettings.getExpiration() || this._duration.getSelectedIndex() != listenerCacheSettings.getDuration().ordinal() || cACHE_TYPE != listenerCacheSettings.getCacheType()) {
                return true;
            }
        }
        return false;
    }
}

