/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.nosql;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.listener.model.NoSQLStoreConfig;
import oracle.dbtools.listener.nosql.NoSQLConstants;
import oracle.dbtools.listener.nosql.NoSQLUtils;
import oracle.dbtools.listener.ui.ListenerUIUtils;
import oracle.dbtools.listener.utils.ListenerUtils;
import oracle.dbtools.listener.utils.ListenerZipFileWriter;
import oracle.dbtools.listener.xml.ListenerImportAdmin;

public class NoSQLExportStores {
    private static HashMap<String, HashMap<String, Properties>> _storeMap;

    public static boolean exportNoSQLStores(ListenerZipFileWriter listenerZipFileWriter, List<NoSQLStoreConfig> list) throws IOException {
        if (list == null || list.isEmpty()) {
            _storeMap = null;
            return false;
        }
        return new NoSQLExportStores().exportStores(listenerZipFileWriter, list);
    }

    public static void refreshStoreMap() {
        if (_storeMap != null) {
            ListenerImportAdmin.getInstance().updateNoSQLStoresProperties(_storeMap);
        }
    }

    private boolean exportStores(ListenerZipFileWriter listenerZipFileWriter, List<NoSQLStoreConfig> list) throws IOException {
        _storeMap = new HashMap();
        try {
            for (NoSQLStoreConfig noSQLStoreConfig : list) {
                Object object;
                Properties properties;
                String string = noSQLStoreConfig.getStoreAlias();
                File file = new File(noSQLStoreConfig.getStorePath());
                this.removeSecureFiles(file, noSQLStoreConfig);
                HashMap<String, Properties> hashMap = null;
                Properties properties2 = null;
                if (noSQLStoreConfig.getStoreMode() == NoSQLConstants.StoreMode.ADD) {
                    properties2 = this.getNoSQLStoreProperties(noSQLStoreConfig);
                } else {
                    hashMap = ListenerImportAdmin.getInstance().getNoSQLStoresProperties(string);
                    properties = hashMap.get("nosql.properties");
                    properties2 = this.getNoSQLStoreProperties(properties, noSQLStoreConfig);
                }
                listenerZipFileWriter.addEntry(this.getEntryName(string, "nosql.properties"));
                listenerZipFileWriter.write(properties2, null);
                properties = null;
                if (noSQLStoreConfig.isSecureStore()) {
                    if (noSQLStoreConfig.getStoreMode() == NoSQLConstants.StoreMode.ADD) {
                        properties = this.getSecurityFileProperites(noSQLStoreConfig);
                    } else {
                        object = hashMap.get("client.security");
                        properties = this.getSecurityFileWithOrigProperites((Properties)object, noSQLStoreConfig);
                    }
                    this.cleanupFileNames(properties);
                    listenerZipFileWriter.addEntry(this.getEntryName(string, "client.security"));
                    listenerZipFileWriter.write(properties, null);
                    object = "nosql/" + noSQLStoreConfig.getStoreAlias() + "/";
                    this.addFileToZip(listenerZipFileWriter, (String)object, file);
                }
                if (properties2 == null) continue;
                object = new HashMap<String, Properties>();
                ((HashMap)object).put("nosql.properties", properties2);
                if (properties != null) {
                    ((HashMap)object).put("client.security", properties);
                }
                _storeMap.put(string, (HashMap<String, Properties>)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        return true;
    }

    private void removeSecureFiles(File file, NoSQLStoreConfig noSQLStoreConfig) throws IOException {
        if (noSQLStoreConfig.isSecureStore()) {
            File file2;
            if (!this.hasValue(noSQLStoreConfig.getWalletDirectory()) && (file2 = new File(file, "wallet")).exists()) {
                ListenerUtils.delete(file2);
            }
        } else {
            File file3;
            File file4;
            File file5 = new File(file, "client.security");
            if (file5.exists()) {
                ListenerUtils.delete(file5);
            }
            if ((file4 = new File(file, "client.trust")).exists()) {
                ListenerUtils.delete(file4);
            }
            if ((file3 = new File(file, "wallet")).exists()) {
                ListenerUtils.delete(file3);
            }
        }
    }

    private Properties getSecurityFileWithOrigProperites(Properties properties, NoSQLStoreConfig noSQLStoreConfig) throws IOException {
        Properties properties2 = null;
        if (noSQLStoreConfig.isSecureStore()) {
            if (noSQLStoreConfig.isOrigSecureStore()) {
                properties2 = new Properties();
                properties2.setProperty("oracle.kv.auth.username", noSQLStoreConfig.getUsername());
                for (String string : properties.stringPropertyNames()) {
                    if (properties2.containsKey(string)) continue;
                    properties2.put(string, properties.get(string));
                }
            } else {
                properties2 = this.getSecurityFileProperites(noSQLStoreConfig);
            }
            if (properties2.containsKey("oracle.kv.auth.pwdfile.file")) {
                properties2.remove("oracle.dbtools.kv.store.security.properties");
            }
        }
        return properties2;
    }

    private Properties getSecurityFileProperites(NoSQLStoreConfig noSQLStoreConfig) throws IOException {
        Properties properties = new Properties();
        File file = new File(noSQLStoreConfig.getStorePath());
        if (file.isDirectory()) {
            File file2 = new File(file, "client.security");
            if (file2.isFile()) {
                properties = NoSQLUtils.getProperties(file2);
            } else {
                throw new IOException("Cannot get property file: " + file2.getPath());
            }
        }
        properties.setProperty("oracle.kv.ssl.trustStore", noSQLStoreConfig.getClientTrustFile());
        properties.setProperty("oracle.kv.auth.username", noSQLStoreConfig.getUsername());
        if (this.hasValue(noSQLStoreConfig.getWalletDirectory())) {
            properties.setProperty("oracle.kv.auth.wallet.dir", noSQLStoreConfig.getWalletDirectory());
            if (properties.containsKey("oracle.dbtools.kv.store.auth.pwd")) {
                properties.remove("oracle.dbtools.kv.store.auth.pwd");
            }
        } else {
            properties.setProperty("oracle.dbtools.kv.store.auth.pwd", noSQLStoreConfig.getPassword());
            if (properties.containsKey("oracle.kv.auth.wallet.dir")) {
                properties.remove("oracle.kv.auth.wallet.dir");
            }
        }
        if (properties.containsKey("oracle.kv.auth.pwdfile.file")) {
            properties.remove("oracle.kv.auth.pwdfile.file");
        }
        return properties;
    }

    private Properties getNoSQLStoreProperties(Properties properties, NoSQLStoreConfig noSQLStoreConfig) {
        Properties properties2 = this.getNoSQLStoreProperties(noSQLStoreConfig);
        if (!noSQLStoreConfig.isSecureStore() && properties2.containsKey("oracle.dbtools.kv.store.security.properties")) {
            properties2.remove("oracle.dbtools.kv.store.security.properties");
        }
        return properties2;
    }

    private Properties getNoSQLStoreProperties(NoSQLStoreConfig noSQLStoreConfig) {
        Properties properties = new Properties();
        properties.setProperty("oracle.dbtools.kv.store.name", noSQLStoreConfig.getStoreName());
        properties.setProperty("oracle.dbtools.kv.store.hosts", ListenerUIUtils.getCommaDelimited(noSQLStoreConfig.getHostPortList()));
        if (noSQLStoreConfig.getRolesList() != null && !noSQLStoreConfig.getRolesList().isEmpty()) {
            properties.setProperty("oracle.dbtools.kv.store.requiredRoles", ListenerUIUtils.getCommaDelimited(noSQLStoreConfig.getRolesList()));
        }
        if (noSQLStoreConfig.isSecureStore()) {
            properties.setProperty("oracle.dbtools.kv.store.security.properties", "client.security");
        }
        if (noSQLStoreConfig.getMaxItems() > 0) {
            properties.setProperty("oracle.dbtools.kv.store.pagelimit", String.valueOf(noSQLStoreConfig.getMaxItems()));
        }
        return properties;
    }

    private void addFileToZip(ListenerZipFileWriter listenerZipFileWriter, String string, File file) throws IOException {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            StringBuilder stringBuilder;
            if (fileArray[i].isDirectory()) {
                stringBuilder = new StringBuilder();
                stringBuilder.append(string).append(fileArray[i].getName()).append("/");
                this.addFileToZip(listenerZipFileWriter, stringBuilder.toString(), fileArray[i]);
                continue;
            }
            if (fileArray[i].getName().equals("nosql.properties") || fileArray[i].getName().equals("client.security")) continue;
            stringBuilder = new StringBuilder();
            stringBuilder.append(string).append(fileArray[i].getName());
            listenerZipFileWriter.addFile(stringBuilder.toString(), fileArray[i]);
        }
    }

    private String getEntryName(String string, String string2) {
        return "nosql/" + string + "/" + string2;
    }

    private void cleanupFileNames(Properties properties) {
        for (String string : NoSQLConstants.NOSQL_FILES) {
            String string2;
            if (!properties.containsKey(string) || !this.hasValue(string2 = (String)properties.get(string))) continue;
            string2 = string2.replace('\\', '/');
            properties.put(string, string2);
        }
    }

    private boolean hasValue(String string) {
        return string != null && string.trim().length() > 0;
    }
}

