/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.model;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import oracle.dbtools.listener.model.ListenerCacheSettings;
import oracle.dbtools.listener.model.ListenerConnectionSettings;
import oracle.dbtools.listener.model.ListenerEnvironmentSettings;
import oracle.dbtools.listener.model.ListenerProcedureSettings;
import oracle.dbtools.listener.model.ListenerReportData;
import oracle.dbtools.listener.model.ListenerReportSettings;
import oracle.dbtools.listener.model.ListenerSecuritySettings;
import oracle.dbtools.listener.model.ListenerURLMappings;
import oracle.dbtools.listener.model.NoSQLStoreConfig;
import oracle.ide.Version;

public class ListenerModel
implements Cloneable {
    private ListenerConnectionSettings _connSettings;
    private ListenerURLMappings _urlMappings;
    private ListenerSecuritySettings _securitySettings;
    private ListenerCacheSettings _cacheSettings;
    private ListenerProcedureSettings _procedureSettings;
    private ListenerReportSettings _reportSettings;
    private ListenerEnvironmentSettings _environSettings;
    private ListenerReportData _reportData;
    private String _name;
    private String _description;
    private String _listenerVersion;
    private String _sqlDevVersion;
    private String _user;
    private int _id;
    private Date _lastModified;
    private List<ListenerModel> _children;
    private List<NoSQLStoreConfig> _noSQLStores;
    private String _configPath;

    public ListenerModel() {
        this.init();
    }

    private void init() {
        this._connSettings = new ListenerConnectionSettings();
        this._urlMappings = new ListenerURLMappings();
        this._securitySettings = new ListenerSecuritySettings();
        this._procedureSettings = new ListenerProcedureSettings();
        this._environSettings = new ListenerEnvironmentSettings();
        this._reportSettings = new ListenerReportSettings();
        this._cacheSettings = new ListenerCacheSettings();
        this._reportData = new ListenerReportData();
        this._sqlDevVersion = Version.VER_FULL;
        this._lastModified = Calendar.getInstance().getTime();
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public String getDescription() {
        return this._description;
    }

    public void setListenerVersion(String string) {
        this._listenerVersion = string;
    }

    public String getListenerVersion() {
        return this._listenerVersion;
    }

    public void setSqlDevVersion(String string) {
        this._sqlDevVersion = string;
    }

    public String getSqlDevVersion() {
        return this._sqlDevVersion;
    }

    public void setUser(String string) {
        this._user = string;
    }

    public String getUser() {
        return this._user;
    }

    public void setID(int n) {
        this._id = n;
    }

    public int getID() {
        return this._id;
    }

    public void setLastModified(Date date) {
        this._lastModified = date;
    }

    public Date getLastModified() {
        return this._lastModified;
    }

    public void setConfigPath(String string) {
        this._configPath = string;
    }

    public String getConfigPath() {
        return this._configPath;
    }

    public void setChildren(List<ListenerModel> list) {
        this._children = list;
    }

    public List<ListenerModel> getChildren() {
        return this._children;
    }

    public void setNoSQLStores(List<NoSQLStoreConfig> list) {
        this._noSQLStores = list;
    }

    public List<NoSQLStoreConfig> getNoSQLStores() {
        return this._noSQLStores;
    }

    public boolean hasChildren() {
        return this._children != null && this._children.size() > 0;
    }

    public void setConnectionSettings(ListenerConnectionSettings listenerConnectionSettings) {
        this._connSettings = listenerConnectionSettings;
    }

    public ListenerConnectionSettings getConnectionSettings() {
        return this._connSettings;
    }

    public void setUrlMappings(ListenerURLMappings listenerURLMappings) {
        this._urlMappings = listenerURLMappings;
    }

    public ListenerURLMappings getUrlMappings() {
        return this._urlMappings;
    }

    public void setSecuritySettings(ListenerSecuritySettings listenerSecuritySettings) {
        this._securitySettings = listenerSecuritySettings;
    }

    public ListenerSecuritySettings getSecuritySettings() {
        return this._securitySettings;
    }

    public void setCacheSettings(ListenerCacheSettings listenerCacheSettings) {
        this._cacheSettings = listenerCacheSettings;
    }

    public ListenerCacheSettings getCacheSettings() {
        return this._cacheSettings;
    }

    public void setProcedureSettings(ListenerProcedureSettings listenerProcedureSettings) {
        this._procedureSettings = listenerProcedureSettings;
    }

    public ListenerProcedureSettings getProcedureSettings() {
        return this._procedureSettings;
    }

    public void setReportSettings(ListenerReportSettings listenerReportSettings) {
        this._reportSettings = listenerReportSettings;
    }

    public ListenerReportSettings getReportSettings() {
        return this._reportSettings;
    }

    public void setEnvironmentSettings(ListenerEnvironmentSettings listenerEnvironmentSettings) {
        this._environSettings = listenerEnvironmentSettings;
    }

    public ListenerEnvironmentSettings getEnvironmentSettings() {
        return this._environSettings;
    }

    public void setReportData(ListenerReportData listenerReportData) {
        this._reportData = listenerReportData;
    }

    public ListenerReportData getReportData() {
        return this._reportData;
    }

    public ListenerModel clone() throws CloneNotSupportedException {
        ListenerModel listenerModel = new ListenerModel();
        listenerModel.setLastModified(this.getLastModified());
        listenerModel.setListenerVersion(this.getListenerVersion());
        listenerModel.setSqlDevVersion(this.getSqlDevVersion());
        listenerModel.setUser(this.getUser());
        listenerModel.setCacheSettings(this.getCacheSettings().clone());
        listenerModel.setConnectionSettings(this.getConnectionSettings().clone());
        listenerModel.setEnvironmentSettings(this.getEnvironmentSettings().clone());
        listenerModel.setProcedureSettings(this.getProcedureSettings().clone());
        listenerModel.setReportSettings(this.getReportSettings().clone());
        listenerModel.setSecuritySettings(this.getSecuritySettings().clone());
        listenerModel.setUrlMappings(this.getUrlMappings().clone());
        return listenerModel;
    }
}

