/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.util.jdbc;

import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleStatement;
import oracle.olapdv.util.Logger;
import oracle.olapdv.util.jdbc.SQLParam;
import oracle.sql.CLOB;

public class SQLWrapper {
    private static OraclePreparedStatement s = null;

    public static SQLParam execute(Connection connection, String string) throws SQLException {
        return SQLWrapper.execute(connection, string, new SQLParam[0]);
    }

    public static SQLParam execute(Connection connection, String string, SQLParam sQLParam) throws SQLException {
        return SQLWrapper.execute(connection, string, new SQLParam[]{sQLParam});
    }

    public static SQLParam execute(Connection connection, String string, SQLParam[] sQLParamArray) throws SQLException {
        SQLParam sQLParam;
        int n;
        if (sQLParamArray == null) {
            sQLParamArray = new SQLParam[]{};
        }
        s = (OraclePreparedStatement)connection.prepareStatement(string);
        StringBuffer stringBuffer = new StringBuffer(string);
        block18: for (int i = 0; i < sQLParamArray.length; ++i) {
            n = stringBuffer.toString().indexOf(63);
            sQLParam = sQLParamArray[i];
            if (sQLParam.getValue() == null) {
                s.setNull(i + 1, sQLParam.getType());
                stringBuffer.replace(n, n + 1, "null");
                continue;
            }
            switch (sQLParam.getType()) {
                case 12: {
                    s.setString(i + 1, (String)sQLParam.getValue());
                    stringBuffer.replace(n, n + 1, "'" + (String)sQLParam.getValue() + "'");
                    continue block18;
                }
                case 4: {
                    s.setInt(i + 1, ((Integer)sQLParam.getValue()).intValue());
                    stringBuffer.replace(n, n + 1, ((Integer)sQLParam.getValue()).toString());
                    continue block18;
                }
                case -5: {
                    s.setLong(i + 1, ((Long)sQLParam.getValue()).longValue());
                    stringBuffer.replace(n, n + 1, ((Long)sQLParam.getValue()).toString());
                    continue block18;
                }
                case 5: {
                    s.setShort(i + 1, ((Short)sQLParam.getValue()).shortValue());
                    stringBuffer.replace(n, n + 1, ((Short)sQLParam.getValue()).toString());
                    continue block18;
                }
                case 8: {
                    s.setDouble(i + 1, ((Double)sQLParam.getValue()).doubleValue());
                    stringBuffer.replace(n, n + 1, ((Double)sQLParam.getValue()).toString());
                    continue block18;
                }
                case 6: {
                    s.setFloat(i + 1, ((Float)sQLParam.getValue()).floatValue());
                    stringBuffer.replace(n, n + 1, ((Float)sQLParam.getValue()).toString());
                    continue block18;
                }
                case 2: {
                    s.setBigDecimal(i + 1, (BigDecimal)sQLParam.getValue());
                    stringBuffer.replace(n, n + 1, ((Float)sQLParam.getValue()).toString());
                    continue block18;
                }
                case 93: {
                    s.setTimestamp(i + 1, (Timestamp)sQLParam.getValue());
                    stringBuffer.replace(n, n + 1, ((Timestamp)sQLParam.getValue()).toString());
                    continue block18;
                }
                case 92: {
                    s.setTime(i + 1, (Time)sQLParam.getValue());
                    stringBuffer.replace(n, n + 1, ((Time)sQLParam.getValue()).toString());
                    continue block18;
                }
                case 91: {
                    s.setDate(i + 1, (Date)sQLParam.getValue());
                    stringBuffer.replace(n, n + 1, ((Date)sQLParam.getValue()).toString());
                    continue block18;
                }
                case 2005: {
                    s.setClob(i + 1, (Clob)((CLOB)sQLParam.getValue()));
                    continue block18;
                }
                default: {
                    throw new SQLException("Unsupported SQL type " + sQLParam.getValue());
                }
            }
        }
        Logger.logDebug("SQLWrapper.execute", "Executing: " + string);
        Logger.logDebug("SQLWrapper.execute", "\n--- SQL Start\n" + stringBuffer.toString() + "\n--- SQL End");
        SQLParam sQLParam2 = null;
        n = 1;
        try {
            if (string.trim().toUpperCase().startsWith("SELECT")) {
                sQLParam = (OracleResultSet)s.executeQuery();
                sQLParam2 = new SQLParam(2006, sQLParam);
                sQLParam2.setStatement((OracleStatement)s);
                n = 0;
            } else if (string.trim().toUpperCase().startsWith("COMMIT")) {
                Logger.logDebug("SQLWrapper.execute", "Executing COMMIT Statement");
                connection.commit();
            } else if (string.trim().toUpperCase().startsWith("ROLLBACK")) {
                Logger.logDebug("SQLWrapper.execute", "Executing ROLLBACK Statements");
                connection.rollback();
            } else {
                Logger.logDebug("SQLWrapper.execute", "Executing non SELECT/COMMIT/ROLLBACK Statements");
                int n2 = s.executeUpdate();
                sQLParam2 = new SQLParam(n2);
            }
        }
        catch (SQLException sQLException) {
            Logger.logError("SQLWrapper.execute", "Error:", sQLException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (s != null && n != 0) {
                s.close();
            }
        }
        return sQLParam2;
    }

    public static void cancel() throws SQLException {
        try {
            if (s != null) {
                s.cancel();
                Logger.logWarning("SQLWrapper.cancel", "Cancel operation requested by user");
            }
        }
        catch (SQLException sQLException) {
            Logger.logError("SQLWrapper.cancel", "Error:", sQLException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (s != null) {
                s.close();
                Logger.logWarning("SQLWrapper.cancel", "Closing statement for Cancel requested by user");
            }
        }
    }

    private SQLWrapper() {
    }
}

