/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.log;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.olapdv.util.MiscUtils;

public class LogWriter {
    private Logger LOG = Logger.getLogger(LogWriter.class.getName());
    private FileWriter appWriter = null;
    private boolean m_firstWrite = true;
    private String logName;

    public LogWriter(String string) {
        this.logName = string;
    }

    public String getName() {
        return this.logName;
    }

    public void shutDown() {
        this.closeAppWriter();
    }

    public void write(String string) {
        FileWriter fileWriter = this.getAppWriter();
        try {
            if (this.m_firstWrite) {
                fileWriter.write("REM --------------------------------------------------------------------------\r\n");
                fileWriter.write("REM   Log Start For New Session For model " + this.logName + "\r\n");
                fileWriter.write("REM   " + new Date().toString() + "\r\n");
                fileWriter.write("REM --------------------------------------------------------------------------\r\n");
                this.m_firstWrite = false;
            }
            fileWriter.write(string + "\r\n");
            this.flush();
        }
        catch (IOException iOException) {
            this.LOG.log(Level.WARNING, "In method write, IOException occurred.", iOException);
        }
    }

    public void flush() {
        FileWriter fileWriter = this.getAppWriter();
        try {
            fileWriter.flush();
        }
        catch (IOException iOException) {
            this.LOG.log(Level.WARNING, "In method flush, IOException occurred.", iOException);
        }
    }

    public void clearLog() {
        try {
            if (this.appWriter != null) {
                this.appWriter.close();
            }
            String string = null;
            String string2 = MiscUtils.getHomeDirectory();
            string = string2 != null ? string2 + "/" + this.logName + ".log" : this.logName + ".log";
            this.appWriter = new FileWriter(string, false);
            FileWriter fileWriter = this.getAppWriter();
            fileWriter.write("REM --------------------------------------------------------------------------\r\n");
            fileWriter.write("REM   Log Start For New Session For model " + this.logName + "\r\n");
            fileWriter.write("REM   " + new Date().toString() + "\r\n");
            fileWriter.write("REM --------------------------------------------------------------------------\r\n");
            this.flush();
            this.m_firstWrite = false;
        }
        catch (IOException iOException) {
            this.LOG.log(Level.WARNING, "In method clearLog, IOException occurred.", iOException);
        }
    }

    private FileWriter getAppWriter() {
        if (this.appWriter == null) {
            try {
                String string = null;
                String string2 = MiscUtils.getHomeDirectory();
                string = string2 != null ? string2 + "/" + this.logName + ".log" : this.logName + ".log";
                this.appWriter = new FileWriter(string, true);
            }
            catch (IOException iOException) {
                this.LOG.log(Level.WARNING, "In method getAppWriter, IOException occurred.", iOException);
            }
        }
        return this.appWriter;
    }

    private void closeAppWriter() {
        if (this.appWriter != null) {
            try {
                FileWriter fileWriter = this.getAppWriter();
                fileWriter.write("\r\n");
                fileWriter.write("REM --------------------------------------------------------------------------\r\n");
                fileWriter.write("REM   Log End For Session For Model " + this.logName + "\r\n");
                fileWriter.write("REM   " + new Date().toString() + "\r\n");
                fileWriter.write("REM --------------------------------------------------------------------------\r\n");
                fileWriter.write("\r\n");
                this.appWriter.close();
            }
            catch (IOException iOException) {
                this.LOG.log(Level.WARNING, "In method closeAppWriter, IOException occurred.", iOException);
            }
        }
        this.appWriter = null;
    }
}

