/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionDisconnectListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DisconnectVetoException;
import oracle.jdeveloper.db.ConnectionException;
import oracle.olapdv.app.DataValidateDialog;
import oracle.olapdv.olap.model.ValidateTopDO;

public class DatabaseConnection {
    private static DatabaseConnection dbConnection;
    private Map<String, Connection> clonedConnections = new HashMap<String, Connection>();

    private DatabaseConnection() {
        this.addDisconnectListener();
    }

    public static DatabaseConnection getInstance() {
        if (dbConnection == null) {
            dbConnection = new DatabaseConnection();
        }
        return dbConnection;
    }

    private ConnectionDisconnectListener addDisconnectListener() {
        ConnectionDisconnectListener connectionDisconnectListener = new ConnectionDisconnectListener(){

            public void checkDisconnect(ConnectionDetails connectionDetails) throws DisconnectVetoException {
            }

            public void connectionDisconnected(ConnectionDetails connectionDetails) {
                ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
                DataValidateDialog dataValidateDialog = validateTopDO.getDataValidateDialog();
                if (dataValidateDialog != null) {
                    dataValidateDialog.closeDown(false);
                }
                validateTopDO.clear();
                String string = connectionDetails.getQualifiedConnectionName();
                Connection connection = (Connection)DatabaseConnection.this.clonedConnections.get(string);
                DatabaseConnection.this.clonedConnections.remove(string);
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
            }
        };
        Connections.getInstance().addConnectionDisconnectListener(connectionDisconnectListener);
        return connectionDisconnectListener;
    }

    public Connection getClonedConnection(Connection connection) throws ConnectionException {
        Connections connections = Connections.getInstance();
        String string = connections.getConnectionName(connection);
        Connection connection2 = this.clonedConnections.get(string);
        if (connection2 == null) {
            connection2 = connections.cloneConnection(connection);
            this.clonedConnections.put(string, connection2);
        }
        return connection2;
    }
}

