/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.olap.app.ui.MultiLineTextArea;
import oracle.olapdv.OLAPDVArb;
import oracle.olapdv.OLAPDVImagesArb;
import oracle.olapdv.app.ProgressStatusDialog;
import oracle.olapdv.app.ProgressStatusPanel;
import oracle.olapdv.app.SwingWorker;
import oracle.olapdv.app.ValidateDrillDialog;
import oracle.olapdv.app.ValidateDrillPanel;
import oracle.olapdv.app.ValidateInterruptObserver;
import oracle.olapdv.app.ValidateTable;
import oracle.olapdv.app.ValidateTableCellEditor;
import oracle.olapdv.app.ValidateViewer;
import oracle.olapdv.log.ViewLogDialog;
import oracle.olapdv.olap.model.DimensionDO;
import oracle.olapdv.olap.model.HierarchyDO;
import oracle.olapdv.olap.model.LevelDO;
import oracle.olapdv.olap.model.LevelMapDO;
import oracle.olapdv.olap.model.ValidateModelDO;
import oracle.olapdv.olap.model.ValidateTopDO;
import oracle.olapdv.query.DrillToDetailQuery;
import oracle.olapdv.query.QueryAliasColumnContext;
import oracle.olapdv.query.QueryManager;
import oracle.olapdv.query.ValidateQuerySQL;
import oracle.olapdv.util.MiscUtils;

public class ValidatePanel
extends JPanel
implements ListSelectionListener,
ValidateInterruptObserver {
    private Component parentComponent;
    private ValidateViewer validateViewer;
    private ValidatePanel validatePanel;
    private ValidateModelDO validateModelDO;
    private JTable table;
    private DefaultTableModel tableModel;
    private JLabel lastTimeValidatedLabel;
    private JTabbedPane validateTab = new JTabbedPane();
    private int lastRow;
    private int lastColumn;
    private int activeReport;
    private JButton detailsButton;
    private JButton validateButton;
    private JButton showSQLButton;
    private LevelDO levelDO;
    private LevelDO parentLevelDO;
    private ImageIcon errorIcon = null;
    private ImageIcon successIcon = null;
    private ImageIcon warningIcon = null;
    private ImageIcon noReportIcon = null;
    private ProgressStatusDialog progressStatusDialog;
    private static boolean interrupted = false;
    private static boolean isAlreadyDrilling = false;
    private List<ValidateDrillDialog> drillDialogList;
    private MultiLineTextArea message;
    private static final int STATUS_COL = 0;
    private static final int DIMENSION_NAME_COL = 1;
    private static final int HIERARCHY_NAME_COL = 2;
    private static final int LEVEL_NAME_COL = 3;
    private static final int LEVEL_DEPTH_COL = 4;
    public static final int REPORT_COUNT_COL = 5;
    public static final int MEMBER_COUNT_COL = 6;
    private static final int TOTAL_COLUMN_COUNT = 7;
    public static final int MEMBER_COUNT = 1;
    public static final int DISTINCT_DESCRIPTION_COUNT = 2;
    public static final int NONUNIQUE_MEMBERS_ACROSS_LEVEL_COUNT = 3;
    public static final int NULL_MEMBER_ROW_COUNT = 4;
    public static final int NULL_DESCRIPTION_COUNT = 5;
    public static final int MEMBER_WITH_MULTIPLE_DESCRIPTION_COUNT = 6;
    public static final int DESCRIPTION_WITH_MULTIPLE_MEMBER_COUNT = 7;
    public static final int MEMBER_WITH_MULTIPLE_PARENT_COUNT = 8;
    public static final int DESCRIPTION_WITH_MULTIPLE_PARENT_DESC_COUNT = 9;
    private static final Logger LOG = Logger.getLogger(ValidatePanel.class.getName());

    public ValidatePanel(Component component, ValidateViewer validateViewer, ValidateModelDO validateModelDO) {
        this.parentComponent = component;
        this.validateViewer = validateViewer;
        this.validatePanel = this;
        this.validateModelDO = validateModelDO;
        this.drillDialogList = new ArrayList<ValidateDrillDialog>();
        this.jbinit();
    }

    protected void removeValidateDrillDialogFromList(ValidateDrillDialog validateDrillDialog) {
        if (this.drillDialogList.size() > 0) {
            int n = -1;
            for (int i = 0; i < this.drillDialogList.size(); ++i) {
                ValidateDrillDialog validateDrillDialog2 = this.drillDialogList.get(i);
                if (validateDrillDialog2 == null || validateDrillDialog2 != validateDrillDialog) continue;
                n = i;
                break;
            }
            if (n >= 0) {
                this.drillDialogList.remove(n);
            }
        }
    }

    @Override
    public boolean getInterruptedStatus() {
        return interrupted;
    }

    @Override
    public void setInterrupted() {
        interrupted = true;
    }

    @Override
    public void clearInterrupted() {
        interrupted = false;
    }

    public void setModelDO(ValidateModelDO validateModelDO) {
        this.validateModelDO = validateModelDO;
    }

    public void refreshTableData() {
        Object[][] objectArray = this.getBaseModelData(this.validateModelDO);
        Object[] objectArray2 = this.getColumnNames();
        this.tableModel = new DefaultTableModel(objectArray, objectArray2);
        this.table.setModel(this.tableModel);
        this.lastRow = -1;
        this.lastColumn = -1;
        this.setColumnWidths();
        this.table.repaint();
    }

    public void setActiveReport(int n) {
        this.activeReport = n;
    }

    public void setReportTitle(String string) {
        boolean bl;
        this.validateTab.setTitleAt(0, string);
        if (this.activeReport == 3 && (bl = this.validateModelDO.getDisableReport())) {
            this.validateTab.setTitleAt(0, OLAPDVArb.format("DISABLED_MSG", string));
        }
    }

    public void disableDrillToDetailButton() {
        this.detailsButton.setEnabled(false);
        this.showSQLButton.setEnabled(false);
    }

    public void resetLevelDO() {
        this.levelDO = null;
    }

    public void setFirstRowFocused() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    LOG.log(Level.WARNING, "In method SetFirstRowFocused, InterruptedException occurred");
                }
                if (ValidatePanel.this.table.getRowCount() > 0) {
                    ValidatePanel.this.table.setRowSelectionInterval(0, 0);
                    ValidatePanel.this.lastRow = 0;
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setCurrentRowFocused() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    LOG.log(Level.WARNING, "In method SetCurrentRowFocused, InterruptedException occurred");
                }
                if (ValidatePanel.this.lastRow >= 0) {
                    ValidatePanel.this.table.setRowSelectionInterval(ValidatePanel.this.lastRow, ValidatePanel.this.lastRow);
                    ValidatePanel.this.table.requestFocusInWindow();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setCachedReportRowHighlighted(final LevelDO levelDO) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ValidatePanel.this.setCachedReportRowHighlightedExecute(levelDO);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            this.setCachedReportRowHighlightedExecute(levelDO);
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.WARNING, "In method setCachedReportRowHighlighted, InterruptedException occurred");
            }
            catch (InvocationTargetException invocationTargetException) {
                LOG.log(Level.WARNING, "In method setCachedReportRowHighlighted, InvocationTargetException occurred");
            }
        }
    }

    private void setCachedReportRowHighlightedExecute(LevelDO levelDO) {
        String string = levelDO.getOwningDimensionName();
        String string2 = levelDO.getOwningHierarchyName();
        String string3 = levelDO.getName();
        int n = -1;
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            String string4 = (String)this.table.getValueAt(i, 1);
            String string5 = (String)this.table.getValueAt(i, 2);
            String string6 = (String)this.table.getValueAt(i, 3);
            if (!string.equalsIgnoreCase(string4) || !string2.equalsIgnoreCase(string5) || !string3.equalsIgnoreCase(string6)) continue;
            n = i;
            break;
        }
        if (n > -1) {
            this.table.setRowSelectionInterval(n, n);
        }
    }

    private void jbinit() {
        JPanel jPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        jPanel.setLayout(new GridBagLayout());
        this.errorIcon = new ImageIcon(OLAPDVImagesArb.getImage("ERROR_ICON"));
        this.successIcon = new ImageIcon(OLAPDVImagesArb.getImage("SUCCESS_ICON"));
        this.warningIcon = new ImageIcon(OLAPDVImagesArb.getImage("WARNING_ICON"));
        this.noReportIcon = new ImageIcon(OLAPDVImagesArb.getImage("NOREPORT_ICON"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        this.message = new MultiLineTextArea(OLAPDVArb.getString("NO_AVAILABLE_DIMENSION_MSG"));
        jPanel.add((Component)this.message, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        this.lastTimeValidatedLabel = this.validateModelDO == null ? new JLabel(OLAPDVArb.format("LAST_TIME_VALIDATION_RUN", " ")) : new JLabel(OLAPDVArb.format("LAST_TIME_VALIDATION_RUN", this.validateModelDO.getLastTimeValidated()));
        jPanel.add((Component)this.lastTimeValidatedLabel, gridBagConstraints);
        this.showSQLButton = new JButton(OLAPDVArb.getString("SHOW_SQL_BUTTON"));
        this.showSQLButton.setMnemonic(83);
        this.validateButton = new JButton(OLAPDVArb.getString("RUN_VALIDATION_FOR_REPORT_BUTTON"));
        this.validateButton.setMnemonic(82);
        this.detailsButton = new JButton(OLAPDVArb.getString("DRILL_TO_DETAILS_BUTTON"));
        this.detailsButton.setMnemonic(68);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this.showSQLButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.detailsButton, gridBagConstraints);
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setLabel(new JLabel(OLAPDVArb.getString("COMPONENT_WITH_TITLE_BAR_ACTIONS_LABEL")));
        ControlBar controlBar = new ControlBar();
        controlBar.add((Component)this.showSQLButton);
        controlBar.add((Component)this.detailsButton);
        componentWithTitlebar.setControlBar(controlBar);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 1, 5);
        gridBagConstraints.anchor = 18;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(1, 5, 5, 5);
        Object[][] objectArray = null;
        if (this.validateModelDO != null) {
            objectArray = this.getBaseModelData(this.validateModelDO);
        }
        Object[] objectArray2 = this.getColumnNames();
        this.tableModel = new DefaultTableModel(objectArray, objectArray2);
        ValidateTableCellEditor validateTableCellEditor = new ValidateTableCellEditor(this.parentComponent, this);
        this.table = new ValidateTable(this.tableModel);
        this.table.setDefaultEditor(Object.class, validateTableCellEditor);
        validateTableCellEditor.setValidateTable((ValidateTable)((Object)this.table));
        this.setColumnWidths();
        this.table.setSelectionMode(0);
        this.table.setBackground(Color.WHITE);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.table);
        this.table.setFillsViewportHeight(true);
        ++gridBagConstraints.gridy;
        jScrollPane.setBackground(Color.WHITE);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        componentWithTitlebar.setComponent((JComponent)jScrollPane);
        jPanel.add((Component)componentWithTitlebar, gridBagConstraints);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(this);
        this.lastRow = -1;
        this.lastColumn = -1;
        this.activeReport = 0;
        this.showSQLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValidateQuerySQL validateQuerySQL = new ValidateQuerySQL();
                String string = null;
                switch (ValidatePanel.this.activeReport) {
                    case 1: {
                        string = validateQuerySQL.getSQLForCountMembers(ValidatePanel.this.levelDO);
                        break;
                    }
                    case 2: {
                        string = validateQuerySQL.getSQLForCountMembers(ValidatePanel.this.levelDO) + "\n" + validateQuerySQL.getSQLForCountDescriptions(ValidatePanel.this.levelDO);
                        break;
                    }
                    case 3: {
                        string = validateQuerySQL.getSQLForCountNonUniqueMembers(ValidatePanel.this.levelDO);
                        break;
                    }
                    case 4: {
                        string = validateQuerySQL.getSQLForCountNullMembers(ValidatePanel.this.levelDO);
                        break;
                    }
                    case 5: {
                        string = validateQuerySQL.getSQLForCountNullDescriptions(ValidatePanel.this.levelDO);
                        break;
                    }
                    case 6: {
                        string = validateQuerySQL.getSQLForCountMembersWithMultipleDescriptions(ValidatePanel.this.levelDO);
                        break;
                    }
                    case 7: {
                        string = validateQuerySQL.getSQLForCountDescriptionsAssignedToMultipleMembers(ValidatePanel.this.levelDO);
                        break;
                    }
                    case 8: {
                        string = validateQuerySQL.getSQLForCountMembersWithMultipleParents(ValidatePanel.this.levelDO);
                        break;
                    }
                    case 9: {
                        string = validateQuerySQL.getSQLForCountDescriptionsWithMultipleParentDescriptions(ValidatePanel.this.levelDO);
                    }
                }
                string = MiscUtils.stripCarriageReturnCharacters(string);
                ViewLogDialog viewLogDialog = null;
                viewLogDialog = ValidatePanel.this.parentComponent instanceof JFrame ? new ViewLogDialog((JFrame)ValidatePanel.this.parentComponent, "SQL", string) : new ViewLogDialog((JDialog)ValidatePanel.this.parentComponent, "SQL", string);
                Rectangle rectangle = MiscUtils.centerWindow(ValidatePanel.this.parentComponent, 500, 400);
                viewLogDialog.setModal(true);
                viewLogDialog.setBounds(rectangle);
                viewLogDialog.setVisible(true);
            }
        });
        this.detailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValidatePanel.this.drillToDetail();
            }
        });
        this.validateTab.add(OLAPDVArb.getString("NONE_SELECTED"), jPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        this.add((Component)this.validateTab, gridBagConstraints);
    }

    public void drillToDetail() {
        DimensionDO dimensionDO = this.levelDO.getDimensionDO();
        if (!dimensionDO.getValidState()) {
            JOptionPane.showMessageDialog(this.parentComponent, OLAPDVArb.format("DIMENSION_NOT_VALID_MSG", dimensionDO.getName()), OLAPDVArb.getString("DIMENSION_NOT_VALID_TITLE"), 0);
            return;
        }
        if (isAlreadyDrilling) {
            return;
        }
        if (this.drillDialogList.size() > 0) {
            for (ValidateDrillDialog validateDrillDialog : this.drillDialogList) {
                if (validateDrillDialog == null) continue;
                validateDrillDialog.dispose();
            }
            this.drillDialogList.clear();
        }
        isAlreadyDrilling = true;
        DrillToDetailQueryWrapper drillToDetailQueryWrapper = new DrillToDetailQueryWrapper();
        this.launchDrillToDetailDialog(drillToDetailQueryWrapper);
        isAlreadyDrilling = false;
    }

    private void launchDrillToDetailDialog(DrillToDetailQueryWrapper drillToDetailQueryWrapper) {
        String string = this.getDrillToDetailDialogTitle();
        ValidateDrillDialog validateDrillDialog = null;
        validateDrillDialog = this.parentComponent instanceof JFrame ? new ValidateDrillDialog(this, (JFrame)this.parentComponent, string) : new ValidateDrillDialog(this, (JDialog)this.parentComponent, string);
        this.drillDialogList.add(validateDrillDialog);
        ValidateDrillPanel validateDrillPanel = new ValidateDrillPanel(validateDrillDialog, this.validateViewer, this.validateModelDO, this.levelDO, this.activeReport);
        validateDrillDialog.setValidateDrillPanel(validateDrillPanel);
        Object object = this.initializeDrillToDetailDialog(validateDrillPanel, drillToDetailQueryWrapper);
        if (object instanceof String) {
            String string2 = (String)object;
            if (string2 != null && string2.equalsIgnoreCase(OLAPDVArb.getString("FINISHED"))) {
                Rectangle rectangle = MiscUtils.centerWindow(this.parentComponent, 850, 700);
                if (validateDrillPanel == null) {
                    LOG.log(Level.SEVERE, "In method launchDrillToDetailDialog, validateDrillPanel is null");
                }
                validateDrillDialog.setContentPane(validateDrillPanel);
                validateDrillDialog.pack();
                validateDrillDialog.setBounds(rectangle);
                validateDrillDialog.setModal(false);
                validateDrillPanel.setFindTextFieldFocus();
                validateDrillDialog.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(this, OLAPDVArb.getString("ERROR_INITIALING_DRILL_DIALOG_MSG") + " " + object, OLAPDVArb.getString("ERROR_INITIALING_DRILL_DIALOG_TITLE"), 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, OLAPDVArb.getString("ERROR_INITIALING_DRILL_DIALOG_MSG") + " " + object, OLAPDVArb.getString("ERROR_INITIALING_DRILL_DIALOG_TITLE"), 0);
        }
    }

    private Object initializeDrillToDetailDialog(ValidateDrillPanel validateDrillPanel, DrillToDetailQueryWrapper drillToDetailQueryWrapper) {
        this.progressStatusDialog = this.parentComponent instanceof JFrame ? new ProgressStatusDialog((JFrame)this.parentComponent, OLAPDVArb.getString("DRILL_TO_DETAIL_RUNNING_TITLE"), OLAPDVArb.getString("DRILL_TO_DETAIL_RUNNING_TITLE"), true) : new ProgressStatusDialog((JDialog)this.parentComponent, OLAPDVArb.getString("DRILL_TO_DETAIL_RUNNING_TITLE"), OLAPDVArb.getString("DRILL_TO_DETAIL_RUNNING_TITLE"), true);
        this.progressStatusDialog.setIsIndeterminateToTrue();
        this.progressStatusDialog.addObserver(this.validatePanel);
        this.clearInterrupted();
        this.progressStatusDialog.initializeDialogPanel();
        this.progressStatusDialog.setModal(true);
        Rectangle rectangle = MiscUtils.centerWindow(this.parentComponent, 550, 200);
        this.progressStatusDialog.setBounds(rectangle);
        final ValidateDrillPanel validateDrillPanel2 = validateDrillPanel;
        final DrillToDetailQueryWrapper drillToDetailQueryWrapper2 = drillToDetailQueryWrapper;
        SwingWorker swingWorker = new SwingWorker(){

            @Override
            public Object construct() {
                try {
                    DrillToDetailQuery drillToDetailQuery = drillToDetailQueryWrapper2.getDrillToDetailQuery();
                    validateDrillPanel2.initializePanel(drillToDetailQuery);
                    if (ValidatePanel.this.getInterruptedStatus()) {
                        return null;
                    }
                    return OLAPDVArb.getString("FINISHED");
                }
                catch (Exception exception) {
                    return exception;
                }
            }

            @Override
            public void finished() {
                ValidatePanel.this.progressStatusDialog.dispose();
            }
        };
        this.progressStatusDialog.setWorkerThread(swingWorker);
        swingWorker.start();
        try {
            this.progressStatusDialog.setVisible(true);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "In method initializeDrillToDetailDialog, exception occurred as " + exception);
        }
        if (swingWorker.getValue() == null) {
            return null;
        }
        if (swingWorker.getValue() instanceof SQLException) {
            LOG.log(Level.SEVERE, "In method initializeDrillToDetailDialog, SQL exception occurred with errorcode =  " + swingWorker.getValue());
            return swingWorker.getValue();
        }
        Object object = swingWorker.getValue();
        if (object instanceof String) {
            String string = (String)swingWorker.getValue();
            if (string.equalsIgnoreCase(OLAPDVArb.getString("FINISHED"))) {
                return OLAPDVArb.getString("FINISHED");
            }
            return null;
        }
        return null;
    }

    public String getDrillToDetailDialogTitle() {
        String string = null;
        String string2 = this.levelDO.getName();
        String string3 = this.levelDO.getOwningHierarchyName();
        String string4 = this.levelDO.getOwningDimensionName();
        if (this.activeReport == 1) {
            string = OLAPDVArb.format("DETAILS_FOR_MEMBERS_AT_LEVEL", string2, this.levelDO.getDepth(), string4, string3);
        } else if (this.activeReport == 2) {
            string = OLAPDVArb.format("DETAILS_FOR_MEMBERS_AND_DESCRIPTIONS_AT_LEVEL", string2, this.levelDO.getDepth(), string4, string3);
        } else if (this.activeReport == 3) {
            string = OLAPDVArb.format("DETAILS_FOR_DUPLICATE_MEMBERS_AT_LEVEL", string2, this.levelDO.getDepth(), string4, string3);
        } else if (this.activeReport == 4) {
            string = OLAPDVArb.format("DETAILS_FOR_NULL_MEMBER_ROWS_AT_LEVEL", string2, this.levelDO.getDepth(), string4, string3);
        } else if (this.activeReport == 5) {
            string = OLAPDVArb.format("DETAILS_FOR_MEMBERS_WITH_NULL_DESCRIPTIONS_AT_LEVEL", string2, this.levelDO.getDepth(), string4, string3);
        } else if (this.activeReport == 6) {
            string = OLAPDVArb.format("DETAILS_FOR_MEMBERS_WITH_MULTIPLE_DESCRIPTIONS_AT_LEVEL", string2, this.levelDO.getDepth(), string4, string3);
        } else if (this.activeReport == 7) {
            string = OLAPDVArb.format("DETAILS_FOR_DESCRIPTIONS_WITH_MULTIPLE_MEMBERS_AT_LEVEL", string2, this.levelDO.getDepth(), string4, string3);
        } else if (this.activeReport == 8) {
            string = OLAPDVArb.format("DETAILS_FOR_MEMBERS_WITH_MULTIPLE_PARENTS_AT_LEVEL", string2, this.levelDO.getDepth(), string4, string3);
        } else if (this.activeReport == 9) {
            string = OLAPDVArb.format("DETAILS_FOR_DESCRIPTIONS_WITH_MULTIPLE_PARENT_DESCRIPTIONS_AT_LEVEL", string2, this.levelDO.getDepth(), string4, string3);
        }
        return string;
    }

    public void showLastTimeRun(String string) {
        final String string2 = string;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ValidatePanel.this.lastTimeValidatedLabel.setText(OLAPDVArb.format("LAST_TIME_VALIDATION_RUN", string2));
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void updateValidateButtonState() {
        boolean bl = this.validateModelDO.getDisableReport();
        if (!bl) {
            this.validateButton.setEnabled(true);
        } else if (this.activeReport == 3) {
            this.validateButton.setEnabled(false);
        } else {
            this.validateButton.setEnabled(true);
        }
    }

    public void setCurrentLevelDO(LevelDO levelDO) {
        this.levelDO = levelDO;
        if (levelDO != null) {
            this.detailsButton.setEnabled(true);
            this.showSQLButton.setEnabled(true);
        } else {
            this.detailsButton.setEnabled(false);
            this.showSQLButton.setEnabled(false);
        }
    }

    public void setParentLevelDO(LevelDO levelDO) {
        this.parentLevelDO = levelDO;
    }

    public void updateCellValue(int n, int n2, String string) {
        this.tableModel.setValueAt(string, n, n2);
    }

    public void resetTableData() {
        Object[][] objectArray = this.getBaseModelData(this.validateModelDO);
        Object[] objectArray2 = this.getColumnNames();
        this.tableModel.setDataVector(objectArray, objectArray2);
        this.setColumnWidths();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.table.getSelectedRow();
        int n2 = this.table.getSelectedColumn();
        boolean bl = listSelectionEvent.getValueIsAdjusting();
        if (n == this.lastRow && n2 == this.lastColumn) {
            return;
        }
        if (n < 0) {
            return;
        }
        LevelDO levelDO = this.validateModelDO.getLevelDOFromDimHierLevel((String)this.table.getValueAt(n, 1), (String)this.table.getValueAt(n, 2), (String)this.table.getValueAt(n, 3));
        this.setCurrentLevelDO(levelDO);
        this.setParentLevelDO(levelDO.getParentLevelDO());
        this.lastRow = n;
        this.lastColumn = n2;
        if (this.activeReport == 8) {
            LevelDO levelDO2 = levelDO.getParentLevelDO();
            if (levelDO2 == null) {
                this.detailsButton.setEnabled(false);
                this.showSQLButton.setEnabled(false);
            } else if (levelDO2.getValidState() == LevelDO.ValidStates.VALID_WARNING) {
                this.detailsButton.setEnabled(false);
                this.showSQLButton.setEnabled(false);
            } else {
                this.detailsButton.setEnabled(true);
                this.showSQLButton.setEnabled(true);
            }
        } else if (this.activeReport == 9) {
            LevelDO levelDO3 = levelDO.getParentLevelDO();
            if (levelDO3 == null) {
                this.detailsButton.setEnabled(false);
                this.showSQLButton.setEnabled(false);
            } else if (levelDO3.getValidState() == LevelDO.ValidStates.VALID_WARNING) {
                this.detailsButton.setEnabled(false);
                this.showSQLButton.setEnabled(false);
            } else {
                this.detailsButton.setEnabled(true);
                this.showSQLButton.setEnabled(true);
            }
        } else if (this.activeReport == 4) {
            LevelDO levelDO4 = levelDO.getParentLevelDO();
            if (levelDO4 == null) {
                this.detailsButton.setEnabled(false);
            } else if (levelDO4.getValidState() == LevelDO.ValidStates.VALID_WARNING) {
                this.detailsButton.setEnabled(false);
                this.showSQLButton.setEnabled(true);
            } else {
                this.detailsButton.setEnabled(true);
            }
        } else {
            this.detailsButton.setEnabled(true);
            this.showSQLButton.setEnabled(true);
        }
        if (levelDO.getValidState() == LevelDO.ValidStates.VALID_WARNING) {
            this.detailsButton.setEnabled(false);
            this.showSQLButton.setEnabled(false);
        }
    }

    public boolean canDrillToDetail(int n) {
        boolean bl = true;
        LevelDO levelDO = this.validateModelDO.getLevelDOFromDimHierLevel((String)this.table.getValueAt(n, 1), (String)this.table.getValueAt(n, 2), (String)this.table.getValueAt(n, 3));
        if (this.levelDO == null) {
            bl = false;
        } else if (this.activeReport == 8) {
            LevelDO levelDO2 = levelDO.getParentLevelDO();
            if (levelDO2 == null) {
                bl = false;
            } else if (levelDO2.getValidState() == LevelDO.ValidStates.VALID_WARNING) {
                bl = false;
            }
        } else if (this.activeReport == 9) {
            LevelDO levelDO3 = levelDO.getParentLevelDO();
            if (levelDO3 == null) {
                bl = false;
            } else if (levelDO3.getValidState() == LevelDO.ValidStates.VALID_WARNING) {
                bl = false;
            }
        } else if (this.activeReport == 4) {
            LevelDO levelDO4 = levelDO.getParentLevelDO();
            if (levelDO4 == null) {
                bl = false;
            } else if (levelDO4.getValidState() == LevelDO.ValidStates.VALID_WARNING) {
                bl = false;
            }
        }
        return bl;
    }

    public Object[][] getBaseModelData(ValidateModelDO validateModelDO) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = validateModelDO.getValidModelRowCount();
        if (n4 == 0) {
            this.message.setVisible(true);
        } else {
            this.message.setVisible(false);
        }
        Object[][] objectArray = null;
        if (this.activeReport == 2) {
            if (n4 > 0) {
                objectArray = new Object[n4][7];
            }
        } else if (n4 > 0) {
            objectArray = new Object[n4][6];
        }
        int n5 = 0;
        ArrayList<DimensionDO> arrayList = validateModelDO.getDimensionDOs();
        for (DimensionDO dimensionDO : arrayList) {
            if (!dimensionDO.getValidState()) continue;
            ArrayList<HierarchyDO> arrayList2 = dimensionDO.getHierarchyDOs();
            for (HierarchyDO hierarchyDO : arrayList2) {
                ArrayList<LevelDO> arrayList3 = hierarchyDO.getLevelDOs();
                boolean bl = true;
                for (LevelDO levelDO : arrayList3) {
                    objectArray[n5][1] = dimensionDO.getName();
                    objectArray[n5][2] = hierarchyDO.getName();
                    objectArray[n5][3] = levelDO.getName();
                    objectArray[n5][4] = Integer.valueOf(levelDO.getDepth()).toString();
                    switch (this.activeReport) {
                        case 1: {
                            n2 = levelDO.getValidateReport("Distinct Members");
                            this.updateDataValuesWithReportCount(n5, n2, objectArray);
                            if (bl) {
                                bl = false;
                                n3 = n2;
                                if (n2 != -1 && n2 != 1) {
                                    objectArray[n5][0] = this.warningIcon;
                                    break;
                                }
                                if (n2 == -1) {
                                    objectArray[n5][0] = this.noReportIcon;
                                    break;
                                }
                                objectArray[n5][0] = this.successIcon;
                                break;
                            }
                            objectArray[n5][0] = n3 != -1 && n2 != -1 ? (n2 < n3 ? this.warningIcon : this.successIcon) : (n2 == -1 ? this.noReportIcon : this.successIcon);
                            n3 = n2;
                            break;
                        }
                        case 2: {
                            n2 = levelDO.getValidateReport("Distinct Members");
                            this.updateDataValuesWithReportCount(n5, n2, objectArray);
                            n = levelDO.getValidateReport("Distinct Members And Descriptions");
                            this.updateDataValuesWithMemberCount(n5, n, objectArray);
                            if (n == -1 || n2 == -1) {
                                objectArray[n5][0] = this.noReportIcon;
                                break;
                            }
                            if (n != n2) {
                                objectArray[n5][0] = this.warningIcon;
                                break;
                            }
                            objectArray[n5][0] = this.successIcon;
                            break;
                        }
                        case 3: {
                            n2 = levelDO.getValidateReport("Duplicate Members Across Levels");
                            this.updateDataValuesWithReportCount(n5, n2, objectArray);
                            if (n2 == -1) {
                                objectArray[n5][0] = this.noReportIcon;
                                break;
                            }
                            if (n2 > 0) {
                                objectArray[n5][0] = this.warningIcon;
                                break;
                            }
                            objectArray[n5][0] = this.successIcon;
                            break;
                        }
                        case 4: {
                            n2 = levelDO.getValidateReport("Rows With Null Members");
                            this.updateDataValuesWithReportCount(n5, n2, objectArray);
                            if (n2 == -1) {
                                objectArray[n5][0] = this.noReportIcon;
                                break;
                            }
                            if (n2 > 0) {
                                objectArray[n5][0] = this.warningIcon;
                                break;
                            }
                            objectArray[n5][0] = this.successIcon;
                            break;
                        }
                        case 5: {
                            n2 = levelDO.getValidateReport("Members With Null Descriptions");
                            this.updateDataValuesWithReportCount(n5, n2, objectArray);
                            if (n2 == -1) {
                                objectArray[n5][0] = this.noReportIcon;
                                break;
                            }
                            if (n2 > 0) {
                                objectArray[n5][0] = this.warningIcon;
                                break;
                            }
                            objectArray[n5][0] = this.successIcon;
                            break;
                        }
                        case 6: {
                            n2 = levelDO.getValidateReport("Members With Multiple Descriptions");
                            this.updateDataValuesWithReportCount(n5, n2, objectArray);
                            if (n2 == -1) {
                                objectArray[n5][0] = this.noReportIcon;
                                break;
                            }
                            if (n2 > 0) {
                                objectArray[n5][0] = this.warningIcon;
                                break;
                            }
                            objectArray[n5][0] = this.successIcon;
                            break;
                        }
                        case 7: {
                            n2 = levelDO.getValidateReport("Descriptions With Multiple Members");
                            this.updateDataValuesWithReportCount(n5, n2, objectArray);
                            if (n2 == -1) {
                                objectArray[n5][0] = this.noReportIcon;
                                break;
                            }
                            if (n2 > 0) {
                                objectArray[n5][0] = this.warningIcon;
                                break;
                            }
                            objectArray[n5][0] = this.successIcon;
                            break;
                        }
                        case 8: {
                            n2 = levelDO.getValidateReport("Members With Multiple Parents");
                            this.updateDataValuesWithReportCount(n5, n2, objectArray);
                            if (n2 == -1) {
                                objectArray[n5][0] = this.noReportIcon;
                                break;
                            }
                            if (n2 > 0) {
                                objectArray[n5][0] = this.errorIcon;
                                break;
                            }
                            objectArray[n5][0] = this.successIcon;
                            break;
                        }
                        case 9: {
                            n2 = levelDO.getValidateReport("Descriptions With Multiple Parent Descriptions");
                            this.updateDataValuesWithReportCount(n5, n2, objectArray);
                            objectArray[n5][0] = n2 == -1 ? this.noReportIcon : (n2 > 0 ? this.warningIcon : this.successIcon);
                        }
                    }
                    ++n5;
                }
            }
        }
        return objectArray;
    }

    private void updateDataValuesWithMemberCount(int n, int n2, Object[][] objectArray) {
        objectArray[n][6] = n2 != -1 ? Integer.valueOf(n2).toString() : "";
    }

    private void updateDataValuesWithReportCount(int n, int n2, Object[][] objectArray) {
        objectArray[n][5] = n2 != -1 ? Integer.valueOf(n2).toString() : "";
    }

    private String[] getColumnNames() {
        String[] stringArray = null;
        switch (this.activeReport) {
            case 1: {
                stringArray = new String[]{OLAPDVArb.getString("STATUS_HEADER"), OLAPDVArb.getString("DIMENSION_NAME_HEADER"), OLAPDVArb.getString("HIERARCHY_NAME_HEADER"), OLAPDVArb.getString("LEVEL_NAME_HEADER"), OLAPDVArb.getString("DEPTH_HEADER"), OLAPDVArb.getString("DISTINCT_MEMBERS_HEADER")};
                break;
            }
            case 2: {
                stringArray = new String[]{OLAPDVArb.getString("STATUS_HEADER"), OLAPDVArb.getString("DIMENSION_NAME_HEADER"), OLAPDVArb.getString("HIERARCHY_NAME_HEADER"), OLAPDVArb.getString("LEVEL_NAME_HEADER"), OLAPDVArb.getString("DEPTH_HEADER"), OLAPDVArb.getString("DISTINCT_MEMBERS_HEADER"), OLAPDVArb.getString("DISTINCT_DESCRIPTIONS_HEADER")};
                break;
            }
            case 3: {
                stringArray = new String[]{OLAPDVArb.getString("STATUS_HEADER"), OLAPDVArb.getString("DIMENSION_NAME_HEADER"), OLAPDVArb.getString("HIERARCHY_NAME_HEADER"), OLAPDVArb.getString("LEVEL_NAME_HEADER"), OLAPDVArb.getString("DEPTH_HEADER"), OLAPDVArb.getString("DUPLICATE_MEMBERS_ACROSS_LEVELS_HEADER")};
                break;
            }
            case 4: {
                stringArray = new String[]{OLAPDVArb.getString("STATUS_HEADER"), OLAPDVArb.getString("DIMENSION_NAME_HEADER"), OLAPDVArb.getString("HIERARCHY_NAME_HEADER"), OLAPDVArb.getString("LEVEL_NAME_HEADER"), OLAPDVArb.getString("DEPTH_HEADER"), OLAPDVArb.getString("ROWS_WITH_NULL_MEMBERS_HEADER")};
                break;
            }
            case 5: {
                stringArray = new String[]{OLAPDVArb.getString("STATUS_HEADER"), OLAPDVArb.getString("DIMENSION_NAME_HEADER"), OLAPDVArb.getString("HIERARCHY_NAME_HEADER"), OLAPDVArb.getString("LEVEL_NAME_HEADER"), OLAPDVArb.getString("DEPTH_HEADER"), OLAPDVArb.getString("MEMBERS_WITH_NULL_DESCRIPTIONS_HEADER")};
                break;
            }
            case 6: {
                stringArray = new String[]{OLAPDVArb.getString("STATUS_HEADER"), OLAPDVArb.getString("DIMENSION_NAME_HEADER"), OLAPDVArb.getString("HIERARCHY_NAME_HEADER"), OLAPDVArb.getString("LEVEL_NAME_HEADER"), OLAPDVArb.getString("DEPTH_HEADER"), OLAPDVArb.getString("MEMBERS_WITH_MULTIPLE_DESCRIPTIONS")};
                break;
            }
            case 7: {
                stringArray = new String[]{OLAPDVArb.getString("STATUS_HEADER"), OLAPDVArb.getString("DIMENSION_NAME_HEADER"), OLAPDVArb.getString("HIERARCHY_NAME_HEADER"), OLAPDVArb.getString("LEVEL_NAME_HEADER"), OLAPDVArb.getString("DEPTH_HEADER"), OLAPDVArb.getString("DESCRIPTIONS_WITH_MULTIPLE_MEMBERS_HEADER")};
                break;
            }
            case 8: {
                stringArray = new String[]{OLAPDVArb.getString("STATUS_HEADER"), OLAPDVArb.getString("DIMENSION_NAME_HEADER"), OLAPDVArb.getString("HIERARCHY_NAME_HEADER"), OLAPDVArb.getString("LEVEL_NAME_HEADER"), OLAPDVArb.getString("DEPTH_HEADER"), OLAPDVArb.getString("MEMBERS_WITH_MULTIPLE_PARENTS")};
                break;
            }
            case 9: {
                stringArray = new String[]{OLAPDVArb.getString("STATUS_HEADER"), OLAPDVArb.getString("DIMENSION_NAME_HEADER"), OLAPDVArb.getString("HIERARCHY_NAME_HEADER"), OLAPDVArb.getString("LEVEL_NAME_HEADER"), OLAPDVArb.getString("DEPTH_HEADER"), OLAPDVArb.getString("DESCRIPTIONS_WITH_MULTIPLE_PARENT_DESCRIPTIONS_HEADER")};
                break;
            }
            default: {
                stringArray = new String[]{OLAPDVArb.getString("STATUS_HEADER"), OLAPDVArb.getString("DIMENSION_NAME_HEADER"), OLAPDVArb.getString("HIERARCHY_NAME_HEADER"), OLAPDVArb.getString("LEVEL_NAME_HEADER"), OLAPDVArb.getString("DEPTH_HEADER"), OLAPDVArb.getString("DISTINCT_MEMBERS_HEADER")};
            }
        }
        return stringArray;
    }

    private void setColumnWidths() {
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(130);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(130);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(130);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(200);
        if (this.activeReport == 2) {
            this.table.getColumnModel().getColumn(5).setPreferredWidth(120);
            this.table.getColumnModel().getColumn(6).setPreferredWidth(80);
        }
    }

    private void clearReportColumn() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            this.table.setValueAt("", i, 5);
        }
    }

    public boolean runValidationOnAllReports(String string, boolean bl, int[] nArray) {
        this.progressStatusDialog = this.parentComponent instanceof JFrame ? new ProgressStatusDialog((JFrame)this.parentComponent, OLAPDVArb.getString("VALIDATION_REPORT_PROGRESS_TITLE"), OLAPDVArb.getString("VALIDATION_REPORT_PROGRESS_TITLE"), true) : new ProgressStatusDialog((JDialog)this.parentComponent, OLAPDVArb.getString("VALIDATION_REPORT_PROGRESS_TITLE"), OLAPDVArb.getString("VALIDATION_REPORT_PROGRESS_TITLE"), true);
        this.progressStatusDialog.addObserver(this);
        this.clearInterrupted();
        if (!bl) {
            this.progressStatusDialog.setIsIndeterminateToTrue();
        }
        this.progressStatusDialog.initializeDialogPanel();
        final ProgressStatusPanel progressStatusPanel = this.progressStatusDialog.getProgressStatusPanel();
        this.progressStatusDialog.setModal(true);
        Rectangle rectangle = MiscUtils.centerWindow(this.parentComponent, 550, 200);
        this.progressStatusDialog.setBounds(rectangle);
        final String string2 = string;
        final boolean bl2 = bl;
        final int[] nArray2 = nArray;
        SwingWorker swingWorker = new SwingWorker(){

            @Override
            public Object construct() {
                boolean bl = false;
                try {
                    if (nArray2 != null && !bl2 && ValidatePanel.this.reportsToRunIncludesCurrentReport(nArray2, 1)) {
                        bl = true;
                    }
                    if (bl2 || ValidatePanel.this.activeReport == 1 || ValidatePanel.this.activeReport == 2 || bl) {
                        if (bl2) {
                            progressStatusPanel.updateProgressBar(0);
                            progressStatusPanel.updateProgressLabel(OLAPDVArb.getString("RUNNING_DISTINCT_MEMBERS_REPORT"));
                        }
                        ValidatePanel.this.updateObjectModelFromValidateQueryResults(1, string2);
                        if (ValidatePanel.this.getInterruptedStatus()) {
                            return null;
                        }
                    }
                    bl = false;
                    if (nArray2 != null && !bl2 && ValidatePanel.this.reportsToRunIncludesCurrentReport(nArray2, 2)) {
                        bl = true;
                    }
                    if (bl2 || ValidatePanel.this.activeReport == 2 || bl) {
                        if (bl2) {
                            progressStatusPanel.updateProgressBar(12);
                            progressStatusPanel.updateProgressLabel(OLAPDVArb.getString("RUNNING_DISTINCT_DESCRIPTIONS_REPORT"));
                        }
                        ValidatePanel.this.updateObjectModelFromValidateQueryResults(2, string2);
                        if (ValidatePanel.this.getInterruptedStatus()) {
                            return null;
                        }
                    }
                    bl = false;
                    if (nArray2 != null && !bl2 && ValidatePanel.this.reportsToRunIncludesCurrentReport(nArray2, 3)) {
                        bl = true;
                    }
                    if (bl2 || ValidatePanel.this.activeReport == 3 || bl) {
                        if (bl2) {
                            progressStatusPanel.updateProgressBar(24);
                            progressStatusPanel.updateProgressLabel(OLAPDVArb.getString("RUNNING_DUPLICATE_MEMBERS_REPORT"));
                        }
                        ValidatePanel.this.updateObjectModelFromValidateQueryResults(3, string2);
                        if (ValidatePanel.this.getInterruptedStatus()) {
                            return null;
                        }
                    }
                    bl = false;
                    if (nArray2 != null && !bl2 && ValidatePanel.this.reportsToRunIncludesCurrentReport(nArray2, 4)) {
                        bl = true;
                    }
                    if (bl2 || ValidatePanel.this.activeReport == 4 || bl) {
                        if (bl2) {
                            progressStatusPanel.updateProgressBar(36);
                            progressStatusPanel.updateProgressLabel(OLAPDVArb.getString("RUNNING_ROWS_WITH_NULL_MEMBERS_REPORT"));
                        }
                        ValidatePanel.this.updateObjectModelFromValidateQueryResults(4, string2);
                        if (ValidatePanel.this.getInterruptedStatus()) {
                            return null;
                        }
                    }
                    bl = false;
                    if (nArray2 != null && !bl2 && ValidatePanel.this.reportsToRunIncludesCurrentReport(nArray2, 5)) {
                        bl = true;
                    }
                    if (bl2 || ValidatePanel.this.activeReport == 5 || bl) {
                        if (bl2) {
                            progressStatusPanel.updateProgressBar(48);
                            progressStatusPanel.updateProgressLabel(OLAPDVArb.getString("RUNNING_NULL_DESCRIPTIONS_REPORT"));
                        }
                        ValidatePanel.this.updateObjectModelFromValidateQueryResults(5, string2);
                        if (ValidatePanel.this.getInterruptedStatus()) {
                            return null;
                        }
                    }
                    bl = false;
                    if (nArray2 != null && !bl2 && ValidatePanel.this.reportsToRunIncludesCurrentReport(nArray2, 6)) {
                        bl = true;
                    }
                    if (bl2 || ValidatePanel.this.activeReport == 6 || bl) {
                        if (bl2) {
                            progressStatusPanel.updateProgressBar(60);
                            progressStatusPanel.updateProgressLabel(OLAPDVArb.getString("RUNNING_MEMBERS_WITH_MULTIPLE_DESCRIPTIONS_REPORT"));
                        }
                        ValidatePanel.this.updateObjectModelFromValidateQueryResults(6, string2);
                        if (ValidatePanel.this.getInterruptedStatus()) {
                            return null;
                        }
                    }
                    bl = false;
                    if (nArray2 != null && !bl2 && ValidatePanel.this.reportsToRunIncludesCurrentReport(nArray2, 7)) {
                        bl = true;
                    }
                    if (bl2 || ValidatePanel.this.activeReport == 7 || bl) {
                        if (bl2) {
                            progressStatusPanel.updateProgressBar(72);
                            progressStatusPanel.updateProgressLabel(OLAPDVArb.getString("RUNNING_DESCRIPTIONS_WITH_MULTIPLE_MEMBERS_REPORT"));
                        }
                        ValidatePanel.this.updateObjectModelFromValidateQueryResults(7, string2);
                        if (ValidatePanel.this.getInterruptedStatus()) {
                            return null;
                        }
                    }
                    bl = false;
                    if (nArray2 != null && !bl2 && ValidatePanel.this.reportsToRunIncludesCurrentReport(nArray2, 8)) {
                        bl = true;
                    }
                    if (bl2 || ValidatePanel.this.activeReport == 8 || bl) {
                        if (bl2) {
                            progressStatusPanel.updateProgressBar(84);
                            progressStatusPanel.updateProgressLabel(OLAPDVArb.getString("RUNNING_MEMBERS_WITH_MULTIPLE_PARENTS_REPORT"));
                        }
                        ValidatePanel.this.updateObjectModelFromValidateQueryResults(8, string2);
                        if (ValidatePanel.this.getInterruptedStatus()) {
                            return null;
                        }
                    }
                    bl = false;
                    if (nArray2 != null && !bl2 && ValidatePanel.this.reportsToRunIncludesCurrentReport(nArray2, 9)) {
                        bl = true;
                    }
                    if (bl2 || ValidatePanel.this.activeReport == 9 || bl) {
                        if (bl2) {
                            progressStatusPanel.updateProgressBar(96);
                            progressStatusPanel.updateProgressLabel(OLAPDVArb.getString("RUNNING_DESCRIPTIONS_WITH_MULTIPLE_PARENT_DESCRIPTIONS_REPORT"));
                        }
                        ValidatePanel.this.updateObjectModelFromValidateQueryResults(9, string2);
                        if (bl2) {
                            progressStatusPanel.updateProgressBar(100);
                        }
                    }
                    if (ValidatePanel.this.getInterruptedStatus()) {
                        return null;
                    }
                    ValidatePanel.this.validateModelDO.setValidateReportPending(true);
                    return "Finished";
                }
                catch (Exception exception) {
                    return exception;
                }
            }

            @Override
            public void finished() {
                ValidatePanel.this.progressStatusDialog.dispose();
            }
        };
        this.progressStatusDialog.setWorkerThread(swingWorker);
        swingWorker.start();
        this.progressStatusDialog.setVisible(true);
        if (swingWorker.getValue() == null) {
            return false;
        }
        Object object = swingWorker.getValue();
        if (object instanceof String) {
            String string3 = (String)object;
            if (!string3.equalsIgnoreCase("Finished")) {
                LOG.log(Level.SEVERE, "In method runValidationOnAllReports, unexpected result, worker returned object " + swingWorker.getValue());
                JOptionPane.showMessageDialog(this.parentComponent, OLAPDVArb.format("UNEXPECTED_RESULT_WORKER_RETURNED_OBJECT", swingWorker.getValue()), OLAPDVArb.format("WORKER_THREAD", new Object[0]), 0);
                return false;
            }
            this.refreshTableData();
            this.validateViewer.refreshMessages(this.validateModelDO);
            return true;
        }
        JOptionPane.showMessageDialog(this.parentComponent, OLAPDVArb.format("UNEXPECTED_RESULT_WORKER_RETURNED_OBJECT", swingWorker.getValue()), OLAPDVArb.format("WORKER_THREAD", new Object[0]), 0);
        LOG.log(Level.SEVERE, "In method runValidationOnAllReports, unexpected result, worker returned object " + swingWorker.getValue());
        return false;
    }

    private boolean reportsToRunIncludesCurrentReport(int[] nArray, int n) {
        boolean bl = false;
        for (int n2 : nArray) {
            if (n2 != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void updateObjectModelFromValidateQueryResults(int n, String string) {
        QueryManager queryManager = new QueryManager();
        boolean bl = false;
        boolean bl2 = false;
        ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
        int n2 = validateTopDO.getFilter();
        String string2 = queryManager.getCurrentServerDateTime();
        ArrayList<DimensionDO> arrayList = this.validateModelDO.getDimensionDOs();
        for (DimensionDO dimensionDO : arrayList) {
            if (!dimensionDO.getValidState()) continue;
            ArrayList<HierarchyDO> arrayList2 = dimensionDO.getHierarchyDOs();
            for (HierarchyDO hierarchyDO : arrayList2) {
                ArrayList<LevelDO> arrayList3 = hierarchyDO.getLevelDOs();
                for (LevelDO levelDO : arrayList3) {
                    if (this.getInterruptedStatus()) {
                        LOG.log(Level.WARNING, "In method updateObjectModelFromValidateQueryResults, user interruption or canceled occurred.");
                        queryManager.getCurrentServerDateTime();
                        return;
                    }
                    if (string != null && !dimensionDO.getName().equalsIgnoreCase(string)) continue;
                    try {
                        if (!bl) {
                            bl = true;
                            this.validateModelDO.setLastTimeValidated(queryManager.getCurrentServerDateTime());
                        }
                        switch (n) {
                            case 1: {
                                int n3 = levelDO.getValidState() == LevelDO.ValidStates.VALID_WARNING ? 1 : queryManager.countMembers(levelDO);
                                levelDO.setValidateReport("Distinct Members", n3);
                                this.validateModelDO.setReportLastTimeValidated("Distinct Members", string2);
                                if (this.activeReport != 1 || bl2) break;
                                this.showLastTimeRun(this.validateModelDO.getReportLastTimeValidated("Distinct Members"));
                                bl2 = true;
                                break;
                            }
                            case 2: {
                                int n3 = levelDO.getValidState() == LevelDO.ValidStates.VALID_WARNING ? 1 : queryManager.countDescriptions(levelDO);
                                levelDO.setValidateReport("Distinct Members And Descriptions", n3);
                                this.validateModelDO.setReportLastTimeValidated("Distinct Members And Descriptions", string2);
                                if (this.activeReport != 2 || bl2) break;
                                this.showLastTimeRun(this.validateModelDO.getReportLastTimeValidated("Distinct Members And Descriptions"));
                                bl2 = true;
                                break;
                            }
                            case 3: {
                                boolean bl3 = this.validateModelDO.getDisableReport();
                                if (bl3) {
                                    return;
                                }
                                int n3 = levelDO.getValidState() == LevelDO.ValidStates.VALID_WARNING ? 0 : queryManager.countNonUniqueMembersAcrossLevels(levelDO);
                                levelDO.setValidateReport("Duplicate Members Across Levels", n3);
                                this.validateModelDO.setReportLastTimeValidated("Duplicate Members Across Levels", string2);
                                if (this.activeReport != 3 || bl2) break;
                                this.showLastTimeRun(this.validateModelDO.getReportLastTimeValidated("Duplicate Members Across Levels"));
                                bl2 = true;
                                break;
                            }
                            case 4: {
                                int n3 = levelDO.getValidState() == LevelDO.ValidStates.VALID_WARNING ? 0 : queryManager.countNullMembers(levelDO);
                                levelDO.setValidateReport("Rows With Null Members", n3);
                                this.validateModelDO.setReportLastTimeValidated("Rows With Null Members", string2);
                                if (this.activeReport != 4 || bl2) break;
                                this.showLastTimeRun(this.validateModelDO.getReportLastTimeValidated("Rows With Null Members"));
                                bl2 = true;
                                break;
                            }
                            case 5: {
                                int n3 = levelDO.getValidState() == LevelDO.ValidStates.VALID_WARNING ? 0 : queryManager.countNullDescriptions(levelDO);
                                levelDO.setValidateReport("Members With Null Descriptions", n3);
                                this.validateModelDO.setReportLastTimeValidated("Members With Null Descriptions", string2);
                                if (this.activeReport != 5 || bl2) break;
                                this.showLastTimeRun(this.validateModelDO.getReportLastTimeValidated("Members With Null Descriptions"));
                                bl2 = true;
                                break;
                            }
                            case 6: {
                                int n3 = levelDO.getValidState() == LevelDO.ValidStates.VALID_WARNING ? 0 : queryManager.countMembersWithMultipleDescriptions(levelDO);
                                levelDO.setValidateReport("Members With Multiple Descriptions", n3);
                                this.validateModelDO.setReportLastTimeValidated("Members With Multiple Descriptions", string2);
                                if (this.activeReport != 6 || bl2) break;
                                this.showLastTimeRun(this.validateModelDO.getReportLastTimeValidated("Members With Multiple Descriptions"));
                                bl2 = true;
                                break;
                            }
                            case 7: {
                                int n3 = levelDO.getValidState() == LevelDO.ValidStates.VALID_WARNING ? 0 : queryManager.countDescriptionsAssignedToMultipleMembers(levelDO);
                                levelDO.setValidateReport("Descriptions With Multiple Members", n3);
                                this.validateModelDO.setReportLastTimeValidated("Descriptions With Multiple Members", string2);
                                if (this.activeReport != 7 || bl2) break;
                                this.showLastTimeRun(this.validateModelDO.getReportLastTimeValidated("Descriptions With Multiple Members"));
                                bl2 = true;
                                break;
                            }
                            case 8: {
                                int n3 = levelDO.getValidState() == LevelDO.ValidStates.VALID_WARNING ? 0 : queryManager.countMembersWithMultipleParents(levelDO);
                                levelDO.setValidateReport("Members With Multiple Parents", n3);
                                this.validateModelDO.setReportLastTimeValidated("Members With Multiple Parents", string2);
                                if (this.activeReport != 8 || bl2) break;
                                this.showLastTimeRun(this.validateModelDO.getReportLastTimeValidated("Members With Multiple Parents"));
                                bl2 = true;
                                break;
                            }
                            case 9: {
                                int n3 = levelDO.getValidState() == LevelDO.ValidStates.VALID_WARNING ? 0 : queryManager.countDescriptionsWithMultipleParentDescriptions(levelDO);
                                levelDO.setValidateReport("Descriptions With Multiple Parent Descriptions", n3);
                                this.validateModelDO.setReportLastTimeValidated("Descriptions With Multiple Parent Descriptions", string2);
                                if (this.activeReport != 9 || bl2) break;
                                this.showLastTimeRun(this.validateModelDO.getReportLastTimeValidated("Descriptions With Multiple Parent Descriptions"));
                                bl2 = true;
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        LOG.log(Level.SEVERE, "In method updateObjectModelFromValidateQueryResults, SQL Exception occurred, error code = " + sQLException.getErrorCode(), sQLException);
                        if (sQLException.getErrorCode() == 1013 || sQLException.getErrorCode() == 17009 || sQLException.getErrorCode() == 17011) continue;
                        JOptionPane.showMessageDialog(this.parentComponent, OLAPDVArb.format("SQL_QUERY_ERROR_ON_RUNNING_DATA_VALIDATION", sQLException), OLAPDVArb.getString("SQL_ERROR_TITLE"), 0);
                        int n4 = JOptionPane.showConfirmDialog(this.parentComponent, OLAPDVArb.getString("DO_YOU_WANT_TO_ABORT_THE_VALIDATION_RUN"), OLAPDVArb.getString("ABORT_TITLE"), 0);
                        if (n4 != 0) continue;
                        this.setInterrupted();
                    }
                }
            }
        }
    }

    public void updateObjectModelWithMemberCounts() {
        QueryManager queryManager = new QueryManager();
        ArrayList<DimensionDO> arrayList = this.validateModelDO.getDimensionDOs();
        for (DimensionDO dimensionDO : arrayList) {
            ArrayList<HierarchyDO> arrayList2 = dimensionDO.getHierarchyDOs();
            for (HierarchyDO hierarchyDO : arrayList2) {
                ArrayList<LevelDO> arrayList3 = hierarchyDO.getLevelDOs();
                for (LevelDO levelDO : arrayList3) {
                    try {
                        int n = queryManager.countMembers(levelDO);
                        levelDO.setValidateReport("Distinct Members", n);
                    }
                    catch (SQLException sQLException) {
                        LOG.log(Level.SEVERE, "In method updateObjectModelWithMemberCount, SQL Exception occurred, error code = " + sQLException.getErrorCode(), sQLException);
                    }
                }
            }
        }
    }

    private String[] getDrillAliasColumnNames() {
        String string;
        String string2;
        String string3;
        byte[] byArray;
        Object object;
        String[] stringArray = null;
        LevelMapDO levelMapDO = this.levelDO.getLevelMapDO();
        String string4 = levelMapDO.getColumnName();
        String string5 = levelMapDO.getLongDescriptionColumnName();
        String string6 = null;
        String string7 = null;
        LevelDO levelDO = this.levelDO.getParentLevelDO();
        if (levelDO != null) {
            object = levelDO.getLevelMapDO();
            string6 = ((LevelMapDO)object).getColumnName();
            string7 = ((LevelMapDO)object).getLongDescriptionColumnName();
        }
        if ((byArray = ((String)(object = OLAPDVArb.format("MEMBER_COLUMN_HEADER", string4))).getBytes()).length > 30) {
            object = byArray.length == ((String)object).length() ? ((String)object).substring(0, 30) : string4;
        }
        if ((byArray = (string3 = OLAPDVArb.format("MEMBER_DESCRIPTION_COLUMN_HEADER", string5)).getBytes()).length > 30) {
            string3 = byArray.length == string3.length() ? string3.substring(0, 30) : string5;
        }
        if ((byArray = (string2 = OLAPDVArb.format("PARENT_COLUMN_HEADER", string6)).getBytes()).length > 30) {
            string2 = byArray.length == string2.length() ? string2.substring(0, 30) : string6;
        }
        if ((byArray = (string = OLAPDVArb.format("PARENT_DESCRIPTION_COLUMN_HEADER", string7)).getBytes()).length > 30) {
            string = byArray.length == string.length() ? string.substring(0, 30) : string7;
        }
        String string8 = OLAPDVArb.get("OCCURRENCES_COLUMN_HEADER");
        String string9 = OLAPDVArb.get("PERCENT_OCCURRENCES_COLUMN_HEADER");
        if (this.activeReport == 1) {
            stringArray = new String[]{object, string3};
        } else if (this.activeReport == 2) {
            stringArray = new String[]{object, string3};
        } else if (this.activeReport == 3) {
            stringArray = new String[]{object, string3};
        } else if (this.activeReport == 4) {
            ArrayList<String> arrayList = this.levelDO.getAncestorKeyAndDescriptionColumns();
            stringArray = new String[arrayList.size() + 1];
            int n = 1;
            stringArray[0] = string4;
            Iterator<String> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string10;
                stringArray[n] = string10 = iterator.next();
                ++n;
            }
        } else if (this.activeReport == 5) {
            stringArray = new String[]{object, string3};
        } else if (this.activeReport == 6) {
            stringArray = new String[]{object, string3, string8, string9};
        } else if (this.activeReport == 7) {
            stringArray = new String[]{string3, object, string, string8, string9};
        } else if (this.activeReport == 8) {
            stringArray = new String[]{object, string2, string3, string, string8, string9};
        } else if (this.activeReport == 9) {
            stringArray = new String[]{string3, string, object, string2, string8, string9};
        }
        return stringArray;
    }

    private class DrillToDetailQueryWrapper {
        private DrillToDetailQuery drillToDetailQuery = null;

        protected DrillToDetailQueryWrapper() {
        }

        public DrillToDetailQuery getDrillToDetailQuery() {
            this.drillToDetailQuery = null;
            QueryAliasColumnContext queryAliasColumnContext = QueryAliasColumnContext.getInstance();
            queryAliasColumnContext.setColumnAliasValues(ValidatePanel.this.getDrillAliasColumnNames());
            this.drillToDetailQuery = new DrillToDetailQuery(ValidatePanel.this.validateViewer, ValidatePanel.this.validateModelDO, ValidatePanel.this.levelDO, ValidatePanel.this.activeReport);
            this.drillToDetailQuery.logDrillToDetailQuery();
            return this.drillToDetailQuery;
        }
    }
}

