/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.olapdv.OLAPDVImagesArb;
import oracle.olapdv.app.ModelValidation;
import oracle.olapdv.olap.model.LevelDO;
import oracle.olapdv.olap.model.LevelMapDO;

public class ModelTableCellRenderer
extends DefaultTableCellRenderer {
    private boolean modelReady = false;
    private int row;
    private int column;
    private ModelValidation modelValidation;
    private static ImageIcon successIcon = null;
    private static ImageIcon errorIcon = null;

    public void setModelReady(boolean bl) {
        this.modelReady = bl;
    }

    public void setModelValidation(ModelValidation modelValidation) {
        this.modelValidation = modelValidation;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        this.row = n;
        this.column = n2;
        if (n2 != 0 && n2 != 9 && object == null) {
            object = "(unmapped)";
        }
        if (n2 == 8 && object != null && object.equals("null")) {
            object = "(unmapped)";
        }
        if (n2 == 0) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (successIcon == null) {
                successIcon = new ImageIcon(OLAPDVImagesArb.getImage("SUCCESS_ICON"));
            }
            if (errorIcon == null) {
                errorIcon = new ImageIcon(OLAPDVImagesArb.getImage("ERROR_ICON"));
            }
            if (object instanceof ImageIcon) {
                this.setIcon((ImageIcon)object);
            } else if (object == null) {
                this.setIcon(successIcon);
            } else {
                this.setIcon(errorIcon);
            }
            this.setText("");
            return this;
        }
        if (n2 > 0 && n2 < 5) {
            this.setIcon(null);
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.modelReady && (((LevelDO)(object2 = this.modelValidation.getLevelDOFromModelTableAtRow(n))).getValidState() == LevelDO.ValidStates.VALID_ERROR || ((LevelDO)object2).getValidState() == LevelDO.ValidStates.VALID_WARNING)) {
            if (((LevelDO)object2).getValidState() == LevelDO.ValidStates.VALID_WARNING) {
                bl4 = true;
            } else {
                LevelMapDO levelMapDO = ((LevelDO)object2).getLevelMapDO();
                if (n2 == 5) {
                    bl3 = !levelMapDO.isOwnerNameValid();
                } else if (n2 == 6) {
                    bl3 = !levelMapDO.isTableNameValid();
                } else if (n2 == 7) {
                    bl3 = !levelMapDO.isKeyColumnValid();
                } else if (n2 == 8) {
                    bl3 = !levelMapDO.isDescColumnValid();
                } else if (n2 == 9) {
                    bl3 = !levelMapDO.isSnowflakeColumnValid();
                }
            }
        }
        object2 = new MyModelCellRendererComponent((String)object, bl3, bl4, n, n2);
        return object2;
    }

    protected static class MyModelCellRendererComponent
    extends JPanel {
        private boolean hasError;
        private boolean hasWarning;
        private JLabel textLabel;
        private String cellText;
        private int row;
        private int column;

        public MyModelCellRendererComponent(String string, boolean bl, boolean bl2, int n, int n2) {
            this.hasError = bl;
            this.hasWarning = bl2;
            this.cellText = string;
            this.row = n;
            this.column = n2;
            this.jbinit();
        }

        private void jbinit() {
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.WHITE);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(1, 1, 1, 1);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            this.textLabel = new JLabel(this.cellText);
            this.add((Component)this.textLabel, gridBagConstraints);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.column == 9 && this.cellText == null || this.cellText.length() == 0) {
                return;
            }
            if (this.hasError) {
                Point point = this.textLabel.getLocation();
                double d = point.getX();
                double d2 = point.getY();
                int n = (int)d;
                int n2 = (int)d2;
                Dimension dimension = this.textLabel.getSize();
                double d3 = dimension.getHeight();
                double d4 = dimension.getWidth();
                int n3 = (int)d3;
                int n4 = (int)d4;
                int n5 = n;
                int n6 = n2 + n3 + 1;
                int n7 = n + n4;
                int n8 = n6;
                graphics.setColor(Color.RED);
                for (int i = n5; i <= n7; i += 2) {
                    graphics.drawLine(i, n6, i + 1, n6 + 1);
                    graphics.drawLine(i + 1, n6 + 1, i + 2, n6);
                }
            }
        }
    }
}

