/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import oracle.olapdv.OLAPDVArb;
import oracle.olapdv.app.RestrictedTextField;

public class LoginPanel
extends JPanel {
    private JDialog m_loginDialog;
    private String[] m_loginDetails;
    private RestrictedTextField m_userNameField;
    private JPasswordField m_passwordField;
    private RestrictedTextField m_connectionStringField;
    private JButton okButton;
    private JButton cancelButton;

    public LoginPanel(JDialog jDialog, String[] stringArray) {
        this.m_loginDialog = jDialog;
        this.m_loginDetails = stringArray;
        this.jbinit();
    }

    private void jbinit() {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.WHITE);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel(OLAPDVArb.getString("PROVIDE_THE_LOGIN_INFORMATION")), gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JLabel(OLAPDVArb.getString("USERNAME")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.m_userNameField = new RestrictedTextField();
        this.m_userNameField.setMaximumLength(30);
        this.add((Component)this.m_userNameField, gridBagConstraints);
        this.m_userNameField.setText(this.m_loginDetails[0]);
        this.m_userNameField.requestFocusInWindow();
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JLabel(OLAPDVArb.getString("PASSWORD")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.m_passwordField = new JPasswordField();
        this.add((Component)this.m_passwordField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JLabel(OLAPDVArb.getString("CONNECTION_STRING")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.m_connectionStringField = new RestrictedTextField();
        this.m_connectionStringField.setMaximumLength(80);
        this.add((Component)this.m_connectionStringField, gridBagConstraints);
        this.m_connectionStringField.setText(this.m_loginDetails[2]);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 1;
        this.add((Component)new JLabel("host:port:sid"), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.WHITE);
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBackground(Color.WHITE);
        this.okButton = new JButton("  " + OLAPDVArb.getString("OK_BUTTON") + "  ");
        this.cancelButton = new JButton(OLAPDVArb.getString("CANCEL_BUTTON"));
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)new JLabel("     "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)new JLabel("     "), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel2.add((Component)new JLabel("     "), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this.okButton, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        jPanel2.add((Component)this.cancelButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel2, gridBagConstraints);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoginPanel.this.doOKProcessing();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoginPanel.this.doCancelProcessing();
            }
        });
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    LoginPanel.this.doOKProcessing();
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (!(keyEvent.getSource() != LoginPanel.this.m_userNameField && keyEvent.getSource() != LoginPanel.this.m_passwordField && keyEvent.getSource() != LoginPanel.this.m_connectionStringField || keyEvent.getKeyChar() != ' ' && keyEvent.getKeyChar() != '.')) {
                    Toolkit.getDefaultToolkit().beep();
                    keyEvent.consume();
                    return;
                }
                if (keyEvent.getKeyChar() == '\u001b') {
                    return;
                }
            }
        };
        this.m_userNameField.addKeyListener(keyAdapter);
        this.m_passwordField.addKeyListener(keyAdapter);
        this.m_connectionStringField.addKeyListener(keyAdapter);
        KeyAdapter keyAdapter2 = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getSource() == LoginPanel.this.cancelButton) {
                    if (keyEvent.getKeyChar() == '\n') {
                        LoginPanel.this.doCancelProcessing();
                    }
                } else if (keyEvent.getSource() == LoginPanel.this.okButton && keyEvent.getKeyChar() == '\n') {
                    LoginPanel.this.doOKProcessing();
                }
            }

            public void KeyTyped(KeyEvent keyEvent) {
            }
        };
        this.okButton.addKeyListener(keyAdapter2);
        this.cancelButton.addKeyListener(keyAdapter2);
    }

    private void doOKProcessing() {
        this.m_loginDetails[0] = this.m_userNameField.getText();
        char[] cArray = this.m_passwordField.getPassword();
        this.m_loginDetails[1] = new String(cArray);
        this.m_loginDetails[2] = this.m_connectionStringField.getText();
        this.m_loginDialog.dispose();
    }

    private void doCancelProcessing() {
        this.m_loginDetails[0] = null;
        this.m_loginDetails[1] = null;
        this.m_loginDetails[2] = null;
        this.m_loginDialog.dispose();
    }
}

