/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import oracle.kv.PasswordCredentials;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.BootstrapParams;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.login.AdminLoginManager;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.impl.util.FileNames;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.util.shell.Shell;

public class GenerateConfig {
    public static final String COMMAND_NAME = "generateconfig";
    public static final String COMMAND_DESC = "generates configuration files for the specified storage node";
    public static final String COMMAND_ARGS = CommandParser.getHostUsage() + " " + CommandParser.getPortUsage() + " -sn <StorageNodeId> " + "-target <zipfile>" + Shell.eolt + "[" + CommandParser.getUserUsage() + "] [" + CommandParser.getSecurityUsage() + "] [-secdir <overriden security directory>]";
    private StorageNodeId snid;
    private Parser parser;
    private CommandServiceAPI cs;
    private Topology t;
    private Parameters p;
    private String target;
    private String userName;
    private String securityFilePath;
    private String secDir;
    private boolean isSecured;
    private PasswordCredentials pwdCreds;

    private void generate() throws Exception {
        AdminParams ap;
        this.initLogin();
        String host = this.parser.getHostname();
        int port = this.parser.getRegistryPort();
        AdminLoginManager loginMgr = KVStoreLogin.getAdminLoginMgr(host, port, this.pwdCreds);
        this.cs = RegistryUtils.getAdmin(host, port, loginMgr);
        this.t = this.cs.getTopology();
        this.p = this.cs.getParameters();
        LoadParameters lp = new LoadParameters();
        GlobalParams gp = this.p.getGlobalParams();
        StorageNodeParams snp = this.p.get(this.snid);
        lp.addMap(gp.getMap());
        lp.addMap(snp.getMap());
        if (snp.getMountMap() != null) {
            lp.addMap(snp.getMountMap());
        }
        if ((ap = this.getAdminParams()) != null) {
            lp.addMap(ap.getMap());
        }
        List<RepNode> rns = this.t.getSortedRepNodes();
        for (RepNode rn : rns) {
            if (!rn.getStorageNodeId().equals(this.snid)) continue;
            RepNodeParams rnp = this.p.get((RepNodeId)rn.getResourceId());
            lp.addMap(rnp.getMap());
        }
        LoadParameters bootLp = this.generateBootConfig(gp, snp, ap);
        File rootDir = new File(snp.getRootDirPath());
        this.createFiles(rootDir.getName(), gp.getKVStoreName(), lp, bootLp);
        this.createZip(rootDir.getName());
        GenerateConfig.delete(new File(rootDir.getName()));
    }

    private AdminParams getAdminParams() {
        Collection<AdminParams> aps = this.p.getAdminParams();
        for (AdminParams ap : aps) {
            if (!ap.getStorageNodeId().equals(this.snid)) continue;
            return ap;
        }
        return null;
    }

    private LoadParameters generateBootConfig(GlobalParams gp, StorageNodeParams snp, AdminParams ap) throws Exception {
        LoadParameters lp = new LoadParameters();
        boolean hostingAdmin = false;
        int adminPort = 0;
        if (ap != null) {
            hostingAdmin = true;
            adminPort = ap.getHttpPort();
        }
        BootstrapParams bp = new BootstrapParams(snp.getRootDirPath(), snp.getHostname(), snp.getHAHostname(), snp.getHAPortRange(), gp.getKVStoreName(), snp.getRegistryPort(), adminPort, snp.getCapacity(), snp.getMountPoints(), this.isSecured);
        bp.setHostingAdmin(hostingAdmin);
        if (this.isSecured) {
            if (this.secDir == null || this.secDir.isEmpty()) {
                this.secDir = "security";
            }
            bp.setSecurityDir(this.secDir);
        }
        ParameterMap map = bp.getMap();
        map.setParameter("storageNodeId", Integer.toString(snp.getStorageNodeId().getStorageNodeId()));
        lp.addMap(map);
        lp.setVersion(2);
        return lp;
    }

    private void createFiles(String rootName, String storeName, LoadParameters lp, LoadParameters bootLp) throws Exception {
        String secPolicy = "grant {\n  permission java.security.AllPermission;\n};\n";
        String tmpName = rootName;
        File rootDir = new File(tmpName);
        rootDir.mkdir();
        bootLp.saveParameters(new File(rootDir, "config.xml"));
        File storeDir = new File(rootDir, storeName);
        storeDir.mkdir();
        File snDir = FileNames.getStorageNodeDir(storeDir, this.snid);
        snDir.mkdir();
        this.writeFile(new File(rootDir, "security.policy"), secPolicy);
        this.writeFile(new File(storeDir, "security.policy"), secPolicy);
        lp.saveParameters(FileNames.getSNAConfigFile(rootDir.getAbsolutePath(), storeName, this.snid));
    }

    private void writeFile(File file, String content) {
        PrintWriter writer = null;
        try {
            FileOutputStream fos = new FileOutputStream(file);
            writer = new PrintWriter(fos);
            writer.printf("%s", content);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem saving file: " + file + ": " + e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void createZip(String rootName) {
        try {
            String targetName = this.target;
            if (!targetName.contains(".zip")) {
                targetName = targetName + ".zip";
            }
            FileOutputStream fout = new FileOutputStream(new File(targetName));
            ZipOutputStream zout = new ZipOutputStream(fout);
            System.out.println("Creating zipfile " + targetName);
            File source = new File(rootName);
            this.addDirectory(zout, source);
            zout.close();
        }
        catch (IOException ioe) {
            System.out.println("IOException :" + ioe);
        }
    }

    private void addDirectory(ZipOutputStream zout, File source) {
        File[] files = source.listFiles();
        System.out.println("Adding directory " + source.getPath());
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.addDirectory(zout, new File(source.getPath() + File.separator + files[i].getName()));
                continue;
            }
            try {
                int length;
                String path = source.getPath() + File.separator + files[i].getName();
                System.out.println("Adding file " + path);
                byte[] buffer = new byte[1024];
                FileInputStream fin = new FileInputStream(path);
                zout.putNextEntry(new ZipEntry(path));
                while ((length = fin.read(buffer)) > 0) {
                    zout.write(buffer, 0, length);
                }
                zout.closeEntry();
                fin.close();
                continue;
            }
            catch (IOException ioe) {
                System.out.println("IOException :" + ioe);
            }
        }
    }

    static void delete(File f) throws IOException {
        if (f.isDirectory()) {
            for (File file : f.listFiles()) {
                GenerateConfig.delete(file);
            }
        }
        f.delete();
    }

    private void initLogin() throws IOException {
        KVStoreLogin storeLogin = new KVStoreLogin(this.userName, this.securityFilePath);
        storeLogin.loadSecurityProperties();
        storeLogin.prepareRegistryCSF();
        this.isSecured = storeLogin.foundSSLTransport();
        if (this.isSecured) {
            this.pwdCreds = storeLogin.makeShellLoginCredentials();
        }
    }

    public void parseArgs(String[] args) {
        this.parser = new Parser(args);
        this.parser.parseArgs();
        this.userName = this.parser.getUserName();
        this.securityFilePath = this.parser.getSecurityFile();
    }

    public static void main(String[] args) {
        GenerateConfig gen = new GenerateConfig();
        gen.parseArgs(args);
        try {
            gen.generate();
        }
        catch (Exception e) {
            System.err.println("Exception in GenerateConfig: " + e);
        }
    }

    class Parser
    extends CommandParser {
        public static final String snidFlag = "-sn";
        public static final String targetFlag = "-target";
        public static final String secDirFlag = "-secdir";

        public Parser(String[] args) {
            super(args);
        }

        @Override
        protected void verifyArgs() {
            if (this.getHostname() == null || this.getRegistryPort() == 0 || GenerateConfig.this.snid == null || GenerateConfig.this.target == null) {
                this.usage("Missing required argument");
            }
        }

        @Override
        public void usage(String errorMsg) {
            if (errorMsg != null) {
                System.err.println(errorMsg);
            }
            System.err.println("Usage: java -jar KVHOME/lib/kvstore.jar generateconfig\n\t" + COMMAND_ARGS);
            System.exit(-1);
        }

        @Override
        protected boolean checkArg(String arg) {
            if (arg.equals(snidFlag)) {
                String sn = this.nextArg(arg);
                try {
                    GenerateConfig.this.snid = StorageNodeId.parse(sn);
                }
                catch (IllegalArgumentException iae) {
                    this.usage("Invalid Storage Node Id: " + sn);
                }
                return true;
            }
            if (arg.equals(targetFlag)) {
                GenerateConfig.this.target = this.nextArg(arg);
                return true;
            }
            if (arg.equals(secDirFlag)) {
                GenerateConfig.this.secDir = this.nextArg(arg);
                return true;
            }
            return false;
        }
    }
}

