/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import oracle.kv.FaultException;
import oracle.kv.KVStoreException;
import oracle.kv.impl.fault.InternalFaultException;
import oracle.kv.impl.rep.admin.RepNodeAdmin;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.LoginHandle;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.HostPort;
import oracle.kv.impl.util.KVThreadFactory;
import oracle.kv.impl.util.registry.RegistryUtils;

public class TopologyLocator {
    public static final String HOST_PORT_SEPARATOR = ":";

    public static Topology get(String[] registryHostPorts, int maxRNs, LoginManager loginMgr, String expectedStoreName) throws KVStoreException {
        final AtomicInteger maxTopoSeqNum = new AtomicInteger(0);
        Topology initialTopology = TopologyLocator.getInitialTopology(registryHostPorts, maxTopoSeqNum, loginMgr, expectedStoreName);
        assert (maxTopoSeqNum.get() > 0);
        if (maxRNs <= 0) {
            return initialTopology;
        }
        int poolSize = Math.max(maxRNs, 10);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new KVThreadFactory(" topology locator", null));
        final AtomicInteger nRNs = new AtomicInteger(maxRNs);
        final AtomicReference currentAdmin = new AtomicReference();
        final RegistryUtils registryUtils = new RegistryUtils(initialTopology, loginMgr);
        for (RepGroup rg : initialTopology.getRepGroupMap().getAll()) {
            for (final RepNode rn : rg.getRepNodes()) {
                executor.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (nRNs.get() <= 0) {
                            return;
                        }
                        try {
                            RepNodeAdminAPI admin = registryUtils.getRepNodeAdmin((RepNodeId)rn.getResourceId());
                            int seqNum = admin.getTopoSeqNum();
                            AtomicInteger atomicInteger = maxTopoSeqNum;
                            synchronized (atomicInteger) {
                                if (seqNum > maxTopoSeqNum.get()) {
                                    maxTopoSeqNum.set(seqNum);
                                    currentAdmin.set(admin);
                                }
                            }
                            nRNs.decrementAndGet();
                        }
                        catch (SessionAccessException sae) {
                        }
                        catch (RemoteException re) {
                        }
                        catch (NotBoundException notBoundException) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        executor.shutdown();
        while (nRNs.get() > 0) {
            try {
                if (!executor.awaitTermination(100L, TimeUnit.MILLISECONDS)) continue;
                break;
            }
            catch (InterruptedException ie) {
            }
        }
        executor.shutdownNow();
        if (currentAdmin.get() != null) {
            try {
                return ((RepNodeAdminAPI)currentAdmin.get()).getTopology();
            }
            catch (RemoteException re) {
                // empty catch block
            }
        }
        return initialTopology;
    }

    private static Topology getInitialTopology(String[] registryHostPorts, final AtomicInteger maxTopoSeqNum, final LoginManager loginMgr, final String expectedStoreName) throws KVStoreException {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, registryHostPorts.length, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new KVThreadFactory(" topology locator", null));
        final AtomicReference<InterruptedException> cause = new AtomicReference<InterruptedException>();
        final AtomicReference currentAdmin = new AtomicReference();
        for (final String registryHostPort : registryHostPorts) {
            executor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HostPort hostPort = HostPort.parse(registryHostPort);
                    String registryHostname = hostPort.hostname();
                    int registryPort = hostPort.port();
                    try {
                        Registry snRegistry = RegistryUtils.getRegistry(registryHostname, registryPort, expectedStoreName);
                        for (String serviceName : snRegistry.list()) {
                            try {
                                Remote stub;
                                if (!RegistryUtils.isRepNodeAdmin(serviceName) || !((stub = snRegistry.lookup(serviceName)) instanceof RepNodeAdmin)) continue;
                                LoginHandle loginHdl = loginMgr == null ? null : loginMgr.getHandle(new HostPort(registryHostname, registryPort), ResourceId.ResourceType.REP_NODE);
                                RepNodeAdminAPI admin = RepNodeAdminAPI.wrap((RepNodeAdmin)stub, loginHdl);
                                int seqNum = admin.getTopoSeqNum();
                                AtomicInteger atomicInteger = maxTopoSeqNum;
                                synchronized (atomicInteger) {
                                    if (seqNum > maxTopoSeqNum.get()) {
                                        maxTopoSeqNum.set(seqNum);
                                        currentAdmin.set(admin);
                                    }
                                }
                            }
                            catch (SessionAccessException e) {
                                cause.set(e);
                            }
                            catch (RemoteException re) {
                                cause.set(re);
                            }
                            catch (NotBoundException e) {
                                cause.set(e);
                            }
                            catch (InternalFaultException e) {
                                cause.compareAndSet(null, e);
                            }
                            catch (Exception e) {
                                cause.compareAndSet(null, e);
                            }
                        }
                    }
                    catch (RemoteException e) {
                        cause.compareAndSet(null, e);
                    }
                }
            });
        }
        executor.shutdown();
        try {
            executor.awaitTermination(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException ie) {
            cause.compareAndSet(null, ie);
        }
        if (currentAdmin.get() == null) {
            if (cause.get() instanceof FaultException) {
                throw (FaultException)cause.get();
            }
            throw new KVStoreException("Could not contact any RepNode at: " + Arrays.toString(registryHostPorts), (Throwable)cause.get());
        }
        try {
            return ((RepNodeAdminAPI)currentAdmin.get()).getTopology();
        }
        catch (RemoteException e) {
            throw new KVStoreException("Could not establish an initial Topology from: " + Arrays.toString(registryHostPorts), (Throwable)cause.get());
        }
        catch (InternalFaultException e) {
            throw new FaultException(e, false);
        }
    }
}

