/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RateLimitingLogger<T> {
    private final Map<T, Long> logEvents;
    private final int logSamplePeriodMs;
    private long limitedMessageCount = 0L;
    private final Logger logger;

    public RateLimitingLogger(int logSamplePeriodMs, final int maxObjects, Logger logger) {
        this.logSamplePeriodMs = logSamplePeriodMs;
        this.logger = logger;
        this.logEvents = new LinkedHashMap<T, Long>(9){

            @Override
            protected boolean removeEldestEntry(Map.Entry<T, Long> eldest) {
                return this.size() > maxObjects;
            }
        };
    }

    synchronized long getLimitedMessageCount() {
        return this.limitedMessageCount;
    }

    int getMapSize() {
        return this.logEvents.size();
    }

    public synchronized void log(T object, Level level, String string) {
        if (object == null) {
            this.logger.log(level, string);
            return;
        }
        Long timeMs = this.logEvents.get(object);
        long now = System.currentTimeMillis();
        if (timeMs == null || now > timeMs + (long)this.logSamplePeriodMs) {
            ++this.limitedMessageCount;
            this.logEvents.put(object, now);
            this.logger.log(level, string);
        }
    }
}

