/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

public abstract class PollCondition {
    private final int checkPeriodMs;
    private final int timeoutMs;

    public PollCondition(int checkPeriodMs, int timeoutMs) {
        assert (checkPeriodMs <= timeoutMs);
        this.checkPeriodMs = checkPeriodMs;
        this.timeoutMs = timeoutMs;
    }

    protected abstract boolean condition();

    public boolean await() {
        if (this.condition()) {
            return true;
        }
        long timeLimit = System.currentTimeMillis() + (long)this.timeoutMs;
        do {
            try {
                Thread.sleep(this.checkPeriodMs);
            }
            catch (InterruptedException e) {
                return false;
            }
            if (!this.condition()) continue;
            return true;
        } while (System.currentTimeMillis() < timeLimit);
        return false;
    }
}

