/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.persist.model.Persistent;
import java.util.Collection;
import oracle.kv.impl.topo.ComponentMap;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeComponentMap;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.change.TopologyChange;

@Persistent
public class RepGroup
extends Topology.Component<RepGroupId> {
    private static final long serialVersionUID = 1L;
    private final ComponentMap<RepNodeId, RepNode> repNodeMap = new RepNodeComponentMap(this, null);

    public RepGroup() {
    }

    private RepGroup(RepGroup repGroup) {
        super(repGroup);
    }

    @Override
    public ResourceId.ResourceType getResourceType() {
        return ResourceId.ResourceType.REP_GROUP;
    }

    public Collection<RepNode> getRepNodes() {
        return this.repNodeMap.getAll();
    }

    @Override
    public Topology.Component<?> clone() {
        return new RepGroup(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.repNodeMap == null ? 0 : this.repNodeMap.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepGroup other = (RepGroup)obj;
        if (this.repNodeMap == null) {
            if (other.repNodeMap != null) {
                return false;
            }
        } else {
            if (!this.repNodeMap.equals(other.repNodeMap)) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
        }
        return true;
    }

    public RepNode get(RepNodeId repNodeId) {
        return this.repNodeMap.get(repNodeId);
    }

    public RepNode add(RepNode repNode) {
        return this.repNodeMap.add(repNode);
    }

    public RepNode update(RepNodeId resourceId, RepNode repNode) {
        return this.repNodeMap.update(resourceId, repNode);
    }

    public RepNode remove(RepNodeId repNodeId) {
        return this.repNodeMap.remove(repNodeId);
    }

    public void apply(TopologyChange change) {
        this.repNodeMap.apply(change);
    }

    @Override
    public void setTopology(Topology topology) {
        super.setTopology(topology);
        this.repNodeMap.setTopology(topology);
    }

    public String toString() {
        return "[" + this.getResourceId() + "]";
    }
}

