/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.util.PackedInteger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.kv.Key;
import oracle.kv.Value;
import oracle.kv.ValueVersion;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.ComplexValueImpl;
import oracle.kv.impl.api.table.DoubleValueImpl;
import oracle.kv.impl.api.table.EnumValueImpl;
import oracle.kv.impl.api.table.FieldComparator;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FloatValueImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.IntegerValueImpl;
import oracle.kv.impl.api.table.LongValueImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.ReturnRowImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.api.table.TableJsonUtils;
import oracle.kv.impl.api.table.TableKey;
import oracle.kv.impl.api.table.TableVersionException;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.security.Ownable;
import oracle.kv.impl.security.ResourceOwner;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.impl.util.SortableString;
import oracle.kv.table.EnumDef;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldRange;
import oracle.kv.table.FieldValue;
import oracle.kv.table.Index;
import oracle.kv.table.IndexKey;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;
import oracle.kv.table.ReturnRow;
import oracle.kv.table.Row;
import oracle.kv.table.Table;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class TableImpl
implements Table,
MetadataInfo,
Ownable,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private long id;
    private final TableImpl parent;
    private final TreeMap<String, Index> indexes;
    private final List<String> primaryKey;
    private final List<String> shardKey;
    private final String description;
    private final Map<String, Table> children;
    private final ArrayList<FieldMap> versions;
    private TableStatus status;
    private final boolean r2compat;
    private final int schemaId;
    private final ResourceOwner owner;
    private transient Schema schema;
    private transient int version;
    private transient int numKeyComponents;
    private transient String idString;
    public static final String KEY_TAG = "_key";
    public static final String ANONYMOUS = "[]";
    private static final String KEYOF = "keyof(";
    static final String ELEMENTOF = "elementof(";
    public static final String SEPARATOR = ".";
    private static final int MAX_ID_LENGTH = 32;
    private static final int MAX_NAME_LENGTH = 64;
    private static final String SEPARATOR_REGEX = "\\.";
    private static final int INITIAL_TABLE_VERSION = 1;
    static final String VALID_NAME_CHAR_REGEX = "^[A-Za-z][A-Za-z0-9_]*$";

    private TableImpl(String name, TableImpl parent, List<String> primaryKey, List<String> shardKey, FieldMap fields, boolean r2compat, int schemaId, String description, boolean validate, ResourceOwner owner) {
        this.name = name;
        this.parent = parent;
        this.description = description;
        this.primaryKey = primaryKey;
        this.shardKey = shardKey;
        this.status = TableStatus.READY;
        this.r2compat = r2compat;
        this.schemaId = schemaId;
        this.version = 1;
        this.children = new TreeMap<String, Table>(FieldComparator.instance);
        this.indexes = new TreeMap(FieldComparator.instance);
        this.versions = new ArrayList();
        this.versions.add(fields);
        if (validate) {
            this.validate();
            this.setSchema(true);
        }
        this.setIdString();
        this.owner = owner == null ? null : new ResourceOwner(owner);
    }

    private TableImpl(TableImpl t) {
        this.name = t.name;
        this.id = t.id;
        this.version = t.version;
        this.description = t.description;
        this.parent = t.parent;
        this.primaryKey = t.primaryKey;
        this.shardKey = t.shardKey;
        this.status = t.status;
        this.r2compat = t.r2compat;
        this.schemaId = t.schemaId;
        this.owner = t.owner;
        this.children = new TreeMap<String, Table>(FieldComparator.instance);
        for (Table table : t.children.values()) {
            this.children.put(table.getName(), ((TableImpl)table).clone());
        }
        this.versions = new ArrayList<FieldMap>(t.versions);
        this.indexes = new TreeMap<String, Index>((SortedMap<String, Index>)t.indexes);
        this.setSchema(true);
        this.setIdString();
    }

    static TableImpl createTable(String name, Table parent, List<String> primaryKey, List<String> shardKey, FieldMap fields, boolean r2compat, int schemaId, String description, boolean validate, ResourceOwner owner) {
        return new TableImpl(name, (TableImpl)parent, primaryKey, shardKey, fields, r2compat, schemaId, description, validate, owner);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setSchema(false);
        this.getTableVersion();
        this.setIdString();
    }

    @Override
    public TableImpl clone() {
        return new TableImpl(this);
    }

    @Override
    public Table getChildTable(String tableName) {
        return this.children.get(tableName);
    }

    @Override
    public boolean childTableExists(String tableName) {
        return this.children.containsKey(tableName);
    }

    @Override
    public Table getVersion(int version1) {
        if (this.versions.size() < version1 || version1 < 0) {
            throw new IllegalArgumentException("Table version " + version1 + " does not exist for table " + this.getFullName());
        }
        TableImpl newTable = this.clone();
        newTable.version = version1;
        newTable.setSchema(true);
        return newTable;
    }

    @Override
    public Map<String, Table> getChildTables() {
        return Collections.unmodifiableMap(this.children);
    }

    @Override
    public Table getParent() {
        return this.parent;
    }

    public String getAvroSchema(boolean pretty) {
        return this.generateAvroSchema(this.version, pretty);
    }

    @Override
    public int getTableVersion() {
        if (this.version == 0) {
            this.version = this.versions.size();
        }
        return this.version;
    }

    @Override
    public Index getIndex(String indexName) {
        return this.indexes.get(indexName);
    }

    @Override
    public Map<String, Index> getIndexes() {
        return Collections.unmodifiableMap(this.indexes);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        StringBuilder sb = new StringBuilder();
        this.getTableNameInternal(sb);
        return sb.toString();
    }

    public long getId() {
        return this.id;
    }

    public String getIdString() {
        return this.idString;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<String> getFields() {
        return Collections.unmodifiableList(this.getFieldOrder(this.version));
    }

    @Override
    public FieldDef getField(String fieldName) {
        FieldMapEntry fme = this.getFieldMapEntry(fieldName, false);
        if (fme != null) {
            return fme.getField();
        }
        return null;
    }

    @Override
    public boolean isNullable(String fieldName) {
        FieldMapEntry fme = this.getFieldMapEntry(fieldName, true);
        return fme.isNullable();
    }

    @Override
    public FieldValue getDefaultValue(String fieldName) {
        FieldMapEntry fme = this.getFieldMapEntry(fieldName, true);
        return fme.getDefaultValue();
    }

    @Override
    public List<String> getPrimaryKey() {
        return Collections.unmodifiableList(this.primaryKey);
    }

    @Override
    public List<String> getShardKey() {
        return Collections.unmodifiableList(this.shardKey);
    }

    List<String> getPrimaryKeyInternal() {
        return this.primaryKey;
    }

    List<String> getShardKeyInternal() {
        return this.shardKey;
    }

    @Override
    public RowImpl createRow() {
        return new RowImpl((RecordDef)new RecordDefImpl(this.getName(), this.getFieldMap()), this);
    }

    @Override
    public RowImpl createRow(RecordValue value) {
        RowImpl row = new RowImpl((RecordDef)new RecordDefImpl(this.getName(), this.getFieldMap()), this);
        TableImpl.populateRecord(row, value);
        return row;
    }

    @Override
    public RowImpl createRowWithDefaults() {
        RecordDefImpl def = new RecordDefImpl(this.getName(), this.getFieldMap());
        RowImpl row = new RowImpl((RecordDef)def, this);
        for (Map.Entry<String, FieldMapEntry> entry : this.getFieldMap().getFields().entrySet()) {
            row.put(entry.getKey(), entry.getValue().getDefaultValue());
        }
        return row;
    }

    @Override
    public PrimaryKeyImpl createPrimaryKey() {
        return new PrimaryKeyImpl((RecordDef)new RecordDefImpl(this.getName(), this.getFieldMap()), this);
    }

    @Override
    public PrimaryKeyImpl createPrimaryKey(RecordValue value) {
        PrimaryKeyImpl key = new PrimaryKeyImpl((RecordDef)new RecordDefImpl(this.getName(), this.getFieldMap()), this);
        TableImpl.populateRecord(key, value);
        return key;
    }

    @Override
    public ReturnRowImpl createReturnRow(ReturnRow.Choice returnChoice) {
        return new ReturnRowImpl((RecordDef)new RecordDefImpl(this.getName(), this.getFieldMap()), this, returnChoice);
    }

    @Override
    public Row createRowFromJson(String jsonInput, boolean exact) {
        return this.createRowFromJson(new ByteArrayInputStream(jsonInput.getBytes()), exact);
    }

    @Override
    public Row createRowFromJson(InputStream jsonInput, boolean exact) {
        RowImpl row = this.createRow();
        TableImpl.createFromJson(row, jsonInput, exact);
        return row;
    }

    @Override
    public PrimaryKeyImpl createPrimaryKeyFromJson(String jsonInput, boolean exact) {
        return this.createPrimaryKeyFromJson(new ByteArrayInputStream(jsonInput.getBytes()), exact);
    }

    @Override
    public PrimaryKeyImpl createPrimaryKeyFromJson(InputStream jsonInput, boolean exact) {
        PrimaryKeyImpl key = this.createPrimaryKey();
        TableImpl.createFromJson(key, jsonInput, exact);
        return key;
    }

    @Override
    public FieldRange createFieldRange(String fieldName) {
        FieldDef def = this.getField(fieldName);
        if (def == null) {
            throw new IllegalArgumentException("Field does not exist in table definition: " + fieldName);
        }
        if (!this.primaryKey.contains(fieldName)) {
            throw new IllegalArgumentException("Field does not exist in primary key: " + fieldName);
        }
        return new FieldRange(fieldName, def);
    }

    @Override
    public MultiRowOptions createMultiRowOptions(List<String> tableNames, FieldRange fieldRange) {
        if ((tableNames == null || tableNames.isEmpty()) && fieldRange == null) {
            throw new IllegalArgumentException("createMultiRowOptions must have at least one non-null parameter");
        }
        MultiRowOptions mro = null;
        if (fieldRange != null) {
            mro = new MultiRowOptions(fieldRange);
        }
        if (tableNames != null) {
            ArrayList<Table> ancestorTables = new ArrayList<Table>();
            ArrayList<Table> childTables = new ArrayList<Table>();
            TableImpl topLevelTable = this.getTopLevelTable();
            for (String tableName : tableNames) {
                TableImpl t = topLevelTable.findTable(tableName);
                if (t == this) {
                    throw new IllegalArgumentException("Target table must not appear in included tables list");
                }
                if (TableImpl.isAncestorOf(this, t)) {
                    ancestorTables.add(t);
                    continue;
                }
                assert (TableImpl.isAncestorOf(t, this));
                childTables.add(t);
            }
            if (mro == null) {
                mro = new MultiRowOptions(null, ancestorTables, childTables);
            } else {
                mro.setIncludedParentTables(ancestorTables);
                mro.setIncludedChildTables(childTables);
            }
        }
        return mro;
    }

    public boolean isAncestor(Table ancestor) {
        String fullName = ancestor.getFullName();
        for (Table parentTable = this.getParent(); parentTable != null; parentTable = parentTable.getParent()) {
            if (!fullName.equals(parentTable.getFullName())) continue;
            return true;
        }
        return false;
    }

    public TableImpl getTopLevelTable() {
        if (this.parent != null) {
            return this.parent.getTopLevelTable();
        }
        return this;
    }

    static void createFromJson(ComplexValueImpl complexValue, InputStream jsonInput, boolean exact) {
        JsonParser jp = null;
        try {
            jp = TableJsonUtils.createJsonParser(jsonInput);
            jp.nextToken();
            complexValue.addJsonFields(jp, complexValue instanceof IndexKey, null, exact);
            complexValue.validate();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to parse JSON input: " + ioe.getMessage(), ioe);
        }
        finally {
            if (jp != null) {
                try {
                    jp.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof Table) {
            TableImpl otherDef = (TableImpl)other;
            if (this.getName().equalsIgnoreCase(otherDef.getName()) && this.getId() == otherDef.getId()) {
                if (this.getParent() != null ? !this.getParent().equals(otherDef.getParent()) : otherDef.getParent() != null) {
                    return false;
                }
                return this.versionsEqual(otherDef) && this.getFieldMap().equals(otherDef.getFieldMap());
            }
        }
        return false;
    }

    public boolean fieldsEqual(Object other) {
        if (other != null && other instanceof Table) {
            TableImpl otherTable = (TableImpl)other;
            if (this.getName().equalsIgnoreCase(otherTable.getName())) {
                if (this.parent != null ? !this.parent.fieldsEqual(otherTable.parent) : otherTable.parent != null) {
                    return false;
                }
                return this.getFieldMap().equals(otherTable.getFieldMap()) && this.primaryKey.equals(otherTable.primaryKey) && this.shardKey.equals(otherTable.shardKey);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getFullName().hashCode() + this.versions.size() + this.getFieldMap().hashCode();
    }

    boolean nameEquals(TableImpl other) {
        return this.getFullName().equals(other.getFullName());
    }

    private boolean versionsEqual(TableImpl other) {
        int thisVersion = this.version == 0 ? this.versions.size() : this.version;
        int otherVersion = other.version == 0 ? other.versions.size() : other.version;
        return thisVersion == otherVersion;
    }

    @Override
    public int numTableVersions() {
        return this.versions.size();
    }

    public boolean hasChildren() {
        return this.children.size() != 0;
    }

    public boolean isR2compatible() {
        return this.r2compat;
    }

    public int getSchemaId() {
        return this.schemaId;
    }

    void setId(long id) {
        this.id = id;
        this.setIdString();
    }

    private void setIdString() {
        this.idString = this.id == 0L || this.r2compat ? this.name : TableImpl.createIdString(this.id);
    }

    public static String createIdString(long id) {
        int encodingLength = SortableString.encodingLength(id);
        return SortableString.toSortable(id, encodingLength);
    }

    public FieldMap getFieldMap() {
        return this.getFieldMap(this.version);
    }

    public int getNumKeyComponents() {
        if (this.numKeyComponents == 0) {
            this.calculateNumKeys();
        }
        return this.numKeyComponents;
    }

    private synchronized void calculateNumKeys() {
        if (this.numKeyComponents == 0) {
            int num = this.primaryKey.size() + 1;
            TableImpl t = this;
            while (t.parent != null) {
                ++num;
                t = t.parent;
            }
            this.numKeyComponents = num;
        }
    }

    public TableStatus getStatus() {
        return this.status;
    }

    public synchronized void setStatus(TableStatus newStatus) {
        if (this.status != newStatus && this.status.isDeleting()) {
            throw new IllegalStateException("Table is being deleted, cannot change status to " + (Object)((Object)newStatus));
        }
        this.status = newStatus;
    }

    Map<String, Table> getMutableChildTables() {
        return this.children;
    }

    FieldMapEntry getFieldMapEntry(String fieldName, boolean mustExist) {
        return this.getFieldMapEntry(fieldName, mustExist, false);
    }

    private FieldMapEntry getFieldMapEntry(String fieldName, boolean mustExist, boolean allowNesting) {
        FieldMapEntry fme;
        TableField tableField;
        FieldMap fieldMap = this.getFieldMap();
        String fieldToUse = fieldName;
        if (allowNesting && (tableField = new TableField(fieldMap, fieldName)).isComplex()) {
            if ((fieldMap = TableImpl.findContainingMap(fieldMap, tableField, mustExist)) == null) {
                if (!mustExist) {
                    return null;
                }
                throw new IllegalArgumentException("Field does not exist in table definition: " + fieldName);
            }
            fieldToUse = tableField.getLastComponent();
        }
        if ((fme = fieldMap.getFieldMapEntry(fieldToUse)) != null) {
            return fme;
        }
        if (mustExist) {
            throw new IllegalArgumentException("Field does not exist in table definition: " + fieldName);
        }
        return null;
    }

    static FieldMap findContainingMap(FieldMap map, TableField tableField, boolean mustExist) {
        if (!tableField.isComplex()) {
            return map;
        }
        String fieldName = tableField.getFieldName();
        String parent = fieldName.substring(0, fieldName.lastIndexOf(46));
        FieldDefImpl def = TableImpl.findTableField(new TableField(map, parent));
        if (def instanceof MapDefImpl || def instanceof ArrayDefImpl) {
            def = TableImpl.findTableField(tableField);
        }
        if (def == null || !(def instanceof RecordDefImpl)) {
            if (mustExist) {
                throw new IllegalArgumentException("Containing field is not a record: " + fieldName);
            }
            return null;
        }
        return ((RecordDefImpl)def).getFieldMap();
    }

    List<String> getMutablePrimaryKey() {
        return this.primaryKey;
    }

    public int getPrimaryKeySize() {
        return this.primaryKey.size();
    }

    Map<String, Index> getMutableIndexes() {
        return this.indexes;
    }

    public String getParentName() {
        if (this.parent != null) {
            return this.parent.getFullName();
        }
        return null;
    }

    public Key createKey(Row row, boolean allowPartial) {
        this.setTableVersion(row);
        return TableKey.createKey(this, row, allowPartial).getKey();
    }

    RowImpl createRowFromKeyBytes(byte[] keyBytes) {
        return this.createFromKeyBytes(keyBytes, false);
    }

    PrimaryKeyImpl createPrimaryKeyFromKeyBytes(byte[] keyBytes) {
        return (PrimaryKeyImpl)this.createFromKeyBytes(keyBytes, true);
    }

    private RowImpl createFromKeyBytes(byte[] keyBytes, boolean createPrimaryKey) {
        TableImpl targetTable;
        Key.BinaryKeyIterator keyIter = this.createBinaryKeyIterator(keyBytes);
        if (keyIter != null && (targetTable = this.findTargetTable(keyIter)) != null) {
            RowImpl row = createPrimaryKey ? targetTable.createPrimaryKey() : targetTable.createRow();
            keyIter.reset();
            if (this.initRowFromKeyBytes(row, keyIter, targetTable)) {
                return row;
            }
        }
        return null;
    }

    RowImpl createRowFromBytes(byte[] keyBytes, byte[] valueBytes, boolean keyOnly) {
        RowImpl fullKey = this.createRowFromKeyBytes(keyBytes);
        if (fullKey != null) {
            if (keyOnly || valueBytes.length == 0) {
                return fullKey;
            }
            Value.Format format = Value.Format.fromFirstByte(valueBytes[0]);
            if (format == Value.Format.TABLE || format == Value.Format.AVRO && this.r2compat) {
                int offset = 1;
                if (format == Value.Format.AVRO && this.r2compat) {
                    offset = PackedInteger.getReadSortedIntLength(valueBytes, 0);
                }
                if (this.initRowFromByteValue(fullKey, valueBytes, format, offset)) {
                    return fullKey;
                }
            }
        }
        return null;
    }

    private boolean initRowFromKeyBytes(RowImpl row, Key.BinaryKeyIterator keyIter, TableImpl targetTable) {
        Iterator<String> pkIter = targetTable.getPrimaryKey().iterator();
        return targetTable.fillInKeyForTable(row, keyIter, pkIter);
    }

    int getDataSize(Row row) {
        Value value = this.createValue(row);
        return value.getValue().length + 1;
    }

    int getKeySize(Row row) {
        return this.createKey(row, true).toByteArray().length;
    }

    Value createValue(Row row) {
        this.setSchema(false);
        if (this.schema == null) {
            return Value.EMPTY_VALUE;
        }
        boolean isAvro = this.schemaId != 0 && this.getTableVersion() == 1;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (!isAvro) {
            int writeVersion = this.getTableVersion();
            outputStream.write(writeVersion);
            this.setTableVersion(row);
        } else {
            int size = PackedInteger.getWriteSortedIntLength(this.schemaId);
            byte[] buf = new byte[size];
            PackedInteger.writeSortedInt(buf, 0, this.schemaId);
            outputStream.write(buf, 0, size);
            ((RowImpl)row).setTableVersion(1);
        }
        BinaryEncoder e = TableJsonUtils.getEncoderFactory().binaryEncoder(outputStream, null);
        GenericDatumWriter<GenericData.Record> w = new GenericDatumWriter<GenericData.Record>(this.schema);
        GenericData.Record r = new GenericData.Record(this.schema);
        for (Map.Entry<String, FieldMapEntry> entry : this.getFields(this.version).entrySet()) {
            FieldMapEntry fme = entry.getValue();
            String fieldName = entry.getKey();
            if (this.isKeyComponent(fieldName)) continue;
            FieldValueImpl fv = (FieldValueImpl)row.get(fieldName);
            if (fv == null) {
                fv = fme.getDefaultValue();
            }
            if (fv.isNull()) {
                if (!fme.isNullable()) {
                    throw new IllegalCommandException("The field can not be null: " + fieldName);
                }
                r.put(fieldName, null);
                continue;
            }
            r.put(fieldName, fv.toAvroValue(this.schema.getField(fieldName).schema()));
        }
        try {
            w.write(r, e);
            e.flush();
        }
        catch (IOException ioe) {
            throw new IllegalCommandException("Failed to serialize Avro: " + ioe);
        }
        return Value.internalCreateValue(outputStream.toByteArray(), isAvro ? Value.Format.AVRO : Value.Format.TABLE);
    }

    private boolean initRowFromByteValue(RowImpl row, byte[] data, Value.Format format, int offset) {
        GenericRecord result = null;
        if (data.length >= offset + 1) {
            Schema writerSchema = this.schema;
            byte tableVersion = format == Value.Format.AVRO ? (byte)1 : data[offset];
            row.setTableVersion(tableVersion);
            if (tableVersion != this.getTableVersion() && tableVersion > this.numTableVersions()) {
                throw new TableVersionException(tableVersion);
            }
            try {
                if (tableVersion != this.getTableVersion()) {
                    String schemaString = this.generateAvroSchema(tableVersion, false);
                    writerSchema = new Schema.Parser().parse(schemaString);
                }
                if (format != Value.Format.AVRO || offset == 0) {
                    ++offset;
                }
                GenericDatumReader<Object> reader = new GenericDatumReader<Object>(writerSchema, this.schema);
                BinaryDecoder decoder = TableJsonUtils.getDecoderFactory().binaryDecoder(data, offset, data.length - offset, null);
                result = reader.read(null, decoder);
            }
            catch (Exception e) {
                return false;
            }
        }
        for (Map.Entry<String, FieldMapEntry> entry : this.getFields(this.version).entrySet()) {
            Object o;
            FieldMapEntry fme = entry.getValue();
            String fieldName = entry.getKey();
            if (this.isKeyComponent(fieldName)) continue;
            Object object = o = result != null ? result.get(fieldName) : null;
            if (o != null) {
                Schema fieldSchema = this.schema.getField(fieldName).schema();
                row.put(fieldName, FieldValueImpl.fromAvroValue(fme.getField(), o, fieldSchema));
                continue;
            }
            if (fme.isNullable()) {
                row.putNull(fieldName);
                continue;
            }
            row.put(fieldName, fme.getDefaultValue());
        }
        return true;
    }

    RowImpl rowFromValueVersion(ValueVersion vv, RowImpl row) {
        assert (row != null);
        row.setVersion(vv.getVersion());
        byte[] data = vv.getValue().getValue();
        Value.Format format = vv.getValue().getFormat();
        if (!(format == Value.Format.TABLE || format == Value.Format.AVRO && this.r2compat || data.length <= 1)) {
            return null;
        }
        if (this.setSchema(false) == null) {
            return row;
        }
        if (this.initRowFromByteValue(row, data, format, 0)) {
            return row;
        }
        return null;
    }

    void evolve(FieldMap newFields) {
        if (this.version == 255) {
            throw new IllegalCommandException("Can't evolve the table any further; too many versions");
        }
        this.validateEvolution(newFields);
        if (this.version != 0 && this.version != this.versions.size()) {
            throw new IllegalCommandException("Table evolution must be performed on the latest version");
        }
        this.versions.add(newFields);
        if (this.version != 0) {
            ++this.version;
        }
        this.setSchema(true);
    }

    void validateFieldAddition(String fieldName, FieldMapEntry field) {
        if (this.findTableField(fieldName) != null) {
            throw new IllegalArgumentException("Cannot add field, " + fieldName + ", it already exists");
        }
        for (FieldMap map : this.versions) {
            FieldDefImpl def = TableImpl.findTableField(new TableField(map, fieldName));
            if (def == null || ((Object)def).equals(field.getField())) continue;
            throw new IllegalArgumentException("Cannot add field, " + fieldName + ". A version " + "of the table contains this name and the types do " + "not match, is: " + (Object)((Object)field.getField().getType()) + ", was: " + (Object)((Object)def.getType()));
        }
    }

    boolean hasValueFields() {
        return this.schema != null;
    }

    private void validateEvolution(FieldMap newFields) {
        for (String fieldName : this.primaryKey) {
            FieldDef newDef;
            FieldDef oldDef = this.getField(fieldName);
            if (oldDef.equals(newDef = newFields.get(fieldName))) continue;
            throw new IllegalCommandException("Evolution cannot modify the primary key");
        }
        for (Index index : this.indexes.values()) {
            for (String field : index.getFields()) {
                FieldDefImpl def = TableImpl.findTableField(newFields, field);
                if (def == null) {
                    throw new IllegalCommandException("Evolution cannot remove indexed fields");
                }
                FieldDefImpl origDef = this.findTableField(field);
                if (def.equals(origDef)) continue;
                throw new IllegalCommandException("Evolution cannot modify indexed fields");
            }
        }
    }

    public String toJsonString(boolean pretty) {
        ObjectWriter writer = JsonUtils.createWriter(pretty);
        ObjectNode o = JsonUtils.createObjectNode();
        o.put("type", "table");
        o.put("name", this.getName());
        o.put("owner", this.owner == null ? null : this.owner.toString());
        if (this.r2compat) {
            o.put("r2compat", this.r2compat);
        }
        o.put("comment", this.description);
        if (this.parent != null) {
            o.put("parent", this.parent.getName());
        }
        ArrayNode key = o.putArray("shardKey");
        for (String fieldName : this.shardKey) {
            key.add(fieldName);
        }
        key = o.putArray("primaryKey");
        for (String fieldName : this.primaryKey) {
            key.add(fieldName);
        }
        if (this.children.size() != 0) {
            ArrayNode childArray = o.putArray("children");
            for (Map.Entry<String, Table> entry : this.children.entrySet()) {
                childArray.add(entry.getKey());
            }
        }
        this.getFieldMap().putFields(o);
        if (this.indexes.size() != 0) {
            ArrayNode indexArray = o.putArray("indexes");
            for (Map.Entry<String, Object> entry : this.indexes.entrySet()) {
                IndexImpl impl = (IndexImpl)entry.getValue();
                impl.toJsonNode(indexArray.addObject());
            }
        }
        try {
            return writer.writeValueAsString(o);
        }
        catch (IOException ioe) {
            return ioe.toString();
        }
    }

    public String formatTable(boolean asJson, String[] fields) {
        if (asJson) {
            if (fields == null) {
                return this.toJsonString(true);
            }
            ObjectWriter writer = JsonUtils.createWriter(true);
            ObjectNode o = JsonUtils.createObjectNode();
            ArrayNode array = o.putArray("fields");
            for (String fieldName : fields) {
                ObjectNode fnode = array.addObject();
                FieldMapEntry entry = this.getFieldMapEntry(fieldName, false, true);
                if (entry == null) {
                    FieldDefImpl def;
                    TableField tableField = new TableField(this, fieldName);
                    if (tableField.isComplex() && (def = TableImpl.findTableField(tableField)) != null) {
                        fnode.put("name", TableImpl.translateToExternalField(fieldName));
                        def.toJson(fnode);
                        continue;
                    }
                    throw new IllegalArgumentException("No such field in table " + this.getFullName() + ": " + fieldName);
                }
                fnode.put("name", TableImpl.translateToExternalField(fieldName));
                entry.toJson(fnode);
            }
            try {
                return writer.writeValueAsString(o);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Failed to serialize table description: " + ioe.getMessage());
            }
        }
        return null;
    }

    public void addIndex(Index index) {
        this.checkForDuplicateIndex(index);
        this.indexes.put(index.getName(), index);
    }

    public Index removeIndex(String indexName) {
        return this.indexes.remove(indexName);
    }

    Key.BinaryKeyIterator createBinaryKeyIterator(byte[] key) {
        Key.BinaryKeyIterator keyIter = new Key.BinaryKeyIterator(key);
        if (this.parent != null) {
            for (int i = 0; i < this.parent.getNumKeyComponents(); ++i) {
                if (keyIter.atEndOfKey()) {
                    return null;
                }
                keyIter.skip();
            }
        }
        if (keyIter.atEndOfKey()) {
            return null;
        }
        String tableId = keyIter.next();
        if (this.getIdString().equals(tableId)) {
            return keyIter;
        }
        return null;
    }

    public TableImpl findTargetTable(byte[] key) {
        Key.BinaryKeyIterator iter = this.createBinaryKeyIterator(key);
        if (iter != null) {
            return this.findTargetTable(iter);
        }
        return null;
    }

    TableImpl findTargetTable(Key.BinaryKeyIterator keyIter) {
        int numPrimaryKeyComponentsToSkip = this.primaryKey.size();
        if (this.parent != null) {
            numPrimaryKeyComponentsToSkip -= this.parent.primaryKey.size();
        }
        for (int i = 0; i < numPrimaryKeyComponentsToSkip; ++i) {
            if (keyIter.atEndOfKey()) {
                return null;
            }
            keyIter.skip();
        }
        if (keyIter.atEndOfKey()) {
            return this;
        }
        String childId = keyIter.next();
        for (Table table : this.children.values()) {
            if (!((TableImpl)table).getIdString().equals(childId)) continue;
            return ((TableImpl)table).findTargetTable(keyIter);
        }
        return null;
    }

    boolean isKeyComponent(String fieldName) {
        for (String component : this.primaryKey) {
            if (!fieldName.equals(component)) continue;
            return true;
        }
        return false;
    }

    boolean isIndexKeyComponent(String fieldName) {
        for (Index index : this.indexes.values()) {
            if (!((IndexImpl)index).containsField(fieldName)) continue;
            return true;
        }
        return false;
    }

    private Map<String, FieldMapEntry> getFields(int version1) {
        return this.getFieldMap(version1).getFields();
    }

    private List<String> getFieldOrder(int version1) {
        return this.getFieldMap(version1).getFieldOrder();
    }

    private FieldMap getFieldMap(int version1) {
        if (this.versions.size() < version1 || version1 < 0) {
            throw new IllegalCommandException("Table version " + version1 + " does not exist for table " + this.name);
        }
        int versionToGet = version1 == 0 ? this.versions.size() : version1;
        return this.versions.get(versionToGet - 1);
    }

    private void throwMissingState(String state) {
        throw new IllegalCommandException("Table is missing state required for construction: " + state);
    }

    private void validate() {
        FieldMap fields;
        if (this.primaryKey.isEmpty()) {
            this.throwMissingState("primary key");
        }
        if (this.name == null) {
            this.throwMissingState("table name");
        }
        if ((fields = this.getFieldMap(0)) == null || fields.isEmpty()) {
            this.throwMissingState("no fields defined");
        }
        if (this.parent != null && this.primaryKey.size() <= this.parent.primaryKey.size()) {
            throw new IllegalCommandException("Child table needs a primary key component");
        }
        if (this.shardKey.size() > this.primaryKey.size()) {
            throw new IllegalCommandException("Shard key must be a subset of the primary key");
        }
        for (int i = 0; i < this.shardKey.size(); ++i) {
            String pkField = this.primaryKey.get(i);
            if (pkField != null && pkField.equals(this.shardKey.get(i))) continue;
            throw new IllegalCommandException("Shard key must be a subset of the primary key");
        }
        for (String pkField : this.primaryKey) {
            FieldDef field = this.getField(pkField);
            if (field == null) {
                throw new IllegalCommandException("Primary key field is not a valid field: " + pkField);
            }
            if (field.isValidKeyField()) continue;
            throw new IllegalCommandException("Field type cannot be part of a primary key: " + (Object)((Object)field.getType()) + ", field name: " + pkField);
        }
    }

    private Schema setSchema(boolean flush) {
        if (this.schema == null || flush) {
            String schemaString = this.generateAvroSchema(this.version, true);
            this.schema = schemaString == null ? null : new Schema.Parser().parse(schemaString);
        }
        return this.schema;
    }

    private void getTableNameInternal(StringBuilder sb) {
        if (this.parent != null) {
            this.parent.getTableNameInternal(sb);
            sb.append(SEPARATOR);
        }
        sb.append(this.name);
    }

    private boolean fillInKeyForTable(Row keyRecord, Key.BinaryKeyIterator keyIter, Iterator<String> pkIter) {
        if (this.parent != null && !this.parent.fillInKeyForTable(keyRecord, keyIter, pkIter)) {
            return false;
        }
        assert (!keyIter.atEndOfKey());
        this.setTableVersion(keyRecord);
        String keyComponent = keyIter.next();
        if (!keyComponent.equals(this.getIdString())) {
            return false;
        }
        String lastKeyField = this.primaryKey.get(this.primaryKey.size() - 1);
        while (pkIter.hasNext()) {
            assert (!keyIter.atEndOfKey());
            String field = pkIter.next();
            String val = keyIter.next();
            try {
                keyRecord.put(field, this.createFromKey(val, this.getField(field)));
            }
            catch (Exception e) {
                return false;
            }
            if (!field.equals(lastKeyField)) continue;
            break;
        }
        return true;
    }

    private FieldValue createFromKey(String value, FieldDef field) {
        switch (field.getType()) {
            case INTEGER: {
                return new IntegerValueImpl(value);
            }
            case LONG: {
                return new LongValueImpl(value);
            }
            case STRING: {
                return new StringValueImpl(value);
            }
            case DOUBLE: {
                return new DoubleValueImpl(value);
            }
            case FLOAT: {
                return new FloatValueImpl(value);
            }
            case ENUM: {
                return EnumValueImpl.createFromKey((EnumDef)field, value);
            }
        }
        throw new IllegalCommandException("Type is not allowed in a key: " + (Object)((Object)field.getType()));
    }

    private String generateAvroSchema(int versionToUse, boolean pretty) {
        boolean hasSchema = false;
        ObjectWriter writer = JsonUtils.createWriter(pretty);
        ObjectNode sch = JsonUtils.createObjectNode();
        sch.put("type", "record");
        sch.put("name", this.getName());
        ArrayNode array = sch.putArray("fields");
        Map<String, FieldMapEntry> mapToUse = this.getFields(versionToUse);
        for (String fname : this.getFieldOrder(versionToUse)) {
            FieldMapEntry fme = mapToUse.get(fname);
            if (this.isKeyComponent(fname)) continue;
            hasSchema = true;
            ObjectNode fnode = array.addObject();
            fnode.put("name", fname);
            fme.createAvroTypeAndDefault(fnode);
            if (fme.getField().getDescription() == null) continue;
            fnode.put("doc", fme.getField().getDescription());
        }
        if (!hasSchema) {
            return null;
        }
        try {
            return writer.writeValueAsString(sch);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("IO Error writing Avro schema string", ioe);
        }
    }

    public String toString() {
        return "Table[" + this.name + ", " + (this.parent == null ? "-" : this.parent.getFullName()) + ", " + this.indexes.size() + ", " + this.children.size() + ", " + (Object)((Object)this.status) + ", " + this.getTableVersion() + "]";
    }

    private TableImpl findTable(String fullName) {
        String[] path = TableImpl.parseFullName(fullName);
        if (!path[0].equals(this.name)) {
            throw new IllegalArgumentException("No such table: " + fullName);
        }
        Table target = this;
        for (int i = 1; i < path.length; ++i) {
            if ((target = target.getChildTable(path[i])) != null) continue;
            throw new IllegalArgumentException("No such table: " + fullName);
        }
        return target;
    }

    private static boolean isAncestorOf(TableImpl start, TableImpl target) {
        TableImpl currentParent = start.parent;
        while (currentParent != null) {
            if (currentParent.id == target.id) {
                return true;
            }
            currentParent = currentParent.parent;
        }
        return false;
    }

    public static void validateComponent(String component, boolean isId) {
        TableImpl.validateComponent(component, isId, false);
    }

    public static void validateComponent(String comp, boolean isId, boolean allowDot) {
        ArrayList<String> components;
        List<String> list = components = allowDot ? new TableField((FieldMap)null, comp).getComponents() : new ArrayList<String>();
        if (!allowDot) {
            components.add(comp);
        }
        for (String component : components) {
            if (!component.matches(VALID_NAME_CHAR_REGEX)) {
                throw new IllegalCommandException("Table, index and field names may contain only alphanumeric values plus the character \"_\": " + comp);
            }
            if (!Character.isLetter(component.charAt(0)) || component.charAt(0) == '_') {
                throw new IllegalCommandException("Table, index and field names must start with an alphabetic character");
            }
            if (isId && component.length() > 32) {
                throw new IllegalCommandException("Illegal name: " + comp + ". Table names must be less than or equal to " + 32 + " characters.");
            }
            if (isId || component.length() <= 64) continue;
            throw new IllegalCommandException("Illegal name: " + component + ". Field and index names must be less than or equal to " + 64 + " characters");
        }
    }

    static String[] parseFullName(String fullName) {
        return fullName.split(SEPARATOR_REGEX);
    }

    public static List<String> parseComplexFieldName(String fname) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (char ch : fname.toCharArray()) {
            if (ch == '.') {
                if (sb.length() == 0) {
                    throw new IllegalArgumentException("Malformed field name: " + fname);
                }
                list.add(sb.toString());
                sb.delete(0, sb.length());
                continue;
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list;
    }

    public static String createFieldName(Iterator<String> iter) {
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            String current = iter.next();
            sb.append(current);
            if (!iter.hasNext()) continue;
            sb.append(SEPARATOR);
        }
        return sb.toString();
    }

    @Override
    public Metadata.MetadataType getType() {
        return Metadata.MetadataType.TABLE;
    }

    @Override
    public int getSourceSeqNum() {
        return this.versions.size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    static void populateRecord(RecordValueImpl record, RecordValue value) {
        for (String s : record.getFields()) {
            FieldValue v = value.get(s);
            if (v == null) continue;
            record.put(s, v);
        }
        record.validate();
    }

    void checkForDuplicateIndex(Index index) {
        for (Map.Entry<String, Index> entry : this.indexes.entrySet()) {
            if (!index.getFields().equals(entry.getValue().getFields())) continue;
            throw new IllegalCommandException("Index is a duplicate of an existing index with another name.  Existing index name: " + entry.getKey() + ", new index name: " + index.getName());
        }
    }

    private void setTableVersion(Row row) {
        ((RowImpl)row).setTableVersion(this.getTableVersion());
    }

    public FieldDefImpl findTableField(String fieldName) {
        return TableImpl.findTableField(this.getFieldMap(), fieldName);
    }

    static FieldDefImpl findTableField(FieldMap fieldMap, String fieldName) {
        return TableImpl.findTableField(new TableField(fieldMap, fieldName));
    }

    static FieldDefImpl findTableField(TableField field) {
        ListIterator<String> fieldPath = field.iterator();
        assert (fieldPath.hasNext());
        FieldDefImpl def = (FieldDefImpl)field.getFieldMap().get(fieldPath.next());
        if (def == null || !field.isComplex()) {
            return def;
        }
        assert (fieldPath.hasNext());
        return def.findField(fieldPath);
    }

    public static String translateToExternalField(String field) {
        if (field.endsWith(KEY_TAG)) {
            StringBuilder sb = new StringBuilder();
            String nonKeyPart = field.substring(0, field.indexOf(KEY_TAG) - 1);
            sb.append(KEYOF).append(nonKeyPart).append(')');
            return sb.toString();
        }
        if (field.contains(ANONYMOUS)) {
            StringBuilder sb = new StringBuilder();
            int anonIndex = field.indexOf(ANONYMOUS);
            sb.append(ELEMENTOF).append(field.substring(0, anonIndex - 1)).append(')');
            if (field.length() > anonIndex + 1) {
                sb.append(field.substring(anonIndex + 2, field.length()));
            }
            return sb.toString();
        }
        return field;
    }

    public static String translateFromExternalField(String field) {
        String lower = field.toLowerCase();
        boolean hasKeyOf = lower.startsWith(KEYOF);
        boolean hasElementOf = lower.startsWith(ELEMENTOF);
        if (hasKeyOf || hasElementOf) {
            StringBuilder sb = new StringBuilder();
            int lp = field.indexOf(40);
            assert (lp >= 0);
            int rp = field.indexOf(41, lp);
            if (rp == -1) {
                return null;
            }
            sb.append(field.substring(lp + 1, rp));
            sb.append(SEPARATOR);
            sb.append(hasKeyOf ? KEY_TAG : ANONYMOUS);
            if (field.length() > rp + 1) {
                sb.append(field.substring(rp + 1, field.length()));
            }
            return sb.toString();
        }
        return field;
    }

    @Override
    public ResourceOwner getOwner() {
        return this.owner;
    }

    static class TableField {
        private final String fieldName;
        private final List<String> fieldComponents;
        private final boolean isComplex;
        private final FieldMap fieldMap;

        protected TableField(TableImpl table, String fieldName) {
            this(table.getFieldMap(), fieldName);
        }

        protected TableField(FieldMap fieldMap, String fieldName) {
            this.fieldMap = fieldMap;
            this.fieldName = fieldName.toLowerCase();
            this.fieldComponents = TableImpl.parseComplexFieldName(fieldName);
            this.isComplex = this.fieldComponents.size() > 1;
        }

        final FieldMap getFieldMap() {
            return this.fieldMap;
        }

        final boolean isComplex() {
            return this.isComplex;
        }

        final String getFieldName() {
            return this.fieldName;
        }

        final List<String> getComponents() {
            return this.fieldComponents;
        }

        ListIterator<String> iterator() {
            return this.fieldComponents.listIterator();
        }

        final String getLastComponent() {
            return this.fieldComponents.get(this.fieldComponents.size() - 1);
        }

        FieldDefImpl getFirstDef() {
            return (FieldDefImpl)this.fieldMap.get(this.fieldComponents.get(0));
        }

        public String toString() {
            return this.fieldName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TableField) {
                TableField other = (TableField)obj;
                return this.fieldName.equalsIgnoreCase(other.fieldName);
            }
            return false;
        }

        public int hashCode() {
            return this.fieldName.hashCode();
        }
    }

    public static enum TableStatus {
        DELETING{

            @Override
            public boolean isDeleting() {
                return true;
            }
        }
        ,
        READY{

            @Override
            public boolean isReady() {
                return true;
            }
        };


        public boolean isDeleting() {
            return false;
        }

        public boolean isReady() {
            return false;
        }
    }
}

