/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.ArrayList;
import oracle.kv.impl.api.StoreIteratorParams;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiTableOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.TableIterateOperation;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.topo.PartitionId;

public class TableKeysIterate
extends TableIterateOperation {
    public TableKeysIterate(StoreIteratorParams sip, TargetTables targetTables, boolean majorComplete, byte[] resumeKey) {
        super(InternalOperation.OpCode.TABLE_KEYS_ITERATE, sip, targetTables, majorComplete, resumeKey);
    }

    TableKeysIterate(ObjectInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.TABLE_KEYS_ITERATE, in, serialVersion);
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, final OperationHandler operationHandler) {
        this.verifyTableAccess(operationHandler);
        final ArrayList<byte[]> results = new ArrayList<byte[]>();
        boolean moreElements = this.iterateTable(operationHandler, txn, partitionId, this.getMajorComplete(), this.getDirection(), this.getBatchSize(), this.getResumeKey(), OperationHandler.CURSOR_READ_COMMITTED, LockMode.READ_UNCOMMITTED_ALL, new OperationHandler.ScanVisitor(){

            @Override
            public int visit(Cursor cursor, DatabaseEntry keyEntry, DatabaseEntry dataEntry) {
                int match = TableKeysIterate.this.keyInTargetTable(operationHandler, keyEntry, dataEntry, cursor);
                if (match > 0) {
                    assert (dataEntry.getPartial());
                    if (cursor.getCurrent(keyEntry, dataEntry, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                        match += TableKeysIterate.this.addAncestorKeys(cursor, results, keyEntry);
                        MultiTableOperation.addKeyResult(results, keyEntry.getData());
                    }
                }
                return match;
            }
        });
        boolean more = moreElements && results.size() == 0 ? false : moreElements;
        return new Result.KeysIterateResult(this.getOpCode(), results, more);
    }
}

