/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.DatabaseEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.kv.Depth;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.util.UserDataControl;

abstract class MultiKeyOperation
extends InternalOperation
implements InternalOperation.PrivilegedTableAccessor {
    private static final OperationHandler.KVAuthorizer UNIVERSAL_AUTHORIZER = new OperationHandler.KVAuthorizer(){

        @Override
        public boolean allowAccess(DatabaseEntry keyEntry) {
            return true;
        }

        @Override
        public boolean allowFullAccess() {
            return true;
        }
    };
    private final byte[] parentKey;
    private final KeyRange subRange;
    private final Depth depth;

    MultiKeyOperation(InternalOperation.OpCode opCode, byte[] parentKey, KeyRange subRange, Depth depth) {
        super(opCode);
        this.parentKey = parentKey;
        this.subRange = subRange;
        this.depth = depth;
    }

    MultiKeyOperation(InternalOperation.OpCode opCode, ObjectInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        short keyLen = in.readShort();
        if (keyLen < 0) {
            this.parentKey = null;
        } else {
            this.parentKey = new byte[keyLen];
            in.readFully(this.parentKey);
        }
        this.subRange = in.read() == 0 ? null : new KeyRange(in, serialVersion);
        this.depth = Depth.getDepth(in.readUnsignedByte());
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (this.parentKey == null) {
            out.writeShort(-1);
        } else {
            out.writeShort(this.parentKey.length);
            out.write(this.parentKey);
        }
        if (this.subRange == null) {
            out.write(0);
        } else {
            out.write(1);
            this.subRange.writeFastExternal(out, serialVersion);
        }
        out.writeByte(this.depth.ordinal());
    }

    OperationHandler.KVAuthorizer checkPermission(OperationHandler operationHandler) {
        if (ExecutionContext.getCurrent() == null) {
            return UNIVERSAL_AUTHORIZER;
        }
        HashSet<InternalOperation.Keyspace.KeyAccessChecker> checkers = new HashSet<InternalOperation.Keyspace.KeyAccessChecker>();
        if (!this.isInternalRequestor() && (this.parentKey == null || InternalOperation.Keyspace.mayBePrivateAccess(this.parentKey))) {
            checkers.add(InternalOperation.Keyspace.privateKeyAccessChecker);
        }
        if (!this.hasSchemaAccessPrivileges() && (this.parentKey == null || InternalOperation.Keyspace.mayBeSchemaAccess(this.parentKey))) {
            checkers.add(InternalOperation.Keyspace.schemaKeyAccessChecker);
        }
        if (!this.hasGeneralAccessPrivileges()) {
            checkers.add(new InternalOperation.TableAccessChecker(operationHandler, this));
        }
        if (checkers.isEmpty()) {
            return UNIVERSAL_AUTHORIZER;
        }
        return new KeyspaceAccessAuthorizer(checkers);
    }

    byte[] getParentKey() {
        return this.parentKey;
    }

    KeyRange getSubRange() {
        return this.subRange;
    }

    Depth getDepth() {
        return this.depth;
    }

    @Override
    public String toString() {
        return super.toString() + " parentKey: " + UserDataControl.displayKey(this.parentKey) + " subRange: " + UserDataControl.displayKeyRange(this.subRange) + " depth: " + (Object)((Object)this.depth);
    }

    boolean hasSchemaAccessPrivileges() {
        ExecutionContext currentContext = ExecutionContext.getCurrent();
        if (currentContext == null) {
            return true;
        }
        return currentContext.hasAllPrivileges(this.schemaAccessPrivileges());
    }

    boolean hasGeneralAccessPrivileges() {
        ExecutionContext currentContext = ExecutionContext.getCurrent();
        if (currentContext == null) {
            return true;
        }
        return currentContext.hasAllPrivileges(this.generalAccessPrivileges());
    }

    @Override
    public List<? extends KVStorePrivilege> getRequiredPrivileges() {
        if (this.parentKey != null) {
            InternalOperation.Keyspace.KeyspaceType keyspace = InternalOperation.Keyspace.identifyKeyspace(this.parentKey);
            switch (keyspace) {
                case PRIVATE: {
                    return SystemPrivilege.internalPrivList;
                }
                case SCHEMA: {
                    return this.schemaAccessPrivileges();
                }
                case GENERAL: {
                    if (InternalOperation.Keyspace.mayBePrivateAccess(this.parentKey) || InternalOperation.Keyspace.mayBeSchemaAccess(this.parentKey)) break;
                    return SystemPrivilege.usrviewPrivList;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        return SystemPrivilege.usrviewPrivList;
    }

    abstract List<? extends KVStorePrivilege> schemaAccessPrivileges();

    abstract List<? extends KVStorePrivilege> generalAccessPrivileges();

    private static class KeyspaceAccessAuthorizer
    implements OperationHandler.KVAuthorizer {
        private final Set<InternalOperation.Keyspace.KeyAccessChecker> keyCheckers;

        private KeyspaceAccessAuthorizer(Set<InternalOperation.Keyspace.KeyAccessChecker> keyCheckers) {
            this.keyCheckers = keyCheckers;
        }

        @Override
        public boolean allowAccess(DatabaseEntry keyEntry) {
            byte[] key = keyEntry.getData();
            for (InternalOperation.Keyspace.KeyAccessChecker checker : this.keyCheckers) {
                if (checker.allowAccess(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean allowFullAccess() {
            return false;
        }
    }
}

