/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiKeyOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.security.TablePrivilege;
import oracle.kv.impl.topo.PartitionId;

public class MultiGet
extends MultiKeyOperation {
    public MultiGet(byte[] parentKey, KeyRange subRange, Depth depth) {
        super(InternalOperation.OpCode.MULTI_GET, parentKey, subRange, depth);
    }

    MultiGet(ObjectInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.MULTI_GET, in, serialVersion);
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, OperationHandler operationHandler) {
        OperationHandler.KVAuthorizer kvAuth = this.checkPermission(operationHandler);
        ArrayList<ResultKeyValueVersion> results = new ArrayList<ResultKeyValueVersion>();
        boolean moreElements = operationHandler.iterate(txn, partitionId, this.getParentKey(), true, this.getSubRange(), this.getDepth(), Direction.FORWARD, 0, null, OperationHandler.CURSOR_DEFAULT, results, kvAuth);
        assert (!moreElements);
        return new Result.IterateResult(this.getOpCode(), results, moreElements);
    }

    @Override
    List<? extends KVStorePrivilege> schemaAccessPrivileges() {
        return SystemPrivilege.schemaReadPrivList;
    }

    @Override
    List<? extends KVStorePrivilege> generalAccessPrivileges() {
        return SystemPrivilege.readOnlyPrivList;
    }

    @Override
    public List<? extends KVStorePrivilege> tableAccessPrivileges(long tableId) {
        return Collections.singletonList(new TablePrivilege.ReadTable(tableId));
    }
}

