/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.util.KVThreadFactory;

class SharedThreadPool {
    private static final int KEEP_ALIVE_SEC = 10;
    private final ThreadPoolExecutor threadPool;

    SharedThreadPool(Logger logger) {
        this.threadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new KVThreadFactory(" shared thread", logger));
    }

    KVStoreImpl.TaskExecutor getTaskExecutor(int maxConcurrentTasks) {
        if (this.threadPool.isShutdown()) {
            throw new IllegalStateException("The shared thread pool has been shutdown");
        }
        return new TaskExecutorImpl(maxConcurrentTasks);
    }

    void shutdownNow() {
        this.threadPool.shutdownNow();
    }

    int getActiveCount() {
        return this.threadPool.getActiveCount();
    }

    int getPoolSize() {
        return this.threadPool.getPoolSize();
    }

    long getKeepAliveTime(TimeUnit timeUnit) {
        return this.threadPool.getKeepAliveTime(timeUnit);
    }

    private static class WrappedTask
    extends FutureTask<Object> {
        private final TaskExecutorImpl executor;

        WrappedTask(Runnable runnable, TaskExecutorImpl executor) {
            super(runnable, null);
            this.executor = executor;
        }

        @Override
        protected void done() {
            this.executor.completed(this);
        }
    }

    private class TaskExecutorImpl
    implements KVStoreImpl.TaskExecutor {
        private final int maxConcurrentTasks;
        private final Queue<WrappedTask> taskQueue;
        private final Set<WrappedTask> runningTasks;
        private volatile boolean closed = false;

        private TaskExecutorImpl(int maxConcurrentTasks) {
            this.maxConcurrentTasks = maxConcurrentTasks;
            this.taskQueue = new LinkedBlockingQueue<WrappedTask>();
            this.runningTasks = new HashSet<WrappedTask>(maxConcurrentTasks);
        }

        @Override
        public synchronized Future<?> submit(Runnable r) {
            if (this.closed) {
                throw new RejectedExecutionException();
            }
            WrappedTask task = new WrappedTask(r, this);
            if (this.runningTasks.size() >= this.maxConcurrentTasks) {
                this.taskQueue.add(task);
            } else {
                this.submitWrappedTask(task);
            }
            return task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Runnable> shutdownNow() {
            this.closed = true;
            TaskExecutorImpl taskExecutorImpl = this;
            synchronized (taskExecutorImpl) {
                for (WrappedTask task : this.runningTasks) {
                    task.cancel(true);
                }
                ArrayList<Runnable> ret = new ArrayList<Runnable>(this.taskQueue);
                this.taskQueue.clear();
                return ret;
            }
        }

        private synchronized void completed(WrappedTask task) {
            if (this.closed) {
                return;
            }
            this.runningTasks.remove(task);
            while (!this.closed && !this.taskQueue.isEmpty() && this.runningTasks.size() < this.maxConcurrentTasks) {
                this.submitWrappedTask(this.taskQueue.remove());
            }
        }

        private void submitWrappedTask(WrappedTask task) {
            assert (Thread.holdsLock(this));
            try {
                SharedThreadPool.this.threadPool.execute(task);
                this.runningTasks.add(task);
            }
            catch (RejectedExecutionException ree) {
                if (SharedThreadPool.this.threadPool.isShutdown()) {
                    this.closed = true;
                    throw ree;
                }
                throw new IllegalStateException("Unexpected task rejection", ree);
            }
        }

        public String toString() {
            return "TaskExecutor[max=" + this.maxConcurrentTasks + ",running=" + this.runningTasks.size() + ",queue=" + this.taskQueue.size() + ",pool=" + SharedThreadPool.this.threadPool.getPoolSize() + "]";
        }
    }
}

