/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.table;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Direction;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreFactory;
import oracle.kv.ParamConstant;
import oracle.kv.hadoop.table.TableInputSplit;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldRange;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.Row;
import oracle.kv.table.Table;
import oracle.kv.table.TableAPI;
import oracle.kv.table.TableIterator;
import oracle.kv.table.TableIteratorOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

abstract class TableRecordReaderBase<K, V>
extends RecordReader<K, V> {
    private static final Log LOG = LogFactory.getLog("oracle.kv.hadoop.table.TableRecordReaderBase");
    private static String[] requiredRangeNames = new String[]{"name", "start", "end"};
    private KVStore kvstore;
    private PrimaryKey primaryKey;
    private MultiRowOptions rowOpts;
    private TableIteratorOptions itrOpts = null;
    private List<Set<Integer>> partitionSets;
    private int startNPartitionSets;
    private TableIterator<Row> iter;
    protected Row current;

    TableRecordReaderBase() {
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        TableAPI tableApi;
        Table table;
        TableInputSplit tableInputSplit = (TableInputSplit)split;
        String tableName = tableInputSplit.getTableName();
        String kvStoreName = tableInputSplit.getKVStoreName();
        String[] kvHelperHosts = tableInputSplit.getKVHelperHosts();
        String kvStoreSecurityFile = tableInputSplit.getKVStoreSecurityFile();
        if (this.kvstore == null) {
            KVStoreConfig storeConfig = new KVStoreConfig(kvStoreName, kvHelperHosts);
            storeConfig.setSecurityProperties(KVStoreLogin.createSecurityProperties(kvStoreSecurityFile));
            this.kvstore = KVStoreFactory.getStore(storeConfig);
        }
        if ((table = (tableApi = this.kvstore.getTableAPI()).getTable(tableName)) == null) {
            String msg = "Store does not contain table [name=" + tableName + "]";
            LOG.error(msg);
            throw new RuntimeException(msg);
        }
        this.primaryKey = this.getPrimaryKey(table, tableInputSplit.getPrimaryKeyProperty());
        this.rowOpts = new MultiRowOptions(this.getFieldRange(table, tableInputSplit.getFieldRangeProperty()));
        Direction direction = tableInputSplit.getDirection();
        Consistency consistency = tableInputSplit.getConsistency();
        long timeout = tableInputSplit.getTimeout();
        TimeUnit timeoutUnit = tableInputSplit.getTimeoutUnit();
        int maxRequests = tableInputSplit.getMaxRequests();
        int batchSize = tableInputSplit.getBatchSize();
        int maxBatches = tableInputSplit.getMaxBatches();
        if (direction != null && consistency != null && timeoutUnit != null) {
            this.itrOpts = new TableIteratorOptions(direction, consistency, timeout, timeoutUnit, maxRequests, batchSize, maxBatches);
        }
        this.partitionSets = tableInputSplit.getPartitionSets();
        this.startNPartitionSets = this.partitionSets.size();
    }

    public boolean nextKeyValue() {
        try {
            if (this.iter == null) {
                this.iter = this.getNextIterator();
            }
            while (this.iter != null) {
                if (this.iter.hasNext()) {
                    this.current = (Row)this.iter.next();
                    LOG.debug("next row: " + this.current);
                    return true;
                }
                this.current = null;
                this.iter = this.getNextIterator();
            }
            LOG.debug("all iterations complete: return false");
            return false;
        }
        catch (Exception e) {
            LOG.error("Exception while iterating table [" + e + "]", e);
            return false;
        }
    }

    private TableIterator<Row> getNextIterator() {
        if (this.partitionSets.isEmpty()) {
            return null;
        }
        Set<Integer> partitions = this.partitionSets.remove(0);
        assert (partitions.size() > 0);
        return ((TableAPIImpl)this.kvstore.getTableAPI()).tableIterator(this.primaryKey, this.rowOpts, this.itrOpts, partitions);
    }

    public float getProgress() {
        return this.partitionSets == null ? 0.0f : (float)(this.startNPartitionSets - this.partitionSets.size()) / (float)this.startNPartitionSets;
    }

    public void close() throws IOException {
        LOG.debug("close table iterator and kvstore");
        if (this.iter != null) {
            this.iter.close();
        }
        if (this.kvstore != null) {
            this.kvstore.close();
        }
    }

    private PrimaryKey getPrimaryKey(Table table, String prop) {
        PrimaryKey retKey = table.createPrimaryKey();
        if (prop == null) {
            return retKey;
        }
        String warnStr = "Invalid JSON in property [" + ParamConstant.PRIMARY_KEY.getName() + "=" + prop + "]: " + "must be a list of name:value pairs in JSON format having " + "the form -D" + ParamConstant.PRIMARY_KEY.getName() + "=" + "\"{\\\"fieldName\\\":\\\"stringValue\\\"," + "\\\"fieldName\\\":floatValue, ... }\"; where the list " + "is enclosed in un-escaped double quotes and curly braces, " + "and each fieldName component and each STRING type fieldValue " + "component is enclosed in ESCAPED double quotes. ";
        String proceedStr = "Proceeding with full PrimaryKey wildcard.";
        try {
            retKey = table.createPrimaryKeyFromJson(prop, false);
        }
        catch (IllegalArgumentException e) {
            LOG.warn(warnStr + "Proceeding with full PrimaryKey wildcard.");
            e.printStackTrace();
        }
        return retKey;
    }

    private FieldRange getFieldRange(Table table, String rangeFieldProp) {
        FieldRange retRange = null;
        if (rangeFieldProp == null) {
            return retRange;
        }
        String warnStr = "Invalid JSON in property [" + ParamConstant.FIELD_RANGE.getName() + "=" + rangeFieldProp + "]: must be a list of name:value pairs in JSON format having " + "the form -D" + ParamConstant.FIELD_RANGE.getName() + "=" + "\"{\\\"name\\\":\\\"fieldName\\\"," + "\\\"start\\\":\\\"stringStartVal\\\"|scalarStartVal," + "[\\\"startInclusive\\\":true|false]," + "\\\"end\\\":\\\"stringEndVal\\\"|scalarEndVal," + "[\\\"endInclusive\\\":true|false]}\"; where the list " + "is enclosed in un-escaped double quotes and curly braces, " + "and each name component and each STRING type value component " + "is enclosed in ESCAPED double quotes. ";
        String proceedStr = "Proceeding with full range of values for the PrimaryKey rather than a sub-range ";
        try {
            retRange = this.createFieldRange(table, rangeFieldProp);
        }
        catch (IllegalArgumentException e) {
            LOG.warn(warnStr + "Proceeding with full range of values for the PrimaryKey rather than a sub-range ");
            e.printStackTrace();
        }
        return retRange;
    }

    private FieldRange createFieldRange(Table table, String rangeFieldProp) {
        FieldRange retRange;
        block27: {
            String[] propComponents;
            retRange = null;
            if (rangeFieldProp == null) {
                return retRange;
            }
            String missingLeftBraceStr = "invalid JSON format: system property does not begin with left curly brace ['{']";
            String missingRightBraceStr = "invalid JSON format: system property does not end with right curly brace ['}']";
            if (!rangeFieldProp.startsWith("{")) {
                throw new IllegalArgumentException("invalid JSON format: system property does not begin with left curly brace ['{']");
            }
            if (!rangeFieldProp.endsWith("}")) {
                throw new IllegalArgumentException("invalid JSON format: system property does not end with right curly brace ['}']");
            }
            String dq = "\"";
            String colon = ":";
            String missingNameBase = "missing required range field name ";
            for (String requiredName : requiredRangeNames) {
                String missingName = "missing required range field name [" + requiredName + "]";
                int indxOf = rangeFieldProp.indexOf("\"" + requiredName + "\"" + ":");
                if (indxOf >= 0) continue;
                throw new IllegalArgumentException(missingName);
            }
            String nameVal = null;
            String startVal = null;
            boolean startInclusive = true;
            String endVal = null;
            boolean endInclusive = true;
            FieldDef.Type fieldType = null;
            String invalidComponentBase = "invalid JSON format: invalid \"name\":\"value\" pair in system property ";
            String prop = rangeFieldProp.substring(1, rangeFieldProp.length() - 1);
            for (String propComponent : propComponents = prop.split(",")) {
                String invalidComponent = "invalid JSON format: invalid \"name\":\"value\" pair in system property [" + propComponent + "]";
                String[] rangeComponents = propComponent.split(":");
                if (rangeComponents.length != 2) {
                    throw new IllegalArgumentException(invalidComponent);
                }
                String name = rangeComponents[0].substring(1, rangeComponents[0].length() - 1);
                String val = rangeComponents[1];
                if ("name".equals(name.toLowerCase())) {
                    if (!val.startsWith("\"") || !val.endsWith("\"")) {
                        throw new IllegalArgumentException(invalidComponent);
                    }
                    nameVal = val.substring(1, val.length() - 1);
                    fieldType = table.getField(nameVal).getType();
                    continue;
                }
                if ("start".equals(name.toLowerCase())) {
                    if (val.startsWith("\"") && !val.endsWith("\"")) {
                        throw new IllegalArgumentException(invalidComponent);
                    }
                    if (!val.startsWith("\"") && val.endsWith("\"")) {
                        throw new IllegalArgumentException(invalidComponent);
                    }
                    if (val.startsWith("\"") && val.endsWith("\"")) {
                        startVal = val.substring(1, val.length() - 1);
                        continue;
                    }
                    startVal = val;
                    continue;
                }
                if ("startinclusive".equals(name.toLowerCase())) {
                    startInclusive = Boolean.parseBoolean(val);
                    continue;
                }
                if ("end".equals(name.toLowerCase())) {
                    if (val.startsWith("\"") && !val.endsWith("\"")) {
                        throw new IllegalArgumentException(invalidComponent);
                    }
                    if (!val.startsWith("\"") && val.endsWith("\"")) {
                        throw new IllegalArgumentException(invalidComponent);
                    }
                    if (val.startsWith("\"") && val.endsWith("\"")) {
                        endVal = val.substring(1, val.length() - 1);
                        continue;
                    }
                    endVal = val;
                    continue;
                }
                if (!"endinclusive".equals(name.toLowerCase())) continue;
                endInclusive = Boolean.parseBoolean(val);
            }
            if (nameVal == null) {
                throw new IllegalArgumentException("invalid JSON format: invalid \"name\":\"value\" pair in system property ");
            }
            if (startVal == null && fieldType == null) {
                throw new IllegalArgumentException("invalid JSON format: invalid \"name\":\"value\" pair in system property ");
            }
            retRange = table.createFieldRange(nameVal);
            if (FieldDef.Type.STRING.equals((Object)fieldType)) {
                retRange.setStart(startVal, startInclusive);
                retRange.setEnd(endVal, endInclusive);
            } else {
                try {
                    if (FieldDef.Type.INTEGER.equals((Object)fieldType)) {
                        retRange.setStart(Integer.parseInt(startVal), startInclusive);
                        retRange.setEnd(Integer.parseInt(endVal), endInclusive);
                        break block27;
                    }
                    if (FieldDef.Type.LONG.equals((Object)fieldType)) {
                        retRange.setStart(Long.parseLong(startVal), startInclusive);
                        retRange.setEnd(Long.parseLong(endVal), endInclusive);
                        break block27;
                    }
                    if (FieldDef.Type.FLOAT.equals((Object)fieldType)) {
                        retRange.setStart(Float.parseFloat(startVal), startInclusive);
                        retRange.setEnd(Float.parseFloat(endVal), endInclusive);
                        break block27;
                    }
                    if (FieldDef.Type.DOUBLE.equals((Object)fieldType)) {
                        retRange.setStart(Double.parseDouble(startVal), startInclusive);
                        retRange.setEnd(Double.parseDouble(endVal), endInclusive);
                        break block27;
                    }
                    throw new IllegalArgumentException("invalid JSON format: invalid \"name\":\"value\" pair in system property ");
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(new NumberFormatException("invalid JSON format: invalid \"name\":\"value\" pair in system property "));
                }
            }
        }
        return retRange;
    }
}

