/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BooleanWritable;

public class TableBooleanObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableBooleanObjectInspector {
    TableBooleanObjectInspector() {
        super(TypeInfoFactory.booleanTypeInfo);
    }

    public Object getPrimitiveWritableObject(Object o) {
        return o == null ? null : new BooleanWritable(this.get(o));
    }

    public boolean get(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof FieldValue) {
            return ((FieldValue)o).asBoolean().get();
        }
        throw new IllegalArgumentException("object is not of type Boolean or type FieldValue");
    }

    public Object create(boolean value) {
        return value;
    }

    public Object set(Object o, boolean value) {
        return ((FieldDef)o).createBoolean(value);
    }
}

