/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import java.util.Arrays;
import oracle.kv.table.BinaryDef;
import oracle.kv.table.BinaryValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FixedBinaryDef;
import oracle.kv.table.FixedBinaryValue;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;

public class TableBinaryObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableBinaryObjectInspector {
    TableBinaryObjectInspector() {
        super(TypeInfoFactory.binaryTypeInfo);
    }

    public byte[] copyObject(Object o) {
        if (o instanceof BinaryValue) {
            return ((BinaryValue)o).clone().get();
        }
        if (o instanceof FixedBinaryValue) {
            return ((FixedBinaryValue)o).clone().get();
        }
        return null;
    }

    public BytesWritable getPrimitiveWritableObject(Object o) {
        if (o instanceof BinaryValue) {
            return new BytesWritable(((BinaryValue)o).get());
        }
        if (o instanceof FixedBinaryValue) {
            return new BytesWritable(((FixedBinaryValue)o).get());
        }
        return null;
    }

    public byte[] getPrimitiveJavaObject(Object o) {
        if (o instanceof BinaryValue) {
            return ((BinaryValue)o).get();
        }
        if (o instanceof FixedBinaryValue) {
            return ((FixedBinaryValue)o).get();
        }
        return null;
    }

    public byte[] set(Object o, byte[] bb) {
        if (null == bb) {
            return null;
        }
        if (o instanceof BinaryDef) {
            return ((FieldDef)o).createBinary(bb).get();
        }
        if (o instanceof FixedBinaryDef) {
            return ((FieldDef)o).createFixedBinary(bb).get();
        }
        return null;
    }

    public byte[] set(Object o, BytesWritable bw) {
        if (null == bw) {
            return null;
        }
        if (o instanceof BinaryDef) {
            return ((FieldDef)o).createBinary(LazyUtils.createByteArray((BytesWritable)bw)).get();
        }
        if (o instanceof FixedBinaryDef) {
            return ((FieldDef)o).createFixedBinary(LazyUtils.createByteArray((BytesWritable)bw)).get();
        }
        return null;
    }

    public byte[] create(byte[] bb) {
        return bb == null ? null : Arrays.copyOf(bb, bb.length);
    }

    public byte[] create(BytesWritable bw) {
        return bw == null ? null : LazyUtils.createByteArray((BytesWritable)bw);
    }
}

