/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.Serializable;
import java.util.Arrays;
import oracle.kv.LoginCredentials;

public class PasswordCredentials
implements LoginCredentials,
Serializable {
    private static final long serialVersionUID = 1L;
    private String username;
    private char[] password;

    public PasswordCredentials(String username, char[] password) throws IllegalArgumentException {
        if (username == null) {
            throw new IllegalArgumentException("The username argument must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("The password argument must not be null");
        }
        this.username = username;
        this.password = Arrays.copyOf(password, password.length);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return Arrays.copyOf(this.password, this.password.length);
    }

    public void clear() {
        Arrays.fill(this.password, ' ');
    }
}

